﻿* Encoding: UTF-8.

* 1. DOWNLOAD SOURCE DATASET FROM THE NLS INVESTIGATOR
  USING THE PROVIDED TAGSET FILE 'Sourcedata.NLSY97' FOR EASY VARIABLE SELECTION
  UNZIP & SAVE THE DOWNLOADED FOLDER IN D:\NLSY97_Kopyckaetal FOR THE SYNTAX BELOW TO RUN SMOOTHLY (RECOMMENDED)
  (OR CHANGE THE FILES LOCATION IN THE TEXT BELOW)
* 2. GENERATE SPSS DATASET USING THE FIRST THREE COMMANDS FROM THE 'Sourcedata.sps' SYNTAX FILE PROVIDED IN THE DOWNLOADED FOLDER:
*  file handle pcdat/name='D:\NLSY97_Kopyckaetal\November22_1.dat' /lrecl=22512.
*  data list file pcdat free / .... [VARLIST PROVIDED IN 'Sourcedata.sps']
*  variable labels .... [OPTIONAL].
* 3. RUN THE FULL SYNTAX PROVIDED BELOW TO GENERATE THE FILE 'NLSY98_SRM.sav' USED IN THE ANALYSIS
* 4. EXPORT THE FILE TO STATA FORMAT TO REPLICATE THE RESULTS.

EXECUTE.
DATASET NAME Sourcedata.
SAVE OUTFILE='D:\NLSY97_Kopyckaetal\Sourcedata.sav'
 /COMPRESSED.

* Adding empty military and self-employment flags for waves were this variable did not exist.
do repeat a=milit1 to milit7.
compute a=-4.
end repeat.
do repeat a=selfemp1 to selfemp25.
compute a=-4.
end repeat.
EXECUTE.

************************************************************ STEP 1. CREATION OF DATAFILE FOR JOBS IN ROUNDS 1-19

* A job is defined as wave-specific, despite the fact that the same job can continue across more than one wave (this will be taken into account later)
 This allows to take into account changes in wages and other characteristics reported for the same job in successive waves
* Freelance jobs in rounds 1-5 are excluded

* Save job characteristics including wages & reorder variables for conversion into long person-job format
 interview dates - rounds 1-19
 number of previous round R participated in - rounds 2-19
 flag for current job
 flag for internship
 flag for military (empty variables for 1997)
 flag for self-employment (empty variables for 1997-1999)
 job start year
 job start month
 job end year
 job end month
 employer unique ID
 hourly compensation
 weekly hours worked
 selected in-work benefits (see below).

* Benefits - information are only for certain jobs - create 183 variables for each benefit and each job, to reshape into long in the next step
Save in dataset in any order. The new 183 variables should be in the same order as the other characteristics
 Paid sick leave for employees - up to 2011
 Paid sick leave for self-employed - 2000-2017 for jobs eligible for benefits
 Paid vacation for employees - up to 2011
 Paid vacation for self-employed 2000-2017
 Total paid leave 2004-2011 for employed who did not report sick leave and vacation separately; 2013-2019 for all employed
 Total paid leave for self-employed 2004-2017 for those who did not report sick leave and vacation separately
 Any paid leave dummy - 2019
 Medical insurance - employees & self-employed
 Retirement benefits - employees & self-employed.

SAVE OUTFILE='D:\NLSY97_Kopyckaetal\Source_jobdata.sav'
KEEP=R0000100 R0536401 R0536402
R1209401 R1209402 R2568301 R2568302 R3890301 R3890302 R5472301 R5472302 R7236101 R7236102 S1550901 S1550902 S2020801 S2020802
S3822001 S3822002 S5422001 S5422002 S7524101 S7524102 T0024501 T0024502 T2019401 T2019402 T3610001 T3610002 T5210401 T5210402
T6661401 T6661402 T8132901 T8132902 U0013201 U0013202 U1850701 U1850702 U3450201 U3450202 
R3957400 R5343800 R7089100 S1528800 S3594100 S4969200 S6708800 S8681100 T1100900 T3178300 T4589100 T6222400 T7720700 T9121700 U1115200 U1703100 U3302800 
R0525200 R0525300 R0525400 R0525500 R0525600 R0525700 R0525800 R2468100 R2468200 R2468300 R2468400 R2468500 R2468600 R2468700
R2468800 R2468900 R3781900 R3782000 R3782100 R3782200 R3782300 R3782400 R3782500 R3782600 R3782700 R5304300 R5304400 R5304500
R5304600 R5304700 R5304800 R5304900 R5305000 R5305100 R7046200 R7046300 R7046400 R7046500 R7046600 R7046700 R7046800 R7046900
S1512800 S1512900 S1513000 S1513100 S1513200 S1513300 S1513400 S1513500 S1513600 S1513700 S1513800 S3579600 S3579700 S3579800
S3579900 S3580000 S3580100 S3580200 S3580300 S3580400 S3580500 S5097500 S5097600 S5097700 S5097800 S5097900 S5098000 S5098100
S6846200 S6846300 S6846400 S6846500 S6846600 S6846700 S6846800 S6846900 S6847000 S8828200 S8828300 S8828400 S8828500 S8828600
S8828700 S8828800 S8828900 S8829000 T1244500 T1244600 T1244700 T1244800 T1244900 T1245000 T1245100 T1245200 T3330100 T3330200
T3330300 T3330400 T3330500 T3330600 T3330700 T3330800 T4746100 T4746200 T4746300 T4746400 T4746500 T4746600 T4746700 T4746800
T4746900 T6387100 T6387200 T6387300 T6387400 T6387500 T6387600 T6387700 T6387800 T6387900 T7887400 T7887500 T7887600 T7887700
T7887800 T7887900 T7888000 T7888100 T7888200 T7888300 T7888400 T7888500 T7888600 T9328000 T9328100 T9328200 T9328300 T9328400
T9328500 T9328600 T9328700 T9328800 T9328900 U1341100 U1341200 U1341300 U1341400 U1341500 U1341600 U1341700 U1341800 U1341900
U1342000 U1342100 U1342200 U3080700 U3080800 U3080900 U3081000 U3081100 U3081200 U3081300 U3081400 U3081500 U3081600 U3081700
U3081800 U3081900 U3082000 U3082100 U4488800 U4488900 U4489000 U4489100 U4489200 U4489300 U4489400 U4489500 U4489600 U4489700 U4489800 
R0526500 R0526600 R0526700 R0526800 R0526900 R0527000 R0527100 R2475200 R2475300 R2475400 R2475500 R2475600 R2475700 R2475800
R2475900 R2476000 R3789100 R3789200 R3789300 R3789400 R3789500 R3789600 R3789700 R3789800 R3789900 R5312800 R5312900 R5313000
R5313100 R5313200 R5313300 R5313400 R5313500 R5313600 R7052700 R7052800 R7052900 R7053000 R7053100 R7053200 R7053300 R7053400
S1513900 S1514000 S1514100 S1514200 S1514300 S1514400 S1514500 S1514600 S1514700 S1514800 S1514900 S3580600 S3580700 S3580800
S3580900 S3581000 S3581100 S3581200 S3581300 S3581400 S3581500 S5221500 S5221600 S5221700 S5221800 S5221900 S5222000 S5222100
S7006600 S7006700 S7006800 S7006900 S7007000 S7007100 S7007200 S7007300 S7007400 S8981300 S8981400 S8981500 S8981600 S8981700
S8981800 S8981900 S8982000 S8982100 T1390700 T1390800 T1390900 T1391000 T1391100 T1391200 T1391300 T1391400 T3486800 T3486900
T3487000 T3487100 T3487200 T3487300 T3487400 T3487500 T4915900 T4916000 T4916100 T4916200 T4916300 T4916400 T4916500 T4916600
T4916700 T6567000 T6567100 T6567200 T6567300 T6567400 T6567500 T6567600 T6567700 T6567800 T8071100 T8071200 T8071300 T8071400
T8071500 T8071600 T8071700 T8071800 T8071900 T8072000 T8072100 T8072200 T8072300 T9332000 T9332100 T9332200 T9332300 T9332400
T9332500 T9332600 T9332700 T9332800 T9332900 U1345900 U1346000 U1346100 U1346200 U1346300 U1346400 U1346500 U1346600 U1346700
U1346800 U1346900 U1347000 U3086700 U3086800 U3086900 U3087000 U3087100 U3087200 U3087300 U3087400 U3087500 U3087600 U3087700
U3087800 U3087900 U3088000 U3088100 U4493200 U4493300 U4493400 U4493500 U4493600 U4493700 U4493800 U4493900 U4494000 U4494100 U4494200 
milit1 to milit7 R2469000 R2469100 R2469200 R2469300 R2469400 R2469500 R2469600 R2469700 R2469800 R3782800 R3782900 R3783000 R3783100 R3783200
R3783300 R3783400 R3783500 R3783600 R5305200 R5305300 R5305400 R5305500 R5305600 R5305700 R5305800 R5305900 R5306000 R7047000
R7047100 R7047200 R7047300 R7047400 R7047500 R7047600 R7047700 S1516100 S1516200 S1516300 S1516400 S1516500 S1516600 S1516700
S1516800 S1516900 S1517000 S1517100 S3582600 S3582700 S3582800 S3582900 S3583000 S3583100 S3583200 S3583300 S3583400 S3583500
S5236800 S5236900 S5237000 S5237100 S5237200 S5237300 S5237400 S7026600 S7026700 S7026800 S7026900 S7027000 S7027100 S7027200
S7027300 S7027400 S8997800 S8997900 S8998000 S8998100 S8998200 S8998300 S8998400 S8998500 S8998600 T1407700 T1407800 T1407900
T1408000 T1408100 T1408200 T1408300 T1408400 T3504400 T3504500 T3504600 T3504700 T3504800 T3504900 T3505000 T3505100 T4934100
T4934200 T4934300 T4934400 T4934500 T4934600 T4934700 T4934800 T4934900 T6587300 T6587400 T6587500 T6587600 T6587700 T6587800
T6587900 T6588000 T6588100 T8093500 T8093600 T8093700 T8093800 T8093900 T8094000 T8094100 T8094200 T8094300 T8094400 T8094500
T8094600 T8094700 T9336000 T9336100 T9336200 T9336300 T9336400 T9336500 T9336600 T9336700 T9336800 T9336900 U1350100 U1350200
U1350300 U1350400 U1350500 U1350600 U1350700 U1350800 U1350900 U1351000 U1351100 U1351200 U3092700 U3092800 U3092900 U3093000
U3093100 U3093200 U3093300 U3093400 U3093500 U3093600 U3093700 U3093800 U3093900 U3094000 U3094100 U4497600 U4497700 U4497800
U4497900 U4498000 U4498100 U4498200 U4498300 U4498400 U4498500 U4498600 
selfemp1 to selfemp25 R5309200 R5309300 R5309400 R5309500 R5309600 R5309700 R5309800 R5309900 R5310000 R7050300 R7050400 R7050500 R7050600 R7050700
R7050800 R7050900 R7051000 S1519900 S1520000 S1520100 S1520200 S1520300 S1520400 S1520500 S1520600 S1520700 S1520800 S1520900
S3585900 S3586000 S3586100 S3586200 S3586300 S3586400 S3586500 S3586600 S3586700 S3586800 S5239600 S5239700 S5239800 S5239900
S5240000 S5240100 S5240200 S7029800 S7029900 S7030000 S7030100 S7030200 S7030300 S7030400 S7030500 S7030600 S9000900 S9001000
S9001100 S9001200 S9001300 S9001400 S9001500 S9001600 S9001700 T1410600 T1410700 T1410800 T1410900 T1411000 T1411100 T1411200
T1411300 T3507200 T3507300 T3507400 T3507500 T3507600 T3507700 T3507800 T3507900 T4937100 T4937200 T4937300 T4937400 T4937500
T4937600 T4937700 T4937800 T4937900 T6590200 T6590300 T6590400 T6590500 T6590600 T6590700 T6590800 T6590900 T6591000 T8097600
T8097700 T8097800 T8097900 T8098000 T8098100 T8098200 T8098300 T8098400 T8098500 T8098600 T8098700 T8098800 T9339600 T9339700
T9339800 T9339900 T9340000 T9340100 T9340200 T9340300 T9340400 T9340500 U1354200 U1354300 U1354400 U1354500 U1354600 U1354700
U1354800 U1354900 U1355000 U1355100 U1355200 U1355300 U3097800 U3097900 U3098000 U3098100 U3098200 U3098300 U3098400 U3098500
U3098600 U3098700 U3098800 U3098900 U3099000 U3099100 U3099200 U4501300 U4501400 U4501500 U4501600 U4501700 U4501800 U4501900 
U4502000 U4502100 U4502200 U4502300 
R0529702 R0529802 R0529902 R0530002 R0530102 R0530202 R0530302 R2472502 R2472602 R2472702 R2472802 R2472902 R2473002 R2473102
R2473202 R2473302 R3786402 R3786502 R3786602 R3786702 R3786802 R3786902 R3787002 R3787102 R3787202 R5310102 R5310202 R5310302
R5310402 R5310502 R5310602 R5310702 R5310802 R5310902 R7051102 R7051202 R7051302 R7051402 R7051502 R7051602 R7051702 R7051802
S1521002 S1521102 S1521202 S1521302 S1521402 S1521502 S1521602 S1521702 S1521802 S1521902 S1522002 S3586902 S3587002 S3587102
S3587202 S3587302 S3587402 S3587502 S3587602 S3587702 S3587802 S5128902 S5129002 S5129102 S5129202 S5129302 S5129402 S5129502
S6880802 S6880902 S6881002 S6881102 S6881202 S6881302 S6881402 S6881502 S6881602 S8862202 S8862302 S8862402 S8862502 S8862602
S8862702 S8862802 S8862902 S8863002 T1277402 T1277502 T1277602 T1277702 T1277802 T1277902 T1278002 T1278102 T3364902 T3365002
T3365102 T3365202 T3365302 T3365402 T3365502 T3365602 T4782202 T4782302 T4782402 T4782502 T4782602 T4782702 T4782802 T4782902
T4783002 T6424702 T6424802 T6424902 T6425002 T6425102 T6425202 T6425302 T6425402 T6425502 T7925602 T7925702 T7925802 T7925902
T7926002 T7926102 T7926202 T7926302 T7926402 T7926502 T7926602 T7926702 T7926802 T9330002 T9330102 T9330202 T9330302 T9330402
T9330502 T9330602 T9330702 T9330802 T9330902 U1343502 U1343602 U1343702 U1343802 U1343902 U1344002 U1344102 U1344202 U1344302
U1344402 U1344502 U1344602 U3083702 U3083802 U3083902 U3084002 U3084102 U3084202 U3084302 U3084402 U3084502 U3084602 U3084702
U3084802 U3084902 U3085002 U3085102 U4491002 U4491102 U4491202 U4491302 U4491402 U4491502 U4491602 U4491702 U4491802 U4491902 U4492002 
R0529701 R0529801 R0529901 R0530001 R0530101 R0530201 R0530301 R2472501 R2472601 R2472701 R2472801 R2472901 R2473001 R2473101
R2473201 R2473301 R3786401 R3786501 R3786601 R3786701 R3786801 R3786901 R3787001 R3787101 R3787201 R5310101 R5310201 R5310301
R5310401 R5310501 R5310601 R5310701 R5310801 R5310901 R7051101 R7051201 R7051301 R7051401 R7051501 R7051601 R7051701 R7051801
S1521001 S1521101 S1521201 S1521301 S1521401 S1521501 S1521601 S1521701 S1521801 S1521901 S1522001 S3586901 S3587001 S3587101
S3587201 S3587301 S3587401 S3587501 S3587601 S3587701 S3587801 S5128901 S5129001 S5129101 S5129201 S5129301 S5129401 S5129501
S6880801 S6880901 S6881001 S6881101 S6881201 S6881301 S6881401 S6881501 S6881601 S8862201 S8862301 S8862401 S8862501 S8862601
S8862701 S8862801 S8862901 S8863001 T1277401 T1277501 T1277601 T1277701 T1277801 T1277901 T1278001 T1278101 T3364901 T3365001
T3365101 T3365201 T3365301 T3365401 T3365501 T3365601 T4782201 T4782301 T4782401 T4782501 T4782601 T4782701 T4782801 T4782901
T4783001 T6424701 T6424801 T6424901 T6425001 T6425101 T6425201 T6425301 T6425401 T6425501 T7925601 T7925701 T7925801 T7925901
T7926001 T7926101 T7926201 T7926301 T7926401 T7926501 T7926601 T7926701 T7926801 T9330001 T9330101 T9330201 T9330301 T9330401
T9330501 T9330601 T9330701 T9330801 T9330901 U1343501 U1343601 U1343701 U1343801 U1343901 U1344001 U1344101 U1344201 U1344301
U1344401 U1344501 U1344601 U3083701 U3083801 U3083901 U3084001 U3084101 U3084201 U3084301 U3084401 U3084501 U3084601 U3084701
U3084801 U3084901 U3085001 U3085101 U4491001 U4491101 U4491201 U4491301 U4491401 U4491501 U4491601 U4491701 U4491801 U4491901 U4492001 
R0530402 R0530502 R0530602 R0530702 R0530802 R0530902 R0531002 R2473402 R2473502 R2473602 R2473702 R2473802 R2473902 R2474002
R2474102 R2474202 R3787302 R3787402 R3787502 R3787602 R3787702 R3787802 R3787902 R3788002 R3788102 R5311002 R5311102 R5311202
R5311302 R5311402 R5311502 R5311602 R5311702 R5311802 R7051902 R7052002 R7052102 R7052202 R7052302 R7052402 R7052502 R7052602
S1522102 S1522202 S1522302 S1522402 S1522502 S1522602 S1522702 S1522802 S1522902 S1523002 S1523102 S3587902 S3588002 S3588102
S3588202 S3588302 S3588402 S3588502 S3588602 S3588702 S3588802 S5113902 S5114002 S5114102 S5114202 S5114302 S5114402 S5114502
S6862302 S6862402 S6862502 S6862602 S6862702 S6862802 S6862902 S6863002 S6863102 S8844102 S8844202 S8844302 S8844402 S8844502
S8844602 S8844702 S8844802 S8844902 T1259502 T1259602 T1259702 T1259802 T1259902 T1260002 T1260102 T1260202 T3346102 T3346202
T3346302 T3346402 T3346502 T3346602 T3346702 T3346802 T4764502 T4764602 T4764702 T4764802 T4764902 T4765002 T4765102 T4765202
T4765302 T6405902 T6406002 T6406102 T6406202 T6406302 T6406402 T6406502 T6406602 T6406702 T7906602 T7906702 T7906802 T7906902
T7907002 T7907102 T7907202 T7907302 T7907402 T7907502 T7907602 T7907702 T7907802 T9329002 T9329102 T9329202 T9329302 T9329402
T9329502 T9329602 T9329702 T9329802 T9329902 U1342302 U1342402 U1342502 U1342602 U1342702 U1342802 U1342902 U1343002 U1343102
U1343202 U1343302 U1343402 U3082202 U3082302 U3082402 U3082502 U3082602 U3082702 U3082802 U3082902 U3083002 U3083102 U3083202
U3083302 U3083402 U3083502 U3083602 U4489902 U4490002 U4490102 U4490202 U4490302 U4490402 U4490502 U4490602 U4490702 U4490802 U4490902 
R0530401 R0530501 R0530601 R0530701 R0530801 R0530901 R0531001 R2473401 R2473501 R2473601 R2473701 R2473801 R2473901 R2474001
R2474101 R2474201 R3787301 R3787401 R3787501 R3787601 R3787701 R3787801 R3787901 R3788001 R3788101 R5311001 R5311101 R5311201
R5311301 R5311401 R5311501 R5311601 R5311701 R5311801 R7051901 R7052001 R7052101 R7052201 R7052301 R7052401 R7052501 R7052601
S1522101 S1522201 S1522301 S1522401 S1522501 S1522601 S1522701 S1522801 S1522901 S1523001 S1523101 S3587901 S3588001 S3588101
S3588201 S3588301 S3588401 S3588501 S3588601 S3588701 S3588801 S5113901 S5114001 S5114101 S5114201 S5114301 S5114401 S5114501
S6862301 S6862401 S6862501 S6862601 S6862701 S6862801 S6862901 S6863001 S6863101 S8844101 S8844201 S8844301 S8844401 S8844501
S8844601 S8844701 S8844801 S8844901 T1259501 T1259601 T1259701 T1259801 T1259901 T1260001 T1260101 T1260201 T3346101 T3346201
T3346301 T3346401 T3346501 T3346601 T3346701 T3346801 T4764501 T4764601 T4764701 T4764801 T4764901 T4765001 T4765101 T4765201
T4765301 T6405901 T6406001 T6406101 T6406201 T6406301 T6406401 T6406501 T6406601 T6406701 T7906601 T7906701 T7906801 T7906901
T7907001 T7907101 T7907201 T7907301 T7907401 T7907501 T7907601 T7907701 T7907801 T9329001 T9329101 T9329201 T9329301 T9329401
T9329501 T9329601 T9329701 T9329801 T9329901 U1342301 U1342401 U1342501 U1342601 U1342701 U1342801 U1342901 U1343001 U1343101
U1343201 U1343301 U1343401 U3082201 U3082301 U3082401 U3082501 U3082601 U3082701 U3082801 U3082901 U3083001 U3083101 U3083201
U3083301 U3083401 U3083501 U3083601 U4489901 U4490001 U4490101 U4490201 U4490301 U4490401 U4490501 U4490601 U4490701 U4490801 U4490901 
R0531100 R0531200 R0531300 R0531400 R0531500 R0531600 R0531700 R2476100 R2476200 R2476300 R2476400 R2476500 R2476600 R2476700
R2476800 R2476900 R3790000 R3790100 R3790200 R3790300 R3790400 R3790500 R3790600 R3790700 R3790800 R5313700 R5313800 R5313900
R5314000 R5314100 R5314200 R5314300 R5314400 R5314500 R7053500 R7053600 R7053700 R7053800 R7053900 R7054000 R7054100 R7054200
S1523200 S1523300 S1523400 S1523500 S1523600 S1523700 S1523800 S1523900 S1524000 S1524100 S1524200 S3588900 S3589000 S3589100
S3589200 S3589300 S3589400 S3589500 S3589600 S3589700 S3589800 S5146300 S5146400 S5146500 S5146600 S5146700 S5146800 S5146900
S6912700 S6912800 S6912900 S6913000 S6913100 S6913200 S6913300 S6913400 S6913500 S8890800 S8890900 S8891000 S8891100 S8891200
S8891300 S8891400 S8891500 S8891600 T1305300 T1305400 T1305500 T1305600 T1305700 T1305800 T1305900 T1306000 T3394500 T3394600
T3394700 T3394800 T3394900 T3395000 T3395100 T3395200 T4814600 T4814700 T4814800 T4814900 T4815000 T4815100 T4815200 T4815300
T4815400 T6460000 T6460100 T6460200 T6460300 T6460400 T6460500 T6460600 T6460700 T6460800 T7961200 T7961300 T7961400 T7961500
T7961600 T7961700 T7961800 T7961900 T7962000 T7962100 T7962200 T7962300 T7962400 T9331000 T9331100 T9331200 T9331300 T9331400
T9331500 T9331600 T9331700 T9331800 T9331900 U1344700 U1344800 U1344900 U1345000 U1345100 U1345200 U1345300 U1345400 U1345500
U1345600 U1345700 U1345800 U3085200 U3085300 U3085400 U3085500 U3085600 U3085700 U3085800 U3085900 U3086000 U3086100 U3086200
U3086300 U3086400 U3086500 U3086600 U4492100 U4492200 U4492300 U4492400 U4492500 U4492600 U4492700 U4492800 U4492900 U4493000 U4493100 
R1207800 R1207900 R1208000 R1208100 R1208200 R1208300 R1208400 R2566300 R2566400 R2566500 R2566600 R2566700 R2566800 R2566900
R2567000 R2567100 R3888000 R3888100 R3888200 R3888300 R3888400 R3888500 R3888600 R3888700 R3888800 R5470100 R5470200 R5470300
R5470400 R5470500 R5470600 R5470700 R5470800 R5470900 R7234100 R7234200 R7234300 R7234400 R7234500 R7234600 R7234700 R7234800
S1548300 S1549200 S1549300 S1548400 S1548500 S1548600 S1548700 S1548800 S1548900 S1549000 S1549100 S2018400 S2019300 S2018500
S2018600 S2018700 S2018800 S2018900 S2019000 S2019100 S2019200 S3820200 S3820300 S3820400 S3820500 S3820600 S3820700 S3820800
S5420100 S5420200 S5420300 S5420400 S5420500 S5420600 S5420700 S5420800 S5420900 S7521300 S7521400 S7521500 S7521600 S7521700
S7521800 S7521900 S7522000 S7522100 T0022000 T0022100 T0022200 T0022300 T0022400 T0022500 T0022600 T0022700 T2016900 T2017000
T2017100 T2017200 T2017300 T2017400 T2017500 T2017600 T3607200 T3607300 T3607400 T3607500 T3607600 T3607700 T3607800 T3607900
T3608000 T5207600 T5207700 T5207800 T5207900 T5208000 T5208100 T5208200 T5208300 T5208400 T6657400 T6658300 T6658400 T6658500
T6658600 T6657500 T6657600 T6657700 T6657800 T6657900 T6658000 T6658100 T6658200 T8129800 T8130700 T8129900 T8130000 T8130100
T8130200 T8130300 T8130400 T8130500 T8130600 U0009500 U0010400 U0010500 U0010600 U0009600 U0009700 U0009800 U0009900 U0010000
U0010100 U0010200 U0010300 U1846100 U1847000 U1847100 U1847200 U1847300 U1847400 U1847500 U1846200 U1846300 U1846400 U1846500
U1846600 U1846700 U1846800 U1846900 U3444600 U3445500 U3445600 U3444700 U3444800 U3444900 U3445000 U3445100 U3445200 U3445300 U3445400 
R1209101 R1209102 R1209103 R1209104 R1209105 R1209106 R1209107 R2568001 R2568002 R2568003 R2568004 R2568005 R2568006 R2568007
R2568008 R2568009 R3889701 R3889702 R3889703 R3889704 R3889705 R3889706 R3889707 R3889708 R3889709 R5471801 R5471802 R5471803
R5471804 R5471805 R5471806 R5471807 R5471808 R5471809 R7235601 R7235602 R7235603 R7235604 R7235605 R7235606 R7235607 R7235608
S1550401 S1550410 S1550411 S1550402 S1550403 S1550404 S1550405 S1550406 S1550407 S1550408 S1550409 S2020301 S2020310 S2020302
S2020303 S2020304 S2020305 S2020306 S2020307 S2020308 S2020309 S3821501 S3821502 S3821503 S3821504 S3821505 S3821506 S3821507
S5421801 S5421802 S5421803 S5421804 S5421805 S5421806 S5421807 S5421808 S5421809 S7523100 S7523200 S7523300 S7523400 S7523500
S7523600 S7523700 S7523800 S7523900 T0023600 T0023700 T0023800 T0023900 T0024000 T0024100 T0024200 T0024300 T2018500 T2018600
T2018700 T2018800 T2018900 T2019000 T2019100 T2019200 T3609000 T3609100 T3609200 T3609300 T3609400 T3609500 T3609600 T3609700
T3609800 T5209400 T5209500 T5209600 T5209700 T5209800 T5209900 T5210000 T5210100 T5210200 T6660000 T6660900 T6661000 T6661100
T6661200 T6660100 T6660200 T6660300 T6660400 T6660500 T6660600 T6660700 T6660800 T8131800 T8132700 T8131900 T8132000 T8132100
T8132200 T8132300 T8132400 T8132500 T8132600 U0011900 U0012800 U0012900 U0013000 U0012000 U0012100 U0012200 U0012300 U0012400
U0012500 U0012600 U0012700 U1849100 U1850000 U1850100 U1850200 U1850300 U1850400 U1850500 U1849200 U1849300 U1849400 U1849500
U1849600 U1849700 U1849800 U1849900 U3449000 U3449900 U3450000 U3449100 U3449200 U3449300 U3449400 U3449500 U3449600 U3449700 U3449800
R0240100 R2045400 R3382700 R4761900 R6391500 S0816400 S2881600 S4593000 S6203000 S8226200 T0634000 T2674800 T4158900 T5791300 T7223700 S2882500 T7224600 
S0817300 T7224700 T7224800 R0240200 R2045500 R3382800 R4762000 R6391600 S0816500 S2881700 S4593100 S6203100 S8226300 T0634100 T2674900 T4159000 T5791400 
T7223800 R0240300 R2045600 R3382900 R4762100 R6391700 S0816600 S2881800 S4593200 S6203200 S8226400 T0634200 T2675000 T4159100 T5791500 T7223900 R0240400 
R2045700 R3383000 R4762200 R6391800 S0816700 S2881900 S4593300 S6203300 S8226500 T0634300 T2675100 T4159200 T5791600 T7224000 R0240500 R2045800 R3383100 
R4762300 R6391900 S0816800 S2882000 S4593400 S6203400 S8226600 T0634400 T2675200 T4159300 T5791700 T7224100 R0240600 R2045900 R3383200 R4762400 R6392000 
S0816900 S2882100 S4593500 S6203500 S8226700 T0634500 T2675300 T4159400 T5791800 T7224200 R0240700 R2046000 R3383300 R4762500 R6392100 S0817000 S2882200 
S4593600 S6203600 S8226800 T0634600 T2675400 T4159500 T5791900 T7224300 R4762600 S0817100 S2882300 S6203700 T0634700 T2675500 T4159600 T5792000 T7224400 
R2046100 R3383400 R4762700 S0817200 S2882400 S6203800 S8226900 T4159700 T5792100 T7224500
R4771300 R6400700 S0828100 S2893400 S4602100 S6220900 S8240500 T0651900 T2691500 T4177400 T5807300 T7241300 T8733800 U0653600 U2591900 R4771400 R6400800 
S0828200 S2893500 S4602200 S6221000 S8240600 T0652000 T2691600 T4177500 T5807400 T7241400 T8733900 U0653700 U2592000 R6400900 S0828300 S2893600 S4602300 
S6221100 S8240700 T0652100 T2691700 T4177600 T5807500 T7241500 T8734000 U0653800 U2592100 S2893700 S6221200 S8240800 T2691800 T4177700 T5807600 T7241600 
T8734100 U0653900 U2592200 S0828400 S6221300 T0652200 T2691900 T4177800 T5807700 T8734200 U0654000 U2592300 T2692000 T4177900 T8734300 T0652300 U2592400 
U2592500
R0239400 R2044600 R3381900 R4761000 R6390800 S0815300 S2880600 S4592000 S6201700 S8225000 T0632700 T2673600 T4157600 T5790000 T7222000 S2881500 T7222900 
S0816200 T7223000 T7223100 R0239500 R2044700 R3382000 R4761100 R6390900 S0815400 S2880700 S4592100 S6201800 S8225100 T0632800 T2673700 T4157700 T5790100 
T7222100 R0239600 R2044800 R3382100 R4761200 R6391000 S0815500 S2880800 S4592200 S6201900 S8225200 T0632900 T2673800 T4157800 T5790200 T7222200 R0239700 
R2044900 R3382200 R4761300 R6391100 S0815600 S2880900 S4592300 S6202000 S8225300 T0633000 T2673900 T4157900 T5790300 T7222300 R0239800 R2045000 R3382300 
R4761400 R6391200 S0815700 S2881000 S4592400 S6202100 S8225400 T0633100 T2674000 T4158000 T5790400 T7222400 R0239900 R2045100 R3382400 R4761500 R6391300 
S0815800 S2881100 S4592500 S6202200 S8225500 T0633200 T2674100 T4158100 T5790500 T7222500 R0240000 R2045200 R3382500 R4761600 R6391400 S0815900 S2881200 
S4592600 S6202300 S8225600 T0633300 T2674200 T4158200 T5790600 T7222600 R4761700 S0816000 S2881300 S6202400 T0633400 T2674300 T4158300 T5790700 T7222700 
R2045300 R3382600 R4761800 S0816100 S2881400 S6202500 S8225700 T4158400 T5790800 T7222800 
R4771100 R6400400 S0827700 S2893000 S4601700 S6220300 S8240000 T0651200 T2690900 T4176700 T5806700 T7240800 T8733100 U0653100 U2591100 R4771200 R6400500 
S0827800 S2893100 S4601800 S6220400 S8240100 T0651300 T2691000 T4176800 T5806800 T7240900 T8733200 U0653200 U2591200 R6400600 S0827900 S2893200 S4601900 
S6220500 S8240200 T0651400 T2691100 T4176900 T5806900 T7241000 T8733300 U0653300 U2591300 S2893300 S6220600 S8240300 T2691200 T4177000 T5807000 T7241100 
T8733400 U0653400 U2591400 S0828000 S6220700 T0651500 T2691300 T4177100 T5807100 T8733500 U0653500 U2591500 T2691400 T4177200 T8733600 T0651600 U2591600 
U2591700 
S4592700 S6202600 S8225800 T0633500 T2674400 T4158500 T5790900 T7223200 T8717500 U0633900 U2568200 U0634800 U2569100 U0634900 U2569200 U2569300 U2569400
U2569500 S4592800 S6202700 S8225900 T0633600 T2674500 T4158600 T5791000 T7223300 T8717600 U0634000 U2568300 S6202800 S8226000 T0633700 T2674600 T4158700
T5791100 T7223400 T8717700 U0634100 U2568400 S6202900 S8226100 T0633800 T2674700 T4158800 T5791200 T7223500 T8717800 U0634200 U2568500 T0633900 T7223600
T8717900 U0634300 U2568600 S4592900 T8718000 U0634400 U2568700 T8718100 U0634500 U2568800 T8718200 U0634600 U2568900 T8718300 U0634700 U2569000 
S4602000 S8240400 T0651700 T4177300 U2591800 S6220800 T0651800 T5807200 T7241200 T8733700
U4022104 U4023004 U4023104 U4022204 U4022304 U4022404 U4022504 U4022604 U4022704 U4022804 U4022904 U4022103 U4023003 U4023103 U4022203 U4022303 U4022403
U4022503 U4022603 U4022703 U4022803 U4022903 U4022105 U4023005 U4023105 U4022205 U4022305 U4022405 U4022505 U4022605 U4022705 U4022805 U4022905 U4042804
U4042904 U4043004 U4043104 U4043204 U4043304 U4042803 U4042903 U4043003 U4043103 U4043203 U4043303 U4042805 U4042905 U4043005 U4043105 U4043205 
U4043305
R0238701 R2043701 R3381101 R4760101 R6390101 S0814202 S2879602 S4591302 S6198502 S8222202 T0629602 T2670802 T4154402 T5786702 T7218602 T8714202 U0630502
U2563601 U4022101 S2880502 T7219502 U0631402 U2564501 U4023001 S0815102 T7219602 U0631502 U4023101 T7219702 U2564601 U2564701 U2564801 U2564901 R0238801
R2043801 R3381201 R4760201 R6390201 S0814302 S2879702 S4591402 S6198602 S8222302 T0629702 T2670902 T4154502 T5786802 T7218702 T8714302 U0630602 U2563701
U4022201 R0238901 R2043901 R3381301 R4760301 R6390301 S0814402 S2879802 S4591502 S6198702 S8222402 T0629802 T2671002 T4154602 T5786902 T7218802 T8714402
U0630702 U2563801 U4022301 R0239001 R2044001 R3381401 R4760401 R6390401 S0814502 S2879902 S4591602 S6198802 S8222502 T0629902 T2671102 T4154702 T5787002
T7218902 T8714502 U0630802 U2563901 U4022401 R0239101 R2044101 R3381501 R4760501 R6390501 S0814602 S2880002 S4591702 S6198902 S8222602 T0630002 T2671202
T4154802 T5787102 T7219002 T8714602 U0630902 U2564001 U4022501 R0239201 R2044201 R3381601 R4760601 R6390601 S0814702 S2880102 S4591802 S6199002 S8222702
T0630102 T2671302 T4154902 T5787202 T7219102 T8714702 U0631002 U2564101 U4022601 R0239301 R2044301 R3381701 R4760701 R6390701 S0814802 S2880202 S4591902
S6199102 S8222802 T0630202 T2671402 T4155002 T5787302 T7219202 T8714802 U0631102 U2564201 U4022701 R4760801 S0814902 S2880302 S6199202 T0630302 T2671502
T4155102 T5787402 T7219302 T8714902 U0631202 U2564301 U4022801 R2044401 R3381801 R4760901 S0815002 S2880402 S6199302 S8222902 T4155202 T5787502 T7219402
T8715002 U0631302 U2564401 U4022901 
U2588501 U4042801 U2588601 U4042901 U2588701 U4043001 U2588801 U4043101 U2588901 U4043201 U2589001 U4043301 U2589101 U2589201 R6399901 S0827302 S2892602
S4601402 S6218902 S8238602 T0649702 T2689002 T4175002 T5805202 T7239502 R6400001 S0827402 S2892702 S4601502 S6219002 S8238702 T0649802 T2689102 T4175102
T5805302 T7239602 S0827502 S2892802 S4601602 S6219102 S8238802 T0649902 T2689202 T4175202 T5805402 T7239702 S2892902 S6219202 S8238902 T2689302 T4175302
T5805502 T7239802 S0827602 S6219302 T0650002 T2689402 T4175402 T5805602 T2689502 T4175502 T0650102 T8731402 U0651502 T8731502 U0651602 T8731602 U0651702
T8731702 U0651802 T8731802 U0651902 T8731902
R0238706 R2043706 R3381106 R4760106 R6390106 S0814207 S2879607 S4591307 S6198507 S8222207 T0629607 T2670807 T4154407 T5786707 T7218607 T8714207 U0630507
U2563606 U4022109 S2880507 T7219507 U0631407 U2564506 U4023009 S0815107 T7219607 U0631507 U4023109 T7219707 U2564606 U2564706 U2564806 U2564906 R0238806
R2043806 R3381206 R4760206 R6390206 S0814307 S2879707 S4591407 S6198607 S8222307 T0629707 T2670907 T4154507 T5786807 T7218707 T8714307 U0630607 U2563706
U4022209 R0238906 R2043906 R3381306 R4760306 R6390306 S0814407 S2879807 S4591507 S6198707 S8222407 T0629807 T2671007 T4154607 T5786907 T7218807 T8714407
U0630707 U2563806 U4022309 R0239006 R2044006 R3381406 R4760406 R6390406 S0814507 S2879907 S4591607 S6198807 S8222507 T0629907 T2671107 T4154707 T5787007
T7218907 T8714507 U0630807 U2563906 U4022409 R0239106 R2044106 R3381506 R4760506 R6390506 S0814607 S2880007 S4591707 S6198907 S8222607 T0630007 T2671207
T4154807 T5787107 T7219007 T8714607 U0630907 U2564006 U4022509 R0239206 R2044206 R3381606 R4760606 R6390606 S0814707 S2880107 S4591807 S6199007 S8222707
T0630107 T2671307 T4154907 T5787207 T7219107 T8714707 U0631007 U2564106 U4022609 R0239306 R2044306 R3381706 R4760706 R6390706 S0814807 S2880207 S4591907
S6199107 S8222807 T0630207 T2671407 T4155007 T5787307 T7219207 T8714807 U0631107 U2564206 U4022709 R4760806 S0814907 S2880307 S6199207 T0630307 T2671507
T4155107 T5787407 T7219307 T8714907 U0631207 U2564306 U4022809 R2044406 R3381806 R4760906 S0815007 S2880407 S6199307 S8222907 T4155207 T5787507 T7219407
T8715007 U0631307 U2564406 U4022909    
R6399906 S0827307 S2892607 S4601407 S6218907 S8238607 T0649707 T2689007 T4175007 T5805207 T7239507 R6400006 S0827407 S2892707 S4601507 S6219007 S8238707
T0649807 T2689107 T4175107 T5805307 T7239607 S0827507 S2892807 S4601607 S6219107 S8238807 T0649907 T2689207 T4175207 T5805407 T7239707 S2892907 S6219207
S8238907 T2689307 T4175307 T5805507 T7239807 S0827607 S6219307 T0650007 T2689407 T4175407 T5805607 T2689507 T4175507 T0650107 U2588506 U4042809 U2588606
U4042909 U2588706 U4043009 U2588806 U4043109 U2588906 U4043209 U2589006 U4043309 U2589106 U2589206 T8731407 U0651507 T8731507 U0651607 T8731607 U0651707
T8731707 U0651807 T8731807 U0651907 T8731907    
R4770900 R4771000 R6400100 R6400200 R6400300.

GET FILE='D:\NLSY97_Kopyckaetal\Source_jobdata.sav'.
DATASET NAME Source_jobdata.

* Maximum number of jobs in each round: 
* 7; 9; 9; 9; 8; 11; 10; 7; 9; 9; 8; 8; 9; 9; 13; 10; 12; 15; 11, which gives a total of 183 jobs reported in rounds 1-19.

DATASET ACTIVATE Source_jobdata.
do repeat a=wave1 to wave183 / b=1 to 183.
if b>0 and b<=7 a=1997.
if b>7 and b<=16 a=1998.
if b>16 and b<=25 a=1999.
if b>25 and b<=34 a=2000.
if b>34 and b<=42 a=2001.
if b>42 and b<=53 a=2002.
if b>53 and b<=63 a=2003.
if b>63 and b<=70 a=2004.
if b>70 and b<=79 a=2005.
if b>79 and b<=88 a=2006.
if b>88 and b<=96 a=2007.
if b>96 and b<=104 a=2008.
if b>104 and b<=113 a=2009.
if b>113 and b<=122 a=2010.
if b>122 and b<=135 a=2011.
if b>135 and b<=145 a=2013.
if b>145 and b<=157 a=2015.
if b>157 and b<=172 a=2017.
if b>172 and b<=183 a=2019.
end repeat.
EXECUTE.
 
do repeat a=wavejobID1 to wavejobID183 / b=wave1 to wave183 / c=1 to 7 1 to 9 1 to 9 1 to 9 1 to 8 1 to 11 1 to 10 1 to 7 1 to 9 1 to 9 1 to 8 1 to 8 1 to 9 1 to 9 1 to 13
 1 to 10 1 to 12 1 to 15 1 to 11.
compute a=b*100+c.
end repeat.
EXECUTE.
formats wave1 to wave183 (F2.0) wavejobID1 to wavejobID183 (F6.0).

do repeat a=
paidsick_97_1 paidsick_97_2 paidsick_97_3 paidsick_97_4 paidsick_97_5 paidsick_97_6 paidsick_97_7 paidsick_98_1 paidsick_98_2 paidsick_98_3 paidsick_98_4 
paidsick_98_5 paidsick_98_6 paidsick_98_7 paidsick_98_8 paidsick_98_9 paidsick_99_1 paidsick_99_2 paidsick_99_3 paidsick_99_4 paidsick_99_5 paidsick_99_6 
paidsick_99_7 paidsick_99_8 paidsick_99_9 paidsick_00_1 paidsick_00_2 paidsick_00_3 paidsick_00_4 paidsick_00_5 paidsick_00_6 paidsick_00_7 paidsick_00_8 
paidsick_00_9 paidsick_01_1 paidsick_01_2 paidsick_01_3 paidsick_01_4 paidsick_01_5 paidsick_01_6 paidsick_01_7 paidsick_01_8 paidsick_02_1 paidsick_02_10
paidsick_02_11 paidsick_02_2 paidsick_02_3 paidsick_02_4 paidsick_02_5 paidsick_02_6 paidsick_02_7 paidsick_02_8 paidsick_02_9 paidsick_03_1 paidsick_03_10
paidsick_03_2 paidsick_03_3 paidsick_03_4 paidsick_03_5 paidsick_03_6 paidsick_03_7 paidsick_03_8 paidsick_03_9 paidsick_04_1 paidsick_04_2 paidsick_04_3 
paidsick_04_4 paidsick_04_5 paidsick_04_6 paidsick_04_7 paidsick_05_1 paidsick_05_2 paidsick_05_3 paidsick_05_4 paidsick_05_5 paidsick_05_6 paidsick_05_7 
paidsick_05_8 paidsick_05_9 paidsick_06_1 paidsick_06_2 paidsick_06_3 paidsick_06_4 paidsick_06_5 paidsick_06_6 paidsick_06_7 paidsick_06_8 paidsick_06_9 
paidsick_07_1 paidsick_07_2 paidsick_07_3 paidsick_07_4 paidsick_07_5 paidsick_07_6 paidsick_07_7 paidsick_07_8 paidsick_08_1 paidsick_08_2 paidsick_08_3 
paidsick_08_4 paidsick_08_5 paidsick_08_6 paidsick_08_7 paidsick_08_8 paidsick_09_1 paidsick_09_2 paidsick_09_3 paidsick_09_4 paidsick_09_5 paidsick_09_6 
paidsick_09_7 paidsick_09_8 paidsick_09_9 paidsick_10_1 paidsick_10_2 paidsick_10_3 paidsick_10_4 paidsick_10_5 paidsick_10_6 paidsick_10_7 paidsick_10_8 
paidsick_10_9 paidsick_11_1 paidsick_11_10 paidsick_11_11 paidsick_11_12 paidsick_11_13 paidsick_11_2 paidsick_11_3 paidsick_11_4 paidsick_11_5 paidsick_11_6 
paidsick_11_7 paidsick_11_8 paidsick_11_9 paidsick_13_1 paidsick_13_10 paidsick_13_2 paidsick_13_3 paidsick_13_4 paidsick_13_5 paidsick_13_6 paidsick_13_7 
paidsick_13_8 paidsick_13_9 paidsick_15_1 paidsick_15_10 paidsick_15_11 paidsick_15_12 paidsick_15_2 paidsick_15_3 paidsick_15_4 paidsick_15_5 paidsick_15_6 
paidsick_15_7 paidsick_15_8 paidsick_15_9 paidsick_17_1 paidsick_17_10 paidsick_17_11 paidsick_17_12 paidsick_17_13 paidsick_17_14 paidsick_17_15 
paidsick_17_2 paidsick_17_3 paidsick_17_4 paidsick_17_5 paidsick_17_6 paidsick_17_7 paidsick_17_8 paidsick_17_9 paidsick_19_1 paidsick_19_10 paidsick_19_11 
paidsick_19_2 paidsick_19_3 paidsick_19_4 paidsick_19_5 paidsick_19_6 paidsick_19_7 paidsick_19_8 paidsick_19_9.
compute a=0.
end repeat.
EXECUTE.				

do repeat a=paidvac_97_1 paidvac_97_2 paidvac_97_3 paidvac_97_4 paidvac_97_5 paidvac_97_6 paidvac_97_7 paidvac_98_1 paidvac_98_2 paidvac_98_3 paidvac_98_4 
paidvac_98_5 paidvac_98_6 paidvac_98_7 paidvac_98_8 paidvac_98_9 paidvac_99_1 paidvac_99_2 paidvac_99_3 paidvac_99_4 paidvac_99_5 paidvac_99_6 
paidvac_99_7 paidvac_99_8 paidvac_99_9 paidvac_00_1 paidvac_00_2 paidvac_00_3 paidvac_00_4 paidvac_00_5 paidvac_00_6 paidvac_00_7 paidvac_00_8 
paidvac_00_9 paidvac_01_1 paidvac_01_2 paidvac_01_3 paidvac_01_4 paidvac_01_5 paidvac_01_6 paidvac_01_7 paidvac_01_8 paidvac_02_1 paidvac_02_10
paidvac_02_11 paidvac_02_2 paidvac_02_3 paidvac_02_4 paidvac_02_5 paidvac_02_6 paidvac_02_7 paidvac_02_8 paidvac_02_9 paidvac_03_1 paidvac_03_10
paidvac_03_2 paidvac_03_3 paidvac_03_4 paidvac_03_5 paidvac_03_6 paidvac_03_7 paidvac_03_8 paidvac_03_9 paidvac_04_1 paidvac_04_2 paidvac_04_3 
paidvac_04_4 paidvac_04_5 paidvac_04_6 paidvac_04_7 paidvac_05_1 paidvac_05_2 paidvac_05_3 paidvac_05_4 paidvac_05_5 paidvac_05_6 paidvac_05_7 
paidvac_05_8 paidvac_05_9 paidvac_06_1 paidvac_06_2 paidvac_06_3 paidvac_06_4 paidvac_06_5 paidvac_06_6 paidvac_06_7 paidvac_06_8 paidvac_06_9 
paidvac_07_1 paidvac_07_2 paidvac_07_3 paidvac_07_4 paidvac_07_5 paidvac_07_6 paidvac_07_7 paidvac_07_8 paidvac_08_1 paidvac_08_2 paidvac_08_3 
paidvac_08_4 paidvac_08_5 paidvac_08_6 paidvac_08_7 paidvac_08_8 paidvac_09_1 paidvac_09_2 paidvac_09_3 paidvac_09_4 paidvac_09_5 paidvac_09_6 
paidvac_09_7 paidvac_09_8 paidvac_09_9 paidvac_10_1 paidvac_10_2 paidvac_10_3 paidvac_10_4 paidvac_10_5 paidvac_10_6 paidvac_10_7 paidvac_10_8 
paidvac_10_9 paidvac_11_1 paidvac_11_10 paidvac_11_11 paidvac_11_12 paidvac_11_13 paidvac_11_2 paidvac_11_3 paidvac_11_4 paidvac_11_5 paidvac_11_6 
paidvac_11_7 paidvac_11_8 paidvac_11_9 paidvac_13_1 paidvac_13_10 paidvac_13_2 paidvac_13_3 paidvac_13_4 paidvac_13_5 paidvac_13_6 paidvac_13_7 
paidvac_13_8 paidvac_13_9 paidvac_15_1 paidvac_15_10 paidvac_15_11 paidvac_15_12 paidvac_15_2 paidvac_15_3 paidvac_15_4 paidvac_15_5 paidvac_15_6 
paidvac_15_7 paidvac_15_8 paidvac_15_9 paidvac_17_1 paidvac_17_10 paidvac_17_11 paidvac_17_12 paidvac_17_13 paidvac_17_14 paidvac_17_15 paidvac_17_2 
paidvac_17_3 paidvac_17_4 paidvac_17_5 paidvac_17_6 paidvac_17_7 paidvac_17_8 paidvac_17_9 paidvac_19_1 paidvac_19_10 paidvac_19_11 paidvac_19_2 
paidvac_19_3 paidvac_19_4 paidvac_19_5 paidvac_19_6 paidvac_19_7 paidvac_19_8 paidvac_19_9.
compute a=0.
end repeat.
EXECUTE.	

do repeat a=paidleave_97_1 paidleave_97_2 paidleave_97_3 paidleave_97_4 paidleave_97_5 paidleave_97_6 paidleave_97_7 paidleave_98_1 paidleave_98_2 
paidleave_98_3 paidleave_98_4 paidleave_98_5 paidleave_98_6 paidleave_98_7 paidleave_98_8 paidleave_98_9 paidleave_99_1 paidleave_99_2 paidleave_99_3 
paidleave_99_4 paidleave_99_5 paidleave_99_6 paidleave_99_7 paidleave_99_8 paidleave_99_9 paidleave_00_1 paidleave_00_2 paidleave_00_3 paidleave_00_4 
paidleave_00_5 paidleave_00_6 paidleave_00_7 paidleave_00_8 paidleave_00_9 paidleave_01_1 paidleave_01_2 paidleave_01_3 paidleave_01_4 paidleave_01_5 
paidleave_01_6 paidleave_01_7 paidleave_01_8 paidleave_02_1 paidleave_02_10 paidleave_02_11 paidleave_02_2 paidleave_02_3 paidleave_02_4 paidleave_02_5 
paidleave_02_6 paidleave_02_7 paidleave_02_8 paidleave_02_9 paidleave_03_1 paidleave_03_10 paidleave_03_2 paidleave_03_3 paidleave_03_4 paidleave_03_5 
paidleave_03_6 paidleave_03_7 paidleave_03_8 paidleave_03_9 paidleave_04_1 paidleave_04_2 paidleave_04_3 paidleave_04_4 paidleave_04_5 paidleave_04_6 
paidleave_04_7 paidleave_05_1 paidleave_05_2 paidleave_05_3 paidleave_05_4 paidleave_05_5 paidleave_05_6 paidleave_05_7 paidleave_05_8 paidleave_05_9 
paidleave_06_1 paidleave_06_2 paidleave_06_3 paidleave_06_4 paidleave_06_5 paidleave_06_6 paidleave_06_7 paidleave_06_8 paidleave_06_9 paidleave_07_1 
paidleave_07_2 paidleave_07_3 paidleave_07_4 paidleave_07_5 paidleave_07_6 paidleave_07_7 paidleave_07_8 paidleave_08_1 paidleave_08_2 paidleave_08_3 
paidleave_08_4 paidleave_08_5 paidleave_08_6 paidleave_08_7 paidleave_08_8 paidleave_09_1 paidleave_09_2 paidleave_09_3 paidleave_09_4 paidleave_09_5 
paidleave_09_6 paidleave_09_7 paidleave_09_8 paidleave_09_9 paidleave_10_1 paidleave_10_2 paidleave_10_3 paidleave_10_4 paidleave_10_5 paidleave_10_6 
paidleave_10_7 paidleave_10_8 paidleave_10_9 paidleave_11_1 paidleave_11_10 paidleave_11_11 paidleave_11_12 paidleave_11_13 paidleave_11_2 paidleave_11_3 
paidleave_11_4 paidleave_11_5 paidleave_11_6 paidleave_11_7 paidleave_11_8 paidleave_11_9 paidleave_13_1 paidleave_13_10 paidleave_13_2 paidleave_13_3 
paidleave_13_4 paidleave_13_5 paidleave_13_6 paidleave_13_7 paidleave_13_8 paidleave_13_9 paidleave_15_1 paidleave_15_10 paidleave_15_11 paidleave_15_12
paidleave_15_2 paidleave_15_3 paidleave_15_4 paidleave_15_5 paidleave_15_6 paidleave_15_7 paidleave_15_8 paidleave_15_9 paidleave_17_1 paidleave_17_10
paidleave_17_11 paidleave_17_12 paidleave_17_13 paidleave_17_14 paidleave_17_15 paidleave_17_2 paidleave_17_3 paidleave_17_4 paidleave_17_5 paidleave_17_6 
paidleave_17_7 paidleave_17_8 paidleave_17_9 paidleave_19_1 paidleave_19_10 paidleave_19_11 paidleave_19_2 
paidleave_19_3 paidleave_19_4 paidleave_19_5 paidleave_19_6 paidleave_19_7 paidleave_19_8 paidleave_19_9.
compute a=0.
end repeat.
EXECUTE.

* Paid sick leave for employees - up to 2011.
do repeat a=R0240100 to T7224500 
/ b=paidsick_97_1 paidsick_98_1 paidsick_99_1 paidsick_00_1 paidsick_01_1 paidsick_02_1 paidsick_03_1 paidsick_04_1 paidsick_05_1 paidsick_06_1 
paidsick_07_1 paidsick_08_1 paidsick_09_1 paidsick_10_1 paidsick_11_1 paidsick_03_10 paidsick_11_10 paidsick_02_11 paidsick_11_11 paidsick_11_12
paidsick_97_2 paidsick_98_2 paidsick_99_2 paidsick_00_2 paidsick_01_2 paidsick_02_2 paidsick_03_2 paidsick_04_2 paidsick_05_2 paidsick_06_2 
paidsick_07_2 paidsick_08_2 paidsick_09_2 paidsick_10_2 paidsick_11_2 paidsick_97_3 paidsick_98_3 paidsick_99_3 paidsick_00_3 paidsick_01_3 
paidsick_02_3 paidsick_03_3 paidsick_04_3 paidsick_05_3 paidsick_06_3 paidsick_07_3 paidsick_08_3 paidsick_09_3 paidsick_10_3 paidsick_11_3 
paidsick_97_4 paidsick_98_4 paidsick_99_4 paidsick_00_4 paidsick_01_4 paidsick_02_4 paidsick_03_4 paidsick_04_4 paidsick_05_4 paidsick_06_4 
paidsick_07_4 paidsick_08_4 paidsick_09_4 paidsick_10_4 paidsick_11_4 paidsick_97_5 paidsick_98_5 paidsick_99_5 paidsick_00_5 paidsick_01_5 
paidsick_02_5 paidsick_03_5 paidsick_04_5 paidsick_05_5 paidsick_06_5 paidsick_07_5 paidsick_08_5 paidsick_09_5 paidsick_10_5 paidsick_11_5 
paidsick_97_6 paidsick_98_6 paidsick_99_6 paidsick_00_6 paidsick_01_6 paidsick_02_6 paidsick_03_6 paidsick_04_6 paidsick_05_6 paidsick_06_6 
paidsick_07_6 paidsick_08_6 paidsick_09_6 paidsick_10_6 paidsick_11_6 paidsick_97_7 paidsick_98_7 paidsick_99_7 paidsick_00_7 paidsick_01_7 
paidsick_02_7 paidsick_03_7 paidsick_04_7 paidsick_05_7 paidsick_06_7 paidsick_07_7 paidsick_08_7 paidsick_09_7 paidsick_10_7 paidsick_11_7 
paidsick_00_8 paidsick_02_8 paidsick_03_8 paidsick_05_8 paidsick_07_8 paidsick_08_8 paidsick_09_8 paidsick_10_8 paidsick_11_8 paidsick_98_9 
paidsick_99_9 paidsick_00_9 paidsick_02_9 paidsick_03_9 paidsick_05_9 paidsick_06_9 paidsick_09_9 paidsick_10_9 paidsick_11_9.
if a>-4 b=a.
end repeat.
EXECUTE.

* paid sick leave for self-employed - 2000-2017 for jobs eligible for benefits.
do repeat a=R4771300 to U2592500 
/ b= paidsick_00_1 paidsick_01_1 paidsick_02_1 paidsick_03_1 paidsick_04_1 paidsick_05_1 paidsick_06_1 paidsick_07_1 paidsick_08_1 paidsick_09_1 
paidsick_10_1 paidsick_11_1 paidsick_13_1 paidsick_15_1 paidsick_17_1 paidsick_00_2 paidsick_01_2 paidsick_02_2 paidsick_03_2 paidsick_04_2 
paidsick_05_2 paidsick_06_2 paidsick_07_2 paidsick_08_2 paidsick_09_2 paidsick_10_2 paidsick_11_2 paidsick_13_2 paidsick_15_2 paidsick_17_2 
paidsick_01_3 paidsick_02_3 paidsick_03_3 paidsick_04_3 paidsick_05_3 paidsick_06_3 paidsick_07_3 paidsick_08_3 paidsick_09_3 paidsick_10_3 
paidsick_11_3 paidsick_13_3 paidsick_15_3 paidsick_17_3 paidsick_03_4 paidsick_05_4 paidsick_06_4 paidsick_08_4 paidsick_09_4 paidsick_10_4 
paidsick_11_4 paidsick_13_4 paidsick_15_4 paidsick_17_4 paidsick_02_5 paidsick_05_5 paidsick_07_5 paidsick_08_5 paidsick_09_5 paidsick_10_5 
paidsick_13_5 paidsick_15_5 paidsick_17_5 paidsick_08_6 paidsick_09_6 paidsick_13_6 paidsick_07_7 paidsick_17_8 paidsick_17_9.
if a>-4 b=a.
end repeat.
EXECUTE.
									
* Paid vacation for employees - up to 2011.
do repeat a=R0239400 to T7222800 
/ b= paidvac_97_1 paidvac_98_1 paidvac_99_1 paidvac_00_1 paidvac_01_1 paidvac_02_1 paidvac_03_1 paidvac_04_1 paidvac_05_1 paidvac_06_1 
paidvac_07_1 paidvac_08_1 paidvac_09_1 paidvac_10_1 paidvac_11_1 paidvac_03_10 paidvac_11_10 paidvac_02_11 paidvac_11_11 paidvac_11_12
paidvac_97_2 paidvac_98_2 paidvac_99_2 paidvac_00_2 paidvac_01_2 paidvac_02_2 paidvac_03_2 paidvac_04_2 paidvac_05_2 paidvac_06_2 
paidvac_07_2 paidvac_08_2 paidvac_09_2 paidvac_10_2 paidvac_11_2 paidvac_97_3 paidvac_98_3 paidvac_99_3 paidvac_00_3 paidvac_01_3 
paidvac_02_3 paidvac_03_3 paidvac_04_3 paidvac_05_3 paidvac_06_3 paidvac_07_3 paidvac_08_3 paidvac_09_3 paidvac_10_3 paidvac_11_3 
paidvac_97_4 paidvac_98_4 paidvac_99_4 paidvac_00_4 paidvac_01_4 paidvac_02_4 paidvac_03_4 paidvac_04_4 paidvac_05_4 paidvac_06_4 
paidvac_07_4 paidvac_08_4 paidvac_09_4 paidvac_10_4 paidvac_11_4 paidvac_97_5 paidvac_98_5 paidvac_99_5 paidvac_00_5 paidvac_01_5 
paidvac_02_5 paidvac_03_5 paidvac_04_5 paidvac_05_5 paidvac_06_5 paidvac_07_5 paidvac_08_5 paidvac_09_5 paidvac_10_5 paidvac_11_5 
paidvac_97_6 paidvac_98_6 paidvac_99_6 paidvac_00_6 paidvac_01_6 paidvac_02_6 paidvac_03_6 paidvac_04_6 paidvac_05_6 paidvac_06_6 
paidvac_07_6 paidvac_08_6 paidvac_09_6 paidvac_10_6 paidvac_11_6 paidvac_97_7 paidvac_98_7 paidvac_99_7 paidvac_00_7 paidvac_01_7 
paidvac_02_7 paidvac_03_7 paidvac_04_7 paidvac_05_7 paidvac_06_7 paidvac_07_7 paidvac_08_7 paidvac_09_7 paidvac_10_7 paidvac_11_7 
paidvac_00_8 paidvac_02_8 paidvac_03_8 paidvac_05_8 paidvac_07_8 paidvac_08_8 paidvac_09_8 paidvac_10_8 paidvac_11_8 paidvac_98_9 
paidvac_99_9 paidvac_00_9 paidvac_02_9 paidvac_03_9 paidvac_05_9 paidvac_06_9 paidvac_09_9 paidvac_10_9 paidvac_11_9.
if a>-4 b=a.
end repeat.
EXECUTE.

* Paid vacation for self-employed 2000-2017.
do repeat a=R4771100 to U2591700
/b=paidvac_00_1 paidvac_01_1 paidvac_02_1 paidvac_03_1 paidvac_04_1 paidvac_05_1 paidvac_06_1 paidvac_07_1 paidvac_08_1 paidvac_09_1 
paidvac_10_1 paidvac_11_1 paidvac_13_1 paidvac_15_1 paidvac_17_1 paidvac_00_2 paidvac_01_2 paidvac_02_2 paidvac_03_2 paidvac_04_2 
paidvac_05_2 paidvac_06_2 paidvac_07_2 paidvac_08_2 paidvac_09_2 paidvac_10_2 paidvac_11_2 paidvac_13_2 paidvac_15_2 paidvac_17_2 
paidvac_01_3 paidvac_02_3 paidvac_03_3 paidvac_04_3 paidvac_05_3 paidvac_06_3 paidvac_07_3 paidvac_08_3 paidvac_09_3 paidvac_10_3 
paidvac_11_3 paidvac_13_3 paidvac_15_3 paidvac_17_3 paidvac_03_4 paidvac_05_4 paidvac_06_4 paidvac_08_4 paidvac_09_4 paidvac_10_4 
paidvac_11_4 paidvac_13_4 paidvac_15_4 paidvac_17_4 paidvac_02_5 paidvac_05_5 paidvac_07_5 paidvac_08_5 paidvac_09_5 paidvac_10_5 
paidvac_13_5 paidvac_15_5 paidvac_17_5 paidvac_08_6 paidvac_09_6 paidvac_13_6 paidvac_07_7 paidvac_17_8 paidvac_17_9.
if a>-4 b=a.
end repeat.
EXECUTE.

* Total paid leave 2004-2011 for employed who did not report sick leave and vacation separately; 2013-2019 for all employed.
do repeat a=S4592700 to U2569000
/b=paidleave_04_1 paidleave_05_1 paidleave_06_1 paidleave_07_1 paidleave_08_1 paidleave_09_1 paidleave_10_1 paidleave_11_1 paidleave_13_1 paidleave_15_1 
paidleave_17_1 paidleave_15_10 paidleave_17_10 paidleave_15_11 paidleave_17_12 paidleave_17_13 paidleave_17_14 paidleave_17_15 paidleave_04_2 paidleave_05_2 
paidleave_06_2 paidleave_07_2 paidleave_08_2 paidleave_09_2 paidleave_10_2 paidleave_11_2 paidleave_13_2 paidleave_15_2 paidleave_17_2 paidleave_05_3 
paidleave_06_3 paidleave_07_3 paidleave_08_3 paidleave_09_3 paidleave_10_3 paidleave_11_3 paidleave_13_3 paidleave_15_3 paidleave_17_3 paidleave_05_4 
paidleave_06_4 paidleave_07_4 paidleave_08_4 paidleave_09_4 paidleave_10_4 paidleave_11_4 paidleave_13_4 paidleave_15_4 paidleave_17_4 paidleave_07_5 
paidleave_11_5 paidleave_13_5 paidleave_15_5 paidleave_17_5 paidleave_04_6 paidleave_13_6 paidleave_15_6 paidleave_17_6 paidleave_13_7 paidleave_15_7 
paidleave_17_7 paidleave_13_8 paidleave_15_8 paidleave_17_8 paidleave_13_9 paidleave_15_9 paidleave_17_9. 
if a>-4 b=a.
end repeat.
EXECUTE.

* Total paid leave for self-employed 2004-2017 for those who did not report sick leave and vacation separately.
do repeat a= S4602000 to T8733700
/b=paidleave_04_1 paidleave_06_1 paidleave_07_1 paidleave_09_1 paidleave_17_1 paidleave_05_2 paidleave_07_2 paidleave_10_2 paidleave_11_2 paidleave_13_2.
if a>-4 b=a.
end repeat.
EXECUTE.

* Any paid leave dummy for 2019 jobs - assign special code 999 to signify the presence of paid leave.
do repeat a=U4022104 to U4043305
/b= paidleave_19_1 paidleave_19_10 paidleave_19_11 paidleave_19_2 paidleave_19_3 paidleave_19_4 paidleave_19_5 paidleave_19_6 paidleave_19_7 paidleave_19_8 
paidleave_19_9 paidleave_19_1 paidleave_19_10 paidleave_19_11 paidleave_19_2 paidleave_19_3 paidleave_19_4 paidleave_19_5 paidleave_19_6 paidleave_19_7 
paidleave_19_8 paidleave_19_9 paidleave_19_1 paidleave_19_10 paidleave_19_11 paidleave_19_2 paidleave_19_3 paidleave_19_4 paidleave_19_5 paidleave_19_6 
paidleave_19_7 paidleave_19_8 paidleave_19_9 paidleave_19_1 paidleave_19_2 paidleave_19_3 paidleave_19_4 paidleave_19_5 paidleave_19_6 paidleave_19_1 
paidleave_19_2 paidleave_19_3 paidleave_19_4 paidleave_19_5 paidleave_19_6 paidleave_19_1 paidleave_19_2 paidleave_19_3 paidleave_19_4 paidleave_19_5 
paidleave_19_6.
if a=-2 or a=-1 b=-1.
if a=1 b=999.
end repeat.
EXECUTE.

* CALCULATING IN-WORK BENEFITS DUMMIES: health insurance, pension plans, and paid leave dummy: either sick leave or vacation.
* 1. Paid leave

do repeat a=paidsick_97_1 to paidsick_19_9 / b=paidvac_97_1 to paidvac_19_9 / c=paidleave_97_1 to paidleave_19_9 / d=paidleave1 to paidleave183.
recode c (0=0)(1 thru highest=1)(-2=-2)(-1=-1) into d.
if (a>0 or b>0) d=1.
if a<0 and b<0 d=-2.
if a=-1 and b=-1 d=-1.
if a=-3 and b=-3 d=-3.
end repeat.
formats paidleave1 to paidleave183 (F2.0).
EXECUTE.

* 2. Medical insurance.

do repeat a= medins_97_1 medins_97_2 medins_97_3 medins_97_4 medins_97_5 medins_97_6 medins_97_7 medins_98_1 medins_98_2 
 medins_98_3 medins_98_4 medins_98_5 medins_98_6 medins_98_7 medins_98_8 medins_98_9 medins_99_1 medins_99_2 medins_99_3 
 medins_99_4 medins_99_5 medins_99_6 medins_99_7 medins_99_8 medins_99_9 medins_00_1 medins_00_2 medins_00_3 medins_00_4 
 medins_00_5 medins_00_6 medins_00_7 medins_00_8 medins_00_9 medins_01_1 medins_01_2 medins_01_3 medins_01_4 medins_01_5 
 medins_01_6 medins_01_7 medins_01_8 medins_02_1 medins_02_10 medins_02_11 medins_02_2 medins_02_3 medins_02_4 medins_02_5 
 medins_02_6 medins_02_7 medins_02_8 medins_02_9 medins_03_1 medins_03_10 medins_03_2 medins_03_3 medins_03_4 medins_03_5 
 medins_03_6 medins_03_7 medins_03_8 medins_03_9 medins_04_1 medins_04_2 medins_04_3 medins_04_4 medins_04_5 medins_04_6 
 medins_04_7 medins_05_1 medins_05_2 medins_05_3 medins_05_4 medins_05_5 medins_05_6 medins_05_7 medins_05_8 medins_05_9 
 medins_06_1 medins_06_2 medins_06_3 medins_06_4 medins_06_5 medins_06_6 medins_06_7 medins_06_8 medins_06_9 medins_07_1 
 medins_07_2 medins_07_3 medins_07_4 medins_07_5 medins_07_6 medins_07_7 medins_07_8 medins_08_1 medins_08_2 medins_08_3 
 medins_08_4 medins_08_5 medins_08_6 medins_08_7 medins_08_8 medins_09_1 medins_09_2 medins_09_3 medins_09_4 medins_09_5 
 medins_09_6 medins_09_7 medins_09_8 medins_09_9 medins_10_1 medins_10_2 medins_10_3 medins_10_4 medins_10_5 medins_10_6 
 medins_10_7 medins_10_8 medins_10_9 medins_11_1 medins_11_10 medins_11_11 medins_11_12 medins_11_13 medins_11_2 medins_11_3 
 medins_11_4 medins_11_5 medins_11_6 medins_11_7 medins_11_8 medins_11_9 medins_13_1 medins_13_10 medins_13_2 medins_13_3 
 medins_13_4 medins_13_5 medins_13_6 medins_13_7 medins_13_8 medins_13_9 medins_15_1 medins_15_10 medins_15_11 medins_15_12
 medins_15_2 medins_15_3 medins_15_4 medins_15_5 medins_15_6 medins_15_7 medins_15_8 medins_15_9 medins_17_1 medins_17_10
 medins_17_11 medins_17_12 medins_17_13 medins_17_14 medins_17_15 medins_17_2 medins_17_3 medins_17_4 medins_17_5 medins_17_6 
 medins_17_7 medins_17_8 medins_17_9 medins_19_1 medins_19_10 medins_19_11 medins_19_2 
 medins_19_3 medins_19_4 medins_19_5 medins_19_6 medins_19_7 medins_19_8 medins_19_9.
compute a=0.
end repeat.
formats medins_97_1 to medins_19_9 (F2.0).
EXECUTE.

do repeat a= R0238701 to U4022901
/b= medins_97_1 medins_98_1 medins_99_1 medins_00_1 medins_01_1 medins_02_1 medins_03_1 medins_04_1 medins_05_1 medins_06_1 medins_07_1 
medins_08_1 medins_09_1 medins_10_1 medins_11_1 medins_13_1 medins_15_1 medins_17_1 medins_19_1 medins_03_10 medins_11_10 medins_15_10
medins_17_10 medins_19_10 medins_02_11 medins_11_11 medins_15_11 medins_19_11 medins_11_12 medins_17_12 medins_17_13 medins_17_14 medins_17_15
medins_97_2 medins_98_2 medins_99_2 medins_00_2 medins_01_2 medins_02_2 medins_03_2 medins_04_2 medins_05_2 medins_06_2 medins_07_2 
medins_08_2 medins_09_2 medins_10_2 medins_11_2 medins_13_2 medins_15_2 medins_17_2 medins_19_2 medins_97_3 medins_98_3 medins_99_3 
medins_00_3 medins_01_3 medins_02_3 medins_03_3 medins_04_3 medins_05_3 medins_06_3 medins_07_3 medins_08_3 medins_09_3 medins_10_3 
medins_11_3 medins_13_3 medins_15_3 medins_17_3 medins_19_3 medins_97_4 medins_98_4 medins_99_4 medins_00_4 medins_01_4 medins_02_4 
medins_03_4 medins_04_4 medins_05_4 medins_06_4 medins_07_4 medins_08_4 medins_09_4 medins_10_4 medins_11_4 medins_13_4 medins_15_4 
medins_17_4 medins_19_4 medins_97_5 medins_98_5 medins_99_5 medins_00_5 medins_01_5 medins_02_5 medins_03_5 medins_04_5 medins_05_5 
medins_06_5 medins_07_5 medins_08_5 medins_09_5 medins_10_5 medins_11_5 medins_13_5 medins_15_5 medins_17_5 medins_19_5 medins_97_6 
medins_98_6 medins_99_6 medins_00_6 medins_01_6 medins_02_6 medins_03_6 medins_04_6 medins_05_6 medins_06_6 medins_07_6 medins_08_6 
medins_09_6 medins_10_6 medins_11_6 medins_13_6 medins_15_6 medins_17_6 medins_19_6 medins_97_7 medins_98_7 medins_99_7 medins_00_7 
medins_01_7 medins_02_7 medins_03_7 medins_04_7 medins_05_7 medins_06_7 medins_07_7 medins_08_7 medins_09_7 medins_10_7 medins_11_7 
medins_13_7 medins_15_7 medins_17_7 medins_19_7 medins_00_8 medins_02_8 medins_03_8 medins_05_8 medins_07_8 medins_08_8 medins_09_8 
medins_10_8 medins_11_8 medins_13_8 medins_15_8 medins_17_8 medins_19_8 medins_98_9 medins_99_9 medins_00_9 medins_02_9 medins_03_9 
medins_05_9 medins_06_9 medins_09_9 medins_10_9 medins_11_9 medins_13_9 medins_15_9 medins_17_9 medins_19_9. 
if a>-4 b=a.
end repeat.
EXECUTE.
 
do repeat a= U2588501 to T8731902
/b= medins_17_1 medins_19_1 medins_17_2 medins_19_2 medins_17_3 medins_19_3 medins_17_4 medins_19_4 medins_17_5 medins_19_5 medins_17_6 
medins_19_6 medins_17_8 medins_17_9 medins_01_1 medins_02_1 medins_03_1 medins_04_1 medins_05_1 medins_06_1 medins_07_1 medins_08_1 
medins_09_1 medins_10_1 medins_11_1 medins_01_2 medins_02_2 medins_03_2 medins_04_2 medins_05_2 medins_06_2 medins_07_2 medins_08_2 
medins_09_2 medins_10_2 medins_11_2 medins_02_3 medins_03_3 medins_04_3 medins_05_3 medins_06_3 medins_07_3 medins_08_3 medins_09_3 
medins_10_3 medins_11_3 medins_03_4 medins_05_4 medins_06_4 medins_08_4 medins_09_4 medins_10_4 medins_11_4 medins_02_5 medins_05_5 
medins_07_5 medins_08_5 medins_09_5 medins_10_5 medins_08_6 medins_09_6 medins_07_7 medins_13_1 medins_15_1 medins_13_2 medins_15_2 
medins_13_3 medins_15_3 medins_13_4 medins_15_4 medins_13_5 medins_15_5 medins_13_6.
if a>-4 b=a.
end repeat.
EXECUTE.

* Below single response questions for 2000 & 2001 (mistake) - only multiple response question in 2000; both in 2001, but:
NOTE: This question was originally (and unintentionally) fielded as a select one pick list. The question type was changed to a mark all that apply option in 
patch #4. Data from the post-patched version are included in the dummy variable, and the variables below are pre-patch data for different respondents
In the select one variables neither medical insurance nor retirement benefits were not selected.

recode R4770900 (-3 thru -1=COPY)(0=0)(1=1)(2 thru highest=0) into medins_00_1.
recode R4771000 (-3 thru -1=COPY)(0=0)(1=1)(2 thru highest=0) into medins_00_2.
if R6400100>-4 medins_01_1 =-2.
if R6400100=0 medins_01_1 =0.
if R6400200>-4 medins_01_2 =-2.
if R6400200=0 medins_01_2 =0.
if R6400300>-4 medins_01_3 =-2.
if R6400300=0 medins_01_3 =0.
EXECUTE.

* 3. Retirement benefits.

do repeat a= 
 retiremnt_97_1 retiremnt_97_2 retiremnt_97_3 retiremnt_97_4 retiremnt_97_5 retiremnt_97_6 retiremnt_97_7 retiremnt_98_1 retiremnt_98_2 
 retiremnt_98_3 retiremnt_98_4 retiremnt_98_5 retiremnt_98_6 retiremnt_98_7 retiremnt_98_8 retiremnt_98_9 retiremnt_99_1 retiremnt_99_2 retiremnt_99_3 
 retiremnt_99_4 retiremnt_99_5 retiremnt_99_6 retiremnt_99_7 retiremnt_99_8 retiremnt_99_9 retiremnt_00_1 retiremnt_00_2 retiremnt_00_3 retiremnt_00_4 
 retiremnt_00_5 retiremnt_00_6 retiremnt_00_7 retiremnt_00_8 retiremnt_00_9 retiremnt_01_1 retiremnt_01_2 retiremnt_01_3 retiremnt_01_4 retiremnt_01_5 
 retiremnt_01_6 retiremnt_01_7 retiremnt_01_8 retiremnt_02_1 retiremnt_02_10 retiremnt_02_11 retiremnt_02_2 retiremnt_02_3 retiremnt_02_4 retiremnt_02_5 
 retiremnt_02_6 retiremnt_02_7 retiremnt_02_8 retiremnt_02_9 retiremnt_03_1 retiremnt_03_10 retiremnt_03_2 retiremnt_03_3 retiremnt_03_4 retiremnt_03_5 
 retiremnt_03_6 retiremnt_03_7 retiremnt_03_8 retiremnt_03_9 retiremnt_04_1 retiremnt_04_2 retiremnt_04_3 retiremnt_04_4 retiremnt_04_5 retiremnt_04_6 
 retiremnt_04_7 retiremnt_05_1 retiremnt_05_2 retiremnt_05_3 retiremnt_05_4 retiremnt_05_5 retiremnt_05_6 retiremnt_05_7 retiremnt_05_8 retiremnt_05_9 
 retiremnt_06_1 retiremnt_06_2 retiremnt_06_3 retiremnt_06_4 retiremnt_06_5 retiremnt_06_6 retiremnt_06_7 retiremnt_06_8 retiremnt_06_9 retiremnt_07_1 
 retiremnt_07_2 retiremnt_07_3 retiremnt_07_4 retiremnt_07_5 retiremnt_07_6 retiremnt_07_7 retiremnt_07_8 retiremnt_08_1 retiremnt_08_2 retiremnt_08_3 
 retiremnt_08_4 retiremnt_08_5 retiremnt_08_6 retiremnt_08_7 retiremnt_08_8 retiremnt_09_1 retiremnt_09_2 retiremnt_09_3 retiremnt_09_4 retiremnt_09_5 
 retiremnt_09_6 retiremnt_09_7 retiremnt_09_8 retiremnt_09_9 retiremnt_10_1 retiremnt_10_2 retiremnt_10_3 retiremnt_10_4 retiremnt_10_5 retiremnt_10_6 
 retiremnt_10_7 retiremnt_10_8 retiremnt_10_9 retiremnt_11_1 retiremnt_11_10 retiremnt_11_11 retiremnt_11_12 retiremnt_11_13 retiremnt_11_2 retiremnt_11_3 
 retiremnt_11_4 retiremnt_11_5 retiremnt_11_6 retiremnt_11_7 retiremnt_11_8 retiremnt_11_9 retiremnt_13_1 retiremnt_13_10 retiremnt_13_2 retiremnt_13_3 
 retiremnt_13_4 retiremnt_13_5 retiremnt_13_6 retiremnt_13_7 retiremnt_13_8 retiremnt_13_9 retiremnt_15_1 retiremnt_15_10 retiremnt_15_11 retiremnt_15_12
 retiremnt_15_2 retiremnt_15_3 retiremnt_15_4 retiremnt_15_5 retiremnt_15_6 retiremnt_15_7 retiremnt_15_8 retiremnt_15_9 retiremnt_17_1 retiremnt_17_10
 retiremnt_17_11 retiremnt_17_12 retiremnt_17_13 retiremnt_17_14 retiremnt_17_15 retiremnt_17_2 retiremnt_17_3 retiremnt_17_4 retiremnt_17_5 retiremnt_17_6 
 retiremnt_17_7 retiremnt_17_8 retiremnt_17_9 retiremnt_19_1 retiremnt_19_10 retiremnt_19_11 retiremnt_19_2 
 retiremnt_19_3 retiremnt_19_4 retiremnt_19_5 retiremnt_19_6 retiremnt_19_7 retiremnt_19_8 retiremnt_19_9. 
compute a=0.
end repeat.
formats retiremnt_97_1 to retiremnt_19_9 (F2.0).
EXECUTE.

do repeat a= R0238706 to U4022909
/b= retiremnt_97_1 retiremnt_98_1 retiremnt_99_1 retiremnt_00_1 retiremnt_01_1 retiremnt_02_1 retiremnt_03_1 retiremnt_04_1 retiremnt_05_1 retiremnt_06_1
 retiremnt_07_1 retiremnt_08_1 retiremnt_09_1 retiremnt_10_1 retiremnt_11_1 retiremnt_13_1 retiremnt_15_1 retiremnt_17_1 retiremnt_19_1 retiremnt_03_10 
retiremnt_11_10 retiremnt_15_10 retiremnt_17_10 retiremnt_19_10 retiremnt_02_11 retiremnt_11_11 retiremnt_15_11 retiremnt_19_11 retiremnt_11_12 retiremnt_17_12 
retiremnt_17_13 retiremnt_17_14 retiremnt_17_15
retiremnt_97_2 retiremnt_98_2 retiremnt_99_2 retiremnt_00_2 retiremnt_01_2 retiremnt_02_2 retiremnt_03_2 retiremnt_04_2 retiremnt_05_2 retiremnt_06_2 
retiremnt_07_2 retiremnt_08_2 retiremnt_09_2 retiremnt_10_2 retiremnt_11_2 retiremnt_13_2 retiremnt_15_2 retiremnt_17_2 retiremnt_19_2 retiremnt_97_3 
retiremnt_98_3 retiremnt_99_3 retiremnt_00_3 retiremnt_01_3 retiremnt_02_3 retiremnt_03_3 retiremnt_04_3 retiremnt_05_3 retiremnt_06_3 retiremnt_07_3 
retiremnt_08_3 retiremnt_09_3 retiremnt_10_3 retiremnt_11_3 retiremnt_13_3 retiremnt_15_3 retiremnt_17_3 retiremnt_19_3 retiremnt_97_4 retiremnt_98_4 
retiremnt_99_4 retiremnt_00_4 retiremnt_01_4 retiremnt_02_4 retiremnt_03_4 retiremnt_04_4 retiremnt_05_4 retiremnt_06_4 retiremnt_07_4 retiremnt_08_4 
retiremnt_09_4 retiremnt_10_4 retiremnt_11_4 retiremnt_13_4 retiremnt_15_4 retiremnt_17_4 retiremnt_19_4 retiremnt_97_5 retiremnt_98_5 retiremnt_99_5 
retiremnt_00_5 retiremnt_01_5 retiremnt_02_5 retiremnt_03_5 retiremnt_04_5 retiremnt_05_5 retiremnt_06_5 retiremnt_07_5 retiremnt_08_5 retiremnt_09_5 
retiremnt_10_5 retiremnt_11_5 retiremnt_13_5 retiremnt_15_5 retiremnt_17_5 retiremnt_19_5 retiremnt_97_6 retiremnt_98_6 retiremnt_99_6 retiremnt_00_6 
retiremnt_01_6 retiremnt_02_6 retiremnt_03_6 retiremnt_04_6 retiremnt_05_6 retiremnt_06_6 retiremnt_07_6 retiremnt_08_6 retiremnt_09_6 retiremnt_10_6 
retiremnt_11_6 retiremnt_13_6 retiremnt_15_6 retiremnt_17_6 retiremnt_19_6 retiremnt_97_7 retiremnt_98_7 retiremnt_99_7 retiremnt_00_7 retiremnt_01_7 
retiremnt_02_7 retiremnt_03_7 retiremnt_04_7 retiremnt_05_7 retiremnt_06_7 retiremnt_07_7 retiremnt_08_7 retiremnt_09_7 retiremnt_10_7 retiremnt_11_7 
retiremnt_13_7 retiremnt_15_7 retiremnt_17_7 retiremnt_19_7 retiremnt_00_8 retiremnt_02_8 retiremnt_03_8 retiremnt_05_8 retiremnt_07_8 retiremnt_08_8 
retiremnt_09_8 retiremnt_10_8 retiremnt_11_8 retiremnt_13_8 retiremnt_15_8 retiremnt_17_8 retiremnt_19_8 retiremnt_98_9 retiremnt_99_9 retiremnt_00_9 
retiremnt_02_9 retiremnt_03_9 retiremnt_05_9 retiremnt_06_9 retiremnt_09_9 retiremnt_10_9 retiremnt_11_9 retiremnt_13_9 retiremnt_15_9 retiremnt_17_9 
retiremnt_19_9.
if a>-4 b=a.
end repeat.
EXECUTE.

do repeat a= R6399906 to T8731907    
/b= retiremnt_01_1 retiremnt_02_1 retiremnt_03_1 retiremnt_04_1 retiremnt_05_1 retiremnt_06_1 retiremnt_07_1 retiremnt_08_1 retiremnt_09_1 retiremnt_10_1 
retiremnt_11_1 retiremnt_01_2 retiremnt_02_2 retiremnt_03_2 retiremnt_04_2 retiremnt_05_2 retiremnt_06_2 retiremnt_07_2 retiremnt_08_2 retiremnt_09_2 
retiremnt_10_2 retiremnt_11_2 retiremnt_02_3 retiremnt_03_3 retiremnt_04_3 retiremnt_05_3 retiremnt_06_3 retiremnt_07_3 retiremnt_08_3 retiremnt_09_3 
retiremnt_10_3 retiremnt_11_3 retiremnt_03_4 retiremnt_05_4 retiremnt_06_4 retiremnt_08_4 retiremnt_09_4 retiremnt_10_4 retiremnt_11_4 retiremnt_02_5 
retiremnt_05_5 retiremnt_07_5 retiremnt_08_5 retiremnt_09_5 retiremnt_10_5 retiremnt_08_6 retiremnt_09_6 retiremnt_07_7 retiremnt_17_1 retiremnt_19_1 
retiremnt_17_2 retiremnt_19_2 retiremnt_17_3 retiremnt_19_3 retiremnt_17_4 retiremnt_19_4 retiremnt_17_5 retiremnt_19_5 retiremnt_17_6 retiremnt_19_6 
retiremnt_17_8 retiremnt_17_9 retiremnt_13_1 retiremnt_15_1 retiremnt_13_2 retiremnt_15_2 retiremnt_13_3 retiremnt_15_3 retiremnt_13_4 retiremnt_15_4 
retiremnt_13_5 retiremnt_15_5 retiremnt_13_6.
if a>-4 b=a.
end repeat.
EXECUTE.

recode R4770900 (-3 thru -1=COPY)(0 thru 5=0)(6=1)(7 thru highest=0) into retiremnt_00_1.
recode R4771000 (-3 thru -1=COPY)(0 thru 5=0)(6=1)(2 thru highest=0) into retiremnt_00_2.
if R6400100>-4 retiremnt_01_1=-2.
if R6400100=0 retiremnt_01_1 =0.
if R6400200>-4 retiremnt_01_2 =-2.
if R6400200=0 retiremnt_01_2 =0.
if R6400300>-4 retiremnt_01_3 =-2.
if R6400300=0 retiremnt_01_3 =0.
EXECUTE.

SAVE OUTFILE='D:\NLSY97_Kopyckaetal\Source_jobdata.sav'
 /COMPRESSED.

************************************************************ STEP 2. CREATION OF LONG PERSON-JOB DATAFILE

DATASET ACTIVATE Source_jobdata.
varstocases
/make wave from wave1 to wave183
/make wavejobID from wavejobID1 to wavejobID183
/make curflag from R0525200 to U4489800
/make internship from R0526500 to U4494200
/make milit from milit1 to milit7 R2469000 to U4498600 
/make selfemp from selfemp1 to selfemp25 R5309200 to U4502300
/make start_yr from R0529702 to U4492002
/make start_mt from R0529701 to U4492001
/make end_yr from R0530402 to U4490902
/make end_mt from R0530401 to U4490901
/make UID from R0531100 to U4493100
/make compensation from R1207800 to U3445400
/make hoursweek from R1209101 to U3449800
/make paidleave from paidleave1 to paidleave183
/make medins from medins_97_1 to medins_19_9
/make retiremnt from retiremnt_97_1 to retiremnt_19_9
/index = jobnum
/keep = R0000100 to U3302800.

var lab paidleave 'Access to benefits: paid leave'
/ medins 'Access to benefits: medical insurance'
/ retiremnt 'Access to benefits: retirement plans'.

val lab paidleave -1 'Missing data: refusal or DK if has paid leave'
 -2 'Missing data: DK number of days paid leave' -3 'Invalid skip'
 /medins -1 'Missing: refusal' -2 'Missing: DK' -3 'Missing: invalid skip'
 /retiremnt -1 'Missing: refusal' -2 'Missing: DK' -3 'Missing: invalid skip'. 
mis val paidleave medins retiremnt (-3 thru -1).

SAVE OUTFILE='D:\NLSY97_Kopyckaetal\Jobdata_long.sav'
 /COMPRESSED.
DATASET NAME jobdata.

* Remove empty records.
* Note: there are inconsistencies in the curjob flag and UID variable - one of these has code -4 while the other has not
 Concerns only 5 jobs (job 2 in 2005 (1 case), 2006 (3 cases) and 2009 / WILL NOT AFFECT SRM CALCULATIONS - NOTIFY NLSY TEAM, leave all cases in dataset

select if UID>0 or curflag>-4.
EXECUTE.

* Monthly variables to identify which surveys the data for a given month come from
* Up to the date of first interview since 1994 – assign first wave.
* Months always come first in NLSY notations
  
do repeat a=Monthround1 to Monthround19 / b=R1209402 R2568302 R3890302 R5472302 R7236102 S1550902 S2020802 S3822002 S5422002 S7524102
T0024502 T2019402 T3610002 T5210402 T6661402 T8132902 U0013202 U1850702 U3450202
/ c=R1209401 R2568301 R3890301 R5472301 R7236101 S1550901 S2020801 S3822001 S5422001 S7524101 T0024501 T2019401 T3610001 T5210401
T6661401 T8132901 U0013201 U1850701 U3450201.
compute a=(b-1994)*12+c.
end repeat.
autorecode wave / into round.
EXECUTE.
do repeat a=Monthround1 to Monthround19 / b=1 to 19.
if round=b Monthround=a.
end repeat.
EXECUTE.

do repeat a=R1209402 R2568302 R3890302 R5472302 R7236102 S1550902 S2020802 S3822002 S5422002 S7524102
T0024502 T2019402 T3610002 T5210402 T6661402 T8132902 U0013202 U1850702 U3450202 / b=1 to 19.
if round=b Round_yr=a.
end repeat.
EXECUTE.

* NxtRnd_mX - number of survey round from which data on this month come from
Monthly variables cover the period January 1994 to December 2020.
* 0 means that respondent will not turn 14 this year.
* 1-19 means that the data on this month come from this survey round
* -3 are months with missing data as they are later than the last survey R participated in (drop out)

do repeat a=NxtRnd_m1 to NxtRnd_m324 / b=1 to 324.
compute a=-3.
if Monthround19>=b a=19.
if Monthround18>=b a=18.
if Monthround17>=b a=17.
if Monthround16>=b a=16.
if Monthround15>=b a=15.
if Monthround14>=b a=14.
if Monthround13>=b a=13.
if Monthround12>=b a=12.
if Monthround11>=b a=11.
if Monthround10>=b a=10.
if Monthround9>=b a=9.
if Monthround8>=b a=8.
if Monthround7>=b a=7.
if Monthround6>=b a=6.
if Monthround5>=b a=5.
if Monthround4>=b a=4.
if Monthround3>=b a=3.
if Monthround2>=b a=2.
if Monthround1>=b a=1.
if (R0536402-1980)*12>=b a=0.
end repeat.
formats Monthround1 to Monthround19 Monthround Round_yr NxtRnd_m1 to NxtRnd_m324 (F2.0).
EXECUTE.

* DLI variables taking into account respondent dropout - in continuous months starting from January 1994
* Based on: previous wave ID and interview dates.

compute yearDLI2=R1209402.
compute monthDLI2=R1209401.
do repeat a=yearDLI3 to yearDLI19 / b=R3957400 to U3302800 / c=R2568302 R3890302 R5472302 R7236102 S1550902 S2020802 S3822002 S5422002 S7524102 T0024502
T2019402 T3610002 T5210402 T6661402 T8132902 U0013202 U1850702 / d=2 to 18 / e=monthDLI3 to monthDLI19 / f= R2568301 R3890301 R5472301 R7236101 S1550901
S2020801 S3822001 S5422001 S7524101 T0024501 T2019401 T3610001 T5210401 T6661401 T8132901 U0013201 U1850701.
if b=d a=c.
if b=1 a=R1209402.
if b=d e=f.
if b=1 e=R1209401.
end repeat.
if R3957400=-4 yearDLI3=R2568302.
if R3957400=-4 monthDLI3=R2568301.
formats yearDLI2 to yearDLI19 (F2.0).
formats monthDLI2 to monthDLI19 (F2.0).
EXECUTE.

do repeat a=DLIRnd_m1 to DLIRnd_m324 / b=1 to 324.
compute a=-3.
if Monthround19>=b a=( yearDLI19-1994)*12+monthDLI19.
if Monthround18>=b a=( yearDLI18-1994)*12+monthDLI18.
if Monthround17>=b a=( yearDLI17-1994)*12+monthDLI17.
if Monthround16>=b a=( yearDLI16-1994)*12+monthDLI16.
if Monthround15>=b a=( yearDLI15-1994)*12+monthDLI15.
if Monthround14>=b a=( yearDLI14-1994)*12+monthDLI14.
if Monthround13>=b a=( yearDLI13-1994)*12+monthDLI13.
if Monthround12>=b a=( yearDLI12-1994)*12+monthDLI12.
if Monthround11>=b a=( yearDLI11-1994)*12+monthDLI11.
if Monthround10>=b a=( yearDLI10-1994)*12+monthDLI10.
if Monthround9>=b a=( yearDLI9-1994)*12+monthDLI9.
if Monthround8>=b a=( yearDLI8-1994)*12+monthDLI8.
if Monthround7>=b a=( yearDLI7-1994)*12+monthDLI7.
if Monthround6>=b a=( yearDLI6-1994)*12+monthDLI6.
if Monthround5>=b a=( yearDLI5-1994)*12+monthDLI5.
if Monthround4>=b a=( yearDLI4-1994)*12+monthDLI4.
if Monthround3>=b a=( yearDLI3-1994)*12+monthDLI3.
if Monthround2>=b a=( yearDLI2-1994)*12+monthDLI2.
if Monthround1>=b a=-5.
end repeat.
formats DLIRnd_m1 to DLIRnd_m324 (F3.0).
mis val DLIRnd_m1 to DLIRnd_m324 (-5, -3).
EXECUTE.

* Variable applies only to months up to the month of the last wave R participated in, all later months are coded -3
* -3 are months with missing data as they are later than the last survey R participated in (drop out)
* -5 are months up to the first round (1997)

SAVE OUTFILE='D:\NLSY97_Kopyckaetal\Jobdata_long.sav'
 /COMPRESSED.

* Job type variable
 Note that military jobs are not present in 1997 and self-employment is flagged only since 2000.

compute Jobtype=10.
If internship=1 Jobtype=30.
If milit=1 Jobtype=40.
If selfemp=1 Jobtype=20.
formats Jobtype (F2.0).
val lab Jobtype 10 'Employee-type job' 20 'Self-employment' 30 'Internship' 40 'Military'.
EXECUTE.

* Preparation of 324 monthly status variables for each job record 
* (but excluding self-employment in the first 3 (and partly 4-5) waves of the survey, these need to be taken from the freelance variables, as per the documentation)
* Values
 -2 respondent does not turn 14 this year
 -6 month covered by next survey wave
 -5 month covered by previous survey wave
 -3 month beyond observation range (after most recent wave)
 0 not working this job
 11 first month of job as reported
 12 first month of job (left censored) - applies starting from round 2
 13 first month of job (imputed)
 21 next months of job
 31 last month of job as reported
 32 last month of job censored by survey (ongoing job)
 41 first and last month of job as reported
 42 first and last month of job (first month censored by survey) - applies since round 2
 43 first and last month of job (last month censored by survey) - ongoing job
 0.5 job started or ended this year, month not known
 0.1 job reported in retrospective period covered by this survey wave, year not known.


* NOTE: due to inconsistencies in the CURFLAG variable some job spells have additional unnecessary 32 codes (concerns 14 cases)
This will be cleaned at a later point, after reshaping the dataset.

do repeat a=JobStat_m1 to JobStat_m324 / b=NxtRnd_m1 to NxtRnd_m324 / c=1 to 324 / d=DLIRnd_m1 to DLIRnd_m324.
if b=0 a=-2.
if b>0 and b<round a=-5.
if b=round a=0.
if b=round and (start_yr-1994)*12+start_mt=c a=11.
if b=round and (start_yr-1994)*12+start_mt<c and (end_yr-1994)*12+end_mt>c a=21.
if b=round and (R0536402-1980)*12+1=c and (start_yr-1994)*12+start_mt<c and (end_yr-1994)*12+end_mt>c a=13.
if b=round and d+1=c and (start_yr-1994)*12+start_mt<c and (end_yr-1994)*12+end_mt>c a=12.
if b=round and start_mt>=-3 and start_mt<0 and (start_yr-1994)*12<=c and (start_yr-1994)*12+12>=c a=0.5.
if b=round and start_mt>=-3 and start_mt<0 and (start_yr-1994)*12+12<c and (end_yr-1994)*12+end_yr>c a=21.
if b=round and start_yr>=-4 and start_yr<0 and (end_yr-1994)*12+end_mt>c a=0.1.
if b=round and (end_yr-1994)*12+end_mt=c a=31.
if b=round and curflag<1 and start_yr=end_yr and start_mt=end_mt and (end_yr-1994)*12+end_mt=c a=41.
if b=round and end_mt>=-3 and end_mt<0 and (start_yr-1994)*12+start_mt<c and (end_yr-1994)*12>=c a=21.
if b=round and end_mt>=-3 and end_mt<0 and (end_yr-1994)*12<c and (end_yr-1994)*12+12>=c a=0.5.
if b=round and end_yr>=-4 and end_yr<0 and (start_yr-1994)*12+start_mt>c a=0.1.
if b=round and start_yr>=-4 and start_yr<0 and end_yr>=-3 and end_yr<0 a=0.1.
if b=round and curflag=1 and Monthround=c a=32.
if b=round and curflag=1 and start_yr=end_yr and start_mt=end_mt and (end_yr-1994)*12+end_mt=c a=43.
if b=round and curflag=1 and (start_yr-1994)*12+start_mt=Monthround and Monthround=c a=43.
if b=round and d+1=c and (start_yr-1994)*12+start_mt<c and (end_yr-1994)*12+end_mt=c a=42.
if b>round a=-6.
if b=-3 a=-3.
end repeat.
formats JobStat_m1 to JobStat_m324 (F2.1).
EXECUTE.

SAVE OUTFILE='D:\NLSY97_Kopyckaetal\Jobdata_long.sav'
 /COMPRESSED.

************************************************************ STEP 3. CREATION OF DATAFILE FOR JOB GAPS & ADDING GAP INFO TO LONG PERSON-JOB FILE

* A total of 396 job gaps recorded in the dataset
 This syntax creates 396 variables: wave specific ID of the gap linking it to the job, number of the gap, beginning and end dates of the gap (year / week)
 reason, whether job search present, reason not searching for work
 Note: since 2000 information on reasons and job search coded in separate variables for the self-employed

* Keep from the original dataset:
  1. Respondent ID & wave dates
  2. Gap dates
  3. Self-employment flags
  4. Reason - employees
  5. Other reasons - employees
  6. Reason - self-employed & additional verbatim variables
  7. Job search - employees
  8. Job search - self-employed
  9. Reason for inactivity - employees
  10. Reason for inactivity - self-employed

DATASET ACTIVATE Sourcedata.

SAVE OUTFILE='D:\NLSY97_Kopyckaetal\Sourcegapdata.sav'
 /KEEP= R0000100 R0000100 R0536402 R1209401 R1209402 R2568301 R2568302 R3890301 R3890302 R5472301 R5472302 R7236101 R7236102 S1550901 
 S1550902 S2020801 S2020802 S3822001 S3822002 S5422001 S5422002 S7524101 S7524102 T0024501 T0024502 T2019401 T2019402 T3610001 T3610002
T5210401 T5210402 T6661401 T6661402 T8132901 T8132902 U0013201 U0013202 U1850701 U1850702 U3450201 U3450202
 E1011701 to E1073501 E2011701 to E2073501 E3011701 to E3073501 E4011701 to E4073501
 R5309200 R7050300 S1519900 S3585900 S5239600 S7029800 S9000900 T1410600 T3507200 T4937100 T6590200 T8097600 T9339600 U1354200
U3097800 U4501300 S1520800 S3586800 T8098500 T9340500 U1355100 U3098700 U4502200 S1520900 T8098600 U1355200 U3098800 U4502300
T8098700 U1355300 U3098900 T8098800 U3099000 U3099100 U3099200 R5309300 R7050400 S1520000 S3586000 S5239700 S7029900 S9001000
T1410700 T3507300 T4937200 T6590300 T8097700 T9339700 U1354300 U3097900 U4501400 R5309400 R7050500 S1520100 S3586100 S5239800
S7030000 S9001100 T1410800 T3507400 T4937300 T6590400 T8097800 T9339800 U1354400 U3098000 U4501500 R5309500 R7050600 S1520200
S3586200 S5239900 S7030100 S9001200 T1410900 T3507500 T4937400 T6590500 T8097900 T9339900 U1354500 U3098100 U4501600 R5309600
R7050700 S1520300 S3586300 S5240000 S7030200 S9001300 T1411000 T3507600 T4937500 T6590600 T8098000 T9340000 U1354600 U3098200
U4501700 R5309700 R7050800 S1520400 S3586400 S5240100 S7030300 S9001400 T1411100 T3507700 T4937600 T6590700 T8098100 T9340100
U1354700 U3098300 U4501800 R5309800 R7050900 S1520500 S3586500 S5240200 S7030400 S9001500 T1411200 T3507800 T4937700 T6590800
T8098200 T9340200 U1354800 U3098400 U4501900 R5309900 R7051000 S1520600 S3586600 S7030500 S9001600 T1411300 T3507900 T4937800
T6590900 T8098300 T9340300 U1354900 U3098500 U4502000 R5310000 S1520700 S3586700 S7030600 S9001700 T4937900 T6591000 T8098400
T9340400 U1355000 U3098600 U4502100
R0254600 R0254700 R0254800 R0254900 R0255000 R0255100 R0255200 R0255300 R0255400 R0255500 R0255600 R2067300 R2067400 R2067500
R2067600 R2067700 R2067800 R2067900 R2068000 R2068100 R3401800 R3401900 R3402000 R3402100 R3402200 R4790200 R4790300 R4790400
R4790500 R4790600 R4790700 R4790800 R4790900 R4791000 R4791100 R6414800 R6414900 R6415000 R6415100 R6415200 R6415300 S0846500
S0846600 S0846700 S0846800 S0846900 S2911300 S2911400 S2911500 S2911600 S2911700 S2911800 S2911900 S2912000 S2912100 S2912200
S4616400 S4616500 S4616600 S4616700 S4616800 S4616900 S4617000 S4617100 S4617200 S4617300 S4617400 S4617500 S6239700 S6239800
S6239900 S6240000 S6240100 S6240200 S6240300 S8259500 S8259600 S8259700 S8259800 T0672500 T0672600 T0672700 T0672800 T0672900
T0673000 T0673100 T2713900 T2714000 T2714100 T2714200 T2714300 T2714400 T4200400 T4200500 T4200600 T4200700 T4200800 T4200900
T4201000 T4201100 T5834100 T5834200 T5834300 T5834400 T5834500 T5834600 T5834700 T5834800 T5834900 T5835000 T5835100 T5835200
T5835300 T7268600 T7268700 T7268800 T7268900 T7269000 T7269100 T8762100 T8762200 T8762300 T8762400 T8762500 T8762600 T8762700
U0682000 U0682100 U0682200 U0682300 U0682400 U0682500 U0682600 U0682700 U0682800 U2620700 U2620800 U2620900 U2621000 U2621100
U4067100 U4067200 U4067300 U4067400 U4067500 U4067600 U4067700 U4068800 R0255700 R0255800 R0255900 R0256000 R0256100 R0256200
R2068200 R2068300 R2068400 R2068500 R2068600 R3402300 R3402400 R3402500 R3402600 R3402700 R3402800 R4791200 R4791300 R4791400
R4791500 R4791600 R6415400 R6415500 R6415600 S0847000 S0847100 S0847200 S0847300 S0847400 S0847500 S0847600 S2912300 S2912400
S2912500 S4617600 S4617700 S4617800 S6240400 S6240500 S6240600 S6240700 S6240800 S8259900 S8260000 S8260100 S8260200 S8260300
S8260400 S8260500 T0673200 T0673300 T0673400 T0673500 T2714500 T2714600 T2714700 T2714800 T4201200 T4201300 T4201400 T4201500
T4201600 T4201700 T5835400 T5835500 T5835600 T5835700 T5835800 T5835900 T5836000 T5836100 T5836200 T7269200 T7269300 T7269400
T8762800 T8762900 T8763000 T8763100 T8763200 T8763300 T8763400 U0682900 U0683000 U0683100 U0683200 U0683300 U0683400 U0683500
U0683600 U0683700 U2621200 U2621300 U2621400 U2621500 U2621600 U4067800 U4067900 U4068000 R0256300 R0256400 R2068700 R2068800
R2068900 R2069000 R3402900 R3403000 R3403100 R4791700 R4791800 R4791900 R6415700 R6415800 R6415900 S0847700 S0847800 S0847900
S2912600 S2912700 S4617900 S4618000 S4618100 S6240900 S6241000 S6241100 S8260600 S8260700 T0673600 T0673700 T2714900 T2715000
T4201800 T4201900 T4202000 T5836300 T5836400 T5836500 T5836600 T7269500 T7269600 T7269700 T8763500 T8763600 T8763700 T8763800
U0683800 U0683900 U0684000 U0684100 U2621700 U2621800 U2621900 U2622000 U2622100 U2622200 U2622300 U4068100 U4068200 U4068300
R0256500 R2069100 R2069200 R3403200 R3403300 R4792000 R4792100 R4792200 R6416000 R6416100 S0848000 S0848100 S2912800 S2912900
S4618200 S4618300 S6241200 S6241300 S8260800 S8260900 T0673800 T0673900 T2715100 T2715200 T4202100 T5836700 T5836800 T7269800
T7269900 T8763900 T8764000 T8764100 U0684200 U0684300 U2622400 U2622500 U4068400 U4068500 U4068600 R0256600 R2069300 R2069400
R3403400 R3403500 R4792300 R6416200 S0848200 S0848300 S2913000 S2913100 S4618400 S6241400 S8261000 T0674000 T0674100 T2715300
T2715400 T2715500 T4202200 T8764200 U0684400 U2622600 U4068700 R0256700 R2069500 R4792400 S6241500 S6241600 T7270000 T8764300
U0684500 U2622700 T8764400 T8764500 U2622800
R2069600 R2069700 R2069800 R2069900 R2070000 R2070100 R2070200 R2070300 R2070400 R3403600 R3403700 R3403800 R3403900 R3404000
R4792500 R4792600 R4792700 R4792800 R4792900 R4793000 R6416300 R6416400 R6416500 R6416600 R6416700 R6416800 S0848400 S0848500
S0848600 S0848700 S0848800 S2913200 S2913300 S2913400 S2913500 S2913600 S4618500 S4618600 S4618700 S4618800 S4618900 S4619000
S4619100 S6241700 S6241800 S6241900 S6242000 S8261100 S8261200 S8261300 S8261400 T0674200 T0674300 T0674400 T0674500 T0674600
T2715600 T2715700 T2715800 T2715900 T2716000 T4202300 T4202400 T4202500 T4202600 T5836900 T5837000 T5837100 T5837200 T5837300
T5837400 T5837500 T5837600 T5837700 T5837800 T5837900 T5838000 T5838100 T7270100 T7270200 T7270300 T7270400 T8764600 T8764700
T8764800 T8764900 T8765000 U0684600 U0684700 U0684800 U0684900 U0685000 U0685100 U0685200 U0685300 U2622900 U2623000 U2623100
U2623200 U2623300 U4068900 U4069000 U4069100 U4069200 U4070200 R2070500 R2070600 R2070700 R2070800 R2070900 R3404100 R3404200
R3404300 R3404400 R4793100 R4793200 R4793300 R4793400 R4793500 R6416900 R6417000 R6417100 S0848900 S0849000 S0849100 S0849200
S2913700 S2913800 S2913900 S4619200 S4619300 S4619400 S6242100 S6242200 S6242300 S6242400 S6242500 S8261500 S8261600 S8261700
S8261800 T0674700 T0674800 T0674900 T0675000 T2716100 T2716200 T2716300 T2716400 T4202700 T4202800 T4202900 T4203000 T5838200
T5838300 T5838400 T5838500 T5838600 T5838700 T5838800 T5838900 T5839000 T7270500 T7270600 T7270700 T8765100 T8765200 T8765300
U0685400 U0685500 U0685600 U0685700 U2623400 U2623500 U2623600 U4069300 U4069400 U4069500 R2071000 R2071100 R2071200 R2071300
R3404500 R3404600 R3404700 R4793600 R4793700 R4793800 R6417200 R6417300 R6417400 S0849300 S0849400 S2914000 S2914100 S4619500
S4619600 S4619700 S6242600 S6242700 S6242800 S8261900 S8262000 T0675100 T0675200 T2716500 T2716600 T4203100 T4203200 T4203300
T5839100 T5839200 T7270800 T7270900 T7271000 T8765400 T8765500 U0685800 U0685900 U0686000 U2623700 U2623800 U4069600 U4069700
R2071400 R3404800 R3404900 R4793900 R4794000 R6417500 S0849500 S0849600 S2914200 S2914300 S4619800 S4619900 S6242900 S8262100
S8262200 T0675300 T0675400 T2716700 T2716800 T4203400 T5839300 T7271100 T8765600 T8765700 T8765800 U0686100 U2623900 U2624000
U4069800 U4069900 U4070000 R2071500 R3405000 R4794100 R6417600 S0849700 S0849800 S2914400 S2914500 S4620000 S6243000 S8262300
T2716900 T2717000 T8765900 U0686200 U2624100 U4070100 R2071600 R4794200 S6243100 S6243200 T7271200 T8766000 U0686300 T8766100
U2624200 R0256800 R0256900 R0257000 R0257100 R0257200 R0257300 R0257400 R0257500 R0257600 R0257700 R0257800 R0257900 R0258000
R0258100 R0258200 R0258300
R4809600 R6431900 S0863300 S2928500 S4632300 S4632400 S4632500 S6256600 S6256700 S6256800 S8274500 S8274600 S8274700 T0686700
T0686800 T0686900 T0687000 T0687100 T0687200 T2733700 T2733800 T2733900 T2734000 T2734100 T4218400 T4218500 T4218600 T4218700
T5857300 T5857400 T5857500 T5857600 T5857700 T5857800 T5857900 T5858000 T5858100 T5858200 T5858300 T7283200 T7283300 T7283400
T7283500 T8786000 T8786100 T8786200 T8786300 T8786400 T8786500 T8786600 T8786700 T8786800 U0707100 U0707200 U0707300 U0707400
U0707500 U0707600 U2644700 U2644800 U2644900 U2645000 U2645100 U2645200 U2645300 U2645400 U2645500 U2645600 U2645700 U2645800
U2645900 U2646000 U4087000 U4087100 U4087200 U4087300 U4087400 U4087500 U4087600 U4087700 U4087800 U4087900 R4809700 R6432000
S0863400 S2928600 S4632600 S4632700 S4632800 S6256900 S6257000 S6257100 S8274800 S8274900 T0687300 T0687400 T2734200 T2734300
T2734400 T4218800 T4218900 T4219000 T4219100 T4219200 T4219300 T4219400 T5858400 T5858500 T5858600 T5858700 T5858800 T5858900
T5859000 T7283600 T7283700 T7283800 T7283900 T8786900 T8787000 T8787100 T8787200 T8787300 U0707700 U0707800 U0707900 U0708000
U0708100 U0708200 U0708300 U2646100 U2646200 U2646300 U2646400 U2646500 U2646600 U4088000 U4088100 U4088200 U4088300 U4088400
R4809800 R6432100 S0863500 S2928700 S4632900 S6257200 S6257300 S6257400 S8275000 T0687500 T0687600 T2734500 T2734600 T2734700
T2734800 T2734900 T2735000 T4219500 T4219600 T5859100 T7284000 T8787400 T8787500 T8787600 T8787700 U0708400 U0708500 U0708600
U2646700 U2646800 U4088500 R6432200 S0863600 S2928800 S4633000 S6257500 S8275100 S8275200 T2735100 T2735200 T2735300 T2735400
T7284100 T7284200 T8787800 U0708700 U2646900 U4088600 U4088700 U4088800 R6432300 S6257600 T4219700 U2647000 U0708800 U4088900
U0709200 U0709300 U0709400
R0263900 R0264000 R0264100 R2077100 R2077200 R2077300 R2077400 R3409400 R3409500 R3409600 R4799900 R4800000 R4800100 R4800200
R4800300 R4800400 R6422000 R6422100 R6422200 S0854000 S0854100 S0854200 S2919100 S2919200 S2919300 S4624500 S4624600 S4624700
S6247500 S6247600 S8267100 S8267200 S8267300 T0679000 T0679100 T2721700 T2721800 T2721900 T4208200 T4208300 T4208400 T5845400
T5845500 T7275200 T7275300 T8772300 T8772400 T8772500 T8772600 T8772700 U0693400 U0693500 U0693600 U0693700 U0693800 U2629300
U2629400 U2629500 U4074500 U4074600 R0264200 R0264300 R2077500 R2077600 R2077700 R3409700 R3409800 R4800500 R4800600 R6422300
R6422400 S0854300 S2919400 S2919500 S4624800 S4624900 S6247700 S6247800 S8267400 S8267500 T0679200 T2722000 T2722100 T4208500
T4208600 T5845600 T5845700 T7275400 T8772800 T8772900 T8773000 T8773100 U0693900 U0694000 U2629600 U4074700 R2077800 R3409900
R4800700 R6422500 R6422600 S0854400 S2919600 S4625000 S6247900 S8267600 T0679300 T2722200 T2722300 T4208700 T5845800 T7275500
T8773200 T8773300 U0694100 U2629700 U2629800 U4074800 R2077900 R3410000 R4800800 R6422700 S2919700 T4208800 T5845900 U0694200
U2629900 U4074900 T2722400 U0694300 U2630000 R0264400 U0694400
R6433200 S0864600 S2930000 S6259500 S6259600 S8276900 T0689600 T0689700 T0689800 T2738600 T2738700 T2738800 T4222900 T4223000
T4223100 T5862200 T5862300 T5862400 T5862500 T5862600 T7286300 T7286400 T8791200 T8791300 U0711800 U0711900 U2650600 U2650700
U4091900 S0864700 S2930100 S6259700 S8277000 T0689900 T0690000 T2738900 T2739000 T4223200 T7286500 T7286600 T8791400 T8791500
U0712000 U2650800 U4092000 S2930200 T4223300 T5862700 T8791600 U2650900 U2651000 U4092100 S2930300 U0712100 U2651100 U0712200
U4092200
R0265100 R0265200 R0265300 R0265400 R0265500 R0265600 R0265700 R0265800 R0265900 R0266000 R0266100 R2078900 R2079000 R2079100
R2079200 R2079300 R2079400 R2079500 R2079600 R2079700 R3410800 R3410900 R3411000 R3411100 R3411200 R4801900 R4802000 R4802100
R4802200 R4802300 R4802400 R4802500 R4802600 R4802700 R4802800 R6423600 R6423700 R6423800 R6423900 R6424000 R6424100 S0855000
S0855100 S0855200 S0855300 S0855400 S2920500 S2920600 S2920700 S2920800 S2920900 S2921000 S2921100 S2921200 S2921300 S2921400
S4625700 S4625800 S4625900 S4626000 S4626100 S4626200 S4626300 S4626400 S4626500 S4626600 S4626700 S4626800 S6248500 S6248600
S6248700 S6248800 S6248900 S6249000 S6249100 S8268300 S8268400 S8268500 S8268600 T0679800 T0679900 T0680000 T0680100 T0680200
T2723300 T2723400 T2723500 T2723600 T2723700 T2723800 T4209600 T4209700 T4209800 T4209900 T4210000 T5846600 T5846700 T5846800
T5846900 T7276000 T7276100 T7276200 T7276300 T7276400 T7276500 T8774500 T8774600 T8774700 T8774800 T8774900 T8775000 T8775100
U0695600 U0695700 U0695800 U0695900 U0696000 U0696100 U0696200 U0696300 U0696400 U2630900 U2631000 U2631100 U2631200 U2631300
U4075500 U4075600 U4075700 U4075800 U4075900 U4077000 R0266200 R0266300 R0266400 R0266500 R0266600 R0266700 R2079800 R2079900
R2080000 R2080100 R2080200 R3411300 R3411400 R3411500 R3411600 R4802900 R4803000 R4803100 R4803200 R4803300 R6424200 R6424300
R6424400 S0855500 S0855600 S0855700 S0855800 S0855900 S0856000 S0856100 S2921500 S2921600 S2921700 S4626900 S4627000 S4627100
S6249200 S6249300 S6249400 S6249500 S6249600 S8268700 S8268800 S8268900 S8269000 S8269100 S8269200 S8269300 T0680300 T0680400
T0680500 T0680600 T2723900 T2724000 T2724100 T2724200 T4210100 T4210200 T4210300 T4210400 T4210500 T4210600 T5847000 T5847100
T5847200 T5847300 T5847400 T5847500 T5847600 T5847700 T5847800 T7276600 T7276700 T8775200 T8775300 T8775400 T8775500 T8775600
T8775700 T8775800 U0696500 U0696600 U0696700 U0696800 U0696900 U0697000 U0697100 U0697200 U0697300 U2631400 U2631500 U2631600
U2631700 U2631800 U4076000 U4076100 U4076200 R0266800 R0266900 R2080300 R2080400 R2080500 R2080600 R3411700 R3411800 R3411900
R4803400 R4803500 R4803600 R6424500 R6424600 R6424700 S0856200 S0856300 S0856400 S2921800 S2921900 S4627200 S4627300 S4627400
S6249700 S6249800 S6249900 S8269400 S8269500 T0680700 T0680800 T2724300 T2724400 T4210700 T4210800 T4210900 T5847900 T5848000
T7276800 T7276900 T7277000 T8775900 T8776000 T8776100 T8776200 U0697400 U0697500 U0697600 U0697700 U2631900 U2632000 U2632100
U2632200 U2632300 U2632400 U2632500 U4076300 U4076400 U4076500 R0267000 R2080700 R3412000 R3412100 R4803700 R4803800 R4803900
R6424800 R6424900 S0856500 S0856600 S2922000 S2922100 S4627500 S4627600 S6250000 S6250100 S8269600 S8269700 T0680900 T0681000
T2724500 T2724600 T4211000 T5848100 T5848200 T7277100 T7277200 T8776300 T8776400 T8776500 U0697800 U2632600 U2632700 U4076600
U4076700 U4076800 R0267100 R2080800 R2080900 R3412200 R3412300 R4804000 R6425000 S0856700 S0856800 S2922200 S2922300 S4627700
S6250200 S8269800 T0681100 T0681200 T2724700 T2724800 T2724900 T4211100 T8776600 U0697900 U2632800 U4076900 R2081000 R4804100
S6250300 S6250400 T7277300 T8776700 U0698000 U2632900 T8776800 T8776900 U2633000
R4810500 R6433400 S0865000 S2930800 S4634600 S4634700 S4634800 S6259800 S6259900 S6260000 S8277300 S8277400 S8277500 T0690600
T0690700 T0690800 T0690900 T0691000 T0691100 T2739600 T2739700 T2739800 T2739900 T4223900 T4224000 T4224100 T5863400 T5863500
T5863600 T5863700 T5863800 T5863900 T7287100 T7287200 T7287300 T7287400 T8792200 T8792300 T8792400 T8792500 U0712800 U0712900
U0713000 U0713100 U0713200 U0713300 U2651800 U2651900 U2652000 U2652100 U2652200 U2652300 U2652400 U2652500 U2652600 U2652700
U2652800 U2652900 U2653000 U2653100 U4092700 U4092800 U4092900 U4093000 U4093100 U4093200 U4093300 U4093400 U4093500 U4093600
R4810600 R6433500 S0865100 S2930900 S4634900 S4635000 S4635100 S6260100 S6260200 S6260300 S8277600 S8277700 T0691200 T0691300
T2740000 T2740100 T2740200 T4224200 T4224300 T4224400 T4224500 T4224600 T4224700 T4224800 T5864000 T5864100 T5864200 T5864300
T5864400 T5864500 T7287500 T7287600 T7287700 T7287800 T8792600 T8792700 T8792800 T8792900 T8793000 U0713400 U0713500 U0713600
U0713700 U0713800 U0713900 U0714000 U2653200 U2653300 U2653400 U2653500 U2653600 U2653700 U4093700 U4093800 U4093900 U4094000
U4094100 R6433600 S0865200 S2931000 S4635200 S6260400 S6260500 S6260600 S8277800 T0691400 T0691500 T2740300 T2740400 T2740500
T2740600 T2740700 T2740800 T4224900 T4225000 T5864600 T7287900 T8793100 T8793200 T8793300 T8793400 U0714100 U0714200 U0714300
U2653800 U2653900 U4094200 R6433700 S0865300 S2931100 S8277900 S8278000 T2740900 T2741000 T2741100 T2741200 T7288000 T7288100
T8793500 U0714400 U2654000 U4094300 U4094400 U4094500 R6433800 S6260700 T4225100 U2654100 U0714500 U4094600
 /COMPRESSED.

GET FILE='D:\NLSY97_Kopyckaetal\Sourcegapdata.sav'.
DATASET NAME Sourcegapdata.

* Creating 396 wave-specific job ID variable to link gaps to jobs.

do repeat a=E1011701 to E1073501 / b=wavejobID1 to wavejobID396
/c=199701 199701 199701 199701 199701 199701 199701 199701 199701 199701 199701 199801 199801 199801 199801 199801 199801 199801 199801 199901
199901 199901 199901 199901 200001 200001 200001 200001 200001 200001 200001 200001 200001 200001 200101 200101 200101 200101 200101 200101
200201 200201 200201 200201 200201 200301 200301 200301 200301 200301 200301 200301 200301 200301 200301 200401 200401 200401 200401 200401
200401 200401 200401 200401 200401 200401 200401 200501 200501 200501 200501 200501 200501 200501 200601 200601 200601 200601 200701 200701
200701 200701 200701 200701 200701 200801 200801 200801 200801 200801 200801 200901 200901 200901 200901 200901 200901 200901 200901 201001
201001 201001 201001 201001 201001 201001 201001 201001 201001 201001 201001 201001 201101 201101 201101 201101 201101 201101 201301 201301
201301 201301 201301 201301 201301 201301 201301 201501 201501 201501 201501 201501 201501 201501 201501 201501 201701 201701 201701 201701
201701 201701 201701 201701 201701 201701 201701 201701 201701 201701 201901 201901 201901 201901 201901 201901 201901 201901 201901 201901
199702 199702 199702 199702 199702 199802 199802 199802 199802 199802 199902 199902 199902 199902 200002 200002 200002 200002 200002 200102
200102 200102 200202 200202 200202 200202 200202 200202 200302 200302 200302 200402 200402 200402 200502 200502 200502 200502 200502 200602
200602 200602 200602 200602 200602 200602 200602 200702 200702 200702 200702 200802 200802 200802 200802 200902 200902 200902 200902 200902
200902 200902 201002 201002 201002 201002 201002 201002 201002 201002 201002 201102 201102 201102 201302 201302 201302 201302 201302 201302
201302 201502 201502 201502 201502 201502 201502 201502 201502 201702 201702 201702 201702 201702 201702 201902 201902 201902 201902 201902
199703 199703 199803 199803 199803 199803 199903 199903 199903 200003 200003 200003 200103 200103 200103 200203 200203 200203 200303 200303
200403 200403 200403 200503 200503 200503 200603 200603 200703 200703 200803 200803 200803 200803 200803 200803 200903 200903 200903 201003
201003 201003 201003 201103 201103 201103 201303 201303 201303 201303 201503 201503 201503 201503 201703 201703 201703 201703 201703 201703
201703 201903 201903 201903 199704 199804 199804 199904 199904 200004 200004 200104 200204 200204 200304 200304 200404 200404 200504 200504
200604 200604 200704 200704 200804 200804 200804 200904 201004 201004 201104 201104 201304 201304 201304 201504 201704 201704 201904 201904
201904 199705 199805 199805 199905 199905 200005 200105 200205 200205 200305 200305 200405 200505 200605 200705 200705 200805 200805 200905
201305 201505 201705 201905 199706 199806 200006 200506 200506 201106 201306 201506 201706 201307 201307 201907. 
if a>=-3 b=c.
end repeat.
do repeat a=E1011701 to E1073501 / b=gapnum1 to gapnum396
/c=01 02 03 04 05 06 07 08 09 10 11 01 02 03 04 05 06 07 08 01 02 03 04 05 01 02 03 04 05 06 07 08 09 10 01 02 03 04 05 06 01 02 03 04 05 01 02 03 04 05
06 07 08 09 10 01 02 03 04 05 06 07 08 09 10 11 12 01 02 03 04 05 06 07 01 02 03 04 01 02 03 04 05 06 07 01 02 03 04 05 06 01 02 03 04 05 06 07 08 01
02 03 04 05 06 07 08 09 10 11 12 13 01 02 03 04 05 06 01 02 03 04 05 06 07 08 09 01 02 03 04 05 06 07 08 09 01 02 03 04 05 06 07 08 09 10 11 12 13 14
01 02 03 04 05 06 07 08 09 10 01 02 03 04 05 01 02 03 04 05 01 02 03 04 01 02 03 04 05 01 02 03 01 02 03 04 06 07 01 02 03 01 02 03 01 02 03 04 05 01
02 03 04 05 06 07 08 01 02 03 04 01 02 03 04 01 02 03 04 05 06 07 01 02 03 04 05 06 07 08 09 01 02 03 01 02 03 04 05 06 07 01 02 03 04 05 06 07 08 01
02 03 04 05 06 01 02 03 04 05 01 02 01 02 03 04 01 02 03 01 02 03 01 02 03 01 02 03 01 02 01 02 03 01 02 03 01 02 01 02 01 02 03 04 05 06 01 02 03 01
02 03 04 01 02 03 01 02 03 04 01 02 03 04 01 02 03 04 05 06 07 01 02 03 01 01 02 01 02 01 02 01 01 02 01 02 01 02 01 02 01 02 01 02 01 02 03 01 01 02
01 02 01 02 03 01 01 02 01 02 03 01 01 02 01 02 01 01 01 02 01 02 01 01 01 01 02 01 02 01 01 01 01 01 01 01 01 01 02 01 01 01 01 01 02 01. 
if a>=-3 b=c.
end repeat.
formats wavejobID1 to wavejobID396 (F6.0) / gapnum1 to gapnum396 (F2.0).
EXECUTE.

* Creating convenient self-employment flags to combine information on reasons and job search for different types of jobs.

do repeat a= SEMP00_1 SEMP01_1 SEMP02_1 SEMP03_1 SEMP04_1 SEMP05_1 SEMP06_1 SEMP07_1 SEMP08_1 SEMP09_1 SEMP10_1 SEMP11_1 SEMP13_1 SEMP15_1 
SEMP17_1 SEMP19_1 SEMP02_10 SEMP03_10 SEMP11_10 SEMP13_10 SEMP15_10 SEMP17_10 SEMP19_10 SEMP02_11 SEMP11_11 SEMP15_11 SEMP17_11 SEMP19_11
SEMP11_12 SEMP15_12 SEMP17_12 SEMP11_13 SEMP17_13 SEMP17_14 SEMP17_15 SEMP00_2 SEMP01_2 SEMP02_2 SEMP03_2 SEMP04_2 SEMP05_2 SEMP06_2 
SEMP07_2 SEMP08_2 SEMP09_2 SEMP10_2 SEMP11_2 SEMP13_2 SEMP15_2 SEMP17_2 SEMP19_2 SEMP00_3 SEMP01_3 SEMP02_3 SEMP03_3 SEMP04_3 
SEMP05_3 SEMP06_3 SEMP07_3 SEMP08_3 SEMP09_3 SEMP10_3 SEMP11_3 SEMP13_3 SEMP15_3 SEMP17_3 SEMP19_3 SEMP00_4 SEMP01_4 SEMP02_4 
SEMP03_4 SEMP04_4 SEMP05_4 SEMP06_4 SEMP07_4 SEMP08_4 SEMP09_4 SEMP10_4 SEMP11_4 SEMP13_4 SEMP15_4 SEMP17_4 SEMP19_4 SEMP00_5 
SEMP01_5 SEMP02_5 SEMP03_5 SEMP04_5 SEMP05_5 SEMP06_5 SEMP07_5 SEMP08_5 SEMP09_5 SEMP10_5 SEMP11_5 SEMP13_5 SEMP15_5 SEMP17_5 
SEMP19_5 SEMP00_6 SEMP01_6 SEMP02_6 SEMP03_6 SEMP04_6 SEMP05_6 SEMP06_6 SEMP07_6 SEMP08_6 SEMP09_6 SEMP10_6 SEMP11_6 SEMP13_6 
SEMP15_6 SEMP17_6 SEMP19_6 SEMP00_7 SEMP01_7 SEMP02_7 SEMP03_7 SEMP04_7 SEMP05_7 SEMP06_7 SEMP07_7 SEMP08_7 SEMP09_7 SEMP10_7 
SEMP11_7 SEMP13_7 SEMP15_7 SEMP17_7 SEMP19_7 SEMP00_8 SEMP01_8 SEMP02_8 SEMP03_8 SEMP05_8 SEMP06_8 SEMP07_8 SEMP08_8 SEMP09_8 
SEMP10_8 SEMP11_8 SEMP13_8 SEMP15_8 SEMP17_8 SEMP19_8 SEMP00_9 SEMP02_9 SEMP03_9 SEMP05_9 SEMP06_9 SEMP09_9 SEMP10_9 SEMP11_9 
SEMP13_9 SEMP15_9 SEMP17_9 SEMP19_9
/b= R5309200 to U4502100.
compute a=b.
end repeat.
EXECUTE.

* Reasons for job gaps (based on 4 variable groups: main reason; additional reason; reason in case of gaps in self-employment; verbatim responses).

do repeat a= REASON97_01_01 REASON97_01_02 REASON97_01_03 REASON97_01_04 REASON97_01_05 REASON97_01_06 REASON97_01_07 REASON97_01_08 REASON97_01_09
REASON97_01_10 REASON97_01_11 REASON98_01_01 REASON98_01_02 REASON98_01_03 REASON98_01_04 REASON98_01_05 REASON98_01_06 REASON98_01_07
REASON98_01_08 REASON99_01_01 REASON99_01_02 REASON99_01_03 REASON99_01_04 REASON99_01_05 REASON00_01_01 REASON00_01_02 REASON00_01_03
REASON00_01_04 REASON00_01_05 REASON00_01_06 REASON00_01_07 REASON00_01_08 REASON00_01_09 REASON00_01_10 REASON01_01_01 REASON01_01_02
REASON01_01_03 REASON01_01_04 REASON01_01_05 REASON01_01_06 REASON02_01_01 REASON02_01_02 REASON02_01_03 REASON02_01_04 REASON02_01_05
REASON03_01_01 REASON03_01_02 REASON03_01_03 REASON03_01_04 REASON03_01_05 REASON03_01_06 REASON03_01_07 REASON03_01_08 REASON03_01_09
REASON03_01_10 REASON04_01_01 REASON04_01_02 REASON04_01_03 REASON04_01_04 REASON04_01_05 REASON04_01_06 REASON04_01_07 REASON04_01_08
REASON04_01_09 REASON04_01_10 REASON04_01_11 REASON04_01_12 REASON05_01_01 REASON05_01_02 REASON05_01_03 REASON05_01_04 REASON05_01_05
REASON05_01_06 REASON05_01_07 REASON06_01_01 REASON06_01_02 REASON06_01_03 REASON06_01_04 REASON07_01_01 REASON07_01_02 REASON07_01_03
REASON07_01_04 REASON07_01_05 REASON07_01_06 REASON07_01_07 REASON08_01_01 REASON08_01_02 REASON08_01_03 REASON08_01_04 REASON08_01_05
REASON08_01_06 REASON09_01_01 REASON09_01_02 REASON09_01_03 REASON09_01_04 REASON09_01_05 REASON09_01_06 REASON09_01_07 REASON09_01_08
REASON10_01_01 REASON10_01_02 REASON10_01_03 REASON10_01_04 REASON10_01_05 REASON10_01_06 REASON10_01_07 REASON10_01_08 REASON10_01_09
REASON10_01_10 REASON10_01_11 REASON10_01_12 REASON10_01_13 REASON11_01_01 REASON11_01_02 REASON11_01_03 REASON11_01_04 REASON11_01_05
REASON11_01_06 REASON13_01_01 REASON13_01_02 REASON13_01_03 REASON13_01_04 REASON13_01_05 REASON13_01_06 REASON13_01_07 REASON13_01_08
REASON13_01_09 REASON15_01_01 REASON15_01_02 REASON15_01_03 REASON15_01_04 REASON15_01_05 REASON15_01_06 REASON15_01_07 REASON15_01_08
REASON15_01_09 REASON17_01_01 REASON17_01_02 REASON17_01_03 REASON17_01_04 REASON17_01_05 REASON17_01_06 REASON17_01_07 REASON17_01_08
REASON17_01_09 REASON17_01_10 REASON17_01_11 REASON17_01_12 REASON17_01_13 REASON17_01_14 REASON19_01_01 REASON19_01_02 REASON19_01_03
REASON19_01_04 REASON19_01_05 REASON19_01_06 REASON19_01_07 REASON19_01_08 REASON19_01_09 REASON19_01_10 REASON97_02_01 REASON97_02_02
REASON97_02_03 REASON97_02_04 REASON97_02_05 REASON98_02_01 REASON98_02_02 REASON98_02_03 REASON98_02_04 REASON98_02_05 REASON99_02_01
REASON99_02_02 REASON99_02_03 REASON99_02_04 REASON00_02_01 REASON00_02_02 REASON00_02_03 REASON00_02_04 REASON00_02_05 REASON01_02_01
REASON01_02_02 REASON01_02_03 REASON02_02_01 REASON02_02_02 REASON02_02_03 REASON02_02_04 REASON02_02_06 REASON02_02_07 REASON03_02_01
REASON03_02_02 REASON03_02_03 REASON04_02_01 REASON04_02_02 REASON04_02_03 REASON05_02_01 REASON05_02_02 REASON05_02_03 REASON05_02_04
REASON05_02_05 REASON06_02_01 REASON06_02_02 REASON06_02_03 REASON06_02_04 REASON06_02_05 REASON06_02_06 REASON06_02_07 REASON06_02_08
REASON07_02_01 REASON07_02_02 REASON07_02_03 REASON07_02_04 REASON08_02_01 REASON08_02_02 REASON08_02_03 REASON08_02_04 REASON09_02_01
REASON09_02_02 REASON09_02_03 REASON09_02_04 REASON09_02_05 REASON09_02_06 REASON09_02_07 REASON10_02_01 REASON10_02_02 REASON10_02_03
REASON10_02_04 REASON10_02_05 REASON10_02_06 REASON10_02_07 REASON10_02_08 REASON10_02_09 REASON11_02_01 REASON11_02_02 REASON11_02_03
REASON13_02_01 REASON13_02_02 REASON13_02_03 REASON13_02_04 REASON13_02_05 REASON13_02_06 REASON13_02_07 REASON15_02_01 REASON15_02_02
REASON15_02_03 REASON15_02_04 REASON15_02_05 REASON15_02_06 REASON15_02_07 REASON15_02_08 REASON17_02_01 REASON17_02_02 REASON17_02_03
REASON17_02_04 REASON17_02_05 REASON17_02_06 REASON19_02_01 REASON19_02_02 REASON19_02_03 REASON19_02_04 REASON19_02_05 REASON97_03_01
REASON97_03_02 REASON98_03_01 REASON98_03_02 REASON98_03_03 REASON98_03_04 REASON99_03_01 REASON99_03_02 REASON99_03_03 REASON00_03_01
REASON00_03_02 REASON00_03_03 REASON01_03_01 REASON01_03_02 REASON01_03_03 REASON02_03_01 REASON02_03_02 REASON02_03_03 REASON03_03_01
REASON03_03_02 REASON04_03_01 REASON04_03_02 REASON04_03_03 REASON05_03_01 REASON05_03_02 REASON05_03_03 REASON06_03_01 REASON06_03_02
REASON07_03_01 REASON07_03_02 REASON08_03_01 REASON08_03_02 REASON08_03_03 REASON08_03_04 REASON08_03_05 REASON08_03_06 REASON09_03_01
REASON09_03_02 REASON09_03_03 REASON10_03_01 REASON10_03_02 REASON10_03_03 REASON10_03_04 REASON11_03_01 REASON11_03_02 REASON11_03_03
REASON13_03_01 REASON13_03_02 REASON13_03_03 REASON13_03_04 REASON15_03_01 REASON15_03_02 REASON15_03_03 REASON15_03_04 REASON17_03_01
REASON17_03_02 REASON17_03_03 REASON17_03_04 REASON17_03_05 REASON17_03_06 REASON17_03_07 REASON19_03_01 REASON19_03_02 REASON19_03_03
REASON97_04_01 REASON98_04_01 REASON98_04_02 REASON99_04_01 REASON99_04_02 REASON00_04_01 REASON00_04_02 REASON01_04_01 REASON02_04_01
REASON02_04_02 REASON03_04_01 REASON03_04_02 REASON04_04_01 REASON04_04_02 REASON05_04_01 REASON05_04_02 REASON06_04_01 REASON06_04_02
REASON07_04_01 REASON07_04_02 REASON08_04_01 REASON08_04_02 REASON08_04_03 REASON09_04_01 REASON10_04_01 REASON10_04_02 REASON11_04_01
REASON11_04_02 REASON13_04_01 REASON13_04_02 REASON13_04_03 REASON15_04_01 REASON17_04_01 REASON17_04_02 REASON19_04_01 REASON19_04_02
REASON19_04_03 REASON97_05_01 REASON98_05_01 REASON98_05_02 REASON99_05_01 REASON99_05_02 REASON00_05_01 REASON01_05_01 REASON02_05_01
REASON02_05_02 REASON03_05_01 REASON03_05_02 REASON04_05_01 REASON05_05_01 REASON06_05_01 REASON07_05_01 REASON07_05_02 REASON08_05_01
REASON08_05_02 REASON09_05_01 REASON13_05_01 REASON15_05_01 REASON17_05_01 REASON19_05_01 REASON97_06_01 REASON98_06_01 REASON00_06_01
REASON05_06_01 REASON05_06_02 REASON11_06_01 REASON13_06_01 REASON15_06_01 REASON17_06_01 REASON13_07_01 REASON13_07_02 REASON19_07_01.
numeric a (F2.0).
end repeat.

do repeat a= REASON97_01_01 REASON97_01_02 REASON97_01_03 REASON97_01_04 REASON97_01_05 REASON97_01_06 REASON97_01_07 REASON97_01_08 REASON97_01_09
REASON97_01_10 REASON97_01_11 REASON98_01_01 REASON98_01_02 REASON98_01_03 REASON98_01_04 REASON98_01_05 REASON98_01_06 REASON98_01_07
REASON98_01_08 REASON98_01_09 REASON99_01_01 REASON99_01_02 REASON99_01_03 REASON99_01_04 REASON99_01_05 REASON00_01_01 REASON00_01_02
REASON00_01_03 REASON00_01_04 REASON00_01_05 REASON00_01_06 REASON00_01_07 REASON00_01_08 REASON00_01_09 REASON00_01_10 REASON01_01_01
REASON01_01_02 REASON01_01_03 REASON01_01_04 REASON01_01_05 REASON01_01_06 REASON02_01_01 REASON02_01_02 REASON02_01_03 REASON02_01_04
REASON02_01_05 REASON03_01_01 REASON03_01_02 REASON03_01_03 REASON03_01_04 REASON03_01_05 REASON03_01_06 REASON03_01_07 REASON03_01_08
REASON03_01_09 REASON03_01_10 REASON04_01_01 REASON04_01_02 REASON04_01_03 REASON04_01_04 REASON04_01_05 REASON04_01_06 REASON04_01_07
REASON04_01_08 REASON04_01_09 REASON04_01_10 REASON04_01_11 REASON04_01_12 REASON05_01_01 REASON05_01_02 REASON05_01_03 REASON05_01_04
REASON05_01_05 REASON05_01_06 REASON05_01_07 REASON06_01_01 REASON06_01_02 REASON06_01_03 REASON06_01_04 REASON07_01_01 REASON07_01_02
REASON07_01_03 REASON07_01_04 REASON07_01_05 REASON07_01_06 REASON07_01_07 REASON08_01_01 REASON08_01_02 REASON08_01_03 REASON08_01_04
REASON08_01_05 REASON08_01_06 REASON09_01_01 REASON09_01_02 REASON09_01_03 REASON09_01_04 REASON09_01_05 REASON09_01_06 REASON09_01_07
REASON09_01_08 REASON10_01_01 REASON10_01_02 REASON10_01_03 REASON10_01_04 REASON10_01_05 REASON10_01_06 REASON10_01_07 REASON10_01_08
REASON10_01_09 REASON10_01_10 REASON10_01_11 REASON10_01_12 REASON10_01_13 REASON11_01_01 REASON11_01_02 REASON11_01_03 REASON11_01_04
REASON11_01_05 REASON11_01_06 REASON13_01_01 REASON13_01_02 REASON13_01_03 REASON13_01_04 REASON13_01_05 REASON13_01_06 REASON13_01_07
REASON15_01_01 REASON15_01_02 REASON15_01_03 REASON15_01_04 REASON15_01_05 REASON15_01_06 REASON15_01_07 REASON15_01_08 REASON15_01_09
REASON17_01_01 REASON17_01_02 REASON17_01_03 REASON17_01_04 REASON17_01_05 REASON19_01_01 REASON19_01_02 REASON19_01_03 REASON19_01_04
REASON19_01_05 REASON19_01_06 REASON19_01_07 REASON19_10_01 REASON97_02_01 REASON97_02_02 REASON97_02_03 REASON97_02_04 REASON97_02_05
REASON97_02_06 REASON98_02_01 REASON98_02_02 REASON98_02_03 REASON98_02_04 REASON98_02_05 REASON99_02_01 REASON99_02_02 REASON99_02_03
REASON99_02_04 REASON99_02_05 REASON99_02_06 REASON00_02_01 REASON00_02_02 REASON00_02_03 REASON00_02_04 REASON00_02_05 REASON01_02_01
REASON01_02_02 REASON01_02_03 REASON02_02_01 REASON02_02_02 REASON02_02_03 REASON02_02_04 REASON02_02_05 REASON02_02_06 REASON02_02_07
REASON03_02_01 REASON03_02_02 REASON03_02_03 REASON04_02_01 REASON04_02_02 REASON04_02_03 REASON05_02_01 REASON05_02_02 REASON05_02_03
REASON05_02_04 REASON05_02_05 REASON06_02_01 REASON06_02_02 REASON06_02_03 REASON06_02_04 REASON06_02_05 REASON06_02_06 REASON06_02_07
REASON07_02_01 REASON07_02_02 REASON07_02_03 REASON07_02_04 REASON08_02_01 REASON08_02_02 REASON08_02_03 REASON08_02_04 REASON09_02_01
REASON09_02_02 REASON09_02_03 REASON09_02_04 REASON09_02_05 REASON09_02_06 REASON10_02_01 REASON10_02_02 REASON10_02_03 REASON10_02_04
REASON10_02_05 REASON10_02_06 REASON10_02_07 REASON10_02_08 REASON10_02_09 REASON11_02_01 REASON11_02_02 REASON11_02_03 REASON13_02_01
REASON13_02_02 REASON13_02_03 REASON13_02_04 REASON13_02_05 REASON13_02_06 REASON13_02_07 REASON15_02_01 REASON15_02_02 REASON15_02_03
REASON15_02_04 REASON15_02_05 REASON15_02_06 REASON15_02_07 REASON15_02_08 REASON15_02_09 REASON17_02_01 REASON17_02_02 REASON17_02_03
REASON17_02_04 REASON17_02_05 REASON19_02_01 REASON19_02_02 REASON19_02_03 REASON97_03_01 REASON97_03_02 REASON98_03_01 REASON98_03_02
REASON98_03_03 REASON98_03_04 REASON99_03_01 REASON99_03_02 REASON99_03_03 REASON00_03_01 REASON00_03_02 REASON00_03_03 REASON01_03_01
REASON01_03_02 REASON01_03_03 REASON02_03_01 REASON02_03_02 REASON02_03_03 REASON03_03_01 REASON03_03_02 REASON04_03_01 REASON04_03_02
REASON04_03_03 REASON05_03_01 REASON05_03_02 REASON05_03_03 REASON06_03_01 REASON06_03_02 REASON07_03_01 REASON07_03_02 REASON08_03_01
REASON08_03_02 REASON09_03_01 REASON09_03_02 REASON09_03_03 REASON10_03_01 REASON10_03_02 REASON10_03_03 REASON10_03_04 REASON11_03_01
REASON11_03_02 REASON11_03_03 REASON13_03_01 REASON13_03_02 REASON13_03_03 REASON13_03_04 REASON15_03_01 REASON15_03_02 REASON15_03_03
REASON15_03_04 REASON17_03_01 REASON17_03_02 REASON17_03_03 REASON17_03_04 REASON17_03_05 REASON17_03_06 REASON17_03_07 REASON19_03_01
REASON19_03_02 REASON19_03_03 REASON97_04_01 REASON98_04_01 REASON98_04_02 REASON99_04_01 REASON99_04_02 REASON00_04_01 REASON00_04_02
REASON00_04_03 REASON01_04_01 REASON01_04_02 REASON02_04_01 REASON02_04_02 REASON03_04_01 REASON03_04_02 REASON04_04_01 REASON04_04_02
REASON05_04_01 REASON05_04_02 REASON06_04_01 REASON06_04_02 REASON07_04_01 REASON07_04_02 REASON08_04_01 REASON08_04_02 REASON09_04_01
REASON10_04_01 REASON10_04_02 REASON11_04_01 REASON11_04_02 REASON13_04_01 REASON13_04_02 REASON13_04_03 REASON15_04_01 REASON15_04_02
REASON17_04_01 REASON17_04_02 REASON19_04_01 REASON19_04_02 REASON19_04_03 REASON97_05_01 REASON98_05_01 REASON98_05_02 REASON99_05_01
REASON99_05_02 REASON00_05_01 REASON01_05_01 REASON02_05_01 REASON02_05_02 REASON03_05_01 REASON03_05_02 REASON04_05_01 REASON05_05_01
REASON06_05_01 REASON07_05_01 REASON07_05_02 REASON08_05_01 REASON08_05_02 REASON08_05_03 REASON09_05_01 REASON13_05_01 REASON15_05_01
REASON17_05_01 REASON19_05_01 REASON97_06_01 REASON98_06_01 REASON00_06_01 REASON05_06_01 REASON05_06_02 REASON11_06_01 REASON13_06_01
REASON15_06_01 REASON17_06_01 REASON13_07_01 REASON13_07_02 REASON17_07_01 
/b= R0254600 to U2622800. 
compute a=b.
end repeat.

do repeat a= REASON98_01_01 REASON98_01_02 REASON98_01_03 REASON98_01_04 REASON98_01_05 REASON98_01_06 REASON98_01_07 REASON98_01_08 REASON98_01_09
REASON99_01_01 REASON99_01_02 REASON99_01_03 REASON99_01_04 REASON99_01_05 REASON00_01_01 REASON00_01_02 REASON00_01_03 REASON00_01_04
REASON00_01_05 REASON00_01_06 REASON01_01_01 REASON01_01_02 REASON01_01_03 REASON01_01_04 REASON01_01_05 REASON01_01_06 REASON02_01_01
REASON02_01_02 REASON02_01_03 REASON02_01_04 REASON02_01_05 REASON03_01_01 REASON03_01_02 REASON03_01_03 REASON03_01_04 REASON03_01_05
REASON04_01_01 REASON04_01_02 REASON04_01_03 REASON04_01_04 REASON04_01_05 REASON04_01_06 REASON04_01_07 REASON05_01_01 REASON05_01_02
REASON05_01_03 REASON05_01_04 REASON06_01_01 REASON06_01_02 REASON06_01_03 REASON06_01_04 REASON07_01_01 REASON07_01_02 REASON07_01_03
REASON07_01_04 REASON07_01_05 REASON08_01_01 REASON08_01_02 REASON08_01_03 REASON08_01_04 REASON08_01_05 REASON09_01_01 REASON09_01_02
REASON09_01_03 REASON09_01_04 REASON10_01_01 REASON10_01_02 REASON10_01_03 REASON10_01_04 REASON10_01_05 REASON10_01_06 REASON10_01_07
REASON10_01_08 REASON10_01_09 REASON10_01_10 REASON10_01_11 REASON10_01_12 REASON10_01_13 REASON11_01_01 REASON11_01_02 REASON11_01_03
REASON11_01_04 REASON13_01_01 REASON13_01_02 REASON13_01_03 REASON13_01_04 REASON13_01_05 REASON15_01_01 REASON15_01_02 REASON15_01_03
REASON15_01_04 REASON15_01_05 REASON15_01_06 REASON15_01_07 REASON15_01_08 REASON17_01_01 REASON17_01_02 REASON17_01_03 REASON17_01_04
REASON17_01_05 REASON19_01_01 REASON19_01_02 REASON19_01_03 REASON19_01_04 REASON19_10_01 REASON98_02_01 REASON98_02_02 REASON98_02_03
REASON98_02_04 REASON98_02_05 REASON99_02_01 REASON99_02_02 REASON99_02_03 REASON99_02_04 REASON00_02_01 REASON00_02_02 REASON00_02_03
REASON00_02_04 REASON00_02_05 REASON01_02_01 REASON01_02_02 REASON01_02_03 REASON02_02_01 REASON02_02_02 REASON02_02_03 REASON02_02_04
REASON03_02_01 REASON03_02_02 REASON03_02_03 REASON04_02_01 REASON04_02_02 REASON04_02_03 REASON05_02_01 REASON05_02_02 REASON05_02_03
REASON05_02_04 REASON05_02_05 REASON06_02_01 REASON06_02_02 REASON06_02_03 REASON06_02_04 REASON07_02_01 REASON07_02_02 REASON07_02_03
REASON07_02_04 REASON08_02_01 REASON08_02_02 REASON08_02_03 REASON08_02_04 REASON09_02_01 REASON09_02_02 REASON09_02_03 REASON09_02_04
REASON10_02_01 REASON10_02_02 REASON10_02_03 REASON10_02_04 REASON10_02_05 REASON10_02_06 REASON10_02_07 REASON10_02_08 REASON10_02_09
REASON11_02_01 REASON11_02_02 REASON11_02_03 REASON13_02_01 REASON13_02_02 REASON13_02_03 REASON15_02_01 REASON15_02_02 REASON15_02_03
REASON15_02_04 REASON17_02_01 REASON17_02_02 REASON17_02_03 REASON19_02_01 REASON19_02_02 REASON19_02_03 REASON98_03_01 REASON98_03_02
REASON98_03_03 REASON98_03_04 REASON99_03_01 REASON99_03_02 REASON99_03_03 REASON00_03_01 REASON00_03_02 REASON00_03_03 REASON01_03_01
REASON01_03_02 REASON01_03_03 REASON02_03_01 REASON02_03_02 REASON03_03_01 REASON03_03_02 REASON04_03_01 REASON04_03_02 REASON04_03_03
REASON05_03_01 REASON05_03_02 REASON05_03_03 REASON06_03_01 REASON06_03_02 REASON07_03_01 REASON07_03_02 REASON08_03_01 REASON08_03_02
REASON09_03_01 REASON09_03_02 REASON09_03_03 REASON10_03_01 REASON10_03_02 REASON11_03_01 REASON11_03_02 REASON11_03_03 REASON13_03_01
REASON13_03_03 REASON15_03_01 REASON15_03_02 REASON15_03_03 REASON17_03_01 REASON17_03_02 REASON19_03_01 REASON19_03_02 REASON98_04_01
REASON99_04_01 REASON99_04_02 REASON00_04_01 REASON00_04_02 REASON01_04_01 REASON02_04_01 REASON02_04_02 REASON03_04_01 REASON03_04_02
REASON04_04_01 REASON04_04_02 REASON05_04_01 REASON06_04_01 REASON06_04_02 REASON07_04_01 REASON07_04_02 REASON08_04_01 REASON08_04_02
REASON09_04_01 REASON10_04_01 REASON11_04_01 REASON13_04_01 REASON13_04_02 REASON13_04_03 REASON15_04_01 REASON17_04_01 REASON17_04_02
REASON19_04_01 REASON19_04_02 REASON19_04_03 REASON98_05_01 REASON99_05_01 REASON00_05_01 REASON01_05_01 REASON02_05_01 REASON02_05_02
REASON03_05_01 REASON03_05_02 REASON04_05_01 REASON05_05_01 REASON06_05_01 REASON08_05_01 REASON08_05_02 REASON13_05_01 REASON15_05_01
REASON17_05_01 REASON19_05_01 REASON98_06_01 REASON00_06_01 REASON05_06_01 REASON05_06_02 REASON11_06_01 REASON13_06_01 REASON15_06_01
REASON13_07_01 REASON17_07_01 REASON97_01_01 REASON97_01_02 REASON97_01_03 REASON97_01_04 REASON97_01_05 REASON97_01_06 REASON97_01_07
REASON97_02_01 REASON97_02_02 REASON97_02_03 REASON97_02_04 REASON97_02_05 REASON97_02_06 REASON97_03_01 REASON97_04_01 REASON97_06_01
/ b= R2069600 to R0258300.
if a=5 a=b.
end repeat.
EXECUTE.

val lab REASON97_01_01 to REASON19_07_01 
 1 "On strike"
 2 "On layoff"
 3 "Quit job but returned to same employer"
 4 "Job ended for a period of time but began again"
 5 "Some other reason you went on unpaid vacation/leave"
 6 "Going to school"
 7 "In the Armed Forces"
 8 "Pregnancy"
 9 "Had health problems"
 10 "Had problems with child care"
 11 "Had other personal or family reason"
 12 "FOR SCHOOL EMPLOYEES ONLY: School shut down"
 13 "Did not want to work"
 14 "Some other reason".

do repeat a = SEMP00_1 SEMP01_1 SEMP02_1 SEMP03_1 SEMP04_1 SEMP04_1 SEMP04_1 SEMP05_1 SEMP05_1 SEMP05_1 SEMP06_1 SEMP06_1 SEMP06_1 SEMP07_1
SEMP07_1 SEMP07_1 SEMP07_1 SEMP07_1 SEMP07_1 SEMP08_1 SEMP08_1 SEMP08_1 SEMP08_1 SEMP08_1 SEMP09_1 SEMP09_1 SEMP09_1 SEMP09_1
SEMP10_1 SEMP10_1 SEMP10_1 SEMP10_1 SEMP10_1 SEMP10_1 SEMP10_1 SEMP10_1 SEMP10_1 SEMP10_1 SEMP10_1 SEMP11_1 SEMP11_1 SEMP11_1
SEMP11_1 SEMP13_1 SEMP13_1 SEMP13_1 SEMP13_1 SEMP13_1 SEMP13_1 SEMP13_1 SEMP13_1 SEMP13_1 SEMP15_1 SEMP15_1 SEMP15_1 SEMP15_1
SEMP15_1 SEMP15_1 SEMP17_1 SEMP17_1 SEMP17_1 SEMP17_1 SEMP17_1 SEMP17_1 SEMP17_1 SEMP17_1 SEMP17_1 SEMP17_1 SEMP17_1 SEMP17_1
SEMP17_1 SEMP17_1 SEMP19_1 SEMP19_1 SEMP19_1 SEMP19_1 SEMP19_1 SEMP19_1 SEMP19_1 SEMP19_1 SEMP19_1 SEMP19_1 SEMP00_2 SEMP01_2
SEMP02_2 SEMP03_2 SEMP04_2 SEMP04_2 SEMP04_2 SEMP05_2 SEMP05_2 SEMP05_2 SEMP06_2 SEMP06_2 SEMP07_2 SEMP07_2 SEMP08_2 SEMP08_2
SEMP08_2 SEMP09_2 SEMP09_2 SEMP09_2 SEMP09_2 SEMP09_2 SEMP09_2 SEMP09_2 SEMP10_2 SEMP10_2 SEMP10_2 SEMP10_2 SEMP10_2 SEMP10_2
SEMP10_2 SEMP11_2 SEMP11_2 SEMP11_2 SEMP11_2 SEMP13_2 SEMP13_2 SEMP13_2 SEMP13_2 SEMP13_2 SEMP15_2 SEMP15_2 SEMP15_2 SEMP15_2
SEMP15_2 SEMP15_2 SEMP15_2 SEMP17_2 SEMP17_2 SEMP17_2 SEMP17_2 SEMP17_2 SEMP17_2 SEMP19_2 SEMP19_2 SEMP19_2 SEMP19_2 SEMP19_2
SEMP00_3 SEMP01_3 SEMP02_3 SEMP03_3 SEMP04_3 SEMP05_3 SEMP05_3 SEMP05_3 SEMP06_3 SEMP07_3 SEMP07_3 SEMP08_3 SEMP08_3 SEMP08_3
SEMP08_3 SEMP08_3 SEMP08_3 SEMP09_3 SEMP09_3 SEMP10_3 SEMP11_3 SEMP13_3 SEMP13_3 SEMP13_3 SEMP13_3 SEMP15_3 SEMP15_3 SEMP15_3
SEMP17_3 SEMP17_3 SEMP19_3 SEMP01_4 SEMP02_4 SEMP03_4 SEMP04_4 SEMP05_4 SEMP06_4 SEMP06_4 SEMP08_4 SEMP08_4 SEMP08_4 SEMP08_4
SEMP11_4 SEMP11_4 SEMP13_4 SEMP15_4 SEMP17_4 SEMP19_4 SEMP19_4 SEMP19_4 SEMP01_5 SEMP05_5 SEMP09_5 SEMP17_5 SEMP15_6 SEMP19_7
/b= REASON00_01_01 REASON01_01_01 REASON02_01_01 REASON03_01_01 REASON04_01_01 REASON04_01_02 REASON04_01_03 REASON05_01_01
REASON05_01_02 REASON05_01_03 REASON06_01_01 REASON06_01_02 REASON06_01_03 REASON07_01_01 REASON07_01_02 REASON07_01_03 REASON07_01_04
REASON07_01_05 REASON07_01_06 REASON08_01_01 REASON08_01_02 REASON08_01_03 REASON08_01_04 REASON08_01_05 REASON09_01_01 REASON09_01_02
REASON09_01_03 REASON09_01_04 REASON10_01_01 REASON10_01_02 REASON10_01_03 REASON10_01_04 REASON10_01_05 REASON10_01_06 REASON10_01_07
REASON10_01_08 REASON10_01_09 REASON10_01_10 REASON10_01_11 REASON11_01_01 REASON11_01_02 REASON11_01_03 REASON11_01_04 REASON13_01_01
REASON13_01_02 REASON13_01_03 REASON13_01_04 REASON13_01_05 REASON13_01_06 REASON13_01_07 REASON13_01_08 REASON13_01_09 REASON15_01_01
REASON15_01_02 REASON15_01_03 REASON15_01_04 REASON15_01_05 REASON15_01_06 REASON17_01_01 REASON17_01_02 REASON17_01_03 REASON17_01_04
REASON17_01_05 REASON17_01_06 REASON17_01_07 REASON17_01_08 REASON17_01_09 REASON17_01_10 REASON17_01_11 REASON17_01_12 REASON17_01_13
REASON17_01_14 REASON19_01_01 REASON19_01_02 REASON19_01_03 REASON19_01_04 REASON19_01_05 REASON19_01_06 REASON19_01_07 REASON19_01_08
REASON19_01_09 REASON19_01_10 REASON00_02_01 REASON01_02_01 REASON02_02_01 REASON03_02_01 REASON04_02_01 REASON04_02_02 REASON04_02_03
REASON05_02_01 REASON05_02_02 REASON05_02_03 REASON06_02_01 REASON06_02_02 REASON07_02_01 REASON07_02_02 REASON08_02_01 REASON08_02_02
REASON08_02_03 REASON09_02_01 REASON09_02_02 REASON09_02_03 REASON09_02_04 REASON09_02_05 REASON09_02_06 REASON09_02_07 REASON10_02_01
REASON10_02_02 REASON10_02_03 REASON10_02_04 REASON10_02_05 REASON10_02_06 REASON10_02_07 REASON11_02_01 REASON11_02_02 REASON11_02_03
REASON11_02_04 REASON13_02_01 REASON13_02_02 REASON13_02_03 REASON13_02_04 REASON13_02_05 REASON15_02_01 REASON15_02_02 REASON15_02_03
REASON15_02_04 REASON15_02_05 REASON15_02_06 REASON15_02_07 REASON17_02_01 REASON17_02_02 REASON17_02_03 REASON17_02_04 REASON17_02_05
REASON17_02_06 REASON19_02_01 REASON19_02_02 REASON19_02_03 REASON19_02_04 REASON19_02_05 REASON00_03_01 REASON01_03_01 REASON02_03_01
REASON03_03_01 REASON04_03_01 REASON05_03_01 REASON05_03_02 REASON05_03_03 REASON06_03_01 REASON07_03_01 REASON07_03_02 REASON08_03_01
REASON08_03_02 REASON08_03_03 REASON08_03_04 REASON08_03_05 REASON08_03_06 REASON09_03_01 REASON09_03_02 REASON10_03_01 REASON11_03_01
REASON13_03_01 REASON13_03_02 REASON13_03_03 REASON13_03_04 REASON15_03_01 REASON15_03_02 REASON15_03_03 REASON17_03_01 REASON17_03_02
REASON19_03_01 REASON01_04_01 REASON02_04_01 REASON03_04_01 REASON04_04_01 REASON05_04_01 REASON06_04_01 REASON06_04_02 REASON08_04_01
REASON08_04_02 REASON08_04_03 REASON08_04_04 REASON11_04_01 REASON11_04_02 REASON13_04_01 REASON15_04_01 REASON17_04_01 REASON19_04_01
REASON19_04_02 REASON19_04_03 REASON01_05_01 REASON05_05_01 REASON09_05_01 REASON17_05_01 REASON15_06_01 REASON19_07_01 
/c= R4809600 to U4088900.
if a=1 b=c+0.1.
end repeat.
recode REASON97_01_01 to REASON19_07_01 (1.1=2.1)(2.1=2.2)(3.1=2.3).

* Add verbatim responses & code
 
if U0707100=14 and U0709200>0 REASON15_01_01=U0709200+0.5.
if U0707200=14 and U0709300>0 REASON15_01_02=U0709300+0.5.
if U0707700=14 and U0709400>0 REASON15_02_01=U0709400+0.5.
if U0707100=14 and U0709200>3 REASON15_01_01=U0709200+0.1.
if U0707200=14 and U0709300>3 REASON15_01_02=U0709300+0.1.
if U0707700=14 and U0709400>3 REASON15_02_01=U0709400+0.1.
recode REASON97_01_01 to REASON19_07_01 (1.5=2.1)(2.5=2.2)(3.5=2.3).
EXECUTE.

ADD VAL LAB REASON97_01_01 to REASON19_07_01 
 2.1 "* No clients / customers - self employed"
 2.2 "* Didn't have materials / equipment needed - self employment"
 2.3 "* Financial problems - self employment"
 4.1 "* Temporary or season job ended for period but later resumed - self employment" 
 5.1 "* Unpaid vacation - self employment"
 6.1 "* Going to school - SE"
 7.1 "* In the Armed Forces - SE"
 8.1 "* Pregnancy - SE"
 9.1 "* Had health problems - SE"
 10.1 "* Had problems with child care - SE"
 11.1 "* Had other personal or family reason - SE"
 13.1 "* Did not want to work - SE"
 14.1 "* Some other reason SE".

* Code job search variables and reasons for not searching
 
do repeat a=SEARCH97_01_01 SEARCH97_01_02 SEARCH97_01_03 SEARCH97_01_04 SEARCH97_01_05 SEARCH97_01_06 SEARCH97_01_07 SEARCH97_01_08 SEARCH97_01_09
SEARCH97_01_10 SEARCH97_01_11 SEARCH98_01_01 SEARCH98_01_02 SEARCH98_01_03 SEARCH98_01_04 SEARCH98_01_05 SEARCH98_01_06 SEARCH98_01_07
SEARCH98_01_08 SEARCH99_01_01 SEARCH99_01_02 SEARCH99_01_03 SEARCH99_01_04 SEARCH99_01_05 SEARCH00_01_01 SEARCH00_01_02 SEARCH00_01_03
SEARCH00_01_04 SEARCH00_01_05 SEARCH00_01_06 SEARCH00_01_07 SEARCH00_01_08 SEARCH00_01_09 SEARCH00_01_10 SEARCH01_01_01 SEARCH01_01_02
SEARCH01_01_03 SEARCH01_01_04 SEARCH01_01_05 SEARCH01_01_06 SEARCH02_01_01 SEARCH02_01_02 SEARCH02_01_03 SEARCH02_01_04 SEARCH02_01_05
SEARCH03_01_01 SEARCH03_01_02 SEARCH03_01_03 SEARCH03_01_04 SEARCH03_01_05 SEARCH03_01_06 SEARCH03_01_07 SEARCH03_01_08 SEARCH03_01_09
SEARCH03_01_10 SEARCH04_01_01 SEARCH04_01_02 SEARCH04_01_03 SEARCH04_01_04 SEARCH04_01_05 SEARCH04_01_06 SEARCH04_01_07 SEARCH04_01_08
SEARCH04_01_09 SEARCH04_01_10 SEARCH04_01_11 SEARCH04_01_12 SEARCH05_01_01 SEARCH05_01_02 SEARCH05_01_03 SEARCH05_01_04 SEARCH05_01_05
SEARCH05_01_06 SEARCH05_01_07 SEARCH06_01_01 SEARCH06_01_02 SEARCH06_01_03 SEARCH06_01_04 SEARCH07_01_01 SEARCH07_01_02 SEARCH07_01_03
SEARCH07_01_04 SEARCH07_01_05 SEARCH07_01_06 SEARCH07_01_07 SEARCH08_01_01 SEARCH08_01_02 SEARCH08_01_03 SEARCH08_01_04 SEARCH08_01_05
SEARCH08_01_06 SEARCH09_01_01 SEARCH09_01_02 SEARCH09_01_03 SEARCH09_01_04 SEARCH09_01_05 SEARCH09_01_06 SEARCH09_01_07 SEARCH09_01_08
SEARCH10_01_01 SEARCH10_01_02 SEARCH10_01_03 SEARCH10_01_04 SEARCH10_01_05 SEARCH10_01_06 SEARCH10_01_07 SEARCH10_01_08 SEARCH10_01_09
SEARCH10_01_10 SEARCH10_01_11 SEARCH10_01_12 SEARCH10_01_13 SEARCH11_01_01 SEARCH11_01_02 SEARCH11_01_03 SEARCH11_01_04 SEARCH11_01_05
SEARCH11_01_06 SEARCH13_01_01 SEARCH13_01_02 SEARCH13_01_03 SEARCH13_01_04 SEARCH13_01_05 SEARCH13_01_06 SEARCH13_01_07 SEARCH13_01_08
SEARCH13_01_09 SEARCH15_01_01 SEARCH15_01_02 SEARCH15_01_03 SEARCH15_01_04 SEARCH15_01_05 SEARCH15_01_06 SEARCH15_01_07 SEARCH15_01_08
SEARCH15_01_09 SEARCH17_01_01 SEARCH17_01_02 SEARCH17_01_03 SEARCH17_01_04 SEARCH17_01_05 SEARCH17_01_06 SEARCH17_01_07 SEARCH17_01_08
SEARCH17_01_09 SEARCH17_01_10 SEARCH17_01_11 SEARCH17_01_12 SEARCH17_01_13 SEARCH17_01_14 SEARCH19_01_01 SEARCH19_01_02 SEARCH19_01_03
SEARCH19_01_04 SEARCH19_01_05 SEARCH19_01_06 SEARCH19_01_07 SEARCH19_01_08 SEARCH19_01_09 SEARCH19_01_10 SEARCH97_02_01 SEARCH97_02_02
SEARCH97_02_03 SEARCH97_02_04 SEARCH97_02_05 SEARCH98_02_01 SEARCH98_02_02 SEARCH98_02_03 SEARCH98_02_04 SEARCH98_02_05 SEARCH99_02_01
SEARCH99_02_02 SEARCH99_02_03 SEARCH99_02_04 SEARCH00_02_01 SEARCH00_02_02 SEARCH00_02_03 SEARCH00_02_04 SEARCH00_02_05 SEARCH01_02_01
SEARCH01_02_02 SEARCH01_02_03 SEARCH02_02_01 SEARCH02_02_02 SEARCH02_02_03 SEARCH02_02_04 SEARCH02_02_06 SEARCH02_02_07 SEARCH03_02_01
SEARCH03_02_02 SEARCH03_02_03 SEARCH04_02_01 SEARCH04_02_02 SEARCH04_02_03 SEARCH05_02_01 SEARCH05_02_02 SEARCH05_02_03 SEARCH05_02_04
SEARCH05_02_05 SEARCH06_02_01 SEARCH06_02_02 SEARCH06_02_03 SEARCH06_02_04 SEARCH06_02_05 SEARCH06_02_06 SEARCH06_02_07 SEARCH06_02_08
SEARCH07_02_01 SEARCH07_02_02 SEARCH07_02_03 SEARCH07_02_04 SEARCH08_02_01 SEARCH08_02_02 SEARCH08_02_03 SEARCH08_02_04 SEARCH09_02_01
SEARCH09_02_02 SEARCH09_02_03 SEARCH09_02_04 SEARCH09_02_05 SEARCH09_02_06 SEARCH09_02_07 SEARCH10_02_01 SEARCH10_02_02 SEARCH10_02_03
SEARCH10_02_04 SEARCH10_02_05 SEARCH10_02_06 SEARCH10_02_07 SEARCH10_02_08 SEARCH10_02_09 SEARCH11_02_01 SEARCH11_02_02 SEARCH11_02_03
SEARCH13_02_01 SEARCH13_02_02 SEARCH13_02_03 SEARCH13_02_04 SEARCH13_02_05 SEARCH13_02_06 SEARCH13_02_07 SEARCH15_02_01 SEARCH15_02_02
SEARCH15_02_03 SEARCH15_02_04 SEARCH15_02_05 SEARCH15_02_06 SEARCH15_02_07 SEARCH15_02_08 SEARCH17_02_01 SEARCH17_02_02 SEARCH17_02_03
SEARCH17_02_04 SEARCH17_02_05 SEARCH17_02_06 SEARCH19_02_01 SEARCH19_02_02 SEARCH19_02_03 SEARCH19_02_04 SEARCH19_02_05 SEARCH97_03_01
SEARCH97_03_02 SEARCH98_03_01 SEARCH98_03_02 SEARCH98_03_03 SEARCH98_03_04 SEARCH99_03_01 SEARCH99_03_02 SEARCH99_03_03 SEARCH00_03_01
SEARCH00_03_02 SEARCH00_03_03 SEARCH01_03_01 SEARCH01_03_02 SEARCH01_03_03 SEARCH02_03_01 SEARCH02_03_02 SEARCH02_03_03 SEARCH03_03_01
SEARCH03_03_02 SEARCH04_03_01 SEARCH04_03_02 SEARCH04_03_03 SEARCH05_03_01 SEARCH05_03_02 SEARCH05_03_03 SEARCH06_03_01 SEARCH06_03_02
SEARCH07_03_01 SEARCH07_03_02 SEARCH08_03_01 SEARCH08_03_02 SEARCH08_03_03 SEARCH08_03_04 SEARCH08_03_05 SEARCH08_03_06 SEARCH09_03_01
SEARCH09_03_02 SEARCH09_03_03 SEARCH10_03_01 SEARCH10_03_02 SEARCH10_03_03 SEARCH10_03_04 SEARCH11_03_01 SEARCH11_03_02 SEARCH11_03_03
SEARCH13_03_01 SEARCH13_03_02 SEARCH13_03_03 SEARCH13_03_04 SEARCH15_03_01 SEARCH15_03_02 SEARCH15_03_03 SEARCH15_03_04 SEARCH17_03_01
SEARCH17_03_02 SEARCH17_03_03 SEARCH17_03_04 SEARCH17_03_05 SEARCH17_03_06 SEARCH17_03_07 SEARCH19_03_01 SEARCH19_03_02 SEARCH19_03_03
SEARCH97_04_01 SEARCH98_04_01 SEARCH98_04_02 SEARCH99_04_01 SEARCH99_04_02 SEARCH00_04_01 SEARCH00_04_02 SEARCH01_04_01 SEARCH02_04_01
SEARCH02_04_02 SEARCH03_04_01 SEARCH03_04_02 SEARCH04_04_01 SEARCH04_04_02 SEARCH05_04_01 SEARCH05_04_02 SEARCH06_04_01 SEARCH06_04_02
SEARCH07_04_01 SEARCH07_04_02 SEARCH08_04_01 SEARCH08_04_02 SEARCH08_04_03 SEARCH09_04_01 SEARCH10_04_01 SEARCH10_04_02 SEARCH11_04_01
SEARCH11_04_02 SEARCH13_04_01 SEARCH13_04_02 SEARCH13_04_03 SEARCH15_04_01 SEARCH17_04_01 SEARCH17_04_02 SEARCH19_04_01 SEARCH19_04_02
SEARCH19_04_03 SEARCH97_05_01 SEARCH98_05_01 SEARCH98_05_02 SEARCH99_05_01 SEARCH99_05_02 SEARCH00_05_01 SEARCH01_05_01 SEARCH02_05_01
SEARCH02_05_02 SEARCH03_05_01 SEARCH03_05_02 SEARCH04_05_01 SEARCH05_05_01 SEARCH06_05_01 SEARCH07_05_01 SEARCH07_05_02 SEARCH08_05_01
SEARCH08_05_02 SEARCH09_05_01 SEARCH13_05_01 SEARCH15_05_01 SEARCH17_05_01 SEARCH19_05_01 SEARCH97_06_01 SEARCH98_06_01 SEARCH00_06_01
SEARCH05_06_01 SEARCH05_06_02 SEARCH11_06_01 SEARCH13_06_01 SEARCH15_06_01 SEARCH17_06_01 SEARCH13_07_01 SEARCH13_07_02 SEARCH19_07_01.
numeric a (F3.0).
end repeat.

do repeat
a= SEARCH97_01_01 SEARCH97_01_02 SEARCH97_01_04 SEARCH98_01_01 SEARCH98_01_02 SEARCH98_01_03 SEARCH98_01_05 SEARCH99_01_01 SEARCH99_01_02
SEARCH99_01_03 SEARCH00_01_01 SEARCH00_01_02 SEARCH00_01_03 SEARCH00_01_04 SEARCH00_01_05 SEARCH00_01_06 SEARCH01_01_01 SEARCH01_01_02
SEARCH01_01_03 SEARCH02_01_01 SEARCH02_01_02 SEARCH02_01_03 SEARCH03_01_01 SEARCH03_01_02 SEARCH03_01_03 SEARCH04_01_01 SEARCH04_01_02
SEARCH04_01_03 SEARCH05_01_01 SEARCH05_01_02 SEARCH06_01_01 SEARCH06_01_02 SEARCH06_01_03 SEARCH07_01_01 SEARCH07_01_02 SEARCH08_01_01
SEARCH08_01_02 SEARCH08_01_03 SEARCH09_01_01 SEARCH09_01_02 SEARCH09_01_03 SEARCH10_01_01 SEARCH10_01_02 SEARCH11_01_01 SEARCH11_01_02
SEARCH13_01_01 SEARCH13_01_02 SEARCH13_01_03 SEARCH13_01_05 SEARCH13_01_06 SEARCH15_01_01 SEARCH15_01_02 SEARCH15_01_03 SEARCH15_01_04
SEARCH15_01_05 SEARCH17_01_01 SEARCH17_01_02 SEARCH17_01_03 SEARCH19_01_01 SEARCH19_01_02 SEARCH97_02_01 SEARCH97_02_03 SEARCH98_02_01
SEARCH98_02_02 SEARCH98_02_03 SEARCH99_02_01 SEARCH99_02_02 SEARCH00_02_01 SEARCH00_02_03 SEARCH01_02_01 SEARCH01_02_02 SEARCH02_02_01
SEARCH03_02_01 SEARCH03_02_02 SEARCH04_02_01 SEARCH04_02_02 SEARCH05_02_01 SEARCH05_02_02 SEARCH06_02_01 SEARCH06_02_03 SEARCH07_02_01
SEARCH08_02_01 SEARCH08_02_02 SEARCH09_02_01 SEARCH09_02_02 SEARCH10_02_01 SEARCH10_02_02 SEARCH11_02_01 SEARCH13_02_01 SEARCH13_02_02
SEARCH13_02_03 SEARCH13_02_04 SEARCH15_02_01 SEARCH15_02_02 SEARCH17_02_01 SEARCH19_02_01 SEARCH98_03_01 SEARCH99_03_01 SEARCH00_03_01
SEARCH01_03_01 SEARCH01_03_02 SEARCH02_03_01 SEARCH03_03_01 SEARCH04_03_01 SEARCH05_03_01 SEARCH06_03_01 SEARCH07_03_01 SEARCH08_03_01
SEARCH08_03_02 SEARCH09_03_03 SEARCH10_03_01 SEARCH11_03_01 SEARCH13_03_01 SEARCH13_03_03 SEARCH15_03_01 SEARCH17_03_01 SEARCH17_03_02
SEARCH19_03_01 SEARCH98_04_01 SEARCH99_04_01 SEARCH00_04_01 SEARCH01_04_01 SEARCH03_04_01 SEARCH09_04_01 SEARCH10_04_02 SEARCH15_04_01
SEARCH17_04_01 SEARCH19_04_01 SEARCH08_05_02 SEARCH15_05_01 SEARCH17_05_01 SEARCH97_06_01 SEARCH15_06_01
/b= R0263900 to U0694400.
compute a=b.
end repeat.

do repeat
a= SEMP01_1 SEMP02_1 SEMP03_1 SEMP05_1 SEMP05_1 SEMP06_1 SEMP07_1 SEMP07_1 SEMP07_1 SEMP08_1 SEMP08_1 SEMP08_1 SEMP09_1 SEMP09_1 
SEMP09_1 SEMP10_1 SEMP10_1 SEMP10_1 SEMP10_1 SEMP10_1 SEMP11_1 SEMP11_1 SEMP13_1 SEMP13_1 SEMP15_1 SEMP15_1 SEMP17_1 SEMP17_1 
SEMP19_1 SEMP02_2 SEMP03_2 SEMP05_2 SEMP06_2 SEMP07_2 SEMP07_2 SEMP08_2 SEMP08_2 SEMP09_2 SEMP11_2 SEMP11_2 SEMP13_2 SEMP13_2 
SEMP15_2 SEMP17_2 SEMP19_2 SEMP03_3 SEMP09_3 SEMP10_3 SEMP13_3 SEMP17_3 SEMP17_3 SEMP19_3 SEMP03_4 SEMP15_4 SEMP17_4 SEMP15_6 SEMP19_7
/b= SEARCH01_01_01 SEARCH02_01_01 SEARCH03_01_01 SEARCH05_01_01 SEARCH05_01_02 SEARCH06_01_01 SEARCH07_01_01 SEARCH07_01_02 SEARCH07_01_03
SEARCH08_01_01 SEARCH08_01_02 SEARCH08_01_05 SEARCH09_01_01 SEARCH09_01_02 SEARCH09_01_03 SEARCH10_01_01 SEARCH10_01_02 SEARCH10_01_03
SEARCH10_01_04 SEARCH10_01_10 SEARCH11_01_01 SEARCH11_01_02 SEARCH13_01_01 SEARCH13_01_02 SEARCH15_01_01 SEARCH15_01_02 SEARCH17_01_01
SEARCH17_01_02 SEARCH19_01_01 SEARCH02_02_01 SEARCH03_02_01 SEARCH05_02_01 SEARCH06_02_01 SEARCH07_02_01 SEARCH07_02_02 SEARCH08_02_01
SEARCH08_02_02 SEARCH09_02_01 SEARCH11_02_01 SEARCH11_02_02 SEARCH13_02_01 SEARCH13_02_02 SEARCH15_02_01 SEARCH17_02_01 SEARCH19_02_01
SEARCH03_03_01 SEARCH09_03_01 SEARCH10_03_01 SEARCH13_03_01 SEARCH17_03_01 SEARCH17_03_02 SEARCH19_03_01 SEARCH03_04_01 SEARCH15_04_01
SEARCH17_04_01 SEARCH15_06_01 SEARCH19_07_01 
/c= R6433200 to U4092200.
if a=1 b=c.
end repeat.
EXECUTE.

do repeat a= IN_RSN97_01_01 IN_RSN97_01_02 IN_RSN97_01_03 IN_RSN97_01_04 IN_RSN97_01_05 IN_RSN97_01_06 IN_RSN97_01_07 IN_RSN97_01_08 IN_RSN97_01_09
IN_RSN97_01_10 IN_RSN97_01_11 IN_RSN98_01_01 IN_RSN98_01_02 IN_RSN98_01_03 IN_RSN98_01_04 IN_RSN98_01_05 IN_RSN98_01_06 IN_RSN98_01_07
IN_RSN98_01_08 IN_RSN99_01_01 IN_RSN99_01_02 IN_RSN99_01_03 IN_RSN99_01_04 IN_RSN99_01_05 IN_RSN00_01_01 IN_RSN00_01_02 IN_RSN00_01_03
IN_RSN00_01_04 IN_RSN00_01_05 IN_RSN00_01_06 IN_RSN00_01_07 IN_RSN00_01_08 IN_RSN00_01_09 IN_RSN00_01_10 IN_RSN01_01_01 IN_RSN01_01_02
IN_RSN01_01_03 IN_RSN01_01_04 IN_RSN01_01_05 IN_RSN01_01_06 IN_RSN02_01_01 IN_RSN02_01_02 IN_RSN02_01_03 IN_RSN02_01_04 IN_RSN02_01_05
IN_RSN03_01_01 IN_RSN03_01_02 IN_RSN03_01_03 IN_RSN03_01_04 IN_RSN03_01_05 IN_RSN03_01_06 IN_RSN03_01_07 IN_RSN03_01_08 IN_RSN03_01_09
IN_RSN03_01_10 IN_RSN04_01_01 IN_RSN04_01_02 IN_RSN04_01_03 IN_RSN04_01_04 IN_RSN04_01_05 IN_RSN04_01_06 IN_RSN04_01_07 IN_RSN04_01_08
IN_RSN04_01_09 IN_RSN04_01_10 IN_RSN04_01_11 IN_RSN04_01_12 IN_RSN05_01_01 IN_RSN05_01_02 IN_RSN05_01_03 IN_RSN05_01_04 IN_RSN05_01_05
IN_RSN05_01_06 IN_RSN05_01_07 IN_RSN06_01_01 IN_RSN06_01_02 IN_RSN06_01_03 IN_RSN06_01_04 IN_RSN07_01_01 IN_RSN07_01_02 IN_RSN07_01_03
IN_RSN07_01_04 IN_RSN07_01_05 IN_RSN07_01_06 IN_RSN07_01_07 IN_RSN08_01_01 IN_RSN08_01_02 IN_RSN08_01_03 IN_RSN08_01_04 IN_RSN08_01_05
IN_RSN08_01_06 IN_RSN09_01_01 IN_RSN09_01_02 IN_RSN09_01_03 IN_RSN09_01_04 IN_RSN09_01_05 IN_RSN09_01_06 IN_RSN09_01_07 IN_RSN09_01_08
IN_RSN10_01_01 IN_RSN10_01_02 IN_RSN10_01_03 IN_RSN10_01_04 IN_RSN10_01_05 IN_RSN10_01_06 IN_RSN10_01_07 IN_RSN10_01_08 IN_RSN10_01_09
IN_RSN10_01_10 IN_RSN10_01_11 IN_RSN10_01_12 IN_RSN10_01_13 IN_RSN11_01_01 IN_RSN11_01_02 IN_RSN11_01_03 IN_RSN11_01_04 IN_RSN11_01_05
IN_RSN11_01_06 IN_RSN13_01_01 IN_RSN13_01_02 IN_RSN13_01_03 IN_RSN13_01_04 IN_RSN13_01_05 IN_RSN13_01_06 IN_RSN13_01_07 IN_RSN13_01_08
IN_RSN13_01_09 IN_RSN15_01_01 IN_RSN15_01_02 IN_RSN15_01_03 IN_RSN15_01_04 IN_RSN15_01_05 IN_RSN15_01_06 IN_RSN15_01_07 IN_RSN15_01_08
IN_RSN15_01_09 IN_RSN17_01_01 IN_RSN17_01_02 IN_RSN17_01_03 IN_RSN17_01_04 IN_RSN17_01_05 IN_RSN17_01_06 IN_RSN17_01_07 IN_RSN17_01_08
IN_RSN17_01_09 IN_RSN17_01_10 IN_RSN17_01_11 IN_RSN17_01_12 IN_RSN17_01_13 IN_RSN17_01_14 IN_RSN19_01_01 IN_RSN19_01_02 IN_RSN19_01_03
IN_RSN19_01_04 IN_RSN19_01_05 IN_RSN19_01_06 IN_RSN19_01_07 IN_RSN19_01_08 IN_RSN19_01_09 IN_RSN19_01_10 IN_RSN97_02_01 IN_RSN97_02_02
IN_RSN97_02_03 IN_RSN97_02_04 IN_RSN97_02_05 IN_RSN98_02_01 IN_RSN98_02_02 IN_RSN98_02_03 IN_RSN98_02_04 IN_RSN98_02_05 IN_RSN99_02_01
IN_RSN99_02_02 IN_RSN99_02_03 IN_RSN99_02_04 IN_RSN00_02_01 IN_RSN00_02_02 IN_RSN00_02_03 IN_RSN00_02_04 IN_RSN00_02_05 IN_RSN01_02_01
IN_RSN01_02_02 IN_RSN01_02_03 IN_RSN02_02_01 IN_RSN02_02_02 IN_RSN02_02_03 IN_RSN02_02_04 IN_RSN02_02_06 IN_RSN02_02_07 IN_RSN03_02_01
IN_RSN03_02_02 IN_RSN03_02_03 IN_RSN04_02_01 IN_RSN04_02_02 IN_RSN04_02_03 IN_RSN05_02_01 IN_RSN05_02_02 IN_RSN05_02_03 IN_RSN05_02_04
IN_RSN05_02_05 IN_RSN06_02_01 IN_RSN06_02_02 IN_RSN06_02_03 IN_RSN06_02_04 IN_RSN06_02_05 IN_RSN06_02_06 IN_RSN06_02_07 IN_RSN06_02_08
IN_RSN07_02_01 IN_RSN07_02_02 IN_RSN07_02_03 IN_RSN07_02_04 IN_RSN08_02_01 IN_RSN08_02_02 IN_RSN08_02_03 IN_RSN08_02_04 IN_RSN09_02_01
IN_RSN09_02_02 IN_RSN09_02_03 IN_RSN09_02_04 IN_RSN09_02_05 IN_RSN09_02_06 IN_RSN09_02_07 IN_RSN10_02_01 IN_RSN10_02_02 IN_RSN10_02_03
IN_RSN10_02_04 IN_RSN10_02_05 IN_RSN10_02_06 IN_RSN10_02_07 IN_RSN10_02_08 IN_RSN10_02_09 IN_RSN11_02_01 IN_RSN11_02_02 IN_RSN11_02_03
IN_RSN13_02_01 IN_RSN13_02_02 IN_RSN13_02_03 IN_RSN13_02_04 IN_RSN13_02_05 IN_RSN13_02_06 IN_RSN13_02_07 IN_RSN15_02_01 IN_RSN15_02_02
IN_RSN15_02_03 IN_RSN15_02_04 IN_RSN15_02_05 IN_RSN15_02_06 IN_RSN15_02_07 IN_RSN15_02_08 IN_RSN17_02_01 IN_RSN17_02_02 IN_RSN17_02_03
IN_RSN17_02_04 IN_RSN17_02_05 IN_RSN17_02_06 IN_RSN19_02_01 IN_RSN19_02_02 IN_RSN19_02_03 IN_RSN19_02_04 IN_RSN19_02_05 IN_RSN97_03_01
IN_RSN97_03_02 IN_RSN98_03_01 IN_RSN98_03_02 IN_RSN98_03_03 IN_RSN98_03_04 IN_RSN99_03_01 IN_RSN99_03_02 IN_RSN99_03_03 IN_RSN00_03_01
IN_RSN00_03_02 IN_RSN00_03_03 IN_RSN01_03_01 IN_RSN01_03_02 IN_RSN01_03_03 IN_RSN02_03_01 IN_RSN02_03_02 IN_RSN02_03_03 IN_RSN03_03_01
IN_RSN03_03_02 IN_RSN04_03_01 IN_RSN04_03_02 IN_RSN04_03_03 IN_RSN05_03_01 IN_RSN05_03_02 IN_RSN05_03_03 IN_RSN06_03_01 IN_RSN06_03_02
IN_RSN07_03_01 IN_RSN07_03_02 IN_RSN08_03_01 IN_RSN08_03_02 IN_RSN08_03_03 IN_RSN08_03_04 IN_RSN08_03_05 IN_RSN08_03_06 IN_RSN09_03_01
IN_RSN09_03_02 IN_RSN09_03_03 IN_RSN10_03_01 IN_RSN10_03_02 IN_RSN10_03_03 IN_RSN10_03_04 IN_RSN11_03_01 IN_RSN11_03_02 IN_RSN11_03_03
IN_RSN13_03_01 IN_RSN13_03_02 IN_RSN13_03_03 IN_RSN13_03_04 IN_RSN15_03_01 IN_RSN15_03_02 IN_RSN15_03_03 IN_RSN15_03_04 IN_RSN17_03_01
IN_RSN17_03_02 IN_RSN17_03_03 IN_RSN17_03_04 IN_RSN17_03_05 IN_RSN17_03_06 IN_RSN17_03_07 IN_RSN19_03_01 IN_RSN19_03_02 IN_RSN19_03_03
IN_RSN97_04_01 IN_RSN98_04_01 IN_RSN98_04_02 IN_RSN99_04_01 IN_RSN99_04_02 IN_RSN00_04_01 IN_RSN00_04_02 IN_RSN01_04_01 IN_RSN02_04_01
IN_RSN02_04_02 IN_RSN03_04_01 IN_RSN03_04_02 IN_RSN04_04_01 IN_RSN04_04_02 IN_RSN05_04_01 IN_RSN05_04_02 IN_RSN06_04_01 IN_RSN06_04_02
IN_RSN07_04_01 IN_RSN07_04_02 IN_RSN08_04_01 IN_RSN08_04_02 IN_RSN08_04_03 IN_RSN09_04_01 IN_RSN10_04_01 IN_RSN10_04_02 IN_RSN11_04_01
IN_RSN11_04_02 IN_RSN13_04_01 IN_RSN13_04_02 IN_RSN13_04_03 IN_RSN15_04_01 IN_RSN17_04_01 IN_RSN17_04_02 IN_RSN19_04_01 IN_RSN19_04_02
IN_RSN19_04_03 IN_RSN97_05_01 IN_RSN98_05_01 IN_RSN98_05_02 IN_RSN99_05_01 IN_RSN99_05_02 IN_RSN00_05_01 IN_RSN01_05_01 IN_RSN02_05_01
IN_RSN02_05_02 IN_RSN03_05_01 IN_RSN03_05_02 IN_RSN04_05_01 IN_RSN05_05_01 IN_RSN06_05_01 IN_RSN07_05_01 IN_RSN07_05_02 IN_RSN08_05_01
IN_RSN08_05_02 IN_RSN09_05_01 IN_RSN13_05_01 IN_RSN15_05_01 IN_RSN17_05_01 IN_RSN19_05_01 IN_RSN97_06_01 IN_RSN98_06_01 IN_RSN00_06_01
IN_RSN05_06_01 IN_RSN05_06_02 IN_RSN11_06_01 IN_RSN13_06_01 IN_RSN15_06_01 IN_RSN17_06_01 IN_RSN13_07_01 IN_RSN13_07_02 IN_RSN19_07_01.
numeric a (F3.0).
end repeat.

do repeat a= IN_RSN97_01_01 IN_RSN97_01_02 IN_RSN97_01_03 IN_RSN97_01_04 IN_RSN97_01_05 IN_RSN97_01_06 IN_RSN97_01_07 IN_RSN97_01_08
IN_RSN97_01_09 IN_RSN97_01_10 IN_RSN97_01_11 IN_RSN98_01_01 IN_RSN98_01_02 IN_RSN98_01_03 IN_RSN98_01_04 IN_RSN98_01_05 IN_RSN98_01_06
IN_RSN98_01_07 IN_RSN98_01_08 IN_RSN98_01_09 IN_RSN99_01_01 IN_RSN99_01_02 IN_RSN99_01_03 IN_RSN99_01_04 IN_RSN99_01_05 IN_RSN00_01_01
IN_RSN00_01_02 IN_RSN00_01_03 IN_RSN00_01_04 IN_RSN00_01_05 IN_RSN00_01_06 IN_RSN00_01_07 IN_RSN00_01_08 IN_RSN00_01_09 IN_RSN00_01_10
IN_RSN01_01_01 IN_RSN01_01_02 IN_RSN01_01_03 IN_RSN01_01_04 IN_RSN01_01_05 IN_RSN01_01_06 IN_RSN02_01_01 IN_RSN02_01_02 IN_RSN02_01_03
IN_RSN02_01_04 IN_RSN02_01_05 IN_RSN03_01_01 IN_RSN03_01_02 IN_RSN03_01_03 IN_RSN03_01_04 IN_RSN03_01_05 IN_RSN03_01_06 IN_RSN03_01_07
IN_RSN03_01_08 IN_RSN03_01_09 IN_RSN03_01_10 IN_RSN04_01_01 IN_RSN04_01_02 IN_RSN04_01_03 IN_RSN04_01_04 IN_RSN04_01_05 IN_RSN04_01_06
IN_RSN04_01_07 IN_RSN04_01_08 IN_RSN04_01_09 IN_RSN04_01_10 IN_RSN04_01_11 IN_RSN04_01_12 IN_RSN05_01_01 IN_RSN05_01_02 IN_RSN05_01_03
IN_RSN05_01_04 IN_RSN05_01_05 IN_RSN05_01_06 IN_RSN05_01_07 IN_RSN06_01_01 IN_RSN06_01_02 IN_RSN06_01_03 IN_RSN06_01_04 IN_RSN07_01_01
IN_RSN07_01_02 IN_RSN07_01_03 IN_RSN07_01_04 IN_RSN07_01_05 IN_RSN08_01_01 IN_RSN08_01_02 IN_RSN08_01_03 IN_RSN08_01_04 IN_RSN08_01_05
IN_RSN08_01_06 IN_RSN09_01_01 IN_RSN09_01_02 IN_RSN09_01_03 IN_RSN09_01_04 IN_RSN09_01_05 IN_RSN10_01_01 IN_RSN10_01_02 IN_RSN10_01_03
IN_RSN10_01_04 IN_RSN11_01_01 IN_RSN11_01_02 IN_RSN11_01_03 IN_RSN11_01_04 IN_RSN11_01_05 IN_RSN11_01_06 IN_RSN13_01_01 IN_RSN13_01_02
IN_RSN13_01_03 IN_RSN13_01_04 IN_RSN13_01_05 IN_RSN13_01_06 IN_RSN13_01_07 IN_RSN15_01_01 IN_RSN15_01_02 IN_RSN15_01_03 IN_RSN15_01_04
IN_RSN15_01_05 IN_RSN15_01_06 IN_RSN15_01_07 IN_RSN15_01_08 IN_RSN15_01_09 IN_RSN17_01_01 IN_RSN17_01_02 IN_RSN17_01_03 IN_RSN17_01_04
IN_RSN17_01_05 IN_RSN19_01_01 IN_RSN19_01_02 IN_RSN19_01_03 IN_RSN19_01_04 IN_RSN19_01_05 IN_RSN19_10_01 IN_RSN97_02_01 IN_RSN97_02_02
IN_RSN97_02_03 IN_RSN97_02_04 IN_RSN97_02_05 IN_RSN97_02_06 IN_RSN98_02_01 IN_RSN98_02_02 IN_RSN98_02_03 IN_RSN98_02_04 IN_RSN98_02_05
IN_RSN99_02_01 IN_RSN99_02_02 IN_RSN99_02_03 IN_RSN99_02_04 IN_RSN00_02_01 IN_RSN00_02_02 IN_RSN00_02_03 IN_RSN00_02_04 IN_RSN00_02_05
IN_RSN01_02_01 IN_RSN01_02_02 IN_RSN01_02_03 IN_RSN02_02_01 IN_RSN02_02_02 IN_RSN02_02_03 IN_RSN02_02_04 IN_RSN02_02_05 IN_RSN02_02_06
IN_RSN02_02_07 IN_RSN03_02_01 IN_RSN03_02_02 IN_RSN03_02_03 IN_RSN04_02_01 IN_RSN04_02_02 IN_RSN04_02_03 IN_RSN05_02_01 IN_RSN05_02_02
IN_RSN05_02_03 IN_RSN05_02_04 IN_RSN05_02_05 IN_RSN06_02_01 IN_RSN06_02_02 IN_RSN06_02_03 IN_RSN06_02_04 IN_RSN06_02_05 IN_RSN06_02_06
IN_RSN06_02_07 IN_RSN07_02_01 IN_RSN07_02_02 IN_RSN07_02_03 IN_RSN07_02_04 IN_RSN08_02_01 IN_RSN08_02_02 IN_RSN08_02_03 IN_RSN08_02_04
IN_RSN09_02_01 IN_RSN09_02_02 IN_RSN09_02_03 IN_RSN09_02_04 IN_RSN09_02_05 IN_RSN09_02_06 IN_RSN10_02_01 IN_RSN10_02_02 IN_RSN10_02_03
IN_RSN10_02_04 IN_RSN10_02_05 IN_RSN10_02_06 IN_RSN10_02_07 IN_RSN10_02_08 IN_RSN10_02_09 IN_RSN11_02_01 IN_RSN11_02_02 IN_RSN13_02_01
IN_RSN13_02_02 IN_RSN13_02_03 IN_RSN13_02_04 IN_RSN13_02_05 IN_RSN13_02_06 IN_RSN13_02_07 IN_RSN15_02_01 IN_RSN15_02_02 IN_RSN15_02_03
IN_RSN15_02_04 IN_RSN15_02_05 IN_RSN15_02_06 IN_RSN15_02_07 IN_RSN15_02_08 IN_RSN15_02_09 IN_RSN17_02_01 IN_RSN17_02_02 IN_RSN17_02_03
IN_RSN17_02_04 IN_RSN17_02_05 IN_RSN19_02_01 IN_RSN19_02_02 IN_RSN19_02_03 IN_RSN97_03_01 IN_RSN97_03_02 IN_RSN98_03_01 IN_RSN98_03_02
IN_RSN98_03_03 IN_RSN98_03_04 IN_RSN99_03_01 IN_RSN99_03_02 IN_RSN99_03_03 IN_RSN00_03_01 IN_RSN00_03_02 IN_RSN00_03_03 IN_RSN01_03_01
IN_RSN01_03_02 IN_RSN01_03_03 IN_RSN02_03_01 IN_RSN02_03_02 IN_RSN02_03_03 IN_RSN03_03_01 IN_RSN03_03_02 IN_RSN04_03_01 IN_RSN04_03_02
IN_RSN04_03_03 IN_RSN05_03_01 IN_RSN05_03_02 IN_RSN05_03_03 IN_RSN06_03_01 IN_RSN06_03_02 IN_RSN07_03_01 IN_RSN07_03_02 IN_RSN08_03_01
IN_RSN08_03_02 IN_RSN09_03_01 IN_RSN09_03_02 IN_RSN09_03_03 IN_RSN10_03_01 IN_RSN10_03_02 IN_RSN11_03_01 IN_RSN11_03_02 IN_RSN11_03_03
IN_RSN13_03_01 IN_RSN13_03_02 IN_RSN13_03_03 IN_RSN13_03_04 IN_RSN15_03_01 IN_RSN15_03_02 IN_RSN15_03_03 IN_RSN15_03_04 IN_RSN17_03_01
IN_RSN17_03_02 IN_RSN17_03_03 IN_RSN17_03_04 IN_RSN17_03_05 IN_RSN17_03_06 IN_RSN17_03_07 IN_RSN19_03_01 IN_RSN19_03_02 IN_RSN19_03_03
IN_RSN97_04_01 IN_RSN98_04_01 IN_RSN99_04_01 IN_RSN99_04_02 IN_RSN00_04_01 IN_RSN00_04_02 IN_RSN00_04_03 IN_RSN01_04_01 IN_RSN01_04_02
IN_RSN02_04_01 IN_RSN02_04_02 IN_RSN03_04_01 IN_RSN03_04_02 IN_RSN04_04_01 IN_RSN04_04_02 IN_RSN05_04_01 IN_RSN05_04_02 IN_RSN06_04_01
IN_RSN06_04_02 IN_RSN07_04_01 IN_RSN07_04_02 IN_RSN08_04_01 IN_RSN08_04_02 IN_RSN09_04_01 IN_RSN10_04_01 IN_RSN10_04_02 IN_RSN11_04_01
IN_RSN11_04_02 IN_RSN13_04_01 IN_RSN13_04_02 IN_RSN13_04_03 IN_RSN15_04_01 IN_RSN17_04_01 IN_RSN17_04_02 IN_RSN19_04_01 IN_RSN19_04_02
IN_RSN19_04_03 IN_RSN97_05_01 IN_RSN98_05_01 IN_RSN98_05_02 IN_RSN99_05_01 IN_RSN99_05_02 IN_RSN00_05_01 IN_RSN01_05_01 IN_RSN02_05_01
IN_RSN02_05_02 IN_RSN03_05_01 IN_RSN03_05_02 IN_RSN04_05_01 IN_RSN05_05_01 IN_RSN06_05_01 IN_RSN07_05_01 IN_RSN07_05_02 IN_RSN08_05_01
IN_RSN08_05_02 IN_RSN08_05_03 IN_RSN09_05_01 IN_RSN13_05_01 IN_RSN15_05_01 IN_RSN17_05_01 IN_RSN19_05_01 IN_RSN98_06_01 IN_RSN00_06_01
IN_RSN05_06_01 IN_RSN05_06_02 IN_RSN11_06_01 IN_RSN13_06_01 IN_RSN15_06_01 IN_RSN17_06_01 IN_RSN13_07_01 IN_RSN13_07_02 IN_RSN17_07_01
/b= R0265100 to U2633000.
compute a=b.
end repeat.

do repeat a= SEMP00_1 SEMP01_1 SEMP02_1 SEMP03_1 SEMP04_1 SEMP04_1 SEMP04_1 SEMP05_1 SEMP05_1 SEMP05_1 SEMP06_1 SEMP06_1 SEMP06_1 
SEMP07_1 SEMP07_1 SEMP07_1 SEMP07_1 SEMP07_1 SEMP07_1 SEMP08_1 SEMP08_1 SEMP08_1 SEMP08_1 SEMP09_1 SEMP09_1 SEMP09_1 SEMP10_1 
SEMP10_1 SEMP10_1 SEMP10_1 SEMP10_1 SEMP10_1 SEMP11_1 SEMP11_1 SEMP11_1 SEMP11_1 SEMP13_1 SEMP13_1 SEMP13_1 SEMP13_1 SEMP15_1 
SEMP15_1 SEMP15_1 SEMP15_1 SEMP15_1 SEMP15_1 SEMP17_1 SEMP17_1 SEMP17_1 SEMP17_1 SEMP17_1 SEMP17_1 SEMP17_1 SEMP17_1 SEMP17_1 
SEMP17_1 SEMP17_1 SEMP17_1 SEMP17_1 SEMP17_1 SEMP19_1 SEMP19_1 SEMP19_1 SEMP19_1 SEMP19_1 SEMP19_1 SEMP19_1 SEMP19_1 SEMP19_1 
SEMP19_1 SEMP00_2 SEMP01_2 SEMP02_2 SEMP03_2 SEMP04_2 SEMP04_2 SEMP04_2 SEMP05_2 SEMP05_2 SEMP05_2 SEMP06_2 SEMP06_2 SEMP07_2 
SEMP07_2 SEMP08_2 SEMP08_2 SEMP08_2 SEMP09_2 SEMP09_2 SEMP09_2 SEMP09_2 SEMP09_2 SEMP09_2 SEMP09_2 SEMP10_2 SEMP10_2 SEMP10_2 
SEMP10_2 SEMP10_2 SEMP10_2 SEMP11_2 SEMP11_2 SEMP11_2 SEMP11_2 SEMP13_2 SEMP13_2 SEMP13_2 SEMP13_2 SEMP13_2 SEMP15_2 SEMP15_2 
SEMP15_2 SEMP15_2 SEMP15_2 SEMP15_2 SEMP15_2 SEMP17_2 SEMP17_2 SEMP17_2 SEMP17_2 SEMP17_2 SEMP17_2 SEMP19_2 SEMP19_2 SEMP19_2 
SEMP19_2 SEMP19_2 SEMP01_3 SEMP02_3 SEMP03_3 SEMP04_3 SEMP05_3 SEMP05_3 SEMP05_3 SEMP06_3 SEMP07_3 SEMP07_3 SEMP08_3 SEMP08_3 
SEMP08_3 SEMP08_3 SEMP08_3 SEMP08_3 SEMP09_3 SEMP09_3 SEMP10_3 SEMP11_3 SEMP13_3 SEMP13_3 SEMP13_3 SEMP13_3 SEMP15_3 SEMP15_3 
SEMP15_3 SEMP17_3 SEMP17_3 SEMP19_3 SEMP01_4 SEMP02_4 SEMP03_4 SEMP06_4 SEMP06_4 SEMP08_4 SEMP08_4 SEMP08_4 SEMP08_4 SEMP11_4 
SEMP11_4 SEMP13_4 SEMP15_4 SEMP17_4 SEMP19_4 SEMP19_4 SEMP19_4 SEMP01_5 SEMP05_5 SEMP09_5 SEMP17_5 SEMP15_6 SEMP19_7 
/b= IN_RSN00_01_01 IN_RSN01_01_01 IN_RSN02_01_01 IN_RSN03_01_01 IN_RSN04_01_01 IN_RSN04_01_02 IN_RSN04_01_03 IN_RSN05_01_01 IN_RSN05_01_02
IN_RSN05_01_03 IN_RSN06_01_01 IN_RSN06_01_02 IN_RSN06_01_03 IN_RSN07_01_01 IN_RSN07_01_02 IN_RSN07_01_03 IN_RSN07_01_04 IN_RSN07_01_05
IN_RSN07_01_06 IN_RSN08_01_01 IN_RSN08_01_02 IN_RSN08_01_03 IN_RSN08_01_05 IN_RSN09_01_01 IN_RSN09_01_02 IN_RSN09_01_03 IN_RSN10_01_01
IN_RSN10_01_02 IN_RSN10_01_03 IN_RSN10_01_04 IN_RSN10_01_10 IN_RSN10_01_11 IN_RSN11_01_01 IN_RSN11_01_02 IN_RSN11_01_03 IN_RSN11_01_04
IN_RSN13_01_01 IN_RSN13_01_02 IN_RSN13_01_03 IN_RSN13_01_04 IN_RSN15_01_01 IN_RSN15_01_02 IN_RSN15_01_03 IN_RSN15_01_04 IN_RSN15_01_05
IN_RSN15_01_06 IN_RSN17_01_01 IN_RSN17_01_02 IN_RSN17_01_03 IN_RSN17_01_04 IN_RSN17_01_05 IN_RSN17_01_06 IN_RSN17_01_07 IN_RSN17_01_08
IN_RSN17_01_09 IN_RSN17_01_10 IN_RSN17_01_11 IN_RSN17_01_12 IN_RSN17_01_13 IN_RSN17_01_14 IN_RSN19_01_01 IN_RSN19_01_02 IN_RSN19_01_03
IN_RSN19_01_04 IN_RSN19_01_05 IN_RSN19_01_06 IN_RSN19_01_07 IN_RSN19_01_08 IN_RSN19_01_09 IN_RSN19_01_10 IN_RSN00_02_01 IN_RSN01_02_01
IN_RSN02_02_01 IN_RSN03_02_01 IN_RSN04_02_01 IN_RSN04_02_02 IN_RSN04_02_03 IN_RSN05_02_01 IN_RSN05_02_02 IN_RSN05_02_03 IN_RSN06_02_01
IN_RSN06_02_02 IN_RSN07_02_01 IN_RSN07_02_02 IN_RSN08_02_01 IN_RSN08_02_02 IN_RSN08_02_03 IN_RSN09_02_01 IN_RSN09_02_02 IN_RSN09_02_03
IN_RSN09_02_04 IN_RSN09_02_05 IN_RSN09_02_06 IN_RSN09_02_07 IN_RSN10_02_01 IN_RSN10_02_02 IN_RSN10_02_03 IN_RSN10_02_04 IN_RSN10_02_05
IN_RSN10_02_07 IN_RSN11_02_01 IN_RSN11_02_02 IN_RSN11_02_03 IN_RSN11_02_04 IN_RSN13_02_01 IN_RSN13_02_02 IN_RSN13_02_03 IN_RSN13_02_04
IN_RSN13_02_05 IN_RSN15_02_01 IN_RSN15_02_02 IN_RSN15_02_03 IN_RSN15_02_04 IN_RSN15_02_05 IN_RSN15_02_06 IN_RSN15_02_07 IN_RSN17_02_01
IN_RSN17_02_02 IN_RSN17_02_03 IN_RSN17_02_04 IN_RSN17_02_05 IN_RSN17_02_06 IN_RSN19_02_01 IN_RSN19_02_02 IN_RSN19_02_03 IN_RSN19_02_04
IN_RSN19_02_05 IN_RSN01_03_01 IN_RSN02_03_01 IN_RSN03_03_01 IN_RSN04_03_01 IN_RSN05_03_01 IN_RSN05_03_02 IN_RSN05_03_03 IN_RSN06_03_01
IN_RSN07_03_01 IN_RSN07_03_02 IN_RSN08_03_01 IN_RSN08_03_02 IN_RSN08_03_03 IN_RSN08_03_04 IN_RSN08_03_05 IN_RSN08_03_06 IN_RSN09_03_01
IN_RSN09_03_02 IN_RSN10_03_01 IN_RSN11_03_01 IN_RSN13_03_01 IN_RSN13_03_02 IN_RSN13_03_03 IN_RSN13_03_04 IN_RSN15_03_01 IN_RSN15_03_02
IN_RSN15_03_03 IN_RSN17_03_01 IN_RSN17_03_02 IN_RSN19_03_01 IN_RSN01_04_01 IN_RSN02_04_01 IN_RSN03_04_01 IN_RSN06_04_01 IN_RSN06_04_02
IN_RSN08_04_01 IN_RSN08_04_02 IN_RSN08_04_03 IN_RSN08_04_04 IN_RSN11_04_01 IN_RSN11_04_02 IN_RSN13_04_01 IN_RSN15_04_01 IN_RSN17_04_01
IN_RSN19_04_01 IN_RSN19_04_02 IN_RSN19_04_03 IN_RSN01_05_01 IN_RSN05_05_01 IN_RSN09_05_01 IN_RSN17_05_01 IN_RSN15_06_01 IN_RSN19_07_01
/c= R4810500 to U4094600.
if a=1 b=c+0.1.
end repeat.
recode IN_RSN97_01_01 to IN_RSN19_07_01 (1.1=1)(2.1=2)(4.1=4)(5.1=5)(6.1=6)(7.1=7)(8.1=8)(9.1=9)(10.1=10)(11.1=11)(12.1=12)(13.1=14)
(14.1=15)(15.1=13.1)(16.1=16).
EXECUTE.
val lab IN_RSN97_01_01 to IN_RSN19_07_01
 1 "DID NOT WANT TO WORK"
 2 "ILL, DISABLED, UNABLE TO WORK"
 3 "SCHOOL EMPLOYEES: SCHOOL WAS NOT IN SESSION FOR THIS PERIOD"
 3.1 "School / Plant/ Firm temporarily closed - SE"
 4 "ARMED FORCES"
 5 "PREGNANCY"
 6 "CHILD CARE PROBLEMS"
 7 "PERSONAL/FAMILY REASONS"
 8 "VACATION"
 9 "LABOR DISPUTES/STRIKE"
 10 "BELIEVED NO WORK AVAILABLE"
 11 "COULD NOT FIND WORK"
 12 "IN SCHOOL"
 13 "HAD ANOTHER JOB"
 13.1 "New job to start - SE"
 14 "IN JAIL"
 15 "TRANSPORTATION PROBLEMS"
 16 "OTHER".

SAVE OUTFILE='D:\NLSY97_Kopyckaetal\Sourcegapdata.sav'
 /COMPRESSED.

* First check basic characteristics of inidividual gaps - to do this, convert dataset to long format with person-jobs-gaps as units.
* Variables: job ID of gap; number of gap; timing of gap (4 variables); number of weeks unemployed within gap; reason for inactivity within gap
respondent ID and year of birth, dates of interviews each round

VARSTOCASES
 /make WavejobID from WavejobID1 to WavejobID396
 /make Gapnum from Gapnum1 to Gapnum396
 /make startweek from E1011701 to E1073501
 /make startyear from E2011701 to E2073501
 /make endweek from E3011701 to E3073501
 /make endyear from E4011701 to E4073501
 /make reason from REASON97_01_01 to REASON19_07_01
 /make search from SEARCH97_01_01 to SEARCH19_07_01
 /make in_rsn from IN_RSN97_01_01 to IN_RSN19_07_01
 /index all_gapnum
/keep=R0000100 R0536402 R1209401 R1209402 R2568301 R2568302 R3890301 R3890302 R5472301 R5472302 R7236101 R7236102 S1550901 S1550902 S2020801 S2020802
S3822001 S3822002 S5422001 S5422002 S7524101 S7524102 T0024501 T0024502 T2019401 T2019402 T3610001 T3610002 T5210401 T5210402
T6661401 T6661402 T8132901 T8132902 U0013201 U0013202 U1850701 U1850702 U3450201 U3450202.
select if gapnum>0.

*Remove empty person-gap records;
NOTE - several cases may have miscoded gap dates: unexplained -4 (valid skips) values in the year gap ended - only in certain rounds
The valid skips may result from censoring - additional checks have shown that these are mostly short breaks with little effect on the data
In several cases the end date is earlier than the start date (possible miscoding, mostly concerning short gaps of 1-3 weeks)
The gaps are ignored in calculations of number of terminations and for the annual wage.

SAVE OUTFILE='D:\NLSY97_Kopyckaetal\Jobgaps_long.sav'
 /COMPRESSED.
DATASET NAME Jobgaps_long.
DATASET ACTIVATE Jobgaps_long.

* DATASET CLEANING:
 Recode of reason variable: System missing values should be treated as -4 (valid skip)
 Clean double missing values; same transformations for reasons for inactivity
 Recode of search variable: valid skips (-4) in the original search variable refer to gaps in which no weeks of job search / layoff were reported
 System missing values in the search variable come from the fact that this variable was not available for all job gaps (if all gaps in the dataset had valid skips)

recode reason in_rsn (sysmis=-4)(-3.9=-4)(-1.9=-2)(-0.9=-1).
recode search (-4=0)(sysmis=0).

Compute Wave=TRUNC(WavejobID/100).
autorecode Wave / into Round.
formats Wave (F4.0) Round (F2.0).
EXECUTE.

* Create variables to inform about start and end of gap in continuous weeks, starting from the first week of 1994
Original code does not account for years with 53 weeks, which could lead to minor biases; years with 53 weeks: 1994, 2000, 2005, 2011, 2016
Calculate gap durations in weeks.

if startyear>0 and startyear<1994 and endyear>=1994 swk=1.
if startyear=1994 swk=startweek.
if startyear>1994 and startyear<=2000 swk=(startyear-1995)*52+53+startweek.
if startyear>2000 and startyear<=2005 swk=(startyear-1995)*52+54+startweek.
if startyear>2005 and startyear<=2011 swk=(startyear-1995)*52+55+startweek.
if startyear>2011 and startyear<=2016 swk=(startyear-1995)*52+56+startweek.
if startyear>2016 swk=(startyear-1995)*52+57+startweek.
if endyear=1994 ewk=endweek.
if endyear>1994 and endyear<=2000 ewk=(endyear-1995)*52+53+endweek.
if endyear>2000 and endyear<=2005 ewk=(endyear-1995)*52+54+endweek.
if endyear>2005 and endyear<=2011 ewk=(endyear-1995)*52+55+endweek.
if endyear>2011 and endyear<=2016 ewk=(endyear-1995)*52+56+endweek.
if endyear>2016 ewk=(endyear-1995)*52+57+endweek.
formats swk ewk (F4.0).
EXECUTE.

if ewk>=swk duration=ewk-swk.
formats duration (F8.0).
EXECUTE.

* POSSIBLE TERMINATIONS - (1) GAPS LASTING 5+ WEEKS, FOR NON-PERSONAL REASONS (this is correlated with job search)
* (2) FOR PERSONAL REASONS - ONLY GAPS LASTING AT LEAST 6 MONTHS.
* Personal reasons - based on 3 variables: (personal) reason for job gap OR zero weeks of job search during gap & (personal)reasons for lack of job search
  All other gaps are treated as gaps for non-personal reasons.

* Definitions - 
* personal reasons: strike (own decision not termination); unpaid vacation; education; Armed Forces; pregnancy; health problems; child care' other personal reasons;
& code 12: school employees: school shut down (most likely vacation months so should not be treated as a termination, though this will affect pay and job continuity)
Note: gaps for other reasons listed below are also treated as gaps for personal reasons if they are not accompanied by job search due to the following: illness, disability;
school not in session (school employees); temporary closure of firm; military service; child care problems; personal / family reasons; vacation; strike; education.
* work related reasons: layoff; quit or ended job but later returned; other reasons (but excluding personal reasons); did not want to work (could be due to bad working conditions)
for the self-employed other work-related reasons include: no clients; no materials; financial problems. All the above reasons are work-related ONLY if they are accompanied 
by job search or the lack of job search is due to the following reasons: did not want to work (no adequate jobs available?); believed no work available; could not find work;
had another job; was to start a new job; was in jail; transportation problems; other.

recode reason (1=1)(5.1 thru 12=1)(else=0) into personal.
if search=0 and ((in_rsn>=2 and in_rsn<=9) or in_rsn=12) personal=1.
formats personal (F2.0).
EXECUTE.
var lab personal 'Job gap for personal reasons / by choice / no search for other job'.
val lab personal 0 'Market / job related reasons' 1 'Personal reasons'.

* Calculate flag for within-job gaps that are to be treated as job terminations.

Compute GAPTERM=0.
if personal=0 and duration>4 GAPTERM=1.
if personal=1 and duration>26 GAPTERM=1.
formats GAPTERM (F2.0).
EXECUTE.
var lab GAPTERM 'Job terminations: work related gaps lasting 5+ weeks and gaps for personal reasons lasting 6+ months'.

recode duration (sysmis=-2).
compute UNSPECGAP=0.
if PERSONAL=0 and duration=-2 UNSPECGAP=1.
formats UNSPECGAP (F2.0).
EXECUTE.
var lab UNSPECGAP 'Work related gaps with missing data on duration'.

* Assign flags of gaps which are treated as job terminations to calendar years.

do repeat a=1994 to 2020 / b=GAPTERM1 to GAPTERM27.
compute b=0.
if startyear=a and GAPTERM=1 b=1.
end repeat.
formats GAPTERM1 to GAPTERM27 (F2.0).
EXECUTE.

* Assign flags of gaps whose status as terminations cannot be established to calendar years.

do repeat a=1994 to 2020 /b=UNSPECGAP1 to UNSPECGAP27.
compute b=0.
if startyear=a and UNSPECGAP=1 b=1.
end repeat.
compute UNSPECGAP00=0.
if startyear=-3 and UNSPECGAP=1 UNSPECGAP00=1.
formats UNSPECGAP1 to UNSPECGAP27 UNSPECGAP00 (F2.0).
EXECUTE.

* calculate the number of weeks of each gap each year - to subtract from annual wages (and account for possible overlaps of gaps)
* Calculate weekly flags 1994-2020 to assess which wave the gap data come from
 
do repeat a=Monthround1 to Monthround19 / b=R1209402 R2568302 R3890302 R5472302 R7236102 S1550902 S2020802 S3822002 S5422002 S7524102
T0024502 T2019402 T3610002 T5210402 T6661402 T8132902 U0013202 U1850702 U3450202
/ c=R1209401 R2568301 R3890301 R5472301 R7236101 S1550901 S2020801 S3822001 S5422001 S7524101 T0024501 T2019401 T3610001 T5210401
T6661401 T8132901 U0013201 U1850701 U3450201.
compute a=(b-1994)*12+c.
end repeat.
EXECUTE.
do repeat a=Monthround1 to Monthround19 / b=Weekround1 to Weekround19.
recode a (1=4) (2=8) (3=13) (4=17) (5=21) (6=26) (7=30) (8=35) (9=39) (10=43) (11=48) (12=52) (13=56) (14=60) (15=65)
(16=69) (17=74) (18=78) (19=82) (20=87) (21=91) (22=95) (23=100) (24=104) (25=109) (26=113) (27=117) (28=121) (29=126) (30=130)
(31=135) (32=139) (33=143) (34=148) (35=152) (36=156) (37=161) (38=165) (39=169) (40=174) (41=178) (42=182) (43=187) (44=191) (45=195)
(46=200) (47=204) (48=209) (49=213) (50=217) (51=221) (52=226) (53=230) (54=234) (55=239) (56=243) (57=248) (58=252) (59=256) (60=261)
(61=265) (62=269) (63=274) (64=278) (65=282) (66=287) (67=291) (68=295) (69=300) (70=304) (71=308) (72=313) (73=317) (74=321) (75=326)
(76=330) (77=335) (78=339) (79=343) (80=348) (81=352) (82=356) (83=361) (84=364) (85=369) (86=373) (87=377) (88=381) (89=386) (90=390)
(91=394) (92=399) (93=403) (94=408) (95=412) (96=416) (97=421) (98=425) (99=429) (100=433) (101=438) (102=442) (103=447) (104=451) (105=455)
(106=460) (107=464) (108=468) (109=473) (110=477) (111=481) (112=486) (113=490) (114=494) (115=499) (116=503) (117=507) (118=512) (119=516) (120=521)
(121=525) (122=529) (123=534) (124=538) (125=542) (126=547) (127=551) (128=555) (129=560) (130=564) (131=568) (132=573) (133=577) (134=581) (135=586)
(136=590) (137=594) (138=599) (139=603) (140=608) (141=612) (142=616) (143=621) (144=624) (145=628) (146=632) (147=637) (148=641) (149=646) (150=650)
(151=654) (152=659) (153=663) (154=667) (155=672) (156=676) (157=681) (158=685) (159=689) (160=693) (161=698) (162=702) (163=706) (164=711) (165=715)
(166=720) (167=724) (168=728) (169=733) (170=737) (171=741) (172=746) (173=750) (174=754) (175=759) (176=763) (177=767) (178=772) (179=776) (180=781)
(181=785) (182=789) (183=793) (184=798) (185=802) (186=806) (187=811) (188=815) (189=820) (190=824) (191=828) (192=833) (193=837) (194=841) (195=846)
(196=850) (197=854) (198=859) (199=863) (200=867) (201=872) (202=876) (203=880) (204=885) (205=889) (206=893) (207=898) (208=902) (209=906) (210=911)
(211=915) (212=920) (213=924) (214=928) (215=933) (216=936) (217=941) (218=945) (219=949) (220=954) (221=958) (222=962) (223=967) (224=971) (225=976)
(226=980) (227=984) (228=989) (229=993) (230=997) (231=1002) (232=1006) (233=1010) (234=1015) (235=1019) (236=1023) (237=1028) (238=1032) (239=1036) 
(240=1041) (241=1045) (242=1049) (243=1054) (244=1058) (245=1062) (246=1067) (247=1071) (248=1076) (249=1080) (250=1084) (251=1089) (252=1093) (253=1097)
(254=1101) (255=1106) (256=1110) (257=1115) (258=1119) (259=1123) (260=1128) (261=1132) (262=1136) (263=1141) (264=1145) (265=1150) (266=1154) (267=1158) 
(268=1162) (269=1167) (270=1171) (271=1176) (272=1180) (273=1184) (274=1189) (275=1193) (276=1196) (277=1201) (278=1205) (279=1209) (280=1214) (281=1218)
(282=1222) (283=1227) (284=1231) (285=1235) (286=1240) (287=1244) (288=1249) (289=1253) (290=1257) (291=1261) (292=1266) (293=1270) (294=1274) (295=1279) 
(296=1283) (297=1288) (298=1292) (299=1296) (300=1301) (301=1305) (302=1309) (303=1314) (304=1318) (305=1322) (306=1327) (307=1331) (308=1335) (309=1340) 
(310=1344) (311=1348) (312=1353) (313=1357) (314=1361) (315=1366) (316=1370) (317=1375) (318=1379) (319=1382) (320=1387) into b.
end repeat.
EXECUTE.
del vars Monthround1 to Monthround19.

* NxtRnd_wX - number of survey round from which data on this week come from
Weekly variables cover the period January 1994 to August 2020.
do repeat a=NxtRnd_w1 to NxtRnd_w1387 / b=1 to 1387.
compute a=-3.
if Weekround19>=b a=19.
if Weekround18>=b a=18.
if Weekround17>=b a=17.
if Weekround16>=b a=16.
if Weekround15>=b a=15.
if Weekround14>=b a=14.
if Weekround13>=b a=13.
if Weekround12>=b a=12.
if Weekround11>=b a=11.
if Weekround10>=b a=10.
if Weekround9>=b a=9.
if Weekround8>=b a=8.
if Weekround7>=b a=7.
if Weekround6>=b a=6.
if Weekround5>=b a=5.
if Weekround4>=b a=4.
if Weekround3>=b a=3.
if Weekround2>=b a=2.
if Weekround1>=b a=1.
if (R0536402-1980)*12>=b a=0.
end repeat.
* 0 means that respondent will not turn 14 this year.
* 1-19 means that the data on this week come from this survey round
* -3 are weeks with missing data as they are later than the last survey R participated in (drop out)

formats Weekround1 to Weekround19 (F4.0) 
/ NxtRnd_w1 to NxtRnd_w1387 (F2.0).
mis val NxtRnd_w1 to NxtRnd_w1387 (-3).
EXECUTE.

* Calculate flags to inform about a job gap in each week; also include decimals for weeks in which the presence of a gap could not be determined due to missing data

do repeat a=gapweek1 to gapweek1387 / b=NxtRnd_w1 to NxtRnd_w1387 / c=1 to 1387.
compute a=0.
if b=Round and swk<=c and ewk>=c a=1.
if b=Round and (startyear=-3 or startyear=-4) and ewk>=c a=0.01.
if b=Round and swk<c and (endyear=-3 or endyear=-4) a=0.01.
if b=Round and swk=c and (endyear=-3 or endyear=-4) a=1.
end repeat.
EXECUTE.

* Create respondent - wave - job ID.
compute RWJID=R0000100*1000000+WavejobID.
formats RWJID (F10.0).
EXECUTE.

SAVE OUTFILE='D:\NLSY97_Kopyckaetal\Jobgaps_long.sav'
 /COMPRESSED.

SORT CASES BY RWJID.
AGGREGATE
 /OUTFILE='D:\NLSY97_Kopyckaetal\Jobgaps_perjob.sav'
 /PRESORTED
 /BREAK=RWJID
 /Wave_mean=MEAN(wave) /Round_mean=MEAN(round) 
 /gapweek1_sum=SUM(gapweek1) /gapweek2_sum=SUM(gapweek2) /gapweek3_sum=SUM(gapweek3) /gapweek4_sum=SUM(gapweek4) 
 /gapweek5_sum=SUM(gapweek5) /gapweek6_sum=SUM(gapweek6) /gapweek7_sum=SUM(gapweek7) /gapweek8_sum=SUM(gapweek8) 
 /gapweek9_sum=SUM(gapweek9) /gapweek10_sum=SUM(gapweek10) /gapweek11_sum=SUM(gapweek11) /gapweek12_sum=SUM(gapweek12) 
 /gapweek13_sum=SUM(gapweek13) /gapweek14_sum=SUM(gapweek14) /gapweek15_sum=SUM(gapweek15) /gapweek16_sum=SUM(gapweek16) 
 /gapweek17_sum=SUM(gapweek17) /gapweek18_sum=SUM(gapweek18) /gapweek19_sum=SUM(gapweek19) /gapweek20_sum=SUM(gapweek20) 
 /gapweek21_sum=SUM(gapweek21) /gapweek22_sum=SUM(gapweek22) /gapweek23_sum=SUM(gapweek23) /gapweek24_sum=SUM(gapweek24) 
 /gapweek25_sum=SUM(gapweek25) /gapweek26_sum=SUM(gapweek26) /gapweek27_sum=SUM(gapweek27) /gapweek28_sum=SUM(gapweek28) 
 /gapweek29_sum=SUM(gapweek29) /gapweek30_sum=SUM(gapweek30) /gapweek31_sum=SUM(gapweek31) /gapweek32_sum=SUM(gapweek32) 
 /gapweek33_sum=SUM(gapweek33) /gapweek34_sum=SUM(gapweek34) /gapweek35_sum=SUM(gapweek35) /gapweek36_sum=SUM(gapweek36) 
 /gapweek37_sum=SUM(gapweek37) /gapweek38_sum=SUM(gapweek38) /gapweek39_sum=SUM(gapweek39) /gapweek40_sum=SUM(gapweek40) 
 /gapweek41_sum=SUM(gapweek41) /gapweek42_sum=SUM(gapweek42) /gapweek43_sum=SUM(gapweek43) /gapweek44_sum=SUM(gapweek44) 
 /gapweek45_sum=SUM(gapweek45) /gapweek46_sum=SUM(gapweek46) /gapweek47_sum=SUM(gapweek47) /gapweek48_sum=SUM(gapweek48) 
 /gapweek49_sum=SUM(gapweek49) /gapweek50_sum=SUM(gapweek50) /gapweek51_sum=SUM(gapweek51) /gapweek52_sum=SUM(gapweek52) 
 /gapweek53_sum=SUM(gapweek53) /gapweek54_sum=SUM(gapweek54) /gapweek55_sum=SUM(gapweek55) /gapweek56_sum=SUM(gapweek56) 
 /gapweek57_sum=SUM(gapweek57) /gapweek58_sum=SUM(gapweek58) /gapweek59_sum=SUM(gapweek59) /gapweek60_sum=SUM(gapweek60) 
 /gapweek61_sum=SUM(gapweek61) /gapweek62_sum=SUM(gapweek62) /gapweek63_sum=SUM(gapweek63) /gapweek64_sum=SUM(gapweek64) 
 /gapweek65_sum=SUM(gapweek65) /gapweek66_sum=SUM(gapweek66) /gapweek67_sum=SUM(gapweek67) /gapweek68_sum=SUM(gapweek68) 
 /gapweek69_sum=SUM(gapweek69) /gapweek70_sum=SUM(gapweek70) /gapweek71_sum=SUM(gapweek71) /gapweek72_sum=SUM(gapweek72) 
 /gapweek73_sum=SUM(gapweek73) /gapweek74_sum=SUM(gapweek74) /gapweek75_sum=SUM(gapweek75) /gapweek76_sum=SUM(gapweek76) 
 /gapweek77_sum=SUM(gapweek77) /gapweek78_sum=SUM(gapweek78) /gapweek79_sum=SUM(gapweek79) /gapweek80_sum=SUM(gapweek80) 
 /gapweek81_sum=SUM(gapweek81) /gapweek82_sum=SUM(gapweek82) /gapweek83_sum=SUM(gapweek83) /gapweek84_sum=SUM(gapweek84) 
 /gapweek85_sum=SUM(gapweek85) /gapweek86_sum=SUM(gapweek86) /gapweek87_sum=SUM(gapweek87) /gapweek88_sum=SUM(gapweek88) 
 /gapweek89_sum=SUM(gapweek89) /gapweek90_sum=SUM(gapweek90) /gapweek91_sum=SUM(gapweek91) /gapweek92_sum=SUM(gapweek92) 
 /gapweek93_sum=SUM(gapweek93) /gapweek94_sum=SUM(gapweek94) /gapweek95_sum=SUM(gapweek95) /gapweek96_sum=SUM(gapweek96) 
 /gapweek97_sum=SUM(gapweek97) /gapweek98_sum=SUM(gapweek98) /gapweek99_sum=SUM(gapweek99) /gapweek100_sum=SUM(gapweek100) 
 /gapweek101_sum=SUM(gapweek101) /gapweek102_sum=SUM(gapweek102) /gapweek103_sum=SUM(gapweek103) /gapweek104_sum=SUM(gapweek104) 
 /gapweek105_sum=SUM(gapweek105) /gapweek106_sum=SUM(gapweek106) /gapweek107_sum=SUM(gapweek107) /gapweek108_sum=SUM(gapweek108) 
 /gapweek109_sum=SUM(gapweek109) /gapweek110_sum=SUM(gapweek110) /gapweek111_sum=SUM(gapweek111) /gapweek112_sum=SUM(gapweek112) 
 /gapweek113_sum=SUM(gapweek113) /gapweek114_sum=SUM(gapweek114) /gapweek115_sum=SUM(gapweek115) /gapweek116_sum=SUM(gapweek116) 
 /gapweek117_sum=SUM(gapweek117) /gapweek118_sum=SUM(gapweek118) /gapweek119_sum=SUM(gapweek119) /gapweek120_sum=SUM(gapweek120) 
 /gapweek121_sum=SUM(gapweek121) /gapweek122_sum=SUM(gapweek122) /gapweek123_sum=SUM(gapweek123) /gapweek124_sum=SUM(gapweek124) 
 /gapweek125_sum=SUM(gapweek125) /gapweek126_sum=SUM(gapweek126) /gapweek127_sum=SUM(gapweek127) /gapweek128_sum=SUM(gapweek128) 
 /gapweek129_sum=SUM(gapweek129) /gapweek130_sum=SUM(gapweek130) /gapweek131_sum=SUM(gapweek131) /gapweek132_sum=SUM(gapweek132) 
 /gapweek133_sum=SUM(gapweek133) /gapweek134_sum=SUM(gapweek134) /gapweek135_sum=SUM(gapweek135) /gapweek136_sum=SUM(gapweek136) 
 /gapweek137_sum=SUM(gapweek137) /gapweek138_sum=SUM(gapweek138) /gapweek139_sum=SUM(gapweek139) /gapweek140_sum=SUM(gapweek140) 
 /gapweek141_sum=SUM(gapweek141) /gapweek142_sum=SUM(gapweek142) /gapweek143_sum=SUM(gapweek143) /gapweek144_sum=SUM(gapweek144) 
 /gapweek145_sum=SUM(gapweek145) /gapweek146_sum=SUM(gapweek146) /gapweek147_sum=SUM(gapweek147) /gapweek148_sum=SUM(gapweek148) 
 /gapweek149_sum=SUM(gapweek149) /gapweek150_sum=SUM(gapweek150) /gapweek151_sum=SUM(gapweek151) /gapweek152_sum=SUM(gapweek152) 
 /gapweek153_sum=SUM(gapweek153) /gapweek154_sum=SUM(gapweek154) /gapweek155_sum=SUM(gapweek155) /gapweek156_sum=SUM(gapweek156) 
 /gapweek157_sum=SUM(gapweek157) /gapweek158_sum=SUM(gapweek158) /gapweek159_sum=SUM(gapweek159) /gapweek160_sum=SUM(gapweek160) 
 /gapweek161_sum=SUM(gapweek161) /gapweek162_sum=SUM(gapweek162) /gapweek163_sum=SUM(gapweek163) /gapweek164_sum=SUM(gapweek164) 
 /gapweek165_sum=SUM(gapweek165) /gapweek166_sum=SUM(gapweek166) /gapweek167_sum=SUM(gapweek167) /gapweek168_sum=SUM(gapweek168) 
 /gapweek169_sum=SUM(gapweek169) /gapweek170_sum=SUM(gapweek170) /gapweek171_sum=SUM(gapweek171) /gapweek172_sum=SUM(gapweek172) 
 /gapweek173_sum=SUM(gapweek173) /gapweek174_sum=SUM(gapweek174) /gapweek175_sum=SUM(gapweek175) /gapweek176_sum=SUM(gapweek176) 
 /gapweek177_sum=SUM(gapweek177) /gapweek178_sum=SUM(gapweek178) /gapweek179_sum=SUM(gapweek179) /gapweek180_sum=SUM(gapweek180) 
 /gapweek181_sum=SUM(gapweek181) /gapweek182_sum=SUM(gapweek182) /gapweek183_sum=SUM(gapweek183) /gapweek184_sum=SUM(gapweek184) 
 /gapweek185_sum=SUM(gapweek185) /gapweek186_sum=SUM(gapweek186) /gapweek187_sum=SUM(gapweek187) /gapweek188_sum=SUM(gapweek188) 
 /gapweek189_sum=SUM(gapweek189) /gapweek190_sum=SUM(gapweek190) /gapweek191_sum=SUM(gapweek191) /gapweek192_sum=SUM(gapweek192) 
 /gapweek193_sum=SUM(gapweek193) /gapweek194_sum=SUM(gapweek194) /gapweek195_sum=SUM(gapweek195) /gapweek196_sum=SUM(gapweek196) 
 /gapweek197_sum=SUM(gapweek197) /gapweek198_sum=SUM(gapweek198) /gapweek199_sum=SUM(gapweek199) /gapweek200_sum=SUM(gapweek200) 
 /gapweek201_sum=SUM(gapweek201) /gapweek202_sum=SUM(gapweek202) /gapweek203_sum=SUM(gapweek203) /gapweek204_sum=SUM(gapweek204) 
 /gapweek205_sum=SUM(gapweek205) /gapweek206_sum=SUM(gapweek206) /gapweek207_sum=SUM(gapweek207) /gapweek208_sum=SUM(gapweek208) 
 /gapweek209_sum=SUM(gapweek209) /gapweek210_sum=SUM(gapweek210) /gapweek211_sum=SUM(gapweek211) /gapweek212_sum=SUM(gapweek212) 
 /gapweek213_sum=SUM(gapweek213) /gapweek214_sum=SUM(gapweek214) /gapweek215_sum=SUM(gapweek215) /gapweek216_sum=SUM(gapweek216) 
 /gapweek217_sum=SUM(gapweek217) /gapweek218_sum=SUM(gapweek218) /gapweek219_sum=SUM(gapweek219) /gapweek220_sum=SUM(gapweek220) 
 /gapweek221_sum=SUM(gapweek221) /gapweek222_sum=SUM(gapweek222) /gapweek223_sum=SUM(gapweek223) /gapweek224_sum=SUM(gapweek224) 
 /gapweek225_sum=SUM(gapweek225) /gapweek226_sum=SUM(gapweek226) /gapweek227_sum=SUM(gapweek227) /gapweek228_sum=SUM(gapweek228) 
 /gapweek229_sum=SUM(gapweek229) /gapweek230_sum=SUM(gapweek230) /gapweek231_sum=SUM(gapweek231) /gapweek232_sum=SUM(gapweek232) 
 /gapweek233_sum=SUM(gapweek233) /gapweek234_sum=SUM(gapweek234) /gapweek235_sum=SUM(gapweek235) /gapweek236_sum=SUM(gapweek236) 
 /gapweek237_sum=SUM(gapweek237) /gapweek238_sum=SUM(gapweek238) /gapweek239_sum=SUM(gapweek239) /gapweek240_sum=SUM(gapweek240) 
 /gapweek241_sum=SUM(gapweek241) /gapweek242_sum=SUM(gapweek242) /gapweek243_sum=SUM(gapweek243) /gapweek244_sum=SUM(gapweek244) 
 /gapweek245_sum=SUM(gapweek245) /gapweek246_sum=SUM(gapweek246) /gapweek247_sum=SUM(gapweek247) /gapweek248_sum=SUM(gapweek248) 
 /gapweek249_sum=SUM(gapweek249) /gapweek250_sum=SUM(gapweek250) /gapweek251_sum=SUM(gapweek251) /gapweek252_sum=SUM(gapweek252) 
 /gapweek253_sum=SUM(gapweek253) /gapweek254_sum=SUM(gapweek254) /gapweek255_sum=SUM(gapweek255) /gapweek256_sum=SUM(gapweek256) 
 /gapweek257_sum=SUM(gapweek257) /gapweek258_sum=SUM(gapweek258) /gapweek259_sum=SUM(gapweek259) /gapweek260_sum=SUM(gapweek260) 
 /gapweek261_sum=SUM(gapweek261) /gapweek262_sum=SUM(gapweek262) /gapweek263_sum=SUM(gapweek263) /gapweek264_sum=SUM(gapweek264) 
 /gapweek265_sum=SUM(gapweek265) /gapweek266_sum=SUM(gapweek266) /gapweek267_sum=SUM(gapweek267) /gapweek268_sum=SUM(gapweek268) 
 /gapweek269_sum=SUM(gapweek269) /gapweek270_sum=SUM(gapweek270) /gapweek271_sum=SUM(gapweek271) /gapweek272_sum=SUM(gapweek272) 
 /gapweek273_sum=SUM(gapweek273) /gapweek274_sum=SUM(gapweek274) /gapweek275_sum=SUM(gapweek275) /gapweek276_sum=SUM(gapweek276) 
 /gapweek277_sum=SUM(gapweek277) /gapweek278_sum=SUM(gapweek278) /gapweek279_sum=SUM(gapweek279) /gapweek280_sum=SUM(gapweek280) 
 /gapweek281_sum=SUM(gapweek281) /gapweek282_sum=SUM(gapweek282) /gapweek283_sum=SUM(gapweek283) /gapweek284_sum=SUM(gapweek284) 
 /gapweek285_sum=SUM(gapweek285) /gapweek286_sum=SUM(gapweek286) /gapweek287_sum=SUM(gapweek287) /gapweek288_sum=SUM(gapweek288) 
 /gapweek289_sum=SUM(gapweek289) /gapweek290_sum=SUM(gapweek290) /gapweek291_sum=SUM(gapweek291) /gapweek292_sum=SUM(gapweek292) 
 /gapweek293_sum=SUM(gapweek293) /gapweek294_sum=SUM(gapweek294) /gapweek295_sum=SUM(gapweek295) /gapweek296_sum=SUM(gapweek296) 
 /gapweek297_sum=SUM(gapweek297) /gapweek298_sum=SUM(gapweek298) /gapweek299_sum=SUM(gapweek299) /gapweek300_sum=SUM(gapweek300) 
 /gapweek301_sum=SUM(gapweek301) /gapweek302_sum=SUM(gapweek302) /gapweek303_sum=SUM(gapweek303) /gapweek304_sum=SUM(gapweek304) 
 /gapweek305_sum=SUM(gapweek305) /gapweek306_sum=SUM(gapweek306) /gapweek307_sum=SUM(gapweek307) /gapweek308_sum=SUM(gapweek308) 
 /gapweek309_sum=SUM(gapweek309) /gapweek310_sum=SUM(gapweek310) /gapweek311_sum=SUM(gapweek311) /gapweek312_sum=SUM(gapweek312) 
 /gapweek313_sum=SUM(gapweek313) /gapweek314_sum=SUM(gapweek314) /gapweek315_sum=SUM(gapweek315) /gapweek316_sum=SUM(gapweek316) 
 /gapweek317_sum=SUM(gapweek317) /gapweek318_sum=SUM(gapweek318) /gapweek319_sum=SUM(gapweek319) /gapweek320_sum=SUM(gapweek320) 
 /gapweek321_sum=SUM(gapweek321) /gapweek322_sum=SUM(gapweek322) /gapweek323_sum=SUM(gapweek323) /gapweek324_sum=SUM(gapweek324) 
 /gapweek325_sum=SUM(gapweek325) /gapweek326_sum=SUM(gapweek326) /gapweek327_sum=SUM(gapweek327) /gapweek328_sum=SUM(gapweek328) 
 /gapweek329_sum=SUM(gapweek329) /gapweek330_sum=SUM(gapweek330) /gapweek331_sum=SUM(gapweek331) /gapweek332_sum=SUM(gapweek332) 
 /gapweek333_sum=SUM(gapweek333) /gapweek334_sum=SUM(gapweek334) /gapweek335_sum=SUM(gapweek335) /gapweek336_sum=SUM(gapweek336) 
 /gapweek337_sum=SUM(gapweek337) /gapweek338_sum=SUM(gapweek338) /gapweek339_sum=SUM(gapweek339) /gapweek340_sum=SUM(gapweek340) 
 /gapweek341_sum=SUM(gapweek341) /gapweek342_sum=SUM(gapweek342) /gapweek343_sum=SUM(gapweek343) /gapweek344_sum=SUM(gapweek344) 
 /gapweek345_sum=SUM(gapweek345) /gapweek346_sum=SUM(gapweek346) /gapweek347_sum=SUM(gapweek347) /gapweek348_sum=SUM(gapweek348) 
 /gapweek349_sum=SUM(gapweek349) /gapweek350_sum=SUM(gapweek350) /gapweek351_sum=SUM(gapweek351) /gapweek352_sum=SUM(gapweek352) 
 /gapweek353_sum=SUM(gapweek353) /gapweek354_sum=SUM(gapweek354) /gapweek355_sum=SUM(gapweek355) /gapweek356_sum=SUM(gapweek356) 
 /gapweek357_sum=SUM(gapweek357) /gapweek358_sum=SUM(gapweek358) /gapweek359_sum=SUM(gapweek359) /gapweek360_sum=SUM(gapweek360) 
 /gapweek361_sum=SUM(gapweek361) /gapweek362_sum=SUM(gapweek362) /gapweek363_sum=SUM(gapweek363) /gapweek364_sum=SUM(gapweek364) 
 /gapweek365_sum=SUM(gapweek365) /gapweek366_sum=SUM(gapweek366) /gapweek367_sum=SUM(gapweek367) /gapweek368_sum=SUM(gapweek368) 
 /gapweek369_sum=SUM(gapweek369) /gapweek370_sum=SUM(gapweek370) /gapweek371_sum=SUM(gapweek371) /gapweek372_sum=SUM(gapweek372) 
 /gapweek373_sum=SUM(gapweek373) /gapweek374_sum=SUM(gapweek374) /gapweek375_sum=SUM(gapweek375) /gapweek376_sum=SUM(gapweek376) 
 /gapweek377_sum=SUM(gapweek377) /gapweek378_sum=SUM(gapweek378) /gapweek379_sum=SUM(gapweek379) /gapweek380_sum=SUM(gapweek380) 
 /gapweek381_sum=SUM(gapweek381) /gapweek382_sum=SUM(gapweek382) /gapweek383_sum=SUM(gapweek383) /gapweek384_sum=SUM(gapweek384) 
 /gapweek385_sum=SUM(gapweek385) /gapweek386_sum=SUM(gapweek386) /gapweek387_sum=SUM(gapweek387) /gapweek388_sum=SUM(gapweek388) 
 /gapweek389_sum=SUM(gapweek389) /gapweek390_sum=SUM(gapweek390) /gapweek391_sum=SUM(gapweek391) /gapweek392_sum=SUM(gapweek392) 
 /gapweek393_sum=SUM(gapweek393) /gapweek394_sum=SUM(gapweek394) /gapweek395_sum=SUM(gapweek395) /gapweek396_sum=SUM(gapweek396) 
 /gapweek397_sum=SUM(gapweek397) /gapweek398_sum=SUM(gapweek398) /gapweek399_sum=SUM(gapweek399) /gapweek400_sum=SUM(gapweek400) 
 /gapweek401_sum=SUM(gapweek401) /gapweek402_sum=SUM(gapweek402) /gapweek403_sum=SUM(gapweek403) /gapweek404_sum=SUM(gapweek404) 
 /gapweek405_sum=SUM(gapweek405) /gapweek406_sum=SUM(gapweek406) /gapweek407_sum=SUM(gapweek407) /gapweek408_sum=SUM(gapweek408) 
 /gapweek409_sum=SUM(gapweek409) /gapweek410_sum=SUM(gapweek410) /gapweek411_sum=SUM(gapweek411) /gapweek412_sum=SUM(gapweek412) 
 /gapweek413_sum=SUM(gapweek413) /gapweek414_sum=SUM(gapweek414) /gapweek415_sum=SUM(gapweek415) /gapweek416_sum=SUM(gapweek416) 
 /gapweek417_sum=SUM(gapweek417) /gapweek418_sum=SUM(gapweek418) /gapweek419_sum=SUM(gapweek419) /gapweek420_sum=SUM(gapweek420) 
 /gapweek421_sum=SUM(gapweek421) /gapweek422_sum=SUM(gapweek422) /gapweek423_sum=SUM(gapweek423) /gapweek424_sum=SUM(gapweek424) 
 /gapweek425_sum=SUM(gapweek425) /gapweek426_sum=SUM(gapweek426) /gapweek427_sum=SUM(gapweek427) /gapweek428_sum=SUM(gapweek428) 
 /gapweek429_sum=SUM(gapweek429) /gapweek430_sum=SUM(gapweek430) /gapweek431_sum=SUM(gapweek431) /gapweek432_sum=SUM(gapweek432) 
 /gapweek433_sum=SUM(gapweek433) /gapweek434_sum=SUM(gapweek434) /gapweek435_sum=SUM(gapweek435) /gapweek436_sum=SUM(gapweek436) 
 /gapweek437_sum=SUM(gapweek437) /gapweek438_sum=SUM(gapweek438) /gapweek439_sum=SUM(gapweek439) /gapweek440_sum=SUM(gapweek440) 
 /gapweek441_sum=SUM(gapweek441) /gapweek442_sum=SUM(gapweek442) /gapweek443_sum=SUM(gapweek443) /gapweek444_sum=SUM(gapweek444) 
 /gapweek445_sum=SUM(gapweek445) /gapweek446_sum=SUM(gapweek446) /gapweek447_sum=SUM(gapweek447) /gapweek448_sum=SUM(gapweek448) 
 /gapweek449_sum=SUM(gapweek449) /gapweek450_sum=SUM(gapweek450) /gapweek451_sum=SUM(gapweek451) /gapweek452_sum=SUM(gapweek452) 
 /gapweek453_sum=SUM(gapweek453) /gapweek454_sum=SUM(gapweek454) /gapweek455_sum=SUM(gapweek455) /gapweek456_sum=SUM(gapweek456) 
 /gapweek457_sum=SUM(gapweek457) /gapweek458_sum=SUM(gapweek458) /gapweek459_sum=SUM(gapweek459) /gapweek460_sum=SUM(gapweek460) 
 /gapweek461_sum=SUM(gapweek461) /gapweek462_sum=SUM(gapweek462) /gapweek463_sum=SUM(gapweek463) /gapweek464_sum=SUM(gapweek464) 
 /gapweek465_sum=SUM(gapweek465) /gapweek466_sum=SUM(gapweek466) /gapweek467_sum=SUM(gapweek467) /gapweek468_sum=SUM(gapweek468) 
 /gapweek469_sum=SUM(gapweek469) /gapweek470_sum=SUM(gapweek470) /gapweek471_sum=SUM(gapweek471) /gapweek472_sum=SUM(gapweek472) 
 /gapweek473_sum=SUM(gapweek473) /gapweek474_sum=SUM(gapweek474) /gapweek475_sum=SUM(gapweek475) /gapweek476_sum=SUM(gapweek476) 
 /gapweek477_sum=SUM(gapweek477) /gapweek478_sum=SUM(gapweek478) /gapweek479_sum=SUM(gapweek479) /gapweek480_sum=SUM(gapweek480) 
 /gapweek481_sum=SUM(gapweek481) /gapweek482_sum=SUM(gapweek482) /gapweek483_sum=SUM(gapweek483) /gapweek484_sum=SUM(gapweek484) 
 /gapweek485_sum=SUM(gapweek485) /gapweek486_sum=SUM(gapweek486) /gapweek487_sum=SUM(gapweek487) /gapweek488_sum=SUM(gapweek488) 
 /gapweek489_sum=SUM(gapweek489) /gapweek490_sum=SUM(gapweek490) /gapweek491_sum=SUM(gapweek491) /gapweek492_sum=SUM(gapweek492) 
 /gapweek493_sum=SUM(gapweek493) /gapweek494_sum=SUM(gapweek494) /gapweek495_sum=SUM(gapweek495) /gapweek496_sum=SUM(gapweek496) 
 /gapweek497_sum=SUM(gapweek497) /gapweek498_sum=SUM(gapweek498) /gapweek499_sum=SUM(gapweek499) /gapweek500_sum=SUM(gapweek500) 
 /gapweek501_sum=SUM(gapweek501) /gapweek502_sum=SUM(gapweek502) /gapweek503_sum=SUM(gapweek503) /gapweek504_sum=SUM(gapweek504) 
 /gapweek505_sum=SUM(gapweek505) /gapweek506_sum=SUM(gapweek506) /gapweek507_sum=SUM(gapweek507) /gapweek508_sum=SUM(gapweek508) 
 /gapweek509_sum=SUM(gapweek509) /gapweek510_sum=SUM(gapweek510) /gapweek511_sum=SUM(gapweek511) /gapweek512_sum=SUM(gapweek512) 
 /gapweek513_sum=SUM(gapweek513) /gapweek514_sum=SUM(gapweek514) /gapweek515_sum=SUM(gapweek515) /gapweek516_sum=SUM(gapweek516) 
 /gapweek517_sum=SUM(gapweek517) /gapweek518_sum=SUM(gapweek518) /gapweek519_sum=SUM(gapweek519) /gapweek520_sum=SUM(gapweek520) 
 /gapweek521_sum=SUM(gapweek521) /gapweek522_sum=SUM(gapweek522) /gapweek523_sum=SUM(gapweek523) /gapweek524_sum=SUM(gapweek524) 
 /gapweek525_sum=SUM(gapweek525) /gapweek526_sum=SUM(gapweek526) /gapweek527_sum=SUM(gapweek527) /gapweek528_sum=SUM(gapweek528) 
 /gapweek529_sum=SUM(gapweek529) /gapweek530_sum=SUM(gapweek530) /gapweek531_sum=SUM(gapweek531) /gapweek532_sum=SUM(gapweek532) 
 /gapweek533_sum=SUM(gapweek533) /gapweek534_sum=SUM(gapweek534) /gapweek535_sum=SUM(gapweek535) /gapweek536_sum=SUM(gapweek536) 
 /gapweek537_sum=SUM(gapweek537) /gapweek538_sum=SUM(gapweek538) /gapweek539_sum=SUM(gapweek539) /gapweek540_sum=SUM(gapweek540) 
 /gapweek541_sum=SUM(gapweek541) /gapweek542_sum=SUM(gapweek542) /gapweek543_sum=SUM(gapweek543) /gapweek544_sum=SUM(gapweek544) 
 /gapweek545_sum=SUM(gapweek545) /gapweek546_sum=SUM(gapweek546) /gapweek547_sum=SUM(gapweek547) /gapweek548_sum=SUM(gapweek548) 
 /gapweek549_sum=SUM(gapweek549) /gapweek550_sum=SUM(gapweek550) /gapweek551_sum=SUM(gapweek551) /gapweek552_sum=SUM(gapweek552) 
 /gapweek553_sum=SUM(gapweek553) /gapweek554_sum=SUM(gapweek554) /gapweek555_sum=SUM(gapweek555) /gapweek556_sum=SUM(gapweek556) 
 /gapweek557_sum=SUM(gapweek557) /gapweek558_sum=SUM(gapweek558) /gapweek559_sum=SUM(gapweek559) /gapweek560_sum=SUM(gapweek560) 
 /gapweek561_sum=SUM(gapweek561) /gapweek562_sum=SUM(gapweek562) /gapweek563_sum=SUM(gapweek563) /gapweek564_sum=SUM(gapweek564) 
 /gapweek565_sum=SUM(gapweek565) /gapweek566_sum=SUM(gapweek566) /gapweek567_sum=SUM(gapweek567) /gapweek568_sum=SUM(gapweek568) 
 /gapweek569_sum=SUM(gapweek569) /gapweek570_sum=SUM(gapweek570) /gapweek571_sum=SUM(gapweek571) /gapweek572_sum=SUM(gapweek572) 
 /gapweek573_sum=SUM(gapweek573) /gapweek574_sum=SUM(gapweek574) /gapweek575_sum=SUM(gapweek575) /gapweek576_sum=SUM(gapweek576) 
 /gapweek577_sum=SUM(gapweek577) /gapweek578_sum=SUM(gapweek578) /gapweek579_sum=SUM(gapweek579) /gapweek580_sum=SUM(gapweek580) 
 /gapweek581_sum=SUM(gapweek581) /gapweek582_sum=SUM(gapweek582) /gapweek583_sum=SUM(gapweek583) /gapweek584_sum=SUM(gapweek584) 
 /gapweek585_sum=SUM(gapweek585) /gapweek586_sum=SUM(gapweek586) /gapweek587_sum=SUM(gapweek587) /gapweek588_sum=SUM(gapweek588) 
 /gapweek589_sum=SUM(gapweek589) /gapweek590_sum=SUM(gapweek590) /gapweek591_sum=SUM(gapweek591) /gapweek592_sum=SUM(gapweek592) 
 /gapweek593_sum=SUM(gapweek593) /gapweek594_sum=SUM(gapweek594) /gapweek595_sum=SUM(gapweek595) /gapweek596_sum=SUM(gapweek596) 
 /gapweek597_sum=SUM(gapweek597) /gapweek598_sum=SUM(gapweek598) /gapweek599_sum=SUM(gapweek599) /gapweek600_sum=SUM(gapweek600) 
 /gapweek601_sum=SUM(gapweek601) /gapweek602_sum=SUM(gapweek602) /gapweek603_sum=SUM(gapweek603) /gapweek604_sum=SUM(gapweek604) 
 /gapweek605_sum=SUM(gapweek605) /gapweek606_sum=SUM(gapweek606) /gapweek607_sum=SUM(gapweek607) /gapweek608_sum=SUM(gapweek608) 
 /gapweek609_sum=SUM(gapweek609) /gapweek610_sum=SUM(gapweek610) /gapweek611_sum=SUM(gapweek611) /gapweek612_sum=SUM(gapweek612) 
 /gapweek613_sum=SUM(gapweek613) /gapweek614_sum=SUM(gapweek614) /gapweek615_sum=SUM(gapweek615) /gapweek616_sum=SUM(gapweek616) 
 /gapweek617_sum=SUM(gapweek617) /gapweek618_sum=SUM(gapweek618) /gapweek619_sum=SUM(gapweek619) /gapweek620_sum=SUM(gapweek620) 
 /gapweek621_sum=SUM(gapweek621) /gapweek622_sum=SUM(gapweek622) /gapweek623_sum=SUM(gapweek623) /gapweek624_sum=SUM(gapweek624) 
 /gapweek625_sum=SUM(gapweek625) /gapweek626_sum=SUM(gapweek626) /gapweek627_sum=SUM(gapweek627) /gapweek628_sum=SUM(gapweek628) 
 /gapweek629_sum=SUM(gapweek629) /gapweek630_sum=SUM(gapweek630) /gapweek631_sum=SUM(gapweek631) /gapweek632_sum=SUM(gapweek632) 
 /gapweek633_sum=SUM(gapweek633) /gapweek634_sum=SUM(gapweek634) /gapweek635_sum=SUM(gapweek635) /gapweek636_sum=SUM(gapweek636) 
 /gapweek637_sum=SUM(gapweek637) /gapweek638_sum=SUM(gapweek638) /gapweek639_sum=SUM(gapweek639) /gapweek640_sum=SUM(gapweek640) 
 /gapweek641_sum=SUM(gapweek641) /gapweek642_sum=SUM(gapweek642) /gapweek643_sum=SUM(gapweek643) /gapweek644_sum=SUM(gapweek644) 
 /gapweek645_sum=SUM(gapweek645) /gapweek646_sum=SUM(gapweek646) /gapweek647_sum=SUM(gapweek647) /gapweek648_sum=SUM(gapweek648) 
 /gapweek649_sum=SUM(gapweek649) /gapweek650_sum=SUM(gapweek650) /gapweek651_sum=SUM(gapweek651) /gapweek652_sum=SUM(gapweek652) 
 /gapweek653_sum=SUM(gapweek653) /gapweek654_sum=SUM(gapweek654) /gapweek655_sum=SUM(gapweek655) /gapweek656_sum=SUM(gapweek656) 
 /gapweek657_sum=SUM(gapweek657) /gapweek658_sum=SUM(gapweek658) /gapweek659_sum=SUM(gapweek659) /gapweek660_sum=SUM(gapweek660) 
 /gapweek661_sum=SUM(gapweek661) /gapweek662_sum=SUM(gapweek662) /gapweek663_sum=SUM(gapweek663) /gapweek664_sum=SUM(gapweek664) 
 /gapweek665_sum=SUM(gapweek665) /gapweek666_sum=SUM(gapweek666) /gapweek667_sum=SUM(gapweek667) /gapweek668_sum=SUM(gapweek668) 
 /gapweek669_sum=SUM(gapweek669) /gapweek670_sum=SUM(gapweek670) /gapweek671_sum=SUM(gapweek671) /gapweek672_sum=SUM(gapweek672) 
 /gapweek673_sum=SUM(gapweek673) /gapweek674_sum=SUM(gapweek674) /gapweek675_sum=SUM(gapweek675) /gapweek676_sum=SUM(gapweek676) 
 /gapweek677_sum=SUM(gapweek677) /gapweek678_sum=SUM(gapweek678) /gapweek679_sum=SUM(gapweek679) /gapweek680_sum=SUM(gapweek680) 
 /gapweek681_sum=SUM(gapweek681) /gapweek682_sum=SUM(gapweek682) /gapweek683_sum=SUM(gapweek683) /gapweek684_sum=SUM(gapweek684) 
 /gapweek685_sum=SUM(gapweek685) /gapweek686_sum=SUM(gapweek686) /gapweek687_sum=SUM(gapweek687) /gapweek688_sum=SUM(gapweek688) 
 /gapweek689_sum=SUM(gapweek689) /gapweek690_sum=SUM(gapweek690) /gapweek691_sum=SUM(gapweek691) /gapweek692_sum=SUM(gapweek692) 
 /gapweek693_sum=SUM(gapweek693) /gapweek694_sum=SUM(gapweek694) /gapweek695_sum=SUM(gapweek695) /gapweek696_sum=SUM(gapweek696) 
 /gapweek697_sum=SUM(gapweek697) /gapweek698_sum=SUM(gapweek698) /gapweek699_sum=SUM(gapweek699) /gapweek700_sum=SUM(gapweek700) 
 /gapweek701_sum=SUM(gapweek701) /gapweek702_sum=SUM(gapweek702) /gapweek703_sum=SUM(gapweek703) /gapweek704_sum=SUM(gapweek704) 
 /gapweek705_sum=SUM(gapweek705) /gapweek706_sum=SUM(gapweek706) /gapweek707_sum=SUM(gapweek707) /gapweek708_sum=SUM(gapweek708) 
 /gapweek709_sum=SUM(gapweek709) /gapweek710_sum=SUM(gapweek710) /gapweek711_sum=SUM(gapweek711) /gapweek712_sum=SUM(gapweek712) 
 /gapweek713_sum=SUM(gapweek713) /gapweek714_sum=SUM(gapweek714) /gapweek715_sum=SUM(gapweek715) /gapweek716_sum=SUM(gapweek716) 
 /gapweek717_sum=SUM(gapweek717) /gapweek718_sum=SUM(gapweek718) /gapweek719_sum=SUM(gapweek719) /gapweek720_sum=SUM(gapweek720) 
 /gapweek721_sum=SUM(gapweek721) /gapweek722_sum=SUM(gapweek722) /gapweek723_sum=SUM(gapweek723) /gapweek724_sum=SUM(gapweek724) 
 /gapweek725_sum=SUM(gapweek725) /gapweek726_sum=SUM(gapweek726) /gapweek727_sum=SUM(gapweek727) /gapweek728_sum=SUM(gapweek728) 
 /gapweek729_sum=SUM(gapweek729) /gapweek730_sum=SUM(gapweek730) /gapweek731_sum=SUM(gapweek731) /gapweek732_sum=SUM(gapweek732) 
 /gapweek733_sum=SUM(gapweek733) /gapweek734_sum=SUM(gapweek734) /gapweek735_sum=SUM(gapweek735) /gapweek736_sum=SUM(gapweek736) 
 /gapweek737_sum=SUM(gapweek737) /gapweek738_sum=SUM(gapweek738) /gapweek739_sum=SUM(gapweek739) /gapweek740_sum=SUM(gapweek740) 
 /gapweek741_sum=SUM(gapweek741) /gapweek742_sum=SUM(gapweek742) /gapweek743_sum=SUM(gapweek743) /gapweek744_sum=SUM(gapweek744) 
 /gapweek745_sum=SUM(gapweek745) /gapweek746_sum=SUM(gapweek746) /gapweek747_sum=SUM(gapweek747) /gapweek748_sum=SUM(gapweek748) 
 /gapweek749_sum=SUM(gapweek749) /gapweek750_sum=SUM(gapweek750) /gapweek751_sum=SUM(gapweek751) /gapweek752_sum=SUM(gapweek752) 
 /gapweek753_sum=SUM(gapweek753) /gapweek754_sum=SUM(gapweek754) /gapweek755_sum=SUM(gapweek755) /gapweek756_sum=SUM(gapweek756) 
 /gapweek757_sum=SUM(gapweek757) /gapweek758_sum=SUM(gapweek758) /gapweek759_sum=SUM(gapweek759) /gapweek760_sum=SUM(gapweek760) 
 /gapweek761_sum=SUM(gapweek761) /gapweek762_sum=SUM(gapweek762) /gapweek763_sum=SUM(gapweek763) /gapweek764_sum=SUM(gapweek764) 
 /gapweek765_sum=SUM(gapweek765) /gapweek766_sum=SUM(gapweek766) /gapweek767_sum=SUM(gapweek767) /gapweek768_sum=SUM(gapweek768) 
 /gapweek769_sum=SUM(gapweek769) /gapweek770_sum=SUM(gapweek770) /gapweek771_sum=SUM(gapweek771) /gapweek772_sum=SUM(gapweek772) 
 /gapweek773_sum=SUM(gapweek773) /gapweek774_sum=SUM(gapweek774) /gapweek775_sum=SUM(gapweek775) /gapweek776_sum=SUM(gapweek776) 
 /gapweek777_sum=SUM(gapweek777) /gapweek778_sum=SUM(gapweek778) /gapweek779_sum=SUM(gapweek779) /gapweek780_sum=SUM(gapweek780) 
 /gapweek781_sum=SUM(gapweek781) /gapweek782_sum=SUM(gapweek782) /gapweek783_sum=SUM(gapweek783) /gapweek784_sum=SUM(gapweek784) 
 /gapweek785_sum=SUM(gapweek785) /gapweek786_sum=SUM(gapweek786) /gapweek787_sum=SUM(gapweek787) /gapweek788_sum=SUM(gapweek788) 
 /gapweek789_sum=SUM(gapweek789) /gapweek790_sum=SUM(gapweek790) /gapweek791_sum=SUM(gapweek791) /gapweek792_sum=SUM(gapweek792) 
 /gapweek793_sum=SUM(gapweek793) /gapweek794_sum=SUM(gapweek794) /gapweek795_sum=SUM(gapweek795) /gapweek796_sum=SUM(gapweek796) 
 /gapweek797_sum=SUM(gapweek797) /gapweek798_sum=SUM(gapweek798) /gapweek799_sum=SUM(gapweek799) /gapweek800_sum=SUM(gapweek800) 
 /gapweek801_sum=SUM(gapweek801) /gapweek802_sum=SUM(gapweek802) /gapweek803_sum=SUM(gapweek803) /gapweek804_sum=SUM(gapweek804) 
 /gapweek805_sum=SUM(gapweek805) /gapweek806_sum=SUM(gapweek806) /gapweek807_sum=SUM(gapweek807) /gapweek808_sum=SUM(gapweek808) 
 /gapweek809_sum=SUM(gapweek809) /gapweek810_sum=SUM(gapweek810) /gapweek811_sum=SUM(gapweek811) /gapweek812_sum=SUM(gapweek812) 
 /gapweek813_sum=SUM(gapweek813) /gapweek814_sum=SUM(gapweek814) /gapweek815_sum=SUM(gapweek815) /gapweek816_sum=SUM(gapweek816) 
 /gapweek817_sum=SUM(gapweek817) /gapweek818_sum=SUM(gapweek818) /gapweek819_sum=SUM(gapweek819) /gapweek820_sum=SUM(gapweek820) 
 /gapweek821_sum=SUM(gapweek821) /gapweek822_sum=SUM(gapweek822) /gapweek823_sum=SUM(gapweek823) /gapweek824_sum=SUM(gapweek824) 
 /gapweek825_sum=SUM(gapweek825) /gapweek826_sum=SUM(gapweek826) /gapweek827_sum=SUM(gapweek827) /gapweek828_sum=SUM(gapweek828) 
 /gapweek829_sum=SUM(gapweek829) /gapweek830_sum=SUM(gapweek830) /gapweek831_sum=SUM(gapweek831) /gapweek832_sum=SUM(gapweek832) 
 /gapweek833_sum=SUM(gapweek833) /gapweek834_sum=SUM(gapweek834) /gapweek835_sum=SUM(gapweek835) /gapweek836_sum=SUM(gapweek836) 
 /gapweek837_sum=SUM(gapweek837) /gapweek838_sum=SUM(gapweek838) /gapweek839_sum=SUM(gapweek839) /gapweek840_sum=SUM(gapweek840) 
 /gapweek841_sum=SUM(gapweek841) /gapweek842_sum=SUM(gapweek842) /gapweek843_sum=SUM(gapweek843) /gapweek844_sum=SUM(gapweek844) 
 /gapweek845_sum=SUM(gapweek845) /gapweek846_sum=SUM(gapweek846) /gapweek847_sum=SUM(gapweek847) /gapweek848_sum=SUM(gapweek848) 
 /gapweek849_sum=SUM(gapweek849) /gapweek850_sum=SUM(gapweek850) /gapweek851_sum=SUM(gapweek851) /gapweek852_sum=SUM(gapweek852) 
 /gapweek853_sum=SUM(gapweek853) /gapweek854_sum=SUM(gapweek854) /gapweek855_sum=SUM(gapweek855) /gapweek856_sum=SUM(gapweek856) 
 /gapweek857_sum=SUM(gapweek857) /gapweek858_sum=SUM(gapweek858) /gapweek859_sum=SUM(gapweek859) /gapweek860_sum=SUM(gapweek860) 
 /gapweek861_sum=SUM(gapweek861) /gapweek862_sum=SUM(gapweek862) /gapweek863_sum=SUM(gapweek863) /gapweek864_sum=SUM(gapweek864) 
 /gapweek865_sum=SUM(gapweek865) /gapweek866_sum=SUM(gapweek866) /gapweek867_sum=SUM(gapweek867) /gapweek868_sum=SUM(gapweek868) 
 /gapweek869_sum=SUM(gapweek869) /gapweek870_sum=SUM(gapweek870) /gapweek871_sum=SUM(gapweek871) /gapweek872_sum=SUM(gapweek872) 
 /gapweek873_sum=SUM(gapweek873) /gapweek874_sum=SUM(gapweek874) /gapweek875_sum=SUM(gapweek875) /gapweek876_sum=SUM(gapweek876) 
 /gapweek877_sum=SUM(gapweek877) /gapweek878_sum=SUM(gapweek878) /gapweek879_sum=SUM(gapweek879) /gapweek880_sum=SUM(gapweek880) 
 /gapweek881_sum=SUM(gapweek881) /gapweek882_sum=SUM(gapweek882) /gapweek883_sum=SUM(gapweek883) /gapweek884_sum=SUM(gapweek884) 
 /gapweek885_sum=SUM(gapweek885) /gapweek886_sum=SUM(gapweek886) /gapweek887_sum=SUM(gapweek887) /gapweek888_sum=SUM(gapweek888) 
 /gapweek889_sum=SUM(gapweek889) /gapweek890_sum=SUM(gapweek890) /gapweek891_sum=SUM(gapweek891) /gapweek892_sum=SUM(gapweek892) 
 /gapweek893_sum=SUM(gapweek893) /gapweek894_sum=SUM(gapweek894) /gapweek895_sum=SUM(gapweek895) /gapweek896_sum=SUM(gapweek896) 
 /gapweek897_sum=SUM(gapweek897) /gapweek898_sum=SUM(gapweek898) /gapweek899_sum=SUM(gapweek899) /gapweek900_sum=SUM(gapweek900) 
 /gapweek901_sum=SUM(gapweek901) /gapweek902_sum=SUM(gapweek902) /gapweek903_sum=SUM(gapweek903) /gapweek904_sum=SUM(gapweek904) 
 /gapweek905_sum=SUM(gapweek905) /gapweek906_sum=SUM(gapweek906) /gapweek907_sum=SUM(gapweek907) /gapweek908_sum=SUM(gapweek908) 
 /gapweek909_sum=SUM(gapweek909) /gapweek910_sum=SUM(gapweek910) /gapweek911_sum=SUM(gapweek911) /gapweek912_sum=SUM(gapweek912) 
 /gapweek913_sum=SUM(gapweek913) /gapweek914_sum=SUM(gapweek914) /gapweek915_sum=SUM(gapweek915) /gapweek916_sum=SUM(gapweek916) 
 /gapweek917_sum=SUM(gapweek917) /gapweek918_sum=SUM(gapweek918) /gapweek919_sum=SUM(gapweek919) /gapweek920_sum=SUM(gapweek920) 
 /gapweek921_sum=SUM(gapweek921) /gapweek922_sum=SUM(gapweek922) /gapweek923_sum=SUM(gapweek923) /gapweek924_sum=SUM(gapweek924) 
 /gapweek925_sum=SUM(gapweek925) /gapweek926_sum=SUM(gapweek926) /gapweek927_sum=SUM(gapweek927) /gapweek928_sum=SUM(gapweek928) 
 /gapweek929_sum=SUM(gapweek929) /gapweek930_sum=SUM(gapweek930) /gapweek931_sum=SUM(gapweek931) /gapweek932_sum=SUM(gapweek932) 
 /gapweek933_sum=SUM(gapweek933) /gapweek934_sum=SUM(gapweek934) /gapweek935_sum=SUM(gapweek935) /gapweek936_sum=SUM(gapweek936) 
 /gapweek937_sum=SUM(gapweek937) /gapweek938_sum=SUM(gapweek938) /gapweek939_sum=SUM(gapweek939) /gapweek940_sum=SUM(gapweek940) 
 /gapweek941_sum=SUM(gapweek941) /gapweek942_sum=SUM(gapweek942) /gapweek943_sum=SUM(gapweek943) /gapweek944_sum=SUM(gapweek944) 
 /gapweek945_sum=SUM(gapweek945) /gapweek946_sum=SUM(gapweek946) /gapweek947_sum=SUM(gapweek947) /gapweek948_sum=SUM(gapweek948) 
 /gapweek949_sum=SUM(gapweek949) /gapweek950_sum=SUM(gapweek950) /gapweek951_sum=SUM(gapweek951) /gapweek952_sum=SUM(gapweek952) 
 /gapweek953_sum=SUM(gapweek953) /gapweek954_sum=SUM(gapweek954) /gapweek955_sum=SUM(gapweek955) /gapweek956_sum=SUM(gapweek956) 
 /gapweek957_sum=SUM(gapweek957) /gapweek958_sum=SUM(gapweek958) /gapweek959_sum=SUM(gapweek959) /gapweek960_sum=SUM(gapweek960) 
 /gapweek961_sum=SUM(gapweek961) /gapweek962_sum=SUM(gapweek962) /gapweek963_sum=SUM(gapweek963) /gapweek964_sum=SUM(gapweek964) 
 /gapweek965_sum=SUM(gapweek965) /gapweek966_sum=SUM(gapweek966) /gapweek967_sum=SUM(gapweek967) /gapweek968_sum=SUM(gapweek968) 
 /gapweek969_sum=SUM(gapweek969) /gapweek970_sum=SUM(gapweek970) /gapweek971_sum=SUM(gapweek971) /gapweek972_sum=SUM(gapweek972) 
 /gapweek973_sum=SUM(gapweek973) /gapweek974_sum=SUM(gapweek974) /gapweek975_sum=SUM(gapweek975) /gapweek976_sum=SUM(gapweek976) 
 /gapweek977_sum=SUM(gapweek977) /gapweek978_sum=SUM(gapweek978) /gapweek979_sum=SUM(gapweek979) /gapweek980_sum=SUM(gapweek980) 
 /gapweek981_sum=SUM(gapweek981) /gapweek982_sum=SUM(gapweek982) /gapweek983_sum=SUM(gapweek983) /gapweek984_sum=SUM(gapweek984) 
 /gapweek985_sum=SUM(gapweek985) /gapweek986_sum=SUM(gapweek986) /gapweek987_sum=SUM(gapweek987) /gapweek988_sum=SUM(gapweek988) 
 /gapweek989_sum=SUM(gapweek989) /gapweek990_sum=SUM(gapweek990) /gapweek991_sum=SUM(gapweek991) /gapweek992_sum=SUM(gapweek992) 
 /gapweek993_sum=SUM(gapweek993) /gapweek994_sum=SUM(gapweek994) /gapweek995_sum=SUM(gapweek995) /gapweek996_sum=SUM(gapweek996) 
 /gapweek997_sum=SUM(gapweek997) /gapweek998_sum=SUM(gapweek998) /gapweek999_sum=SUM(gapweek999) /gapweek1000_sum=SUM(gapweek1000) 
 /gapweek1001_sum=SUM(gapweek1001) /gapweek1002_sum=SUM(gapweek1002) /gapweek1003_sum=SUM(gapweek1003) /gapweek1004_sum=SUM(gapweek1004) 
 /gapweek1005_sum=SUM(gapweek1005) /gapweek1006_sum=SUM(gapweek1006) /gapweek1007_sum=SUM(gapweek1007) /gapweek1008_sum=SUM(gapweek1008) 
 /gapweek1009_sum=SUM(gapweek1009) /gapweek1010_sum=SUM(gapweek1010) /gapweek1011_sum=SUM(gapweek1011) /gapweek1012_sum=SUM(gapweek1012) 
 /gapweek1013_sum=SUM(gapweek1013) /gapweek1014_sum=SUM(gapweek1014) /gapweek1015_sum=SUM(gapweek1015) /gapweek1016_sum=SUM(gapweek1016) 
 /gapweek1017_sum=SUM(gapweek1017) /gapweek1018_sum=SUM(gapweek1018) /gapweek1019_sum=SUM(gapweek1019) /gapweek1020_sum=SUM(gapweek1020) 
 /gapweek1021_sum=SUM(gapweek1021) /gapweek1022_sum=SUM(gapweek1022) /gapweek1023_sum=SUM(gapweek1023) /gapweek1024_sum=SUM(gapweek1024) 
 /gapweek1025_sum=SUM(gapweek1025) /gapweek1026_sum=SUM(gapweek1026) /gapweek1027_sum=SUM(gapweek1027) /gapweek1028_sum=SUM(gapweek1028) 
 /gapweek1029_sum=SUM(gapweek1029) /gapweek1030_sum=SUM(gapweek1030) /gapweek1031_sum=SUM(gapweek1031) /gapweek1032_sum=SUM(gapweek1032) 
 /gapweek1033_sum=SUM(gapweek1033) /gapweek1034_sum=SUM(gapweek1034) /gapweek1035_sum=SUM(gapweek1035) /gapweek1036_sum=SUM(gapweek1036) 
 /gapweek1037_sum=SUM(gapweek1037) /gapweek1038_sum=SUM(gapweek1038) /gapweek1039_sum=SUM(gapweek1039) /gapweek1040_sum=SUM(gapweek1040) 
 /gapweek1041_sum=SUM(gapweek1041) /gapweek1042_sum=SUM(gapweek1042) /gapweek1043_sum=SUM(gapweek1043) /gapweek1044_sum=SUM(gapweek1044) 
 /gapweek1045_sum=SUM(gapweek1045) /gapweek1046_sum=SUM(gapweek1046) /gapweek1047_sum=SUM(gapweek1047) /gapweek1048_sum=SUM(gapweek1048) 
 /gapweek1049_sum=SUM(gapweek1049) /gapweek1050_sum=SUM(gapweek1050) /gapweek1051_sum=SUM(gapweek1051) /gapweek1052_sum=SUM(gapweek1052) 
 /gapweek1053_sum=SUM(gapweek1053) /gapweek1054_sum=SUM(gapweek1054) /gapweek1055_sum=SUM(gapweek1055) /gapweek1056_sum=SUM(gapweek1056) 
 /gapweek1057_sum=SUM(gapweek1057) /gapweek1058_sum=SUM(gapweek1058) /gapweek1059_sum=SUM(gapweek1059) /gapweek1060_sum=SUM(gapweek1060) 
 /gapweek1061_sum=SUM(gapweek1061) /gapweek1062_sum=SUM(gapweek1062) /gapweek1063_sum=SUM(gapweek1063) /gapweek1064_sum=SUM(gapweek1064) 
 /gapweek1065_sum=SUM(gapweek1065) /gapweek1066_sum=SUM(gapweek1066) /gapweek1067_sum=SUM(gapweek1067) /gapweek1068_sum=SUM(gapweek1068) 
 /gapweek1069_sum=SUM(gapweek1069) /gapweek1070_sum=SUM(gapweek1070) /gapweek1071_sum=SUM(gapweek1071) /gapweek1072_sum=SUM(gapweek1072) 
 /gapweek1073_sum=SUM(gapweek1073) /gapweek1074_sum=SUM(gapweek1074) /gapweek1075_sum=SUM(gapweek1075) /gapweek1076_sum=SUM(gapweek1076) 
 /gapweek1077_sum=SUM(gapweek1077) /gapweek1078_sum=SUM(gapweek1078) /gapweek1079_sum=SUM(gapweek1079) /gapweek1080_sum=SUM(gapweek1080) 
 /gapweek1081_sum=SUM(gapweek1081) /gapweek1082_sum=SUM(gapweek1082) /gapweek1083_sum=SUM(gapweek1083) /gapweek1084_sum=SUM(gapweek1084) 
 /gapweek1085_sum=SUM(gapweek1085) /gapweek1086_sum=SUM(gapweek1086) /gapweek1087_sum=SUM(gapweek1087) /gapweek1088_sum=SUM(gapweek1088) 
 /gapweek1089_sum=SUM(gapweek1089) /gapweek1090_sum=SUM(gapweek1090) /gapweek1091_sum=SUM(gapweek1091) /gapweek1092_sum=SUM(gapweek1092) 
 /gapweek1093_sum=SUM(gapweek1093) /gapweek1094_sum=SUM(gapweek1094) /gapweek1095_sum=SUM(gapweek1095) /gapweek1096_sum=SUM(gapweek1096) 
 /gapweek1097_sum=SUM(gapweek1097) /gapweek1098_sum=SUM(gapweek1098) /gapweek1099_sum=SUM(gapweek1099) /gapweek1100_sum=SUM(gapweek1100) 
 /gapweek1101_sum=SUM(gapweek1101) /gapweek1102_sum=SUM(gapweek1102) /gapweek1103_sum=SUM(gapweek1103) /gapweek1104_sum=SUM(gapweek1104) 
 /gapweek1105_sum=SUM(gapweek1105) /gapweek1106_sum=SUM(gapweek1106) /gapweek1107_sum=SUM(gapweek1107) /gapweek1108_sum=SUM(gapweek1108) 
 /gapweek1109_sum=SUM(gapweek1109) /gapweek1110_sum=SUM(gapweek1110) /gapweek1111_sum=SUM(gapweek1111) /gapweek1112_sum=SUM(gapweek1112) 
 /gapweek1113_sum=SUM(gapweek1113) /gapweek1114_sum=SUM(gapweek1114) /gapweek1115_sum=SUM(gapweek1115) /gapweek1116_sum=SUM(gapweek1116) 
 /gapweek1117_sum=SUM(gapweek1117) /gapweek1118_sum=SUM(gapweek1118) /gapweek1119_sum=SUM(gapweek1119) /gapweek1120_sum=SUM(gapweek1120) 
 /gapweek1121_sum=SUM(gapweek1121) /gapweek1122_sum=SUM(gapweek1122) /gapweek1123_sum=SUM(gapweek1123) /gapweek1124_sum=SUM(gapweek1124) 
 /gapweek1125_sum=SUM(gapweek1125) /gapweek1126_sum=SUM(gapweek1126) /gapweek1127_sum=SUM(gapweek1127) /gapweek1128_sum=SUM(gapweek1128) 
 /gapweek1129_sum=SUM(gapweek1129) /gapweek1130_sum=SUM(gapweek1130) /gapweek1131_sum=SUM(gapweek1131) /gapweek1132_sum=SUM(gapweek1132) 
 /gapweek1133_sum=SUM(gapweek1133) /gapweek1134_sum=SUM(gapweek1134) /gapweek1135_sum=SUM(gapweek1135) /gapweek1136_sum=SUM(gapweek1136) 
 /gapweek1137_sum=SUM(gapweek1137) /gapweek1138_sum=SUM(gapweek1138) /gapweek1139_sum=SUM(gapweek1139) /gapweek1140_sum=SUM(gapweek1140) 
 /gapweek1141_sum=SUM(gapweek1141) /gapweek1142_sum=SUM(gapweek1142) /gapweek1143_sum=SUM(gapweek1143) /gapweek1144_sum=SUM(gapweek1144) 
 /gapweek1145_sum=SUM(gapweek1145) /gapweek1146_sum=SUM(gapweek1146) /gapweek1147_sum=SUM(gapweek1147) /gapweek1148_sum=SUM(gapweek1148) 
 /gapweek1149_sum=SUM(gapweek1149) /gapweek1150_sum=SUM(gapweek1150) /gapweek1151_sum=SUM(gapweek1151) /gapweek1152_sum=SUM(gapweek1152) 
 /gapweek1153_sum=SUM(gapweek1153) /gapweek1154_sum=SUM(gapweek1154) /gapweek1155_sum=SUM(gapweek1155) /gapweek1156_sum=SUM(gapweek1156) 
 /gapweek1157_sum=SUM(gapweek1157) /gapweek1158_sum=SUM(gapweek1158) /gapweek1159_sum=SUM(gapweek1159) /gapweek1160_sum=SUM(gapweek1160) 
 /gapweek1161_sum=SUM(gapweek1161) /gapweek1162_sum=SUM(gapweek1162) /gapweek1163_sum=SUM(gapweek1163) /gapweek1164_sum=SUM(gapweek1164) 
 /gapweek1165_sum=SUM(gapweek1165) /gapweek1166_sum=SUM(gapweek1166) /gapweek1167_sum=SUM(gapweek1167) /gapweek1168_sum=SUM(gapweek1168) 
 /gapweek1169_sum=SUM(gapweek1169) /gapweek1170_sum=SUM(gapweek1170) /gapweek1171_sum=SUM(gapweek1171) /gapweek1172_sum=SUM(gapweek1172) 
 /gapweek1173_sum=SUM(gapweek1173) /gapweek1174_sum=SUM(gapweek1174) /gapweek1175_sum=SUM(gapweek1175) /gapweek1176_sum=SUM(gapweek1176) 
 /gapweek1177_sum=SUM(gapweek1177) /gapweek1178_sum=SUM(gapweek1178) /gapweek1179_sum=SUM(gapweek1179) /gapweek1180_sum=SUM(gapweek1180) 
 /gapweek1181_sum=SUM(gapweek1181) /gapweek1182_sum=SUM(gapweek1182) /gapweek1183_sum=SUM(gapweek1183) /gapweek1184_sum=SUM(gapweek1184) 
 /gapweek1185_sum=SUM(gapweek1185) /gapweek1186_sum=SUM(gapweek1186) /gapweek1187_sum=SUM(gapweek1187) /gapweek1188_sum=SUM(gapweek1188) 
 /gapweek1189_sum=SUM(gapweek1189) /gapweek1190_sum=SUM(gapweek1190) /gapweek1191_sum=SUM(gapweek1191) /gapweek1192_sum=SUM(gapweek1192) 
 /gapweek1193_sum=SUM(gapweek1193) /gapweek1194_sum=SUM(gapweek1194) /gapweek1195_sum=SUM(gapweek1195) /gapweek1196_sum=SUM(gapweek1196) 
 /gapweek1197_sum=SUM(gapweek1197) /gapweek1198_sum=SUM(gapweek1198) /gapweek1199_sum=SUM(gapweek1199) /gapweek1200_sum=SUM(gapweek1200) 
 /gapweek1201_sum=SUM(gapweek1201) /gapweek1202_sum=SUM(gapweek1202) /gapweek1203_sum=SUM(gapweek1203) /gapweek1204_sum=SUM(gapweek1204) 
 /gapweek1205_sum=SUM(gapweek1205) /gapweek1206_sum=SUM(gapweek1206) /gapweek1207_sum=SUM(gapweek1207) /gapweek1208_sum=SUM(gapweek1208) 
 /gapweek1209_sum=SUM(gapweek1209) /gapweek1210_sum=SUM(gapweek1210) /gapweek1211_sum=SUM(gapweek1211) /gapweek1212_sum=SUM(gapweek1212) 
 /gapweek1213_sum=SUM(gapweek1213) /gapweek1214_sum=SUM(gapweek1214) /gapweek1215_sum=SUM(gapweek1215) /gapweek1216_sum=SUM(gapweek1216) 
 /gapweek1217_sum=SUM(gapweek1217) /gapweek1218_sum=SUM(gapweek1218) /gapweek1219_sum=SUM(gapweek1219) /gapweek1220_sum=SUM(gapweek1220) 
 /gapweek1221_sum=SUM(gapweek1221) /gapweek1222_sum=SUM(gapweek1222) /gapweek1223_sum=SUM(gapweek1223) /gapweek1224_sum=SUM(gapweek1224) 
 /gapweek1225_sum=SUM(gapweek1225) /gapweek1226_sum=SUM(gapweek1226) /gapweek1227_sum=SUM(gapweek1227) /gapweek1228_sum=SUM(gapweek1228) 
 /gapweek1229_sum=SUM(gapweek1229) /gapweek1230_sum=SUM(gapweek1230) /gapweek1231_sum=SUM(gapweek1231) /gapweek1232_sum=SUM(gapweek1232) 
 /gapweek1233_sum=SUM(gapweek1233) /gapweek1234_sum=SUM(gapweek1234) /gapweek1235_sum=SUM(gapweek1235) /gapweek1236_sum=SUM(gapweek1236) 
 /gapweek1237_sum=SUM(gapweek1237) /gapweek1238_sum=SUM(gapweek1238) /gapweek1239_sum=SUM(gapweek1239) /gapweek1240_sum=SUM(gapweek1240) 
 /gapweek1241_sum=SUM(gapweek1241) /gapweek1242_sum=SUM(gapweek1242) /gapweek1243_sum=SUM(gapweek1243) /gapweek1244_sum=SUM(gapweek1244) 
 /gapweek1245_sum=SUM(gapweek1245) /gapweek1246_sum=SUM(gapweek1246) /gapweek1247_sum=SUM(gapweek1247) /gapweek1248_sum=SUM(gapweek1248) 
 /gapweek1249_sum=SUM(gapweek1249) /gapweek1250_sum=SUM(gapweek1250) /gapweek1251_sum=SUM(gapweek1251) /gapweek1252_sum=SUM(gapweek1252) 
 /gapweek1253_sum=SUM(gapweek1253) /gapweek1254_sum=SUM(gapweek1254) /gapweek1255_sum=SUM(gapweek1255) /gapweek1256_sum=SUM(gapweek1256) 
 /gapweek1257_sum=SUM(gapweek1257) /gapweek1258_sum=SUM(gapweek1258) /gapweek1259_sum=SUM(gapweek1259) /gapweek1260_sum=SUM(gapweek1260) 
 /gapweek1261_sum=SUM(gapweek1261) /gapweek1262_sum=SUM(gapweek1262) /gapweek1263_sum=SUM(gapweek1263) /gapweek1264_sum=SUM(gapweek1264) 
 /gapweek1265_sum=SUM(gapweek1265) /gapweek1266_sum=SUM(gapweek1266) /gapweek1267_sum=SUM(gapweek1267) /gapweek1268_sum=SUM(gapweek1268) 
 /gapweek1269_sum=SUM(gapweek1269) /gapweek1270_sum=SUM(gapweek1270) /gapweek1271_sum=SUM(gapweek1271) /gapweek1272_sum=SUM(gapweek1272) 
 /gapweek1273_sum=SUM(gapweek1273) /gapweek1274_sum=SUM(gapweek1274) /gapweek1275_sum=SUM(gapweek1275) /gapweek1276_sum=SUM(gapweek1276) 
 /gapweek1277_sum=SUM(gapweek1277) /gapweek1278_sum=SUM(gapweek1278) /gapweek1279_sum=SUM(gapweek1279) /gapweek1280_sum=SUM(gapweek1280) 
 /gapweek1281_sum=SUM(gapweek1281) /gapweek1282_sum=SUM(gapweek1282) /gapweek1283_sum=SUM(gapweek1283) /gapweek1284_sum=SUM(gapweek1284) 
 /gapweek1285_sum=SUM(gapweek1285) /gapweek1286_sum=SUM(gapweek1286) /gapweek1287_sum=SUM(gapweek1287) /gapweek1288_sum=SUM(gapweek1288) 
 /gapweek1289_sum=SUM(gapweek1289) /gapweek1290_sum=SUM(gapweek1290) /gapweek1291_sum=SUM(gapweek1291) /gapweek1292_sum=SUM(gapweek1292) 
 /gapweek1293_sum=SUM(gapweek1293) /gapweek1294_sum=SUM(gapweek1294) /gapweek1295_sum=SUM(gapweek1295) /gapweek1296_sum=SUM(gapweek1296) 
 /gapweek1297_sum=SUM(gapweek1297) /gapweek1298_sum=SUM(gapweek1298) /gapweek1299_sum=SUM(gapweek1299) /gapweek1300_sum=SUM(gapweek1300) 
 /gapweek1301_sum=SUM(gapweek1301) /gapweek1302_sum=SUM(gapweek1302) /gapweek1303_sum=SUM(gapweek1303) /gapweek1304_sum=SUM(gapweek1304) 
 /gapweek1305_sum=SUM(gapweek1305) /gapweek1306_sum=SUM(gapweek1306) /gapweek1307_sum=SUM(gapweek1307) /gapweek1308_sum=SUM(gapweek1308) 
 /gapweek1309_sum=SUM(gapweek1309) /gapweek1310_sum=SUM(gapweek1310) /gapweek1311_sum=SUM(gapweek1311) /gapweek1312_sum=SUM(gapweek1312) 
 /gapweek1313_sum=SUM(gapweek1313) /gapweek1314_sum=SUM(gapweek1314) /gapweek1315_sum=SUM(gapweek1315) /gapweek1316_sum=SUM(gapweek1316) 
 /gapweek1317_sum=SUM(gapweek1317) /gapweek1318_sum=SUM(gapweek1318) /gapweek1319_sum=SUM(gapweek1319) /gapweek1320_sum=SUM(gapweek1320) 
 /gapweek1321_sum=SUM(gapweek1321) /gapweek1322_sum=SUM(gapweek1322) /gapweek1323_sum=SUM(gapweek1323) /gapweek1324_sum=SUM(gapweek1324) 
 /gapweek1325_sum=SUM(gapweek1325) /gapweek1326_sum=SUM(gapweek1326) /gapweek1327_sum=SUM(gapweek1327) /gapweek1328_sum=SUM(gapweek1328) 
 /gapweek1329_sum=SUM(gapweek1329) /gapweek1330_sum=SUM(gapweek1330) /gapweek1331_sum=SUM(gapweek1331) /gapweek1332_sum=SUM(gapweek1332) 
 /gapweek1333_sum=SUM(gapweek1333) /gapweek1334_sum=SUM(gapweek1334) /gapweek1335_sum=SUM(gapweek1335) /gapweek1336_sum=SUM(gapweek1336) 
 /gapweek1337_sum=SUM(gapweek1337) /gapweek1338_sum=SUM(gapweek1338) /gapweek1339_sum=SUM(gapweek1339) /gapweek1340_sum=SUM(gapweek1340) 
 /gapweek1341_sum=SUM(gapweek1341) /gapweek1342_sum=SUM(gapweek1342) /gapweek1343_sum=SUM(gapweek1343) /gapweek1344_sum=SUM(gapweek1344) 
 /gapweek1345_sum=SUM(gapweek1345) /gapweek1346_sum=SUM(gapweek1346) /gapweek1347_sum=SUM(gapweek1347) /gapweek1348_sum=SUM(gapweek1348) 
 /gapweek1349_sum=SUM(gapweek1349) /gapweek1350_sum=SUM(gapweek1350) /gapweek1351_sum=SUM(gapweek1351) /gapweek1352_sum=SUM(gapweek1352) 
 /gapweek1353_sum=SUM(gapweek1353) /gapweek1354_sum=SUM(gapweek1354) /gapweek1355_sum=SUM(gapweek1355) /gapweek1356_sum=SUM(gapweek1356) 
 /gapweek1357_sum=SUM(gapweek1357) /gapweek1358_sum=SUM(gapweek1358) /gapweek1359_sum=SUM(gapweek1359) /gapweek1360_sum=SUM(gapweek1360) 
 /gapweek1361_sum=SUM(gapweek1361) /gapweek1362_sum=SUM(gapweek1362) /gapweek1363_sum=SUM(gapweek1363) /gapweek1364_sum=SUM(gapweek1364) 
 /gapweek1365_sum=SUM(gapweek1365) /gapweek1366_sum=SUM(gapweek1366) /gapweek1367_sum=SUM(gapweek1367) /gapweek1368_sum=SUM(gapweek1368) 
 /gapweek1369_sum=SUM(gapweek1369) /gapweek1370_sum=SUM(gapweek1370) /gapweek1371_sum=SUM(gapweek1371) /gapweek1372_sum=SUM(gapweek1372) 
 /gapweek1373_sum=SUM(gapweek1373) /gapweek1374_sum=SUM(gapweek1374) /gapweek1375_sum=SUM(gapweek1375) /gapweek1376_sum=SUM(gapweek1376) 
 /gapweek1377_sum=SUM(gapweek1377) /gapweek1378_sum=SUM(gapweek1378) /gapweek1379_sum=SUM(gapweek1379) /gapweek1380_sum=SUM(gapweek1380) 
 /gapweek1381_sum=SUM(gapweek1381) /gapweek1382_sum=SUM(gapweek1382) /gapweek1383_sum=SUM(gapweek1383) /gapweek1384_sum=SUM(gapweek1384) 
 /gapweek1385_sum=SUM(gapweek1385) /gapweek1386_sum=SUM(gapweek1386) /gapweek1387_sum=SUM(gapweek1387) 
 /GAPTERM1_sum=SUM(GAPTERM1) /GAPTERM2_sum=SUM(GAPTERM2) /GAPTERM3_sum=SUM(GAPTERM3) /GAPTERM4_sum=SUM(GAPTERM4) /GAPTERM5_sum=SUM(GAPTERM5) 
 /GAPTERM6_sum=SUM(GAPTERM6) /GAPTERM7_sum=SUM(GAPTERM7) /GAPTERM8_sum=SUM(GAPTERM8) /GAPTERM9_sum=SUM(GAPTERM9) /GAPTERM10_sum=SUM(GAPTERM10) 
 /GAPTERM11_sum=SUM(GAPTERM11) /GAPTERM12_sum=SUM(GAPTERM12) /GAPTERM13_sum=SUM(GAPTERM13) /GAPTERM14_sum=SUM(GAPTERM14) 
 /GAPTERM15_sum=SUM(GAPTERM15) /GAPTERM16_sum=SUM(GAPTERM16) /GAPTERM17_sum=SUM(GAPTERM17) /GAPTERM18_sum=SUM(GAPTERM18) 
 /GAPTERM19_sum=SUM(GAPTERM19) /GAPTERM20_sum=SUM(GAPTERM20) /GAPTERM21_sum=SUM(GAPTERM21) /GAPTERM22_sum=SUM(GAPTERM22) 
 /GAPTERM23_sum=SUM(GAPTERM23) /GAPTERM24_sum=SUM(GAPTERM24) /GAPTERM25_sum=SUM(GAPTERM25) /GAPTERM26_sum=SUM(GAPTERM26) 
 /GAPTERM27_sum=SUM(GAPTERM27) /UNSPECGAP1_sum=SUM(UNSPECGAP1) /UNSPECGAP2_sum=SUM(UNSPECGAP2) /UNSPECGAP3_sum=SUM(UNSPECGAP3) 
 /UNSPECGAP4_sum=SUM(UNSPECGAP4) /UNSPECGAP5_sum=SUM(UNSPECGAP5) /UNSPECGAP6_sum=SUM(UNSPECGAP6) /UNSPECGAP7_sum=SUM(UNSPECGAP7) 
 /UNSPECGAP8_sum=SUM(UNSPECGAP8) /UNSPECGAP9_sum=SUM(UNSPECGAP9) /UNSPECGAP10_sum=SUM(UNSPECGAP10) /UNSPECGAP11_sum=SUM(UNSPECGAP11) 
 /UNSPECGAP12_sum=SUM(UNSPECGAP12) /UNSPECGAP13_sum=SUM(UNSPECGAP13) /UNSPECGAP14_sum=SUM(UNSPECGAP14) /UNSPECGAP15_sum=SUM(UNSPECGAP15) 
 /UNSPECGAP16_sum=SUM(UNSPECGAP16) /UNSPECGAP17_sum=SUM(UNSPECGAP17) /UNSPECGAP18_sum=SUM(UNSPECGAP18) /UNSPECGAP19_sum=SUM(UNSPECGAP19) 
 /UNSPECGAP20_sum=SUM(UNSPECGAP20) /UNSPECGAP21_sum=SUM(UNSPECGAP21) /UNSPECGAP22_sum=SUM(UNSPECGAP22) /UNSPECGAP23_sum=SUM(UNSPECGAP23) 
 /UNSPECGAP24_sum=SUM(UNSPECGAP24) /UNSPECGAP25_sum=SUM(UNSPECGAP25) /UNSPECGAP26_sum=SUM(UNSPECGAP26) /UNSPECGAP27_sum=SUM(UNSPECGAP27) 
 /UNSPECGAP00_sum=SUM(UNSPECGAP00) /N_BREAK=N.

GET FILE='D:\NLSY97_Kopyckaetal\Jobgaps_perjob.sav'.
DATASET NAME Jobgaps_perjob.
DATASET CLOSE Jobgaps_long.

* Create yearly number of confirmed gap weeks

DATASET ACTIVATE Jobgaps_perjob.
do repeat a=gapweek1_SUM to gapweek1387_SUM / b=gapweek1 to gapweek1387.
compute b=0.
if a>=1 b=1.
end repeat.
formats gapweek1 to gapweek1387 (F2.0).
EXECUTE.

do repeat a=gapweeks1 to gapweeks27 / b=gapweek1 gapweek54 gapweek106 gapweek158 gapweek210 gapweek262 gapweek314 gapweek367 gapweek419 gapweek471
gapweek523 gapweek575 gapweek628 gapweek680 gapweek732 gapweek784 gapweek836 gapweek888 gapweek941 gapweek993 gapweek1045 gapweek1097 gapweek1149
gapweek1202 gapweek1254 gapweek1306 gapweek1358 / c= gapweek53 gapweek105 gapweek157 gapweek209 gapweek261 gapweek313 gapweek366 gapweek418
gapweek470 gapweek522 gapweek574 gapweek627 gapweek679 gapweek731 gapweek783 gapweek835 gapweek887 gapweek940 gapweek992 gapweek1044
gapweek1096 gapweek1148 gapweek1201 gapweek1253 gapweek1305 gapweek1357 gapweek1387.
compute a=sum (b to c).
end repeat.
formats gapweeks1 to gapweeks27 (F2.0).
EXECUTE. 
del vars gapweek1 to gapweek1387.

* Flag months with possible (but uncertain) gaps
 
do repeat a=gapweek1_SUM to gapweek1387_SUM / b=gapweek1 to gapweek1387.
compute b=0.
if a>0 and a<1 b=1.
end repeat.
formats gapweek1 to gapweek1387 (F2.0).
EXECUTE.

do repeat a=maybegap1 to maybegap320
/b= gapweek1 gapweek5 gapweek9 gapweek14 gapweek18 gapweek22 gapweek27 gapweek31 gapweek36 gapweek40 gapweek44 gapweek49 gapweek53
gapweek57 gapweek61 gapweek66 gapweek70 gapweek75 gapweek79 gapweek83 gapweek88 gapweek92 gapweek96 gapweek101 gapweek105 gapweek110
gapweek114 gapweek118 gapweek122 gapweek127 gapweek131 gapweek136 gapweek140 gapweek144 gapweek149 gapweek153 gapweek157 gapweek162 gapweek166
gapweek170 gapweek175 gapweek179 gapweek183 gapweek188 gapweek192 gapweek196 gapweek201 gapweek205 gapweek210 gapweek214 gapweek218 gapweek222
gapweek227 gapweek231 gapweek235 gapweek240 gapweek244 gapweek249 gapweek253 gapweek257 gapweek262 gapweek266 gapweek270 gapweek275 gapweek279
gapweek283 gapweek288 gapweek292 gapweek296 gapweek301 gapweek305 gapweek309 gapweek314 gapweek318 gapweek322 gapweek327 gapweek331 gapweek336
gapweek340 gapweek344 gapweek349 gapweek353 gapweek357 gapweek362 gapweek365 gapweek370 gapweek374 gapweek378 gapweek382 gapweek387 gapweek391
gapweek395 gapweek400 gapweek404 gapweek409 gapweek413 gapweek417 gapweek422 gapweek426 gapweek430 gapweek434 gapweek439 gapweek443 gapweek448
gapweek452 gapweek456 gapweek461 gapweek465 gapweek469 gapweek474 gapweek478 gapweek482 gapweek487 gapweek491 gapweek495 gapweek500 gapweek504
gapweek508 gapweek513 gapweek517 gapweek522 gapweek526 gapweek530 gapweek535 gapweek539 gapweek543 gapweek548 gapweek552 gapweek556 gapweek561
gapweek565 gapweek569 gapweek574 gapweek578 gapweek582 gapweek587 gapweek591 gapweek595 gapweek600 gapweek604 gapweek609 gapweek613 gapweek617
gapweek622 gapweek625 gapweek629 gapweek633 gapweek638 gapweek642 gapweek647 gapweek651 gapweek655 gapweek660 gapweek664 gapweek668 gapweek673
gapweek677 gapweek682 gapweek686 gapweek690 gapweek694 gapweek699 gapweek703 gapweek707 gapweek712 gapweek716 gapweek721 gapweek725 gapweek729
gapweek734 gapweek738 gapweek742 gapweek747 gapweek751 gapweek755 gapweek760 gapweek764 gapweek768 gapweek773 gapweek777 gapweek782 gapweek786
gapweek790 gapweek794 gapweek799 gapweek803 gapweek807 gapweek812 gapweek816 gapweek821 gapweek825 gapweek829 gapweek834 gapweek838 gapweek842
gapweek847 gapweek851 gapweek855 gapweek860 gapweek864 gapweek868 gapweek873 gapweek877 gapweek881 gapweek886 gapweek890 gapweek894 gapweek899
gapweek903 gapweek907 gapweek912 gapweek916 gapweek921 gapweek925 gapweek929 gapweek934 gapweek937 gapweek942 gapweek946 gapweek950 gapweek955
gapweek959 gapweek963 gapweek968 gapweek972 gapweek977 gapweek981 gapweek985 gapweek990 gapweek994 gapweek998 gapweek1003 gapweek1007 gapweek1011
gapweek1016 gapweek1020 gapweek1024 gapweek1029 gapweek1033 gapweek1037 gapweek1042 gapweek1046 gapweek1050 gapweek1055 gapweek1059 gapweek1063 gapweek1068
gapweek1072 gapweek1077 gapweek1081 gapweek1085 gapweek1090 gapweek1094 gapweek1098 gapweek1102 gapweek1107 gapweek1111 gapweek1116 gapweek1120 gapweek1124
gapweek1129 gapweek1133 gapweek1137 gapweek1142 gapweek1146 gapweek1151 gapweek1155 gapweek1159 gapweek1163 gapweek1168 gapweek1172 gapweek1177 gapweek1181
gapweek1185 gapweek1190 gapweek1194 gapweek1197 gapweek1202 gapweek1206 gapweek1210 gapweek1215 gapweek1219 gapweek1223 gapweek1228 gapweek1232 gapweek1236
gapweek1241 gapweek1245 gapweek1250 gapweek1254 gapweek1258 gapweek1262 gapweek1267 gapweek1271 gapweek1275 gapweek1280 gapweek1284 gapweek1289 gapweek1293
gapweek1297 gapweek1302 gapweek1306 gapweek1310 gapweek1315 gapweek1319 gapweek1323 gapweek1328 gapweek1332 gapweek1336 gapweek1341 gapweek1345 gapweek1349
gapweek1354 gapweek1358 gapweek1362 gapweek1367 gapweek1371 gapweek1376 gapweek1380 gapweek1383 
/ c= gapweek4 gapweek8 gapweek13 gapweek17 gapweek21 gapweek26 gapweek30 gapweek35 gapweek39 gapweek43 gapweek48 gapweek52 gapweek56
gapweek60 gapweek65 gapweek69 gapweek74 gapweek78 gapweek82 gapweek87 gapweek91 gapweek95 gapweek100 gapweek104 gapweek109 gapweek113
gapweek117 gapweek121 gapweek126 gapweek130 gapweek135 gapweek139 gapweek143 gapweek148 gapweek152 gapweek156 gapweek161 gapweek165 gapweek169
gapweek174 gapweek178 gapweek182 gapweek187 gapweek191 gapweek195 gapweek200 gapweek204 gapweek209 gapweek213 gapweek217 gapweek221 gapweek226
gapweek230 gapweek234 gapweek239 gapweek243 gapweek248 gapweek252 gapweek256 gapweek261 gapweek265 gapweek269 gapweek274 gapweek278 gapweek282
gapweek287 gapweek291 gapweek295 gapweek300 gapweek304 gapweek308 gapweek313 gapweek317 gapweek321 gapweek326 gapweek330 gapweek335 gapweek339
gapweek343 gapweek348 gapweek352 gapweek356 gapweek361 gapweek364 gapweek369 gapweek373 gapweek377 gapweek381 gapweek386 gapweek390 gapweek394
gapweek399 gapweek403 gapweek408 gapweek412 gapweek416 gapweek421 gapweek425 gapweek429 gapweek433 gapweek438 gapweek442 gapweek447 gapweek451
gapweek455 gapweek460 gapweek464 gapweek468 gapweek473 gapweek477 gapweek481 gapweek486 gapweek490 gapweek494 gapweek499 gapweek503 gapweek507
gapweek512 gapweek516 gapweek521 gapweek525 gapweek529 gapweek534 gapweek538 gapweek542 gapweek547 gapweek551 gapweek555 gapweek560 gapweek564
gapweek568 gapweek573 gapweek577 gapweek581 gapweek586 gapweek590 gapweek594 gapweek599 gapweek603 gapweek608 gapweek612 gapweek616 gapweek621
gapweek624 gapweek628 gapweek632 gapweek637 gapweek641 gapweek646 gapweek650 gapweek654 gapweek659 gapweek663 gapweek667 gapweek672 gapweek676
gapweek681 gapweek685 gapweek689 gapweek693 gapweek698 gapweek702 gapweek706 gapweek711 gapweek715 gapweek720 gapweek724 gapweek728 gapweek733
gapweek737 gapweek741 gapweek746 gapweek750 gapweek754 gapweek759 gapweek763 gapweek767 gapweek772 gapweek776 gapweek781 gapweek785 gapweek789
gapweek793 gapweek798 gapweek802 gapweek806 gapweek811 gapweek815 gapweek820 gapweek824 gapweek828 gapweek833 gapweek837 gapweek841 gapweek846
gapweek850 gapweek854 gapweek859 gapweek863 gapweek867 gapweek872 gapweek876 gapweek880 gapweek885 gapweek889 gapweek893 gapweek898 gapweek902
gapweek906 gapweek911 gapweek915 gapweek920 gapweek924 gapweek928 gapweek933 gapweek936 gapweek941 gapweek945 gapweek949 gapweek954 gapweek958
gapweek962 gapweek967 gapweek971 gapweek976 gapweek980 gapweek984 gapweek989 gapweek993 gapweek997 gapweek1002 gapweek1006 gapweek1010 gapweek1015
gapweek1019 gapweek1023 gapweek1028 gapweek1032 gapweek1036 gapweek1041 gapweek1045 gapweek1049 gapweek1054 gapweek1058 gapweek1062 gapweek1067 gapweek1071
gapweek1076 gapweek1080 gapweek1084 gapweek1089 gapweek1093 gapweek1097 gapweek1101 gapweek1106 gapweek1110 gapweek1115 gapweek1119 gapweek1123 gapweek1128
gapweek1132 gapweek1136 gapweek1141 gapweek1145 gapweek1150 gapweek1154 gapweek1158 gapweek1162 gapweek1167 gapweek1171 gapweek1176 gapweek1180 gapweek1184
gapweek1189 gapweek1193 gapweek1196 gapweek1201 gapweek1205 gapweek1209 gapweek1214 gapweek1218 gapweek1222 gapweek1227 gapweek1231 gapweek1235 gapweek1240
gapweek1244 gapweek1249 gapweek1253 gapweek1257 gapweek1261 gapweek1266 gapweek1270 gapweek1274 gapweek1279 gapweek1283 gapweek1288 gapweek1292 gapweek1296
gapweek1301 gapweek1305 gapweek1309 gapweek1314 gapweek1318 gapweek1322 gapweek1327 gapweek1331 gapweek1335 gapweek1340 gapweek1344 gapweek1348 gapweek1353
gapweek1357 gapweek1361 gapweek1366 gapweek1370 gapweek1375 gapweek1379 gapweek1382 gapweek1387.
compute a=sum (b to c).
end repeat.
compute maybegap321=0.
compute maybegap322=0.
compute maybegap323=0.
compute maybegap324=0.
formats maybegap1 to maybegap324 (F2.0).
EXECUTE.
del vars gapweek1 to gapweek1387.
EXECUTE.

SAVE OUTFILE='D:\NLSY97_Kopyckaetal\Jobgaps_perjob.sav'
 /COMPRESSED.

************************************************************ STEP 4. MERGING FILES & CALCULATING NUMBER OF TERMINATIONS PER JOB PER YEAR

sort cases by RWJID.
DATASET ACTIVATE jobdata.
* Create respondent - wave - job ID.
compute RWJID=R0000100*1000000+WavejobID.
formats RWJID (F10.0).
EXECUTE.
SORT CASES by RWJID.

MATCH FILES /FILE=*
 /FILE='Jobgaps_perjob'
 /BY RWJID
 /KEEP=R0000100 Monthround1 to Monthround19 Wave Round WavejobID RWJID jobtype UID compensation hoursweek paidleave medins retiremnt JobStat_m1 to JobStat_m324
 gapweeks1 to gapweeks27 maybegap1 to maybegap324 GAPTERM1_sum to GAPTERM27_sum UNSPECGAP1_sum to UNSPECGAP27_sum.
EXECUTE.

SAVE OUTFILE='D:\NLSY97_Kopyckaetal\Jobdata_long.sav'
 /COMPRESSED.
DATASET CLOSE jobgaps_perjob.

* Restructure to longer format (years); units are person-job-years; file name: Jobdata_yearlong.sav
* variables: monthly (job) data status MDS; total weeks of within-job gaps per year; flag for possible within-job gaps with unknown duration
number of additional job terminations coded in source data as within-job gaps
number of within-job gaps whose status as job terminations cannot be te determined due to missing information on duration.
* No possible terminations due to gaps whose status as terminations could not be established (UNSPECGAP00_sum not kept in file).

rename vars (JobStat_m1 to JobStat_m324 = M1 to M324).
rename vars (maybegap1 to maybegap324 = G1 to G324).
VARSTOCASES
 /make MDS1 from M1 M13 M25 M37 M49 M61 M73 M85 M97 M109 M121 M133 M145 M157 M169 M181 M193 M205 M217 M229 M241 M253 M265 M277 M289 M301 M313
 /make MDS2 from M2 M14 M26 M38 M50 M62 M74 M86 M98 M110 M122 M134 M146 M158 M170 M182 M194 M206 M218 M230 M242 M254 M266 M278 M290 M302 M314
 /make MDS3 from M3 M15 M27 M39 M51 M63 M75 M87 M99 M111 M123 M135 M147 M159 M171 M183 M195 M207 M219 M231 M243 M255 M267 M279 M291 M303 M315
 /make MDS4 from M4 M16 M28 M40 M52 M64 M76 M88 M100 M112 M124 M136 M148 M160 M172 M184 M196 M208 M220 M232 M244 M256 M268 M280 M292 M304 M316
 /make MDS5 from M5 M17 M29 M41 M53 M65 M77 M89 M101 M113 M125 M137 M149 M161 M173 M185 M197 M209 M221 M233 M245 M257 M269 M281 M293 M305 M317
 /make MDS6 from M6 M18 M30 M42 M54 M66 M78 M90 M102 M114 M126 M138 M150 M162 M174 M186 M198 M210 M222 M234 M246 M258 M270 M282 M294 M306 M318
 /make MDS7 from M7 M19 M31 M43 M55 M67 M79 M91 M103 M115 M127 M139 M151 M163 M175 M187 M199 M211 M223 M235 M247 M259 M271 M283 M295 M307 M319
 /make MDS8 from M8 M20 M32 M44 M56 M68 M80 M92 M104 M116 M128 M140 M152 M164 M176 M188 M200 M212 M224 M236 M248 M260 M272 M284 M296 M308 M320
 /make MDS9 from M9 M21 M33 M45 M57 M69 M81 M93 M105 M117 M129 M141 M153 M165 M177 M189 M201 M213 M225 M237 M249 M261 M273 M285 M297 M309 M321
 /make MDS10 from M10 M22 M34 M46 M58 M70 M82 M94 M106 M118 M130 M142 M154 M166 M178 M190 M202 M214 M226 M238 M250 M262 M274 M286 M298 M310 M322
 /make MDS11 from M11 M23 M35 M47 M59 M71 M83 M95 M107 M119 M131 M143 M155 M167 M179 M191 M203 M215 M227 M239 M251 M263 M275 M287 M299 M311 M323
 /make MDS12 from M12 M24 M36 M48 M60 M72 M84 M96 M108 M120 M132 M144 M156 M168 M180 M192 M204 M216 M228 M240 M252 M264 M276 M288 M300 M312 M324
 /make GMD1 from G1 G13 G25 G37 G49 G61 G73 G85 G97 G109 G121 G133 G145 G157 G169 G181 G193 G205 G217 G229 G241 G253 G265 G277 G289 G301 G313
 /make GMD2 from G2 G14 G26 G38 G50 G62 G74 G86 G98 G110 G122 G134 G146 G158 G170 G182 G194 G206 G218 G230 G242 G254 G266 G278 G290 G302 G314
 /make GMD3 from G3 G15 G27 G39 G51 G63 G75 G87 G99 G111 G123 G135 G147 G159 G171 G183 G195 G207 G219 G231 G243 G255 G267 G279 G291 G303 G315
 /make GMD4 from G4 G16 G28 G40 G52 G64 G76 G88 G100 G112 G124 G136 G148 G160 G172 G184 G196 G208 G220 G232 G244 G256 G268 G280 G292 G304 G316
 /make GMD5 from G5 G17 G29 G41 G53 G65 G77 G89 G101 G113 G125 G137 G149 G161 G173 G185 G197 G209 G221 G233 G245 G257 G269 G281 G293 G305 G317
 /make GMD6 from G6 G18 G30 G42 G54 G66 G78 G90 G102 G114 G126 G138 G150 G162 G174 G186 G198 G210 G222 G234 G246 G258 G270 G282 G294 G306 G318
 /make GMD7 from G7 G19 G31 G43 G55 G67 G79 G91 G103 G115 G127 G139 G151 G163 G175 G187 G199 G211 G223 G235 G247 G259 G271 G283 G295 G307 G319
 /make GMD8 from G8 G20 G32 G44 G56 G68 G80 G92 G104 G116 G128 G140 G152 G164 G176 G188 G200 G212 G224 G236 G248 G260 G272 G284 G296 G308 G320
 /make GMD9 from G9 G21 G33 G45 G57 G69 G81 G93 G105 G117 G129 G141 G153 G165 G177 G189 G201 G213 G225 G237 G249 G261 G273 G285 G297 G309 G321
 /make GMD10 from G10 G22 G34 G46 G58 G70 G82 G94 G106 G118 G130 G142 G154 G166 G178 G190 G202 G214 G226 G238 G250 G262 G274 G286 G298 G310 G322
 /make GMD11 from G11 G23 G35 G47 G59 G71 G83 G95 G107 G119 G131 G143 G155 G167 G179 G191 G203 G215 G227 G239 G251 G263 G275 G287 G299 G311 G323
 /make GMD12 from G12 G24 G36 G48 G60 G72 G84 G96 G108 G120 G132 G144 G156 G168 G180 G192 G204 G216 G228 G240 G252 G264 G276 G288 G300 G312 G324
 /make gapweeks from gapweeks1 to gapweeks27
 /make gapterm from GAPTERM1_sum to GAPTERM27_sum
 /make unspecgap from UNSPECGAP1_sum to UNSPECGAP27_sum 
 /index yearnum
 /keep=R0000100 Monthround1 to Monthround19 Wave Round WavejobID RWJID jobtype UID compensation hoursweek paidleave medins retiremnt.

DATASET NAME jobdata_yrly.
SAVE OUTFILE='D:\NLSY97_Kopyckaetal\Jobdata_yearlong.sav'
 /COMPRESSED.

compute year=yearnum+1993.
formats year (F4.0).
EXECUTE.

* Flag months with at least 1 week in which within-job gap could not be established; excluding months not working in this job (which implies no gap)

do repeat a=GMD1 to GMD12 / b=MDS1 to MDS12.
recode a(0=0)(1 thru highest=1).
if b<=0 a=0.
end repeat.
EXECUTE.

* Restrict number of cases in dataset to year-jobs which were done for at least one month this year

compute filter=0.
do repeat a=MDS1 to MDS12.
if a>0 filter=1.
end repeat.
EXECUTE.
select if filter=1.
EXECUTE.
delete vars filter.
sort cases by R0000100 year.
EXECUTE.
 
SAVE OUTFILE='D:\NLSY97_Kopyckaetal\Jobdata_yearlong.sav'
 /COMPRESSED.

********** JOB TERMINATIONS ***********************************

* Notes on possible double counting of the terminations associated with within-job gaps due to gap overlap:
 Generally gap overlaps are rare, and a great majority of gaps do not count as terminations.

* Count job terminations: reported & censored
 CONDITIONS - WHEN IS A CENSORED TERMINATION NOT TREATED AS AN ACTUAL TERMINATION
 1) This same employer is reported in the following wave (based on employer UID)
 2) If the whole case is censored, meaning number of censored months (-3) >0 (create flag to add to dataset)
 3) If this is the last year of work observed and this year is NOT covered by the next wave of the interview (i.e., job censored in December)

* MDS Values
 -2 respondent does not turn 14 this year
 -6 month covered by next survey wave
 -5 month covered by previous survey wave
 -3 month beyond observation range (after most recent wave)
 0 not working this job
 11 first month of job as reported
 12 first month of job (left censored) - applies starting from round 2
 13 first month of job (imputed)
 21 next months of job
 31 last month of job as reported
 32 last month of job censored by survey (ongoing job)
 41 first and last month of job as reported
 42 first and last month of job (first month censored by survey) - applies since round 2
 43 first and last month of job (last month censored by survey) - ongoing job
 0.5 job started or ended this year, month not known
 0.1 job reported in retrospective period covered by this survey wave, year not known.

* Create lagged respondent-specific employer ID variable to check if the same job reported as continuing in the next wave

compute RUID=R0000100*1000000+UID.
EXECUTE.
sort cases by ruid (D) wavejobID (D) year (D).
compute RUID_lag=lag(RUID).
EXECUTE.

* Create flag for censored cases - year of last survey wave

count nextwave=MDS1 to MDS12 (-6).
count censored=MDS1 to MDS12 (-3).
recode censored (1 thru highest=1).
if nextwave>=1 censored=0.
var lab censored 'Cases censored by last survey wave'.
EXECUTE.

* Count reported terminations.
count term_reported = MDS1 to MDS12 (31, 41, 42).
EXECUTE.

* Count censored terminations and correct for additional censored terminations due to the mistake in the original CURFLAG variable (14 cases; remove value 32 from MDS).
count term_censored = MDS1 to MDS12 (32, 43).
EXECUTE.
do if term_reported+term_censored=2.
recode MDS1 to MDS12 (32=0).
end if.
count term_censored = MDS1 to MDS12 (32, 43).
if term_censored=1 and RUID_lag=RUID term_censored=0.
formats term_reported term_censored (F2.0).
EXECUTE.

* Add terminations due to long-lasting within-job gaps; gaps flagged by unspecgap (work related but with missing data on duration) not included
  Terminations due to censoring by the last survey wave are included, but these cases are filtered out after aggregation to person-years using the censored variable

recode gapterm (sysmis=0).
EXECUTE.
compute terminations=term_reported + term_censored + gapterm.
var lab terminations 'Total number of job terminations this year'.
EXECUTE.

SAVE OUTFILE='D:\NLSY97_Kopyckaetal\Jobdata_yearlong.sav'
 /COMPRESSED.

************************************************************ STEP 5. CALCULATING ANNUAL PAY PER JOB & ACCESS TO BENEFITS FOR EACH JOB/YEAR

* Assess duration of jobs and flag cases when actual duration cannot be established (and minimal duration is calculated instead)
* Zero values of gross job duration (GDJ; gross means that periods of gaps are not subtracted) are due to missing data on job dates
* All cases with unspecified durations due to missing data should be excluded from calculations of annual wage (based on GDJ_mis)

DATASET ACTIVATE jobdata_yrly.
sort cases by R0000100 YEAR.
count GDJ = MDS1 to MDS12 (11 thru 43).
count GDJ_mis = MDS1 to MDS12 (0.5, 0.1).
formats GDJ GDJ_mis (F2.0).
var lab GDJ 'Total duration of job in months - job gaps not subtracted'.
var lab GDJ_mis 'Total number of months in which working could not be established'.
EXECUTE.
recode gapweeks(sysmis=0). 

* Assess duration of jobs in weeks 

compute workweekstot=(364/7)*(GDJ/12).
compute workweeks=(364/7)*(GDJ/12)-gapweeks.
recode workweeks (lowest thru 0=0).
formats workweekstot workweeks (F4.2).
var lab workweeks 'Number of weeks of confirmed work - excluding job gaps'.
EXECUTE.
* Total number of weeks which could be within-job gaps

recode GMD1 to GMD12 (sysmis=0).
compute maybegap=sum (GMD1 to GMD12).
var lab maybegap 'max number of possible additional weeks of gaps - unspecified due to missing data'.
format maybegap (F2.0).
EXECUTE.

* Create flag for missing data on annual pay. 4 sources of missing data:
Military jobs - no data on pay (only paygrade) - Military jobs are 2% of all job-years
Missing data on wages & 1 outlier
Missing data on work hours per week
Missing data on job duration and/or duration of within-job gap(s)

compute mis_mili=0.
compute mis_dates=0.
compute mis_nopay1=0.
compute mis_outpay1=0.
compute mis_hours1=0.
if jobtype=40 mis_mili=1.
IF jobtype<40 and (GDJ_mis>0 or maybegap>0) mis_dates=1.
IF jobtype<40 and mis_dates=0 and hoursweek<0 mis_hours1=1. 
IF jobtype<40 and mis_dates=0 and compensation<0 mis_nopay1=1.
IF jobtype<40 and mis_dates=0 and compensation>=10000 mis_outpay1=1.
var lab mis_mili 'Flag for missing pay data - presence of military job this year'
/mis_dates 'Flag for missing pay data - uknown job duration this year'
/ mis_nopay1 'Flag for missing pay data - not military and duration known; missing data on wages'
/ mis_outpay1 'Flag for missing pay data - not military and duration known; probably miscoded data on wages'
/ mis_hours1 'Flag for missing pay data - not military and duration known; missing data on job hours'.
formats mis_mili mis_dates mis_nopay1 mis_outpay1 mis_hours1 (F2.0).
EXECUTE.

* The largest number of missing cases come from the lack of information on working hours and hourly compensation
  In later analysis, this information can be compared to and supplemented from the raw dataset (compensation is a constructed variable)
  The syntax below assigns available values for job-wave-years with missing data based on data on this same job collected in the closes wave(s)
  If information is provided for both earier and later year, weighted average is assigned, taking into account the distance between the missing data year and neighboring observations
  Check how many missing cases remain after this addition

sort cases by ruid (A) wavejobID (A) year (A).
mis val compensation hoursweek (-5 thru -1).
do repeat a=v1994 to v2020 / b=1994 to 2020.
if year=b and compensation>=0 and compensation<10000 a=b.
end repeat. 
EXECUTE.
AGGREGATE
 /OUTFILE=* MODE=ADDVARIABLES
 /PRESORTED
 /BREAK=ruid
/comp1994=MAX(v1994) /comp1995=MAX(v1995) /comp1996=MAX(v1996) /comp1997=MAX(v1997) /comp1998=MAX(v1998) /comp1999=MAX(v1999) /comp2000=MAX(v2000)
/comp2001=MAX(v2001) /comp2002=MAX(v2002) /comp2003=MAX(v2003) /comp2004=MAX(v2004) /comp2005=MAX(v2005) /comp2006=MAX(v2006) /comp2007=MAX(v2007)
/comp2008=MAX(v2008) /comp2009=MAX(v2009) /comp2010=MAX(v2010) /comp2011=MAX(v2011) /comp2012=MAX(v2012) /comp2013=MAX(v2013) /comp2014=MAX(v2014)
/comp2015=MAX(v2015) /comp2016=MAX(v2016) /comp2017=MAX(v2017) /comp2018=MAX(v2018) /comp2019=MAX(v2019) /comp2020=MAX(v2020).
EXECUTE.
del vars v1994 to v2020.
EXECUTE.

do repeat a=comp1994 to comp2020 / b=e1994 to e2020.
if (mis_nopay1=1 or mis_outpay1=1) and a-year<=0 b=a-year.
end repeat.
do repeat a=comp1994 to comp2020 / b=l1994 to l2020.
if (mis_nopay1=1 or mis_outpay1=1) and a-year>0 b=a-year.
end repeat.
if (mis_nopay1=1 or mis_outpay1=1) nearcomp_E=MAX(e1994 to e2020).
if (mis_nopay1=1 or mis_outpay1=1) nearcomp_L=MIN(l1994 to l2020).
EXECUTE.
del vars comp1994 to l2020.
if (mis_nopay1=1 or mis_outpay1=1) nearcomp_EY=year+nearcomp_E.
if (mis_nopay1=1 or mis_outpay1=1) nearcomp_LY=year+nearcomp_L.
EXECUTE.

do repeat a=v1994 to v2020 / b=1994 to 2020.
if year=b and compensation>=0 and compensation<10000 a=compensation.
end repeat. 
EXECUTE.
AGGREGATE
 /OUTFILE=* MODE=ADDVARIABLES
 /PRESORTED
 /BREAK=ruid
/comp1994e=LAST(v1994) /comp1995e=LAST(v1995) /comp1996e=LAST(v1996) /comp1997e=LAST(v1997) /comp1998e=LAST(v1998) /comp1999e=LAST(v1999)
/comp2000e=LAST(v2000) /comp2001e=LAST(v2001) /comp2002e=LAST(v2002) /comp2003e=LAST(v2003) /comp2004e=LAST(v2004) /comp2005e=LAST(v2005)
/comp2006e=LAST(v2006) /comp2007e=LAST(v2007) /comp2008e=LAST(v2008) /comp2009e=LAST(v2009) /comp2010e=LAST(v2010) /comp2011e=LAST(v2011)
/comp2012e=LAST(v2012) /comp2013e=LAST(v2013) /comp2014e=LAST(v2014) /comp2015e=LAST(v2015) /comp2016e=LAST(v2016) /comp2017e=LAST(v2017)
/comp2018e=LAST(v2018) /comp2019e=LAST(v2019) /comp2020e=LAST(v2020).
EXECUTE.
do repeat a=1994 to 2020 / b=comp1994e to comp2020e.
if nearcomp_EY=a nearcomp_EA=b.
end repeat.
EXECUTE.

AGGREGATE
 /OUTFILE=* MODE=ADDVARIABLES
 /PRESORTED
 /BREAK=ruid
/comp1994l=FIRST(v1994) /comp1995l=FIRST(v1995) /comp1996l=FIRST(v1996) /comp1997l=FIRST(v1997) /comp1998l=FIRST(v1998) /comp1999l=FIRST(v1999)
/comp2000l=FIRST(v2000) /comp2001l=FIRST(v2001) /comp2002l=FIRST(v2002) /comp2003l=FIRST(v2003) /comp2004l=FIRST(v2004) /comp2005l=FIRST(v2005)
/comp2006l=FIRST(v2006) /comp2007l=FIRST(v2007) /comp2008l=FIRST(v2008) /comp2009l=FIRST(v2009) /comp2010l=FIRST(v2010) /comp2011l=FIRST(v2011)
/comp2012l=FIRST(v2012) /comp2013l=FIRST(v2013) /comp2014l=FIRST(v2014) /comp2015l=FIRST(v2015) /comp2016l=FIRST(v2016) /comp2017l=FIRST(v2017)
/comp2018l=FIRST(v2018) /comp2019l=FIRST(v2019) /comp2020l=FIRST(v2020).
EXECUTE.
do repeat a=1994 to 2020 / b=comp1994l to comp2020l.
if nearcomp_LY=a nearcomp_LA=b.
end repeat.
EXECUTE.
del vars v1994 to comp2020e comp1994l to comp2020l.
EXECUTE.

* Create new hourly compensation variable with fewer missing cases
  If break between year with available data and year with missing data longer than 5 years and data only for one time point - treat as missing
  If two time points available - assign weighted average taking into account which time point is nearer.

if compensation<10000 compensation2=compensation.
if (mis_nopay1=1 or mis_outpay1=1) and nearcomp_E<0 and nearcomp_E>=-5 compensation2=nearcomp_EA.
if (mis_nopay1=1 or mis_outpay1=1) and nearcomp_L>0 and nearcomp_L<=5 compensation2=nearcomp_LA.
if (mis_nopay1=1 or mis_outpay1=1) and nearcomp_E=0 compensation2=nearcomp_EA.
if (mis_nopay1=1 or mis_outpay1=1) and nearcomp_E<0 and nearcomp_L>0 increase=(nearcomp_LA-nearcomp_EA)*((year-nearcomp_EY)/(nearcomp_LY-nearcomp_EY)).
if (mis_nopay1=1 or mis_outpay1=1) and nearcomp_E<0 and nearcomp_L>0 compensation2=nearcomp_EA+increase.
EXECUTE.
del vars increase.
compute mis_nopay2=mis_nopay1.
compute mis_outpay2=mis_outpay1.
if compensation2>=0 mis_nopay2=0.
if compensation2>=0 mis_outpay2=0.
EXECUTE.
var lab compensation2 'Hourly compensation with reduced missing data based on information on the same job from neighboring years'
/ mis_nopay2 'Missing data on hourly compensation flag after correction'
/ mis_outpay2 'Miscoded data on hourly compensation flag after correction'.

* Same procedure for missing data on hours worked
  
do repeat a=v1994 to v2020 / b=1994 to 2020.
if year=b and hoursweek>=0 a=b.
end repeat. 
EXECUTE.
AGGREGATE
 /OUTFILE=* MODE=ADDVARIABLES
 /PRESORTED
 /BREAK=ruid
/hours1994=MAX(v1994) /hours1995=MAX(v1995) /hours1996=MAX(v1996) /hours1997=MAX(v1997) /hours1998=MAX(v1998) /hours1999=MAX(v1999) /hours2000=MAX(v2000)
/hours2001=MAX(v2001) /hours2002=MAX(v2002) /hours2003=MAX(v2003) /hours2004=MAX(v2004) /hours2005=MAX(v2005) /hours2006=MAX(v2006) /hours2007=MAX(v2007)
/hours2008=MAX(v2008) /hours2009=MAX(v2009) /hours2010=MAX(v2010) /hours2011=MAX(v2011) /hours2012=MAX(v2012) /hours2013=MAX(v2013) /hours2014=MAX(v2014)
/hours2015=MAX(v2015) /hours2016=MAX(v2016) /hours2017=MAX(v2017) /hours2018=MAX(v2018) /hours2019=MAX(v2019) /hours2020=MAX(v2020).
EXECUTE.
del vars v1994 to v2020.
EXECUTE.

do repeat a=hours1994 to hours2020 / b=e1994 to e2020.
if (mis_hours1=1 or mis_outpay1=1) and a-year<=0 b=a-year.
end repeat.
do repeat a=hours1994 to hours2020 / b=l1994 to l2020.
if (mis_hours1=1 or mis_outpay1=1) and a-year>0 b=a-year.
end repeat.
if (mis_hours1=1) nearhours_E=MAX(e1994 to e2020).
if (mis_hours1=1) nearhours_L=MIN(l1994 to l2020).
EXECUTE.
del vars hours1994 to l2020.
if (mis_hours1=1) nearhours_EY=year+nearhours_E.
if (mis_hours1=1) nearhours_LY=year+nearhours_L.
EXECUTE.

do repeat a=v1994 to v2020 / b=1994 to 2020.
if year=b and hoursweek>=0 a=hoursweek.
end repeat. 
EXECUTE.
AGGREGATE
 /OUTFILE=* MODE=ADDVARIABLES
 /PRESORTED
 /BREAK=ruid
/hours1994e=LAST(v1994) /hours1995e=LAST(v1995) /hours1996e=LAST(v1996) /hours1997e=LAST(v1997) /hours1998e=LAST(v1998) /hours1999e=LAST(v1999)
/hours2000e=LAST(v2000) /hours2001e=LAST(v2001) /hours2002e=LAST(v2002) /hours2003e=LAST(v2003) /hours2004e=LAST(v2004) /hours2005e=LAST(v2005)
/hours2006e=LAST(v2006) /hours2007e=LAST(v2007) /hours2008e=LAST(v2008) /hours2009e=LAST(v2009) /hours2010e=LAST(v2010) /hours2011e=LAST(v2011)
/hours2012e=LAST(v2012) /hours2013e=LAST(v2013) /hours2014e=LAST(v2014) /hours2015e=LAST(v2015) /hours2016e=LAST(v2016) /hours2017e=LAST(v2017)
/hours2018e=LAST(v2018) /hours2019e=LAST(v2019) /hours2020e=LAST(v2020).
EXECUTE.
do repeat a=1994 to 2020 / b=hours1994e to hours2020e.
if nearhours_EY=a nearhours_EA=b.
end repeat.
EXECUTE.

AGGREGATE
 /OUTFILE=* MODE=ADDVARIABLES
 /PRESORTED
 /BREAK=ruid
/hours1994l=FIRST(v1994) /hours1995l=FIRST(v1995) /hours1996l=FIRST(v1996) /hours1997l=FIRST(v1997) /hours1998l=FIRST(v1998) /hours1999l=FIRST(v1999)
/hours2000l=FIRST(v2000) /hours2001l=FIRST(v2001) /hours2002l=FIRST(v2002) /hours2003l=FIRST(v2003) /hours2004l=FIRST(v2004) /hours2005l=FIRST(v2005)
/hours2006l=FIRST(v2006) /hours2007l=FIRST(v2007) /hours2008l=FIRST(v2008) /hours2009l=FIRST(v2009) /hours2010l=FIRST(v2010) /hours2011l=FIRST(v2011)
/hours2012l=FIRST(v2012) /hours2013l=FIRST(v2013) /hours2014l=FIRST(v2014) /hours2015l=FIRST(v2015) /hours2016l=FIRST(v2016) /hours2017l=FIRST(v2017)
/hours2018l=FIRST(v2018) /hours2019l=FIRST(v2019) /hours2020l=FIRST(v2020). 
EXECUTE.
do repeat a=1994 to 2020 / b=hours1994l to hours2020l.
if nearhours_LY=a nearhours_LA=b.
end repeat.
EXECUTE.
del vars v1994 to hours2020e hours1994l to hours2020l.
EXECUTE.

* Create new hourly hoursweek variable with fewer missing cases
  If break between year with available data and year with missing data longer than 5 years and data only for one time point - treat as missing
  If two time points available - assign weighted average taking into account which time point is nearer.

compute hoursweek2=hoursweek.
if (mis_hours1=1) and nearhours_E<0 and nearhours_E>=-5 hoursweek2=nearhours_EA.
if (mis_hours1=1) and nearhours_L>0 and nearhours_L<=5 hoursweek2=nearhours_LA.
if (mis_hours1=1) and nearhours_E=0 hoursweek2=nearhours_EA.
if (mis_hours1=1) and nearhours_E<0 and nearhours_L>0 increase=(nearhours_LA-nearhours_EA)*((year-nearhours_EY)/(nearhours_LY-nearhours_EY)).
if (mis_hours1=1) and nearhours_E<0 and nearhours_L>0 hoursweek2=nearhours_EA+increase.
EXECUTE.
del vars increase.
compute mis_hours2=mis_hours1.
if hoursweek2>=0 mis_hours2=0.
EXECUTE.
var lab hoursweek2 'Hours worked per week with reduced missing data based on information on the same job from neighboring years'
/ mis_hours2 'Missing data on hours flag after correction'.

* Note that if the number of working hours is 0 we do not need information on hourly pay - do not treat as missing.
* hours of work and compensation to calculate annual earnings from each job; divide by 100 to account for 2 implied decimals in the original dataset.

if hoursweek2=0 or workweeks=0 mis_nopay2=0.
if hoursweek2=0 or workweeks=0 mis_outpay2=0.
if hoursweek2>=0 work_allhours=workweeks*hoursweek2.
compute weekpay=compensation2*hoursweek2/100.
if mis_mili=1 or mis_dates=1 or mis_nopay2=1 or mis_outpay2=1 or mis_hours2=1 weekpay=0.
compute annuearn=weekpay*workweeks.
EXECUTE.
var lab annuearn 'Annual earnings from this job - assign zero to missing data or count lower bound'.

SAVE OUTFILE='D:\NLSY97_Kopyckaetal\Jobdata_yearlong.sav'
 /COMPRESSED.

* AVAILABILITY OF SELECTED BENEFITS: paid leave dummy, medical insurance and retirement benefits  
* RULES:
  Treat benefits for months with missing data on job status (MDS=0.1 or 0.5) as missing data
  Assign missing data to months not covered by survey wave (MDS<0)
  Assign flags whether benefit exists to months: job started, continues, ended (MDS>=11 and MDS<=32)
  (but without job started and ended in same month MDS>40 - jobs lasting <13 weeks are not considered eligible for benefits)
* Total duration of job in weeks each calendar year based on job dates provided by the respondents (job gaps are counted as work)
  subtract total number of weeks of job gaps to calculate total weeks actually spent in this job
  Ratio of weeks actually spent working this job to total reported weeks of attachment to employer
  Use as weight when calculating access to benefits

DATASET ACTIVATE jobdata_yrly.
do repeat a=MDS1 to MDS12 / b=M1 to M12.
recode a (lowest thru -1=sysmis)(0=0)(0.1 thru 0.5=copy)(10 thru 39=1)(40 thru 43=0) into b.
end repeat.
EXECUTE.

* Create weight to account for within-job gaps

do repeat a=M1 to M12 / b=pdlve1 to pdlve12 .
compute b=0.
if paidleave>0 and a=1 b=paidleave*a.
end repeat.
do repeat a=M1 to M12 / c=pdlvemis1 to pdlvemis12.
compute c=0.
if paidleave<0 or (a>0 and a<1) c=1.
end repeat.
do repeat a=M1 to M12 / b=medins1 to medins12.
compute b=0.
if medins>0 and a=1 b=medins*a.
end repeat.
do repeat a=M1 to M12 / c=medinsmis1 to medinsmis12.
compute c=0.
if medins<0 or (a>0 and a<1) c=1.
end repeat.
do repeat a=M1 to M12 / b=retir1 to retir12.
compute b=0.
if retiremnt>0 and a=1 b=retiremnt*a.
end repeat.
do repeat a=M1 to M12 / c=retirmis1 to retirmis12.
compute c=0.
if retiremnt<0 or (a>0 and a<1) c=1.
end repeat.
formats pdlve1 to retirmis12 (F2.0). 
EXECUTE.

COMPUTE respyearID=R0000100*10000+YEAR.
formats respyearID (F10.0).
EXECUTE.

SAVE OUTFILE='D:\NLSY97_Kopyckaetal\Jobdata_yearlong.sav'
 /COMPRESSED.

* Next step - aggregate monthly variables for each benefit by RESPYEAR
  Maximum value (whether coverage from at least one job in this month)
  Sum (whether coverage from more than one job results in full month coverage)
  - but also check how missing data will affect the sums

************************************************************ STEP 6. CREATING YEARLY DATASET AND LOW PAY / BENEFITS INDICATOR

* AGGREGATE DATASET - COMPUTE ANNUAL VARIABLES AND FINAL CNPI LOW PAY AND JOB TERMINATIONS COMPONENTS
 
SORT CASES BY respyearID.
AGGREGATE
 /OUTFILE='D:\NLSY97_Kopyckaetal\NLSY97_CNPI.sav'
 /PRESORTED
 /BREAK=respyearID
 /ID=mean(R0000100) /year=mean(year) /censored=MAX(censored) /mis_mili=MAX(mis_mili) /mis_dates=MAX(mis_dates) /mis_nopay=MAX(mis_nopay2) 
 /mis_outpay=MAX(mis_outpay2) /mis_hours=MAX(mis_hours2) /work_allhours=SUM(work_allhours) /work_allweeks=SUM(workweeks)/ meanearn=MEAN(compensation2)
 /annuearn=SUM(annuearn) /njobterm=SUM(terminations) /N_jobspells=N
 /pdlve1_sum=SUM(pdlve1) /pdlve2_sum=SUM(pdlve2) /pdlve3_sum=SUM(pdlve3) /pdlve4_sum=SUM(pdlve4) /pdlve5_sum=SUM(pdlve5) /pdlve6_sum=SUM(pdlve6) 
 /pdlve7_sum=SUM(pdlve7) /pdlve8_sum=SUM(pdlve8) /pdlve9_sum=SUM(pdlve9) /pdlve10_sum=SUM(pdlve10) /pdlve11_sum=SUM(pdlve11) /pdlve12_sum=SUM(pdlve12) 
 /medins1_sum=SUM(medins1) /medins2_sum=SUM(medins2) /medins3_sum=SUM(medins3) /medins4_sum=SUM(medins4) /medins5_sum=SUM(medins5) 
 /medins6_sum=SUM(medins6) /medins7_sum=SUM(medins7) /medins8_sum=SUM(medins8) /medins9_sum=SUM(medins9) /medins10_sum=SUM(medins10) 
 /medins11_sum=SUM(medins11) /medins12_sum=SUM(medins12) /retir1_sum=SUM(retir1) /retir2_sum=SUM(retir2) /retir3_sum=SUM(retir3) /retir4_sum=SUM(retir4)
 /retir5_sum=SUM(retir5) /retir6_sum=SUM(retir6) /retir7_sum=SUM(retir7) /retir8_sum=SUM(retir8) /retir9_sum=SUM(retir9) /retir10_sum=SUM(retir10) /retir11_sum=SUM(retir11)
 /retir12_sum=SUM(retir12) 
 /pdlvemis1=SUM(pdlvemis1) /pdlvemis2=SUM(pdlvemis2) /pdlvemis3=SUM(pdlvemis3) /pdlvemis4=SUM(pdlvemis4) /pdlvemis5=SUM(pdlvemis5) /pdlvemis6=SUM(pdlvemis6)
 /pdlvemis7=SUM(pdlvemis7) /pdlvemis8=SUM(pdlvemis8) /pdlvemis9=SUM(pdlvemis9) /pdlvemis10=SUM(pdlvemis10) /pdlvemis11=SUM(pdlvemis11)
 /pdlvemis12=SUM(pdlvemis12) /medinsmis1=SUM(medinsmis1) /medinsmis2=SUM(medinsmis2) /medinsmis3=SUM(medinsmis3) /medinsmis4=SUM(medinsmis4)
 /medinsmis5=SUM(medinsmis5) /medinsmis6=SUM(medinsmis6) /medinsmis7=SUM(medinsmis7) /medinsmis8=SUM(medinsmis8) /medinsmis9=SUM(medinsmis9)
 /medinsmis10=SUM(medinsmis10) /medinsmis11=SUM(medinsmis11) /medinsmis12=SUM(medinsmis12) /retirmis1=SUM(retirmis1) /retirmis2=SUM(retirmis2) 
 /retirmis3=SUM(retirmis3) /retirmis4=SUM(retirmis4) /retirmis5=SUM(retirmis5) /retirmis6=SUM(retirmis6) /retirmis7=SUM(retirmis7) /retirmis8=SUM(retirmis8) 
 /retirmis9=SUM(retirmis9) /retirmis10=SUM(retirmis10) /retirmis11=SUM(retirmis11) /retirmis12=SUM(retirmis12) /N_BREAK=N.

GET FILE='D:\NLSY97_Kopyckaetal\NLSY97_CNPI.sav'.
DATASET NAME NLSY97_CNPI.
DATASET CLOSE Jobdata_yrly.
DATASET ACTIVATE NLSY97_CNPI.
SAVE OUTFILE='D:\NLSY97_Kopyckaetal\NLSY97_CNPI.sav'
 /COMPRESSED.

******************************************** YEARLY BENEFITS INDICATORS
* TARGET VARIABLES (USED IN FINAL MS):
  Benefits in first two months of the year
  Benefit coverage 9+ months of year (based on weights taking into account the number of weeks of work & alternative - without weights)

* After merge all cases with missing data on other CNPI variables and censored cases are filtered out
  recode sysmis into 0, as this concerns person-years where no work was done

do repeat a=pdlve1_sum to pdlve12_sum / b=pdlvemis1 to pdlvemis12 / c=pdlve_1 to pdlve_12.
if a>=1 c=1.
if a<1 and b=0 c=a.
if a<1 and b>0 c=-1.
end repeat.

do repeat a=medins1_sum to medins12_sum / b= medinsmis1 to medinsmis12 / c= medins_1 to medins_12.
if a>=1 c=1.
if a<1 and b=0 c=a.
if a<1 and b>0 c=-1.
end repeat.

do repeat a=retir1_sum to retir12_sum / b= retirmis1 to retirmis12 / c= retir_1 to retir_12.
if a>=1 c=1.
if a<1 and b=0 c=a.
if a<1 and b>0 c=-1.
end repeat.
EXECUTE.

* Minimum sum for all months of the year - assuming all missing values are zero
  If minimum sum >=9 condition met regardless of other missing values.

do repeat a=pdlve_1 to retir_12 / b=v1 to v36.
recode a (lowest thru 0=0)(else=copy) into b.
end repeat.
compute pdlve_minsum=sum(v1 to v12).
compute medins_minsum=sum(v13 to v24).
compute retir_minsum=sum(v25 to v36).

* Maximum sum for all months of the year - assuming all missing values are one
  If maximum sum <9 condition not met regardless of other missing values

do repeat a=pdlve_1 to retir_12 / b=v1 to v36.
recode a (-1=1)(0=0)(else=copy) into b.
end repeat.
compute pdlve_maxsum=sum(v1 to v12).
compute medins_maxsum=sum(v13 to v24).
compute retir_maxsum=sum(v25 to v36).
EXECUTE.
del vars v1 to v36.

do repeat a= pdlve_minsum to retir_minsum / b=pdlve_maxsum to retir_maxsum
/ c=pdlve_9M medins_9M retiremnt_9M.
if a>=9 c=1.
if b<9 c=0.
recode c (sysmis=-1).
end repeat.
EXECUTE.

*   Compute combinations of benefits

if pdlve_9M=0 and medins_9M=0 and retiremnt_9M=0 benefits_9M=0.
if pdlve_9M=1 or medins_9M=1 or retiremnt_9M=1 benefits_9M=1.
if pdlve_9M<0 or medins_9M<0 or retiremnt_9M<0 benefits_9M=-1.
if (pdlve_9M<0 or medins_9M<0 or retiremnt_9M<0) and (pdlve_9M+medins_9M+retiremnt_9M=0) benefits_9M=1.
if pdlve_9M=1 and medins_9M=1 and retiremnt_9M=1 benefits_9M=2.

var lab benefits_9M 'Availability of either one or all employee benefits among: paid leave, medical insurance, retirement plan'.
mis val benefits_9M (-1).
val lab benefits_9m 0 'No benefits' 1 'At least one type of benefit' 2 'Full coverage: all three benefits'.
formats benefits_9M (F2.0).
EXECUTE.

* Benefits in first two months of each year (observed at least once; at least half a month case of weighted information)
  
do repeat a= pdlve_1 medins_1 retir_1 / b= pdlve_2 medins_2 retir_2 / c= pdlve_1M medins_1M retiremnt_1M.
if a>=0 and b>=0 and a<0.5 and b<0.5 c=0.
if a>=0.5 or b>=0.5 c=1.
recode c (sysmis=-1).
end repeat.
EXECUTE.

* Compute combinations of benefits
  
if pdlve_1M=0 and medins_1M=0 and retiremnt_1M=0 benefits_1M=0.
if pdlve_1M=1 or medins_1M=1 or retiremnt_1M=1 benefits_1M=1.
if pdlve_1M<0 or medins_1M<0 or retiremnt_1M<0 benefits_1M=-1.
if (pdlve_1M<0 or medins_1M<0 or retiremnt_1M<0) and (pdlve_1M+medins_1M+retiremnt_1M=0) benefits_1M=1.
if pdlve_1M=1 and medins_1M=1 and retiremnt_1M=1 benefits_1M=2.

var lab benefits_1M 'Availability of either one or all employee benefits among: paid leave, medical insurance, retirement plan - Jan/Feb'.
mis val benefits_1M (-1).
val lab benefits_1M 0 'No benefits' 1 'At least one type of benefit' 2 'Full coverage: all three benefits'.
formats benefits_1M (F2.0).
EXECUTE.

del vars pdlve1_sum to retiremnt_9M pdlve_1M to retiremnt_1M.
SAVE OUTFILE='D:\NLSY97_Kopyckaetal\NLSY97_CNPI.sav'
 /COMPRESSED.

*******************************************************
* Create low pay threshold - 0.5 mean annual wages in current currency (source: https://stats.oecd.org/viewhtml.aspx?datasetcode=AV_AN_WAGE&lang=en)

do repeat a=1994 to 2020 / b=15123.22257 15529.18553 16093.0818 16781.94278 17612.24698 18340.07859 19431.58672 19973.12576 20398.10271 21050.69427
21972.84593 22627.29035 23612.64712 24677.27995 25344.92805 25527.77157 26214.30609 26913.51954 27649.37822 27891.11306 28725.02535 29514.54243
29864.3494 30719.47828 31718.29458 32748.46694 35044.82413.
if YEAR=a threshold=b.
end repeat.
EXECUTE.

* Compare annual wages to threshold and calculate CNPI low pay component

if (mis_mili=0 and mis_dates=0 and mis_outpay=0 and mis_nopay=0 and mis_hours=0) perc_linc=annuearn/threshold.
if annuearn>=Threshold perc_linc=1.
var lab perc_linc 'CNPI low wage component: annual pay as percentage of low pay threshold'.
EXECUTE.

compute filter=1.
if mis_mili=1 or mis_dates=1 or censored=1 filter=0.
if mis_hours=1 filter=0.
if perc_linc=1 filter=1.
EXECUTE.

compute fullcases1=filter.
if filter=1 and (mis_nopay=1 or mis_outpay=1) fullcases1=0.
if perc_linc=1 fullcases1=1.
var lab fullcases1 'Filter for all non-censored cases with full data allowing to compute CNPI'.
EXECUTE.

SAVE OUTFILE='D:\NLSY97_Kopyckaetal\NLSY97_CNPI.sav'
 /COMPRESSED.

* NOTE: THIS DATASET DOES NOT INCLUDE THOSE WHO DID NOT REPORT ANY WORK THIS YEAR
These cases will be added to the dataset in step 8.

************************************************************ STEP 7. CALCULATING YEARLY NUMBER OF MONTHS JOBLESS BASED ON EMPLOYMENT ARRAYS

* the number of months of joblessness - based on weekly employment arrays
Create wide dataset with weekly employment status variables.
* E0011406
 0 "0: No information reported to account for week; job dates indeterminate"
 1 "1: Not associated with an employer, not actively searching for an employer job"
 2 "2: Not working (unemployment vs. out of labor force cannot be determined)"
 3 "3: Associated with an employer, periods not working for the employer are missing"
 4 "4: Unemployed"
 5 "5: Out of the labor force"
 6 "6: Active military service"
 9701 "9701 TO 201999: Employer on roster (see YEMP_UID)"

* WORK IN MONTH DEFINED AS OCCURRING WHEN A RESPODENT WORKS 2 OR MORE WEEKS DURING THIS MONTH
* COMBINED WITH LACK OF MISSING DATA (-4 AND 0 & 3); active military treated as work
 * ALL OTHER MONTHS ARE JOBLESS

DATASET ACTIVATE Sourcedata.
SAVE OUTFILE='D:\NLSY97_Kopyckaetal\source_empstatus.sav'
/KEEP = R0000100 R0536401 R0536402 E0011406 to E0014027
 /COMPRESSED.

GET FILE 'D:\NLSY97_Kopyckaetal\source_empstatus.sav'.
DATASET NAME empstatus.
DATASET ACTIVATE empstatus.

do repeat a=E0011406 to E0014027 / b=ESW1 to ESW1379.
recode a (0=-1)(3=0.5)(1, 2, 4, 5=0)(6 thru highest=1)(else=copy) into b.
end repeat.
EXECUTE.

compute work_M1=0.
do repeat a= work_M2 to work_M319 / b= ESW1 ESW5 ESW10 ESW14 ESW18 ESW23 ESW27 ESW32 ESW36 ESW40 ESW45 ESW49 ESW53 ESW57 ESW62 ESW66 ESW71 
ESW75 ESW79 ESW84 ESW88 ESW92 ESW97 ESW101 ESW106 ESW110 ESW114 ESW118 ESW123 ESW127 ESW132 ESW136 ESW140 ESW145 ESW149 ESW153 ESW158 
ESW162 ESW166 ESW171 ESW175 ESW179 ESW184 ESW188 ESW192 ESW197 ESW201 ESW206 ESW210 ESW214 ESW218 ESW223 ESW227 ESW231 ESW236 ESW240 
ESW245 ESW249 ESW253 ESW258 ESW262 ESW266 ESW271 ESW275 ESW279 ESW284 ESW288 ESW292 ESW297 ESW301 ESW305 ESW310 ESW314 ESW318 ESW323 
ESW327 ESW332 ESW336 ESW340 ESW345 ESW349 ESW353 ESW358 ESW361 ESW366 ESW370 ESW374 ESW378 ESW383 ESW387 ESW391 ESW396 ESW400 ESW405 
ESW409 ESW413 ESW418 ESW422 ESW426 ESW430 ESW435 ESW439 ESW444 ESW448 ESW452 ESW457 ESW461 ESW465 ESW470 ESW474 ESW478 ESW483 ESW487 
ESW491 ESW496 ESW500 ESW504 ESW509 ESW513 ESW518 ESW522 ESW526 ESW531 ESW535 ESW539 ESW544 ESW548 ESW552 ESW557 ESW561 ESW565 ESW570 
ESW574 ESW578 ESW583 ESW587 ESW591 ESW596 ESW600 ESW605 ESW609 ESW613 ESW618 ESW621 ESW625 ESW629 ESW634 ESW638 ESW643 ESW647 ESW651 
ESW656 ESW660 ESW664 ESW669 ESW673 ESW678 ESW682 ESW686 ESW690 ESW695 ESW699 ESW703 ESW708 ESW712 ESW717 ESW721 ESW725 ESW730 ESW734 
ESW738 ESW743 ESW747 ESW751 ESW756 ESW760 ESW764 ESW769 ESW773 ESW778 ESW782 ESW786 ESW790 ESW795 ESW799 ESW803 ESW808 ESW812 ESW817 
ESW821 ESW825 ESW830 ESW834 ESW838 ESW843 ESW847 ESW851 ESW856 ESW860 ESW864 ESW869 ESW873 ESW877 ESW882 ESW886 ESW890 ESW895 ESW899 
ESW903 ESW908 ESW912 ESW917 ESW921 ESW925 ESW930 ESW933 ESW938 ESW942 ESW946 ESW951 ESW955 ESW959 ESW964 ESW968 ESW973 ESW977 ESW981 
ESW986 ESW990 ESW994 ESW999 ESW1003 ESW1007 ESW1012 ESW1016 ESW1020 ESW1025 ESW1029 ESW1033 ESW1038 ESW1042 ESW1046 ESW1051 ESW1055 
ESW1059 ESW1064 ESW1068 ESW1073 ESW1077 ESW1081 ESW1086 ESW1090 ESW1094 ESW1098 ESW1103 ESW1107 ESW1112 ESW1116 ESW1120 ESW1125 ESW1129 
ESW1133 ESW1138 ESW1142 ESW1147 ESW1151 ESW1155 ESW1159 ESW1164 ESW1168 ESW1173 ESW1177 ESW1181 ESW1186 ESW1190 ESW1193 ESW1198 ESW1202 
ESW1206 ESW1211 ESW1215 ESW1219 ESW1224 ESW1228 ESW1232 ESW1237 ESW1241 ESW1246 ESW1250 ESW1254 ESW1258 ESW1263 ESW1267 ESW1271 ESW1276 
ESW1280 ESW1285 ESW1289 ESW1293 ESW1298 ESW1302 ESW1306 ESW1311 ESW1315 ESW1319 ESW1324 ESW1328 ESW1332 ESW1337 ESW1341 ESW1345 ESW1350 
ESW1354 ESW1358 ESW1363 ESW1367 ESW1372 ESW1376 
/ c= ESW4 ESW9 ESW13 ESW17 ESW22 ESW26 ESW31 ESW35 ESW39 ESW44 ESW48 ESW52 ESW56 ESW61 ESW65 ESW70 ESW74
ESW78 ESW83 ESW87 ESW91 ESW96 ESW100 ESW105 ESW109 ESW113 ESW117 ESW122 ESW126 ESW131 ESW135 ESW139 ESW144 ESW148
ESW152 ESW157 ESW161 ESW165 ESW170 ESW174 ESW178 ESW183 ESW187 ESW191 ESW196 ESW200 ESW205 ESW209 ESW213 ESW217 ESW222
ESW226 ESW230 ESW235 ESW239 ESW244 ESW248 ESW252 ESW257 ESW261 ESW265 ESW270 ESW274 ESW278 ESW283 ESW287 ESW291 ESW296
ESW300 ESW304 ESW309 ESW313 ESW317 ESW322 ESW326 ESW331 ESW335 ESW339 ESW344 ESW348 ESW352 ESW357 ESW360 ESW365 ESW369
ESW373 ESW377 ESW382 ESW386 ESW390 ESW395 ESW399 ESW404 ESW408 ESW412 ESW417 ESW421 ESW425 ESW429 ESW434 ESW438 ESW443
ESW447 ESW451 ESW456 ESW460 ESW464 ESW469 ESW473 ESW477 ESW482 ESW486 ESW490 ESW495 ESW499 ESW503 ESW508 ESW512 ESW517
ESW521 ESW525 ESW530 ESW534 ESW538 ESW543 ESW547 ESW551 ESW556 ESW560 ESW564 ESW569 ESW573 ESW577 ESW582 ESW586 ESW590
ESW595 ESW599 ESW604 ESW608 ESW612 ESW617 ESW620 ESW624 ESW628 ESW633 ESW637 ESW642 ESW646 ESW650 ESW655 ESW659 ESW663
ESW668 ESW672 ESW677 ESW681 ESW685 ESW689 ESW694 ESW698 ESW702 ESW707 ESW711 ESW716 ESW720 ESW724 ESW729 ESW733 ESW737
ESW742 ESW746 ESW750 ESW755 ESW759 ESW763 ESW768 ESW772 ESW777 ESW781 ESW785 ESW789 ESW794 ESW798 ESW802 ESW807 ESW811
ESW816 ESW820 ESW824 ESW829 ESW833 ESW837 ESW842 ESW846 ESW850 ESW855 ESW859 ESW863 ESW868 ESW872 ESW876 ESW881 ESW885
ESW889 ESW894 ESW898 ESW902 ESW907 ESW911 ESW916 ESW920 ESW924 ESW929 ESW932 ESW937 ESW941 ESW945 ESW950 ESW954 ESW958
ESW963 ESW967 ESW972 ESW976 ESW980 ESW985 ESW989 ESW993 ESW998 ESW1002 ESW1006 ESW1011 ESW1015 ESW1019 ESW1024 ESW1028 ESW1032
ESW1037 ESW1041 ESW1045 ESW1050 ESW1054 ESW1058 ESW1063 ESW1067 ESW1072 ESW1076 ESW1080 ESW1085 ESW1089 ESW1093 ESW1097 ESW1102 ESW1106
ESW1111 ESW1115 ESW1119 ESW1124 ESW1128 ESW1132 ESW1137 ESW1141 ESW1146 ESW1150 ESW1154 ESW1158 ESW1163 ESW1167 ESW1172 ESW1176 ESW1180
ESW1185 ESW1189 ESW1192 ESW1197 ESW1201 ESW1205 ESW1210 ESW1214 ESW1218 ESW1223 ESW1227 ESW1231 ESW1236 ESW1240 ESW1245 ESW1249 ESW1253
ESW1257 ESW1262 ESW1266 ESW1270 ESW1275 ESW1279 ESW1284 ESW1288 ESW1292 ESW1297 ESW1301 ESW1305 ESW1310 ESW1314 ESW1318 ESW1323 ESW1327
ESW1331 ESW1336 ESW1340 ESW1344 ESW1349 ESW1353 ESW1357 ESW1362 ESW1366 ESW1371 ESW1375 ESW1379.
count a = b to c (1).
end repeat.
do repeat a= work_M320 to work_M324.
compute a=0.
end repeat.
formats work_M1 to work_M324 (F2.0).
EXECUTE.

compute probwork_M1=0.
do repeat a= probwork_M2 to probwork_M319
/ b= ESW1 ESW5 ESW10 ESW14 ESW18 ESW23 ESW27 ESW32 ESW36 ESW40 ESW45 ESW49 ESW53 ESW57 ESW62 ESW66 ESW71 
ESW75 ESW79 ESW84 ESW88 ESW92 ESW97 ESW101 ESW106 ESW110 ESW114 ESW118 ESW123 ESW127 ESW132 ESW136 ESW140 ESW145 ESW149 ESW153 ESW158 
ESW162 ESW166 ESW171 ESW175 ESW179 ESW184 ESW188 ESW192 ESW197 ESW201 ESW206 ESW210 ESW214 ESW218 ESW223 ESW227 ESW231 ESW236 ESW240 
ESW245 ESW249 ESW253 ESW258 ESW262 ESW266 ESW271 ESW275 ESW279 ESW284 ESW288 ESW292 ESW297 ESW301 ESW305 ESW310 ESW314 ESW318 ESW323 
ESW327 ESW332 ESW336 ESW340 ESW345 ESW349 ESW353 ESW358 ESW361 ESW366 ESW370 ESW374 ESW378 ESW383 ESW387 ESW391 ESW396 ESW400 ESW405 
ESW409 ESW413 ESW418 ESW422 ESW426 ESW430 ESW435 ESW439 ESW444 ESW448 ESW452 ESW457 ESW461 ESW465 ESW470 ESW474 ESW478 ESW483 ESW487 
ESW491 ESW496 ESW500 ESW504 ESW509 ESW513 ESW518 ESW522 ESW526 ESW531 ESW535 ESW539 ESW544 ESW548 ESW552 ESW557 ESW561 ESW565 ESW570 
ESW574 ESW578 ESW583 ESW587 ESW591 ESW596 ESW600 ESW605 ESW609 ESW613 ESW618 ESW621 ESW625 ESW629 ESW634 ESW638 ESW643 ESW647 ESW651 
ESW656 ESW660 ESW664 ESW669 ESW673 ESW678 ESW682 ESW686 ESW690 ESW695 ESW699 ESW703 ESW708 ESW712 ESW717 ESW721 ESW725 ESW730 ESW734 
ESW738 ESW743 ESW747 ESW751 ESW756 ESW760 ESW764 ESW769 ESW773 ESW778 ESW782 ESW786 ESW790 ESW795 ESW799 ESW803 ESW808 ESW812 ESW817 
ESW821 ESW825 ESW830 ESW834 ESW838 ESW843 ESW847 ESW851 ESW856 ESW860 ESW864 ESW869 ESW873 ESW877 ESW882 ESW886 ESW890 ESW895 ESW899 
ESW903 ESW908 ESW912 ESW917 ESW921 ESW925 ESW930 ESW933 ESW938 ESW942 ESW946 ESW951 ESW955 ESW959 ESW964 ESW968 ESW973 ESW977 ESW981 
ESW986 ESW990 ESW994 ESW999 ESW1003 ESW1007 ESW1012 ESW1016 ESW1020 ESW1025 ESW1029 ESW1033 ESW1038 ESW1042 ESW1046 ESW1051 ESW1055 
ESW1059 ESW1064 ESW1068 ESW1073 ESW1077 ESW1081 ESW1086 ESW1090 ESW1094 ESW1098 ESW1103 ESW1107 ESW1112 ESW1116 ESW1120 ESW1125 ESW1129 
ESW1133 ESW1138 ESW1142 ESW1147 ESW1151 ESW1155 ESW1159 ESW1164 ESW1168 ESW1173 ESW1177 ESW1181 ESW1186 ESW1190 ESW1193 ESW1198 ESW1202 
ESW1206 ESW1211 ESW1215 ESW1219 ESW1224 ESW1228 ESW1232 ESW1237 ESW1241 ESW1246 ESW1250 ESW1254 ESW1258 ESW1263 ESW1267 ESW1271 ESW1276 
ESW1280 ESW1285 ESW1289 ESW1293 ESW1298 ESW1302 ESW1306 ESW1311 ESW1315 ESW1319 ESW1324 ESW1328 ESW1332 ESW1337 ESW1341 ESW1345 ESW1350 
ESW1354 ESW1358 ESW1363 ESW1367 ESW1372 ESW1376 
/ c= ESW4 ESW9 ESW13 ESW17 ESW22 ESW26 ESW31 ESW35 ESW39 ESW44 ESW48 ESW52 ESW56 ESW61 ESW65 ESW70 ESW74
ESW78 ESW83 ESW87 ESW91 ESW96 ESW100 ESW105 ESW109 ESW113 ESW117 ESW122 ESW126 ESW131 ESW135 ESW139 ESW144 ESW148
ESW152 ESW157 ESW161 ESW165 ESW170 ESW174 ESW178 ESW183 ESW187 ESW191 ESW196 ESW200 ESW205 ESW209 ESW213 ESW217 ESW222
ESW226 ESW230 ESW235 ESW239 ESW244 ESW248 ESW252 ESW257 ESW261 ESW265 ESW270 ESW274 ESW278 ESW283 ESW287 ESW291 ESW296
ESW300 ESW304 ESW309 ESW313 ESW317 ESW322 ESW326 ESW331 ESW335 ESW339 ESW344 ESW348 ESW352 ESW357 ESW360 ESW365 ESW369
ESW373 ESW377 ESW382 ESW386 ESW390 ESW395 ESW399 ESW404 ESW408 ESW412 ESW417 ESW421 ESW425 ESW429 ESW434 ESW438 ESW443
ESW447 ESW451 ESW456 ESW460 ESW464 ESW469 ESW473 ESW477 ESW482 ESW486 ESW490 ESW495 ESW499 ESW503 ESW508 ESW512 ESW517
ESW521 ESW525 ESW530 ESW534 ESW538 ESW543 ESW547 ESW551 ESW556 ESW560 ESW564 ESW569 ESW573 ESW577 ESW582 ESW586 ESW590
ESW595 ESW599 ESW604 ESW608 ESW612 ESW617 ESW620 ESW624 ESW628 ESW633 ESW637 ESW642 ESW646 ESW650 ESW655 ESW659 ESW663
ESW668 ESW672 ESW677 ESW681 ESW685 ESW689 ESW694 ESW698 ESW702 ESW707 ESW711 ESW716 ESW720 ESW724 ESW729 ESW733 ESW737
ESW742 ESW746 ESW750 ESW755 ESW759 ESW763 ESW768 ESW772 ESW777 ESW781 ESW785 ESW789 ESW794 ESW798 ESW802 ESW807 ESW811
ESW816 ESW820 ESW824 ESW829 ESW833 ESW837 ESW842 ESW846 ESW850 ESW855 ESW859 ESW863 ESW868 ESW872 ESW876 ESW881 ESW885
ESW889 ESW894 ESW898 ESW902 ESW907 ESW911 ESW916 ESW920 ESW924 ESW929 ESW932 ESW937 ESW941 ESW945 ESW950 ESW954 ESW958
ESW963 ESW967 ESW972 ESW976 ESW980 ESW985 ESW989 ESW993 ESW998 ESW1002 ESW1006 ESW1011 ESW1015 ESW1019 ESW1024 ESW1028 ESW1032
ESW1037 ESW1041 ESW1045 ESW1050 ESW1054 ESW1058 ESW1063 ESW1067 ESW1072 ESW1076 ESW1080 ESW1085 ESW1089 ESW1093 ESW1097 ESW1102 ESW1106
ESW1111 ESW1115 ESW1119 ESW1124 ESW1128 ESW1132 ESW1137 ESW1141 ESW1146 ESW1150 ESW1154 ESW1158 ESW1163 ESW1167 ESW1172 ESW1176 ESW1180
ESW1185 ESW1189 ESW1192 ESW1197 ESW1201 ESW1205 ESW1210 ESW1214 ESW1218 ESW1223 ESW1227 ESW1231 ESW1236 ESW1240 ESW1245 ESW1249 ESW1253
ESW1257 ESW1262 ESW1266 ESW1270 ESW1275 ESW1279 ESW1284 ESW1288 ESW1292 ESW1297 ESW1301 ESW1305 ESW1310 ESW1314 ESW1318 ESW1323 ESW1327
ESW1331 ESW1336 ESW1340 ESW1344 ESW1349 ESW1353 ESW1357 ESW1362 ESW1366 ESW1371 ESW1375 ESW1379.
count a = b to c (0.5).
end repeat.
do repeat a= probwork_M320 to probwork_M324.
compute a=0.
end repeat.
formats probwork_M1 to probwork_M324 (F2.0).
EXECUTE.

compute missing_M1=0.
do repeat a= missing_M2 to missing_M319
/ b= ESW1 ESW5 ESW10 ESW14 ESW18 ESW23 ESW27 ESW32 ESW36 ESW40 ESW45 ESW49 ESW53 ESW57 ESW62 ESW66 ESW71 
ESW75 ESW79 ESW84 ESW88 ESW92 ESW97 ESW101 ESW106 ESW110 ESW114 ESW118 ESW123 ESW127 ESW132 ESW136 ESW140 ESW145 ESW149 ESW153 ESW158 
ESW162 ESW166 ESW171 ESW175 ESW179 ESW184 ESW188 ESW192 ESW197 ESW201 ESW206 ESW210 ESW214 ESW218 ESW223 ESW227 ESW231 ESW236 ESW240 
ESW245 ESW249 ESW253 ESW258 ESW262 ESW266 ESW271 ESW275 ESW279 ESW284 ESW288 ESW292 ESW297 ESW301 ESW305 ESW310 ESW314 ESW318 ESW323 
ESW327 ESW332 ESW336 ESW340 ESW345 ESW349 ESW353 ESW358 ESW361 ESW366 ESW370 ESW374 ESW378 ESW383 ESW387 ESW391 ESW396 ESW400 ESW405 
ESW409 ESW413 ESW418 ESW422 ESW426 ESW430 ESW435 ESW439 ESW444 ESW448 ESW452 ESW457 ESW461 ESW465 ESW470 ESW474 ESW478 ESW483 ESW487 
ESW491 ESW496 ESW500 ESW504 ESW509 ESW513 ESW518 ESW522 ESW526 ESW531 ESW535 ESW539 ESW544 ESW548 ESW552 ESW557 ESW561 ESW565 ESW570 
ESW574 ESW578 ESW583 ESW587 ESW591 ESW596 ESW600 ESW605 ESW609 ESW613 ESW618 ESW621 ESW625 ESW629 ESW634 ESW638 ESW643 ESW647 ESW651 
ESW656 ESW660 ESW664 ESW669 ESW673 ESW678 ESW682 ESW686 ESW690 ESW695 ESW699 ESW703 ESW708 ESW712 ESW717 ESW721 ESW725 ESW730 ESW734 
ESW738 ESW743 ESW747 ESW751 ESW756 ESW760 ESW764 ESW769 ESW773 ESW778 ESW782 ESW786 ESW790 ESW795 ESW799 ESW803 ESW808 ESW812 ESW817 
ESW821 ESW825 ESW830 ESW834 ESW838 ESW843 ESW847 ESW851 ESW856 ESW860 ESW864 ESW869 ESW873 ESW877 ESW882 ESW886 ESW890 ESW895 ESW899 
ESW903 ESW908 ESW912 ESW917 ESW921 ESW925 ESW930 ESW933 ESW938 ESW942 ESW946 ESW951 ESW955 ESW959 ESW964 ESW968 ESW973 ESW977 ESW981 
ESW986 ESW990 ESW994 ESW999 ESW1003 ESW1007 ESW1012 ESW1016 ESW1020 ESW1025 ESW1029 ESW1033 ESW1038 ESW1042 ESW1046 ESW1051 ESW1055 
ESW1059 ESW1064 ESW1068 ESW1073 ESW1077 ESW1081 ESW1086 ESW1090 ESW1094 ESW1098 ESW1103 ESW1107 ESW1112 ESW1116 ESW1120 ESW1125 ESW1129 
ESW1133 ESW1138 ESW1142 ESW1147 ESW1151 ESW1155 ESW1159 ESW1164 ESW1168 ESW1173 ESW1177 ESW1181 ESW1186 ESW1190 ESW1193 ESW1198 ESW1202 
ESW1206 ESW1211 ESW1215 ESW1219 ESW1224 ESW1228 ESW1232 ESW1237 ESW1241 ESW1246 ESW1250 ESW1254 ESW1258 ESW1263 ESW1267 ESW1271 ESW1276 
ESW1280 ESW1285 ESW1289 ESW1293 ESW1298 ESW1302 ESW1306 ESW1311 ESW1315 ESW1319 ESW1324 ESW1328 ESW1332 ESW1337 ESW1341 ESW1345 ESW1350 
ESW1354 ESW1358 ESW1363 ESW1367 ESW1372 ESW1376 
/ c= ESW4 ESW9 ESW13 ESW17 ESW22 ESW26 ESW31 ESW35 ESW39 ESW44 ESW48 ESW52 ESW56 ESW61 ESW65 ESW70 ESW74
ESW78 ESW83 ESW87 ESW91 ESW96 ESW100 ESW105 ESW109 ESW113 ESW117 ESW122 ESW126 ESW131 ESW135 ESW139 ESW144 ESW148
ESW152 ESW157 ESW161 ESW165 ESW170 ESW174 ESW178 ESW183 ESW187 ESW191 ESW196 ESW200 ESW205 ESW209 ESW213 ESW217 ESW222
ESW226 ESW230 ESW235 ESW239 ESW244 ESW248 ESW252 ESW257 ESW261 ESW265 ESW270 ESW274 ESW278 ESW283 ESW287 ESW291 ESW296
ESW300 ESW304 ESW309 ESW313 ESW317 ESW322 ESW326 ESW331 ESW335 ESW339 ESW344 ESW348 ESW352 ESW357 ESW360 ESW365 ESW369
ESW373 ESW377 ESW382 ESW386 ESW390 ESW395 ESW399 ESW404 ESW408 ESW412 ESW417 ESW421 ESW425 ESW429 ESW434 ESW438 ESW443
ESW447 ESW451 ESW456 ESW460 ESW464 ESW469 ESW473 ESW477 ESW482 ESW486 ESW490 ESW495 ESW499 ESW503 ESW508 ESW512 ESW517
ESW521 ESW525 ESW530 ESW534 ESW538 ESW543 ESW547 ESW551 ESW556 ESW560 ESW564 ESW569 ESW573 ESW577 ESW582 ESW586 ESW590
ESW595 ESW599 ESW604 ESW608 ESW612 ESW617 ESW620 ESW624 ESW628 ESW633 ESW637 ESW642 ESW646 ESW650 ESW655 ESW659 ESW663
ESW668 ESW672 ESW677 ESW681 ESW685 ESW689 ESW694 ESW698 ESW702 ESW707 ESW711 ESW716 ESW720 ESW724 ESW729 ESW733 ESW737
ESW742 ESW746 ESW750 ESW755 ESW759 ESW763 ESW768 ESW772 ESW777 ESW781 ESW785 ESW789 ESW794 ESW798 ESW802 ESW807 ESW811
ESW816 ESW820 ESW824 ESW829 ESW833 ESW837 ESW842 ESW846 ESW850 ESW855 ESW859 ESW863 ESW868 ESW872 ESW876 ESW881 ESW885
ESW889 ESW894 ESW898 ESW902 ESW907 ESW911 ESW916 ESW920 ESW924 ESW929 ESW932 ESW937 ESW941 ESW945 ESW950 ESW954 ESW958
ESW963 ESW967 ESW972 ESW976 ESW980 ESW985 ESW989 ESW993 ESW998 ESW1002 ESW1006 ESW1011 ESW1015 ESW1019 ESW1024 ESW1028 ESW1032
ESW1037 ESW1041 ESW1045 ESW1050 ESW1054 ESW1058 ESW1063 ESW1067 ESW1072 ESW1076 ESW1080 ESW1085 ESW1089 ESW1093 ESW1097 ESW1102 ESW1106
ESW1111 ESW1115 ESW1119 ESW1124 ESW1128 ESW1132 ESW1137 ESW1141 ESW1146 ESW1150 ESW1154 ESW1158 ESW1163 ESW1167 ESW1172 ESW1176 ESW1180
ESW1185 ESW1189 ESW1192 ESW1197 ESW1201 ESW1205 ESW1210 ESW1214 ESW1218 ESW1223 ESW1227 ESW1231 ESW1236 ESW1240 ESW1245 ESW1249 ESW1253
ESW1257 ESW1262 ESW1266 ESW1270 ESW1275 ESW1279 ESW1284 ESW1288 ESW1292 ESW1297 ESW1301 ESW1305 ESW1310 ESW1314 ESW1318 ESW1323 ESW1327
ESW1331 ESW1336 ESW1340 ESW1344 ESW1349 ESW1353 ESW1357 ESW1362 ESW1366 ESW1371 ESW1375 ESW1379.
count a = b to c (-1).
end repeat.
do repeat a= missing_M320 to missing_M324.
compute a=0.
end repeat.
formats missing_M1 to missing_M324 (F2.0).
EXECUTE.

compute cen_M1=4.
do repeat a= cen_M2 to cen_M319
/ b= ESW1 ESW5 ESW10 ESW14 ESW18 ESW23 ESW27 ESW32 ESW36 ESW40 ESW45 ESW49 ESW53 ESW57 ESW62 ESW66 ESW71 
ESW75 ESW79 ESW84 ESW88 ESW92 ESW97 ESW101 ESW106 ESW110 ESW114 ESW118 ESW123 ESW127 ESW132 ESW136 ESW140 ESW145 ESW149 ESW153 ESW158 
ESW162 ESW166 ESW171 ESW175 ESW179 ESW184 ESW188 ESW192 ESW197 ESW201 ESW206 ESW210 ESW214 ESW218 ESW223 ESW227 ESW231 ESW236 ESW240 
ESW245 ESW249 ESW253 ESW258 ESW262 ESW266 ESW271 ESW275 ESW279 ESW284 ESW288 ESW292 ESW297 ESW301 ESW305 ESW310 ESW314 ESW318 ESW323 
ESW327 ESW332 ESW336 ESW340 ESW345 ESW349 ESW353 ESW358 ESW361 ESW366 ESW370 ESW374 ESW378 ESW383 ESW387 ESW391 ESW396 ESW400 ESW405 
ESW409 ESW413 ESW418 ESW422 ESW426 ESW430 ESW435 ESW439 ESW444 ESW448 ESW452 ESW457 ESW461 ESW465 ESW470 ESW474 ESW478 ESW483 ESW487 
ESW491 ESW496 ESW500 ESW504 ESW509 ESW513 ESW518 ESW522 ESW526 ESW531 ESW535 ESW539 ESW544 ESW548 ESW552 ESW557 ESW561 ESW565 ESW570 
ESW574 ESW578 ESW583 ESW587 ESW591 ESW596 ESW600 ESW605 ESW609 ESW613 ESW618 ESW621 ESW625 ESW629 ESW634 ESW638 ESW643 ESW647 ESW651 
ESW656 ESW660 ESW664 ESW669 ESW673 ESW678 ESW682 ESW686 ESW690 ESW695 ESW699 ESW703 ESW708 ESW712 ESW717 ESW721 ESW725 ESW730 ESW734 
ESW738 ESW743 ESW747 ESW751 ESW756 ESW760 ESW764 ESW769 ESW773 ESW778 ESW782 ESW786 ESW790 ESW795 ESW799 ESW803 ESW808 ESW812 ESW817 
ESW821 ESW825 ESW830 ESW834 ESW838 ESW843 ESW847 ESW851 ESW856 ESW860 ESW864 ESW869 ESW873 ESW877 ESW882 ESW886 ESW890 ESW895 ESW899 
ESW903 ESW908 ESW912 ESW917 ESW921 ESW925 ESW930 ESW933 ESW938 ESW942 ESW946 ESW951 ESW955 ESW959 ESW964 ESW968 ESW973 ESW977 ESW981 
ESW986 ESW990 ESW994 ESW999 ESW1003 ESW1007 ESW1012 ESW1016 ESW1020 ESW1025 ESW1029 ESW1033 ESW1038 ESW1042 ESW1046 ESW1051 ESW1055 
ESW1059 ESW1064 ESW1068 ESW1073 ESW1077 ESW1081 ESW1086 ESW1090 ESW1094 ESW1098 ESW1103 ESW1107 ESW1112 ESW1116 ESW1120 ESW1125 ESW1129 
ESW1133 ESW1138 ESW1142 ESW1147 ESW1151 ESW1155 ESW1159 ESW1164 ESW1168 ESW1173 ESW1177 ESW1181 ESW1186 ESW1190 ESW1193 ESW1198 ESW1202 
ESW1206 ESW1211 ESW1215 ESW1219 ESW1224 ESW1228 ESW1232 ESW1237 ESW1241 ESW1246 ESW1250 ESW1254 ESW1258 ESW1263 ESW1267 ESW1271 ESW1276 
ESW1280 ESW1285 ESW1289 ESW1293 ESW1298 ESW1302 ESW1306 ESW1311 ESW1315 ESW1319 ESW1324 ESW1328 ESW1332 ESW1337 ESW1341 ESW1345 ESW1350 
ESW1354 ESW1358 ESW1363 ESW1367 ESW1372 ESW1376 
/ c= ESW4 ESW9 ESW13 ESW17 ESW22 ESW26 ESW31 ESW35 ESW39 ESW44 ESW48 ESW52 ESW56 ESW61 ESW65 ESW70 ESW74
ESW78 ESW83 ESW87 ESW91 ESW96 ESW100 ESW105 ESW109 ESW113 ESW117 ESW122 ESW126 ESW131 ESW135 ESW139 ESW144 ESW148
ESW152 ESW157 ESW161 ESW165 ESW170 ESW174 ESW178 ESW183 ESW187 ESW191 ESW196 ESW200 ESW205 ESW209 ESW213 ESW217 ESW222
ESW226 ESW230 ESW235 ESW239 ESW244 ESW248 ESW252 ESW257 ESW261 ESW265 ESW270 ESW274 ESW278 ESW283 ESW287 ESW291 ESW296
ESW300 ESW304 ESW309 ESW313 ESW317 ESW322 ESW326 ESW331 ESW335 ESW339 ESW344 ESW348 ESW352 ESW357 ESW360 ESW365 ESW369
ESW373 ESW377 ESW382 ESW386 ESW390 ESW395 ESW399 ESW404 ESW408 ESW412 ESW417 ESW421 ESW425 ESW429 ESW434 ESW438 ESW443
ESW447 ESW451 ESW456 ESW460 ESW464 ESW469 ESW473 ESW477 ESW482 ESW486 ESW490 ESW495 ESW499 ESW503 ESW508 ESW512 ESW517
ESW521 ESW525 ESW530 ESW534 ESW538 ESW543 ESW547 ESW551 ESW556 ESW560 ESW564 ESW569 ESW573 ESW577 ESW582 ESW586 ESW590
ESW595 ESW599 ESW604 ESW608 ESW612 ESW617 ESW620 ESW624 ESW628 ESW633 ESW637 ESW642 ESW646 ESW650 ESW655 ESW659 ESW663
ESW668 ESW672 ESW677 ESW681 ESW685 ESW689 ESW694 ESW698 ESW702 ESW707 ESW711 ESW716 ESW720 ESW724 ESW729 ESW733 ESW737
ESW742 ESW746 ESW750 ESW755 ESW759 ESW763 ESW768 ESW772 ESW777 ESW781 ESW785 ESW789 ESW794 ESW798 ESW802 ESW807 ESW811
ESW816 ESW820 ESW824 ESW829 ESW833 ESW837 ESW842 ESW846 ESW850 ESW855 ESW859 ESW863 ESW868 ESW872 ESW876 ESW881 ESW885
ESW889 ESW894 ESW898 ESW902 ESW907 ESW911 ESW916 ESW920 ESW924 ESW929 ESW932 ESW937 ESW941 ESW945 ESW950 ESW954 ESW958
ESW963 ESW967 ESW972 ESW976 ESW980 ESW985 ESW989 ESW993 ESW998 ESW1002 ESW1006 ESW1011 ESW1015 ESW1019 ESW1024 ESW1028 ESW1032
ESW1037 ESW1041 ESW1045 ESW1050 ESW1054 ESW1058 ESW1063 ESW1067 ESW1072 ESW1076 ESW1080 ESW1085 ESW1089 ESW1093 ESW1097 ESW1102 ESW1106
ESW1111 ESW1115 ESW1119 ESW1124 ESW1128 ESW1132 ESW1137 ESW1141 ESW1146 ESW1150 ESW1154 ESW1158 ESW1163 ESW1167 ESW1172 ESW1176 ESW1180
ESW1185 ESW1189 ESW1192 ESW1197 ESW1201 ESW1205 ESW1210 ESW1214 ESW1218 ESW1223 ESW1227 ESW1231 ESW1236 ESW1240 ESW1245 ESW1249 ESW1253
ESW1257 ESW1262 ESW1266 ESW1270 ESW1275 ESW1279 ESW1284 ESW1288 ESW1292 ESW1297 ESW1301 ESW1305 ESW1310 ESW1314 ESW1318 ESW1323 ESW1327
ESW1331 ESW1336 ESW1340 ESW1344 ESW1349 ESW1353 ESW1357 ESW1362 ESW1366 ESW1371 ESW1375 ESW1379.
count a = b to c (-4).
end repeat.
do repeat a= cen_M320 to cen_M324.
compute a=4.
end repeat.
formats cen_M1 to cen_M324 (F2.0).
EXECUTE.

SAVE OUTFILE='D:\NLSY97_Kopyckaetal\source_empstatus.sav'
 /COMPRESSED.

rename vars (work_M1 to work_M324 = W1 to W324)(probwork_M1 to probwork_M324 = P1 to P324)(missing_M1 to missing_M324 = M1 to M324)(cen_M1 to cen_M324 = C1 to C324).
VARSTOCASES
/make work1 from W1 W13 W25 W37 W49 W61 W73 W85 W97 W109 W121 W133 W145 W157 W169 W181 W193 W205 W217 W229 W241 W253 W265 W277 W289 W301 W313
/make work2 from W2 W14 W26 W38 W50 W62 W74 W86 W98 W110 W122 W134 W146 W158 W170 W182 W194 W206 W218 W230 W242 W254 W266 W278 W290 W302 W314
/make work3 from W3 W15 W27 W39 W51 W63 W75 W87 W99 W111 W123 W135 W147 W159 W171 W183 W195 W207 W219 W231 W243 W255 W267 W279 W291 W303 W315
/make work4 from W4 W16 W28 W40 W52 W64 W76 W88 W100 W112 W124 W136 W148 W160 W172 W184 W196 W208 W220 W232 W244 W256 W268 W280 W292 W304 W316
/make work5 from W5 W17 W29 W41 W53 W65 W77 W89 W101 W113 W125 W137 W149 W161 W173 W185 W197 W209 W221 W233 W245 W257 W269 W281 W293 W305 W317
/make work6 from W6 W18 W30 W42 W54 W66 W78 W90 W102 W114 W126 W138 W150 W162 W174 W186 W198 W210 W222 W234 W246 W258 W270 W282 W294 W306 W318
/make work7 from W7 W19 W31 W43 W55 W67 W79 W91 W103 W115 W127 W139 W151 W163 W175 W187 W199 W211 W223 W235 W247 W259 W271 W283 W295 W307 W319
/make work8 from W8 W20 W32 W44 W56 W68 W80 W92 W104 W116 W128 W140 W152 W164 W176 W188 W200 W212 W224 W236 W248 W260 W272 W284 W296 W308 W320
/make work9 from W9 W21 W33 W45 W57 W69 W81 W93 W105 W117 W129 W141 W153 W165 W177 W189 W201 W213 W225 W237 W249 W261 W273 W285 W297 W309 W321
/make work10 from W10 W22 W34 W46 W58 W70 W82 W94 W106 W118 W130 W142 W154 W166 W178 W190 W202 W214 W226 W238 W250 W262 W274 W286 W298 W310 W322
/make work11 from W11 W23 W35 W47 W59 W71 W83 W95 W107 W119 W131 W143 W155 W167 W179 W191 W203 W215 W227 W239 W251 W263 W275 W287 W299 W311 W323
/make work12 from W12 W24 W36 W48 W60 W72 W84 W96 W108 W120 W132 W144 W156 W168 W180 W192 W204 W216 W228 W240 W252 W264 W276 W288 W300 W312 W324
/make prwrk1 from P1 P13 P25 P37 P49 P61 P73 P85 P97 P109 P121 P133 P145 P157 P169 P181 P193 P205 P217 P229 P241 P253 P265 P277 P289 P301 P313
 /make prwrk2 from P2 P14 P26 P38 P50 P62 P74 P86 P98 P110 P122 P134 P146 P158 P170 P182 P194 P206 P218 P230 P242 P254 P266 P278 P290 P302 P314
 /make prwrk3 from P3 P15 P27 P39 P51 P63 P75 P87 P99 P111 P123 P135 P147 P159 P171 P183 P195 P207 P219 P231 P243 P255 P267 P279 P291 P303 P315
 /make prwrk4 from P4 P16 P28 P40 P52 P64 P76 P88 P100 P112 P124 P136 P148 P160 P172 P184 P196 P208 P220 P232 P244 P256 P268 P280 P292 P304 P316
 /make prwrk5 from P5 P17 P29 P41 P53 P65 P77 P89 P101 P113 P125 P137 P149 P161 P173 P185 P197 P209 P221 P233 P245 P257 P269 P281 P293 P305 P317
 /make prwrk6 from P6 P18 P30 P42 P54 P66 P78 P90 P102 P114 P126 P138 P150 P162 P174 P186 P198 P210 P222 P234 P246 P258 P270 P282 P294 P306 P318
 /make prwrk7 from P7 P19 P31 P43 P55 P67 P79 P91 P103 P115 P127 P139 P151 P163 P175 P187 P199 P211 P223 P235 P247 P259 P271 P283 P295 P307 P319
 /make prwrk8 from P8 P20 P32 P44 P56 P68 P80 P92 P104 P116 P128 P140 P152 P164 P176 P188 P200 P212 P224 P236 P248 P260 P272 P284 P296 P308 P320
 /make prwrk9 from P9 P21 P33 P45 P57 P69 P81 P93 P105 P117 P129 P141 P153 P165 P177 P189 P201 P213 P225 P237 P249 P261 P273 P285 P297 P309 P321
 /make prwrk10 from P10 P22 P34 P46 P58 P70 P82 P94 P106 P118 P130 P142 P154 P166 P178 P190 P202 P214 P226 P238 P250 P262 P274 P286 P298 P310 P322
 /make prwrk11 from P11 P23 P35 P47 P59 P71 P83 P95 P107 P119 P131 P143 P155 P167 P179 P191 P203 P215 P227 P239 P251 P263 P275 P287 P299 P311 P323
 /make prwrk12 from P12 P24 P36 P48 P60 P72 P84 P96 P108 P120 P132 P144 P156 P168 P180 P192 P204 P216 P228 P240 P252 P264 P276 P288 P300 P312 P324
 /make missing1 from M1 M13 M25 M37 M49 M61 M73 M85 M97 M109 M121 M133 M145 M157 M169 M181 M193 M205 M217 M229 M241 M253 M265 M277 M289 M301 M313
 /make missing2 from M2 M14 M26 M38 M50 M62 M74 M86 M98 M110 M122 M134 M146 M158 M170 M182 M194 M206 M218 M230 M242 M254 M266 M278 M290 M302 M314
 /make missing3 from M3 M15 M27 M39 M51 M63 M75 M87 M99 M111 M123 M135 M147 M159 M171 M183 M195 M207 M219 M231 M243 M255 M267 M279 M291 M303 M315
 /make missing4 from M4 M16 M28 M40 M52 M64 M76 M88 M100 M112 M124 M136 M148 M160 M172 M184 M196 M208 M220 M232 M244 M256 M268 M280 M292 M304 M316
 /make missing5 from M5 M17 M29 M41 M53 M65 M77 M89 M101 M113 M125 M137 M149 M161 M173 M185 M197 M209 M221 M233 M245 M257 M269 M281 M293 M305 M317
 /make missing6 from M6 M18 M30 M42 M54 M66 M78 M90 M102 M114 M126 M138 M150 M162 M174 M186 M198 M210 M222 M234 M246 M258 M270 M282 M294 M306 M318
 /make missing7 from M7 M19 M31 M43 M55 M67 M79 M91 M103 M115 M127 M139 M151 M163 M175 M187 M199 M211 M223 M235 M247 M259 M271 M283 M295 M307 M319
 /make missing8 from M8 M20 M32 M44 M56 M68 M80 M92 M104 M116 M128 M140 M152 M164 M176 M188 M200 M212 M224 M236 M248 M260 M272 M284 M296 M308 M320
 /make missing9 from M9 M21 M33 M45 M57 M69 M81 M93 M105 M117 M129 M141 M153 M165 M177 M189 M201 M213 M225 M237 M249 M261 M273 M285 M297 M309 M321
 /make missing10 from M10 M22 M34 M46 M58 M70 M82 M94 M106 M118 M130 M142 M154 M166 M178 M190 M202 M214 M226 M238 M250 M262 M274 M286 M298 M310 M322
 /make missing11 from M11 M23 M35 M47 M59 M71 M83 M95 M107 M119 M131 M143 M155 M167 M179 M191 M203 M215 M227 M239 M251 M263 M275 M287 M299 M311 M323
 /make missing12 from M12 M24 M36 M48 M60 M72 M84 M96 M108 M120 M132 M144 M156 M168 M180 M192 M204 M216 M228 M240 M252 M264 M276 M288 M300 M312 M324
 /make censored1 from C1 C13 C25 C37 C49 C61 C73 C85 C97 C109 C121 C133 C145 C157 C169 C181 C193 C205 C217 C229 C241 C253 C265 C277 C289 C301 C313
 /make censored2 from C2 C14 C26 C38 C50 C62 C74 C86 C98 C110 C122 C134 C146 C158 C170 C182 C194 C206 C218 C230 C242 C254 C266 C278 C290 C302 C314
 /make censored3 from C3 C15 C27 C39 C51 C63 C75 C87 C99 C111 C123 C135 C147 C159 C171 C183 C195 C207 C219 C231 C243 C255 C267 C279 C291 C303 C315
 /make censored4 from C4 C16 C28 C40 C52 C64 C76 C88 C100 C112 C124 C136 C148 C160 C172 C184 C196 C208 C220 C232 C244 C256 C268 C280 C292 C304 C316
 /make censored5 from C5 C17 C29 C41 C53 C65 C77 C89 C101 C113 C125 C137 C149 C161 C173 C185 C197 C209 C221 C233 C245 C257 C269 C281 C293 C305 C317
 /make censored6 from C6 C18 C30 C42 C54 C66 C78 C90 C102 C114 C126 C138 C150 C162 C174 C186 C198 C210 C222 C234 C246 C258 C270 C282 C294 C306 C318
 /make censored7 from C7 C19 C31 C43 C55 C67 C79 C91 C103 C115 C127 C139 C151 C163 C175 C187 C199 C211 C223 C235 C247 C259 C271 C283 C295 C307 C319
 /make censored8 from C8 C20 C32 C44 C56 C68 C80 C92 C104 C116 C128 C140 C152 C164 C176 C188 C200 C212 C224 C236 C248 C260 C272 C284 C296 C308 C320
 /make censored9 from C9 C21 C33 C45 C57 C69 C81 C93 C105 C117 C129 C141 C153 C165 C177 C189 C201 C213 C225 C237 C249 C261 C273 C285 C297 C309 C321
 /make censored10 from C10 C22 C34 C46 C58 C70 C82 C94 C106 C118 C130 C142 C154 C166 C178 C190 C202 C214 C226 C238 C250 C262 C274 C286 C298 C310 C322
 /make censored11 from C11 C23 C35 C47 C59 C71 C83 C95 C107 C119 C131 C143 C155 C167 C179 C191 C203 C215 C227 C239 C251 C263 C275 C287 C299 C311 C323
 /make censored12 from C12 C24 C36 C48 C60 C72 C84 C96 C108 C120 C132 C144 C156 C168 C180 C192 C204 C216 C228 C240 C252 C264 C276 C288 C300 C312 C324
/index yearnum
/keep=R0000100 R0536401 R0536402.

compute year=yearnum+1993.
EXECUTE.
rename vars (R0000100 R0536401 R0536402 = ID Monthborn Yearborn).
compute agefilter=1.
if year-Yearborn<14 agefilter=0.
formats agefilter (F2.0).
EXECUTE.

SAVE OUTFILE='D:\NLSY97_Kopyckaetal\empstatus.sav'
 /COMPRESSED.

* Criteria for estabilishing work status each month:
  1 - working - if worked for at least 2 weeks this month
  0 - not working - if jobless for at least 2 weeks each month excl. working
  2 - probably working - if associated with employer, job gaps indeterminate for at least 2 weeks this month excl. working and jobless
 -1 - missing data - if missing data for at least 2 weeks and not working, not probably working and not jobless (max 1 week of each status)
 -4 - censored (valid skips) - if at least 2 weeks are censored and max 1 week of each status and missing data
 censored cases can also be checked when using the censored filter in the full dataset.

do repeat a=wrkstat1 to wrkstat12 / b=work1 to work12 / c=missing1 to missing12 / d=censored1 to censored12 / e=prwrk1 to prwrk12.
if d>=2 a=-4.
if c>=2 a=-1.
if e>=2 a=2.
if b+c+d+e<=2 a=0.
if b>=2 a=1.
end repeat.
formats wrkstat1 to wrkstat12 (F2.0).
EXECUTE.

sort cases by ID year.
count working_nmonths = wrkstat1 to wrkstat12 (1).
count jobless_nmonths = wrkstat1 to wrkstat12 (0).
count prwrking_nmonths = wrkstat1 to wrkstat12 (2).
count missing_emp = wrkstat1 to wrkstat12 (-1).
count censored_emp = wrkstat1 to wrkstat12 (-4).
formats working_nmonths missing_emp censored_emp (F2.0).
EXECUTE.

recode missing_emp (0=0)(1 thru 12=1) into missing_flag.
recode censored_emp (0=0)(1 thru 12=1) into censored_flag.
recode prwrking_nmonths (0=0)(1 thru 12=1) into misgap_flag.
compute empmis_filter=1.
if missing_flag=1 or censored_flag=1 empmis_filter=0.
formats missing_flag censored_flag misgap_flag empmis_filter (F2.0).
EXECUTE.
var lab working_nmonths 'Number of months working this year'.
var lab jobless_nmonths 'Number of months jobless this year'.
var lab prwrking_nmonths 'Number of months attached to employer but possible job gap this year'.
var lab missing_flag 'Employment status could not be established for 1+ month this year due to missing data'.
var lab censored_flag 'Employment status could not be established for 1+ month this year due to censoring'.
var lab misgap_flag 'Employment status could not be established for 1+ month this year due to missing dates of gaps'.

SAVE OUTFILE='D:\NLSY97_Kopyckaetal\empstatus.sav'
 /COMPRESSED.

*************************************************************** STEP 8. FINAL MERGING AND CLEANING OF FILES

compute respyearID=ID*10000+year.
EXECUTE.
SORT CASES BY respyearID.

SAVE OUTFILE='D:\NLSY97_Kopyckaetal\empstatus.sav'
 /COMPRESSED.
DATASET ACTIVATE NLSY97_CNPI.
SORT CASES BY respyearID.
MATCH FILES /FILE=*
 /FILE='empstatus'
 /BY respyearID
 /KEEP= ID YEAR respyearID Yearborn Monthborn Agefilter filter fullcases1
censored mis_mili mis_dates mis_nopay mis_outpay mis_hours work_allhours work_allweeks meanearn 
N_jobspells working_nmonths jobless_nmonths prwrking_nmonths missing_emp censored_emp missing_flag censored_flag empmis_filter misgap_flag
benefits_9M benefits_1M njobterm perc_linc.
EXECUTE.

SAVE OUTFILE='D:\NLSY97_Kopyckaetal\NLSY97_CNPI.sav'
 /COMPRESSED.
DATASET CLOSE empstatus.

* Remove cases (uears) when the respondent has not yet turned 14.
* Years in which the respondent turns 14 should also be excluded due to left censoring, which is present in all these cases.

select if agefilter=1.
EXECUTE.
del vars agefilter.
recode N_jobspells (sysmis=0).
compute addcases=0.
if N_jobspells=0 addcases=1.
if year-yearborn=14 censored=1.
if addcases=1 and censored_flag=1 censored=1.
recode censored (sysmis=0).
EXECUTE.
var lab censored 'Cases censored by age or last survey wave'.
var lab addcases 'Cases added based on employment array data, no jobs were recorded'.

* Reducing the number of missing cases - if no jobs were recorded in the source dataset, assign joblessness for non-censored cases
  This is confirmed in the employment arrays in 33558 out of 33988 noncensored cases
  In other cases the lack of job recording could be due to counting backreporting in the arrays or coding errors
  This will also minimise the problem of missing data from employment arrays

* COMPUTING THE FINAL CNPI COMPONENTS: employed_nmonths njobterm pct_linc

compute employed_nmths=working_nmonths.
if addcases=1 and censored=0 employed_nmths=0.
if addcases=1 and censored=0 njobterm=0.
if addcases=1 and censored=0 perc_linc=0.
if addcases=1 and censored=0 lowinc_chk=0.
if addcases=1 and censored=0 benefits_9M=0.
if addcases=1 and censored=0 benefits_nw9M=0.
if addcases=1 and censored=0 benefits_1M=0.
if addcases=1 and censored=0 benefits_nw1M=0.
if addcases=1 and censored=0 filter=1.
if addcases=1 and censored=0 fullcases1=1.
if censored=1 filter=0.
if censored=1 fullcases1=0.
if missing_flag=1 or misgap_flag=1 filter=0.
if missing_flag=1 or misgap_flag=1 fullcases1=0.
var lab employed_nmths 'CNPI employment component: number of months working'.
var lab njobterm 'CNPI terminations component: total number of job terminations including selected gaps this year'.
var lab filter 'Exclude all censored cases and cases with missing or incomplete career and wage data'.
EXECUTE.

* Add year start of career.

if employed_nmths>0 yearwork=year.
EXECUTE.
SORT CASES BY ID.
AGGREGATE
 /OUTFILE=* MODE=ADDVARIABLES
 /PRESORTED
 /BREAK=ID
 / year_start=MIN(yearwork). 
EXECUTE.
del vars yearwork.
EXECUTE.
var lab year_start 'Year reported first job excl teenage freelance'.

SAVE OUTFILE='D:\NLSY97_Kopyckaetal\NLSY97_CNPI.sav'
 /COMPRESSED.

COMPUTE timeSRM=0.
if year>=2013 and year<=2017 timeSRM=1.
COMPUTE filSRM=fullcases1*timeSRM.
EXECUTE.
var lab timeSRM 'Years 2013-2017'.
var lab filSRM 'Filter for person-year cases with full career data this year & year falls within 2013-2017'.

rename vars (ID year Yearborn Monthborn = pid syear dateborn_y dateborn_m).
var lab syear 'Calendar year'.

* Calculate sample filters

compute fullseq=0.
if filSRM=1 fullseq=1.
compute empseq=0.
if filSRM=1 and employed_nmths>0 empseq=1.
SORT CASES BY pid.
AGGREGATE
 /OUTFILE=* MODE=ADDVARIABLES
 /PRESORTED
 /BREAK=pid
 / fullseqSRM=SUM(fullseq)
 / empseqSRM=MAX(empseq). 
EXECUTE.
do if syear<2013 or syear>2017.
recode fullseqSRM empseqSRM (1 thru 5=0).
end if.
compute seqSRM=0.
if fullseqSRM=5 and empseqSRM=1 seqSRM=1.
var lab seqSRM 'Respondents with full career data for 2013-2017 who worked for at least 1 month during this period'.
EXECUTE.
del vars fullseq empseq fullseqSRM empseqSRM.

SAVE OUTFILE='D:\NLSY97_Kopyckaetal\CNPI_long.sav'
 /KEEP=respyearID pid syear dateborn_y dateborn_m year_start	 njobterm	employed_nmths	perc_linc fullcases1 filSRM seqsrm benefits_9M benefits_1M 
 /COMPRESSED.

GET FILE='D:\NLSY97_Kopyckaetal\CNPI_long.sav'.
DATASET NAME Long.
DATASET CLOSE  NLSY97_CNPI.

************************************************************ STEP 9. ADDING EDUCATION & MARITAL STATUS IN 2017; ADDING CUSTOM WEIGHTS TO DATASET

DATASET ACTIVATE Sourcedata.
SAVE OUTFILE='D:\NLSY97_Kopyckaetal\Demographics.sav'
/KEEP=R0000100 E7013712 R0536300 R1235800 R1482600 U0009400 U1846000 U1850701 U1850702 U2166200 U2166300 U2166601  U2166701
 U3444500 U3450100 U3455500  U3606701 U3658200 U3658300 U3658400 U3658601 U3658701 U3658801
/COMPRESSED. 

GET FILE='D:\NLSY97_Kopyckaetal\Demographics.sav'.
DATASET NAME Demographics.
DATASET CLOSE Sourcedata.

*Variables: pid maritstat17, education, race
* Marital status as of december 2017 - data come from 2017 wave if interview conducted december 2017 or later, or from 2019 wave
use the event history constructed variable E7013712.
* on definitions, see: https://nlsinfo.org/content/cohorts/nlsy97/topical-guide/marriage-and-children/marital-marriage-relationships

rename vars (R0000100 R0536300 R1482600 R1235800 = pid sex race oversampl_filter).
compute maritstat17=E7013712.
recode maritstat17 (-4 thru -3=sysmis).
EXECUTE.
var lab maritstat17 'Marital / cohabitations status as of December 2017'.
val lab maritstat17   0 "Never Married, Not Cohabitating"   1 "Never Married, Cohabiting"   2 "Married"   3 "Legally Separated"   4 "Divorced"   5 "Widowed".

* EDUCATION - Criteria for education in december 2017, highest degree
* If interview in december 2017 - current value
* if interview in 2018 - check if same value as in 2015 wave - take same value
* if interview in 2018 and different value - check date received diploma (has to be up to 2017)
* if interview before december 2017 - compare with 2019 value - take same value
* If interivew before december 2017 and wave 2019 values need to be taken - check date received diploma held in 2019 (has to be up to 2017).
* other cases are assigned missing value

* Date of 2017 interview and participation in 2019 interview.

compute date2017fil=-1.
if U1850702=2017 and U1850701<12 date2017fil=0.
if U1850702=2017 and U1850701=12 date2017fil=1.
if U1850702=2018 and U1850701=1 date2017fil=2.
if U1850702=2018 and U1850701>1 date2017fil=3.

EXECUTE.
val lab date2017fil -1 'Did not participate' 0 'Interview pre december 2017' 
 1 'Interview December 2017' 2 'Interview January 2018' 3 'Interview after January 2018'.
recode U3450100 (-5=0)(else=1) into wave2019.
compute data_end2017=0.
if date2017fil>=1 or wave2019=1 data_end2017=1.
EXECUTE.

* Calculate missing values for education depending on the timing of 2017 interview.

recode date2017fil (-1=-5)(0=-4)(1=-3)(2=-2)(3=-1) into education.
EXECUTE.
val lab education -5 'Did not participate 2017' -4 'Interview pre december 2017' -3 'Interview December 2017' -2 'Interview January 2018' -1 'Interview after January 2018'.

* Calculate education variable. If different values but all are 5 or above - value=5 (MA).

* did not participate in wave 2017 & same education given in waves 2015 and 2019 - 2019 value; -5: different values or missing data.
if date2017fil=-1 and U3444500=U0009400 and U3444500>=0 education=U3444500.
if date2017fil=-1 and U0009400>=5 and U3444500>=5 education=5.
* Interview conducted before december 2017 & same education given in 2017 and 2019 - 2019 value; -4: different values or missing data.
if date2017fil=-0 and U1846000=U3444500 and U3444500>=0 education=U3444500.
if date2017fil=-0 and U3444500>=5 and U1846000>=5 education=5.
* Interview december 2017 - 2017 value and if 2017 value missing & same education given in waves 2015 and 2019 - 2019 value; -3: missing data.
if date2017fil=1 and U1846000>=0 education=U1846000.
if date2017fil=1 and U1846000<0 and U3444500=U0009400 and U3444500>=0 education=U3444500.
if date2017fil=1 and U1846000<0 and U0009400>=5 and U3444500>=5 education=5.
* Interview in 2018 & same education given in 2015 and 2017 - 2017 value; -2: different values or missing data, but 2017 data from january 2018
 -1: different values or missing data.
if date2017fil>=2 and U0009400=U1846000 and U1846000>=0 education=U1846000.
if date2017fil>=2 and U1846000>=5 and U0009400>=5 education=5.
EXECUTE.
add val lab education
0 'None'
1 'GED'
2 'High school diploma (Regular 12 year program)'
3 'Associate/Junior college (AA)'
4 'Bachelors degree (BA, BS)'
5 'Masters degree (MA, MS), PhD, Professional degree (DDS, JD, MD)'.

* Remaining missing cases (excluding those for whom full 2017 data not available due to dropout) are checked using data from the nearest wave
* Individuals for whom data need to be taken from 2019; provided that they did not receive a diploma after december 2017.
* No respondent received a high school diploma - exclude.
* If received GED after December 2017 - education at December 2017 = NONE
* In other cass when college diploma received after 2017 - assign missing data.

if date2017fil<=0 education=U3444500.
exe.
if U3606701>2017 education=0.
if U3444500=3 and U3658200=1 and U3658601>2017 education=-1.
if U3444500=4 and U3658200=3 and U3658601>2017 education=-1.
if U3444500=3 and U3658300=1 and U3658701>2017 education=-1.
if U3444500=4 and U3658300=3 and U3658701>2017 education=-1.
if U3444500=5 and U3658300=4 and U3658701>2017 education=-1.
if U3444500=3 and U3658400=1 and U3658801>2017 education=-1.
if U3444500=4 and U3658400=3 and U3658801>2017 education=-1.
recode education (6 thru 7=5).
EXECUTE.

* Remaining missing cases (excluding those for whom full 2017 data not available due to dropout) are checked using data from the nearest wave
* Individuals for whom data need to be taken from 2017 (wave 2017 conducted in 2018); provided that they did not receive a diploma after december 2017.
* No respondent received a high school diploma.

* If received GED after December 2017 - education at December 2017 = NONE
* In other cass when college diploma received after 2017 - assign missing data.
  
if date2017fil>=1 education=U1846000.
if U3606701>2017 education=0.
if U1846000=3 and U2166200=1 and U2166601>2017 education=-1.
if U1846000=4 and U2166200=3 and U2166601>2017 education=-1.
if U1846000=5 and U2166300=4 and U2166601>2017 education=-1.
if U1846000=3 and U2166300=1 and U2166701>2017 education=-1.
if U1846000=4 and U2166300=3 and U2166701>2017 education=-1.
if U1846000=7 and U2166300=6 and U2166701>2017 education=-1.
recode education (6 thru 7=5)(-3=-1).
if data_end2017=0 education=-5.
add val lab education -5 'Censored case: no longer observed in december 2017' -1 'missing data, degree cannot be established'.
mis val education (-5, -1).
EXECUTE.
del vars date2017fil wave2019.
var lab education 'Respondents education in December 2017'.

* CALCULATE WEIGHTS
  2 weight variables are needed:
  First - for all cases which did not drop-out before January 2018 (non-censored) - custom weight
  Second - standard cross-sectional weight for participants in the 2019 wave of NLSY97 - provided in the dataset
  
* 1) Generate list of respondent ID values to paste into the field and generate custom weights (see: https://www.nlsinfo.org/weights/nlsy97)
* Save the .dat file downloadable from this website as 'custwgt.dat' to the working folder D:\NLSY97_Kopyckaetal; then import the weights to a new SPSS dataset

filter by data_end2017.
list pid.
filter off.

* Use the above command to obtain custom weights or use the .dat file provided for ease of replication. For the script to run smothly, 
    it needs to be saved in the folder: 'D:\NLSY97_Kopyckaetal', under the name of '\customweight.dat'
  
file handle pcdat/name='D:\NLSY97_Kopyckaetal\customweight.dat' /lrecl=11.
data list file pcdat free /
 pid (F4)
 cweight (F6).
EXECUTE.
DATASET NAME customweight.
SAVE OUTFILE='D:\NLSY97_Kopyckaetal\customweight.sav'
/COMPRESSED.
sort cases by pid.

DATASET ACTIVATE Demographics.
sort cases by pid.
MATCH FILES /FILE=*
 /FILE='customweight'
 /BY pid
 /KEEP= ALL.
EXECUTE.
DATASET CLOSE customweight.
DATASET ACTIVATE Demographics.

* Calculate corrected weights that retain the original sample size (using the weights provided in the dataset 'inflates' the sample to the size of the whole population).
* N after weighting: 19378452; original N: 7382; note the original weights have 2 implied decimals & correct below.

compute weights=cweight*(7382/1937845200).
recode weights (sysmis=0).
exe.

var lab cweight 'Population weights for ID of respondents observed at least till end of 2017 calculated using NLSY software'.
var lab weights 'Corrected weights for ID of respondents observed at least till end of 2017 - do not affect sample size'.

* N after weighting: 19378453
* original N: 6947

compute weight19=U3455500*(6947/1937845300).
formats weights weight19 (F10.8).
recode weight19 (sysmis=0).
exe.
var lab weight19 'Corrected weight for those who participated in 2019 wave'.

SAVE OUTFILE='D:\NLSY97_Kopyckaetal\Demographics.sav'
/COMPRESSED.

SAVE OUTFILE='D:\NLSY97_Kopyckaetal\CNPI_demoweights.sav'
 /KEEP=pid sex race oversampl_filter maritstat17 education weights weight19 /COMPRESSED.

GET FILE='D:\NLSY97_Kopyckaetal\CNPI_demoweights.sav'.
DATASET NAME demoweights.
DATASET CLOSE Demographics.
DATASET ACTIVATE demoweights.
sort cases by pid.
recode education (-1, -5=sysmis).

SAVE OUTFILE='D:\NLSY97_Kopyckaetal\CNPI_demoweights.sav' /COMPRESSED.

SAVE TRANSLATE OUTFILE='D:\NLSY97_Kopyckaetal\Demographics.dta'
  /TYPE=STATA
  /VERSION=14
  /EDITION=SE
  /MAP
  /REPLACE.

DATASET ACTIVATE Long.
SAVE TRANSLATE OUTFILE='D:\NLSY97_Kopyckaetal\Long.dta'
  /TYPE=STATA
  /VERSION=14
  /EDITION=SE
  /MAP
  /REPLACE.
